/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.std.ttl.TtlLibrary;
import com.cburch.logisim.std.ttl.TtlRegisterData;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class Ttl74161
extends AbstractTtlGate {
    public static final String _ID = "74161";
    public static final int PORT_INDEX_nCLR = 0;
    public static final int PORT_INDEX_CLK = 1;
    public static final int PORT_INDEX_A = 2;
    public static final int PORT_INDEX_B = 3;
    public static final int PORT_INDEX_C = 4;
    public static final int PORT_INDEX_D = 5;
    public static final int PORT_INDEX_EnP = 6;
    public static final int PORT_INDEX_nLOAD = 7;
    public static final int PORT_INDEX_EnT = 8;
    public static final int PORT_INDEX_QD = 9;
    public static final int PORT_INDEX_QC = 10;
    public static final int PORT_INDEX_QB = 11;
    public static final int PORT_INDEX_QA = 12;
    public static final int PORT_INDEX_RC0 = 13;
    private static final String[] PORT_NAMES = new String[]{"MR/CLR (Reset, active LOW)", "CP/CLK (Clock)", "D0/A", "D1/B", "D2/C", "D3/D", "CE/ENP (Count Enable)", "PE/LOAD (Parallel Enable, active LOW)", "CET/ENT (Count Enable Carry)", "Q3/QD", "Q2/QC", "A1/QB", "A0/QA", "TC/RC0 (Terminal Count)"};
    private static final byte[] OUTPUT_PORTS = new byte[]{11, 12, 13, 14, 15};

    public Ttl74161() {
        super(_ID, (byte)16, OUTPUT_PORTS, PORT_NAMES, null);
        super.setInstancePoker(Poker.class);
    }

    public Ttl74161(String name) {
        super(name, (byte)16, OUTPUT_PORTS, PORT_NAMES, null);
        super.setInstancePoker(Poker.class);
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        Graphics2D gfx = (Graphics2D)painter.getGraphics();
        super.paintBase(painter, false, false);
        Drawgates.paintPortNames(painter, x, y, height, new String[]{"nClr", "Clk", "A", "B", "C", "D", "EnP", "nLD", "EnT", "Qd", "Qc", "Qb", "Qa", "RC0"});
        TtlRegisterData data = (TtlRegisterData)painter.getData();
        this.drawState(gfx, x, y, height, data);
    }

    private void drawState(Graphics2D gfx, int x, int y, int height, TtlRegisterData state) {
        if (state == null) {
            return;
        }
        long value = state.getValue().toLongValue();
        for (int i = 0; i < 4; ++i) {
            boolean isSetBitValue = (value & (long)(1 << 3 - i)) != 0L;
            gfx.setColor(isSetBitValue ? Value.trueColor : Value.falseColor);
            gfx.fillOval(x + 52 + i * 10, y + height / 2 - 4, 8, 8);
            gfx.setColor(Color.WHITE);
            GraphicsUtil.drawCenteredText(gfx, isSetBitValue ? "1" : "0", x + 56 + i * 10, y + height / 2);
        }
        gfx.setColor(Color.BLACK);
    }

    public static void updateState(InstanceState state, Long value) {
        TtlRegisterData data = Ttl74161.getStateData(state);
        data.setValue(Value.createKnown(BitWidth.create(4), (long)value));
        Value vA = data.getValue().get(0);
        Value vB = data.getValue().get(1);
        Value vC = data.getValue().get(2);
        Value vD = data.getValue().get(3);
        state.setPort(12, vA, 1);
        state.setPort(11, vB, 1);
        state.setPort(10, vC, 1);
        state.setPort(9, vD, 1);
        state.setPort(13, state.getPortValue(8).and(vA).and(vB).and(vC).and(vD), 1);
    }

    public static TtlRegisterData getStateData(InstanceState state) {
        TtlRegisterData data = (TtlRegisterData)state.getData();
        if (data == null) {
            data = new TtlRegisterData(BitWidth.create(4));
            state.setData(data);
        }
        return data;
    }

    @Override
    public void propagateTtl(InstanceState state) {
        TtlRegisterData data = Ttl74161.getStateData(state);
        boolean triggered = data.updateClock(state.getPortValue(1), StdAttr.TRIG_RISING);
        long nClear = state.getPortValue(0).toLongValue();
        long counter = data.getValue().toLongValue();
        if (nClear == 0L) {
            counter = 0L;
        } else if (triggered) {
            Value nLoad = state.getPortValue(7);
            if (nLoad.toLongValue() == 0L) {
                counter = state.getPortValue(2).toLongValue();
                counter += state.getPortValue(3).toLongValue() << 1;
                counter += state.getPortValue(4).toLongValue() << 2;
                counter += state.getPortValue(5).toLongValue() << 3;
            } else {
                long enpAndEnt = state.getPortValue(6).and(state.getPortValue(8)).toLongValue();
                if (enpAndEnt == 1L && ++counter > 15L) {
                    counter = 0L;
                }
            }
        }
        Ttl74161.updateState(state, counter);
    }

    @Override
    public boolean checkForGatedClocks(netlistComponent comp) {
        return true;
    }

    @Override
    public int[] clockPinIndex(netlistComponent comp) {
        return new int[]{1};
    }

    public static class Poker
    extends InstancePoker {
        boolean isPressed = true;

        private boolean isInside(InstanceState state, MouseEvent e) {
            Point p = AbstractTtlGate.getTranslatedTtlXY(state, e);
            boolean inside = false;
            for (int i = 0; i < 4; ++i) {
                int dx = p.x - (56 + i * 10);
                int dy = p.y - 30;
                int d2 = dx * dx + dy * dy;
                inside |= d2 < 16;
            }
            return inside;
        }

        private int getIndex(InstanceState state, MouseEvent e) {
            Point p = AbstractTtlGate.getTranslatedTtlXY(state, e);
            for (int i = 0; i < 4; ++i) {
                int dx = p.x - (56 + i * 10);
                int dy = p.y - 30;
                int d2 = dx * dx + dy * dy;
                if (d2 >= 16) continue;
                return 3 - i;
            }
            return 0;
        }

        @Override
        public void mousePressed(InstanceState state, MouseEvent e) {
            this.isPressed = this.isInside(state, e);
        }

        @Override
        public void mouseReleased(InstanceState state, MouseEvent e) {
            if (!state.getAttributeValue(TtlLibrary.DRAW_INTERNAL_STRUCTURE).booleanValue()) {
                return;
            }
            if (this.isPressed && this.isInside(state, e)) {
                int index = this.getIndex(state, e);
                TtlRegisterData data = (TtlRegisterData)state.getData();
                if (data == null) {
                    return;
                }
                long current = data.getValue().toLongValue();
                long bitValue = 1L << index;
                Ttl74161.updateState(state, current ^= bitValue);
            }
            this.isPressed = false;
        }
    }
}

