/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.std.ttl.TtlLibrary;
import com.cburch.logisim.util.LineBuffer;

public class AbstractOctalFlopsHdlGenerator
extends AbstractHdlGeneratorFactory {
    public AbstractOctalFlopsHdlGenerator(boolean hasClockEnable) {
        this.myWires.addWire("state", 8).addWire("enable", 1).addWire("next", 8);
        if (hasClockEnable) {
            this.myPorts.add("input", "nCLR", 1, "fixed_pull_up").add("input", "nCLKen", 1, 0);
        } else {
            this.myPorts.add("input", "nCLR", 1, 0).add("input", "nCLKen", 1, "fixed_pull_down");
        }
        this.myPorts.add("clock", "clock", 1, 9).add("input", "D0", 1, 2).add("input", "D1", 1, 3).add("input", "D2", 1, 6).add("input", "D3", 1, 7).add("input", "D4", 1, 11).add("input", "D5", 1, 12).add("input", "D6", 1, 15).add("input", "D7", 1, 16).add("output", "Q0", 1, 1).add("output", "Q1", 1, 4).add("output", "Q2", 1, 5).add("output", "Q3", 1, 8).add("output", "Q4", 1, 10).add("output", "Q5", 1, 13).add("output", "Q6", 1, 14).add("output", "Q7", 1, 17);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist theNetlist, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer().pair("CLK", "clock").pair("tick", "tick");
        if (Hdl.isVhdl()) {
            contents.empty().addVhdlKeywords().add("enable <= {{tick}} {{and}} {{not}}(nCLKen);\nnext   <= D7&D6&D5&D4&D3&D2&D1&D0 {{when}} enable = '1' {{else}} state;\nQ0     <= state(0);\nQ1     <= state(1);\nQ2     <= state(2);\nQ3     <= state(3);\nQ4     <= state(4);\nQ5     <= state(5);\nQ6     <= state(6);\nQ7     <= state(7);\n\ndffs : {{process}}({{CLK}}, nCLR) {{is}}\n   {{begin}}\n      {{if}} (nCLR = '0') {{then}} state <= ({{others}} => '0');\n      {{elsif}} (rising_edge({{CLK}})) {{then}} state <= next;\n      {{end}} {{if}};\n   {{end}} {{process}} dffs;\n");
        } else {
            contents.add("assign enable = {{tick}} & ~nCLKen;\nassign next   = enable ? {D7, D6, D5, D4, D3, D2, D1, D0} : state;\nassign Q0     = state[0];\nassign Q1     = state[1];\nassign Q2     = state[2];\nassign Q3     = state[3];\nassign Q4     = state[4];\nassign Q5     = state[5];\nassign Q6     = state[6];\nassign Q7     = state[7];\n\nalways @(posedge {{CLK}} or negedge nCLR)\nbegin\n   if (~nCLR) state <= 0;\n   else state <= next;\nend\n");
        }
        return contents.empty();
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        if (attrs == null) {
            return false;
        }
        return attrs.getValue(TtlLibrary.VCC_GND) == false;
    }
}

