/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.tcl;

import com.cburch.logisim.std.tcl.TclComponentAttributes;
import com.cburch.logisim.std.tcl.TclComponentData;
import com.cburch.logisim.tools.MessageBox;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TclWrapper {
    static final Logger logger = LoggerFactory.getLogger(TclWrapper.class);
    private static final String TCL_PATH = System.getProperty("java.io.tmpdir") + "/logisim/tcl/";
    private static final String TCL_RESOURCES_PATH = "/resources/logisim/tcl/";
    private static boolean fileExists = false;
    private Process process;
    private final TclComponentData tclConsole;
    private File tclContentFile;
    private TclWrapperState state = TclWrapperState.STOPPED;

    public TclWrapper(TclComponentData tclComp) {
        this.tclConsole = tclComp;
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void setFile(File file) {
        this.tclContentFile = file;
    }

    public void start() {
        if (this.state != TclWrapperState.STOPPED) {
            return;
        }
        this.tclContentFile = this.tclConsole.getState().getAttributeValue(TclComponentAttributes.CONTENT_FILE_ATTR);
        if (!this.tclContentFile.isFile()) {
            return;
        }
        this.state = TclWrapperState.STARTING;
        if (!fileExists) {
            new File(TCL_PATH).mkdirs();
            try {
                Files.copy(this.getClass().getResourceAsStream("/resources/logisim/tcl/tcl_wrapper.tcl"), Paths.get(TCL_PATH + "tcl_wrapper.tcl", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                logger.error("Cannot copy TCL wrapper file : {}", (Object)e.getMessage());
                e.printStackTrace();
            }
            fileExists = true;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("tclsh");
        command.add(TCL_PATH + "tcl_wrapper.tcl");
        command.add("" + this.tclConsole.getTclClient().getServerPort());
        command.add(this.tclContentFile.getAbsolutePath());
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.directory(this.tclContentFile.getParentFile());
        builder.redirectErrorStream(true);
        try {
            this.process = builder.start();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error("Cannot run TCL wrapper for TCL console : {}", (Object)e.getMessage());
            return;
        }
        new Thread(() -> {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            try {
                String line;
                StringBuilder errorMessage = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    errorMessage.append("\n").append(line);
                    if (!line.contains("TCL_WRAPPER_RUNNING")) continue;
                    new Thread(() -> {
                        Scanner sc = new Scanner(new InputStreamReader(this.process.getInputStream()));
                        while (sc.hasNextLine()) {
                            String nextLine = sc.nextLine();
                            if (nextLine.length() <= 0) continue;
                            System.out.println(nextLine);
                        }
                        sc.close();
                        this.stop();
                    }).start();
                    this.tclConsole.tclWrapperStartCallback();
                    this.state = TclWrapperState.RUNNING;
                    return;
                }
                MessageBox userInfoBox = new MessageBox("Error starting TCL wrapper", errorMessage.toString(), 0);
                userInfoBox.show();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public void stop() {
        this.tclConsole.send("end");
        try {
            this.tclConsole.getTclClient().getSocket().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.state = TclWrapperState.STOPPED;
    }

    public static enum TclWrapperState {
        STOPPED,
        STARTING,
        RUNNING;

    }
}

