/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.plexers;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.gui.icons.PlexerIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.plexers.BitSelectorHdlGeneratorFactory;
import com.cburch.logisim.std.plexers.PlexersLibrary;
import com.cburch.logisim.tools.key.BitWidthConfigurator;
import com.cburch.logisim.tools.key.JoinedConfigurator;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;

public class BitSelector
extends InstanceFactory {
    public static final String _ID = "BitSelector";
    public static final Attribute<BitWidth> GROUP_ATTR = Attributes.forBitWidth("group", Strings.S.getter("bitSelectorGroupAttr"));
    public static final Attribute<Integer> SELECT_ATTR = Attributes.forNoSave();
    public static final Attribute<Integer> EXTENDED_ATTR = Attributes.forNoSave();

    public BitSelector() {
        super(_ID, Strings.S.getter("bitSelectorComponent"), new BitSelectorHdlGeneratorFactory());
        this.setAttributes(new Attribute[]{StdAttr.FACING, StdAttr.SELECT_LOC, StdAttr.WIDTH, GROUP_ATTR, SELECT_ATTR, EXTENDED_ATTR}, new Object[]{Direction.EAST, StdAttr.SELECT_BOTTOM_LEFT, BitWidth.create(8), BitWidth.ONE, 3, 9});
        this.setKeyConfigurator(JoinedConfigurator.create(new BitWidthConfigurator(GROUP_ATTR, 1, 64, 0), new BitWidthConfigurator(StdAttr.WIDTH)));
        this.setIcon(new PlexerIcon(false, true));
        this.setFacingAttribute(StdAttr.FACING);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        StringBuilder completeName = new StringBuilder();
        completeName.append(CorrectLabel.getCorrectLabel(this.getName()));
        if (attrs.getValue(GROUP_ATTR).getWidth() > 1) {
            completeName.append("_bus");
        }
        return completeName.toString();
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        Direction facing = attrs.getValue(StdAttr.FACING);
        Bounds base = Bounds.create(-30, -15, 30, 30);
        return base.rotate(Direction.EAST, facing, 0, 0);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == StdAttr.FACING) {
            instance.recomputeBounds();
            this.updatePorts(instance);
        } else if (attr == StdAttr.WIDTH || attr == GROUP_ATTR || attr == StdAttr.SELECT_LOC) {
            this.updatePorts(instance);
        }
    }

    @Override
    public void paintGhost(InstancePainter painter) {
        PlexersLibrary.drawTrapezoid(painter.getGraphics(), painter.getBounds(), painter.getAttributeValue(StdAttr.FACING), 9);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics g = painter.getGraphics();
        Direction facing = painter.getAttributeValue(StdAttr.FACING);
        g.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        PlexersLibrary.drawTrapezoid(g, painter.getBounds(), facing, 9);
        Bounds bds = painter.getBounds();
        GraphicsUtil.drawCenteredText(g, "Sel", bds.getX() + bds.getWidth() / 2, bds.getY() + bds.getHeight() / 2);
        painter.drawPorts();
    }

    @Override
    public void propagate(InstanceState state) {
        Value group;
        Value data = state.getPortValue(1);
        Value select = state.getPortValue(2);
        BitWidth groupBits = state.getAttributeValue(GROUP_ATTR);
        if (!select.isFullyDefined()) {
            group = Value.createUnknown(groupBits);
        } else {
            int shift = (int)select.toLongValue() * groupBits.getWidth();
            if (shift >= data.getWidth()) {
                group = Value.createKnown(groupBits, 0L);
            } else if (groupBits.getWidth() == 1) {
                group = data.get(shift);
            } else {
                Value[] bits = new Value[groupBits.getWidth()];
                for (int i = 0; i < bits.length; ++i) {
                    bits[i] = shift + i >= data.getWidth() ? Value.FALSE : data.get(shift + i);
                }
                group = Value.create(bits);
            }
        }
        state.setPort(0, group, 3);
    }

    private void updatePorts(Instance instance) {
        Location selPt;
        Location inPt;
        Direction facing = instance.getAttributeValue(StdAttr.FACING);
        AttributeOption selectLoc = instance.getAttributeValue(StdAttr.SELECT_LOC);
        BitWidth data = instance.getAttributeValue(StdAttr.WIDTH);
        BitWidth group = instance.getAttributeValue(GROUP_ATTR);
        int groups = (data.getWidth() + group.getWidth() - 1) / group.getWidth() - 1;
        int selectBits = 1;
        if (groups > 0) {
            while (groups != 1) {
                groups >>= 1;
                ++selectBits;
            }
        }
        BitWidth select = BitWidth.create(selectBits);
        instance.getAttributeSet().setValue(SELECT_ATTR, select.getWidth());
        int maxGroups = (int)Math.pow(2.0, select.getWidth());
        instance.getAttributeSet().setValue(EXTENDED_ATTR, maxGroups * group.getWidth() + 1);
        if (facing == Direction.WEST) {
            inPt = Location.create(30, 0, true);
            selPt = selectLoc == StdAttr.SELECT_BOTTOM_LEFT ? Location.create(10, -10, true) : Location.create(10, 10, true);
        } else if (facing == Direction.NORTH) {
            inPt = Location.create(0, 30, true);
            selPt = selectLoc == StdAttr.SELECT_BOTTOM_LEFT ? Location.create(-10, 10, true) : Location.create(10, 10, true);
        } else if (facing == Direction.SOUTH) {
            inPt = Location.create(0, -30, true);
            selPt = selectLoc == StdAttr.SELECT_BOTTOM_LEFT ? Location.create(-10, -10, true) : Location.create(10, -10, true);
        } else {
            inPt = Location.create(-30, 0, true);
            selPt = selectLoc == StdAttr.SELECT_BOTTOM_LEFT ? Location.create(-10, 10, true) : Location.create(-10, -10, true);
        }
        Port[] ps = new Port[]{new Port(0, 0, "output", group.getWidth()), new Port(inPt.getX(), inPt.getY(), "input", data.getWidth()), new Port(selPt.getX(), selPt.getY(), "input", select.getWidth())};
        ps[0].setToolTip(Strings.S.getter("bitSelectorOutputTip"));
        ps[1].setToolTip(Strings.S.getter("bitSelectorDataTip"));
        ps[2].setToolTip(Strings.S.getter("bitSelectorSelectTip"));
        instance.setPorts(ps);
    }
}

