/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.hex.HexModel;
import com.cburch.hex.HexModelListener;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.MemContents;

class RomContentsListener
implements HexModelListener {
    final Project proj;
    boolean enabled = true;

    RomContentsListener(Project proj) {
        this.proj = proj;
    }

    @Override
    public void bytesChanged(HexModel source, long start, long numBytes, long[] oldValues) {
        if (this.enabled && this.proj != null && oldValues != null) {
            long[] newValues = new long[oldValues.length];
            for (int i = 0; i < newValues.length; ++i) {
                newValues[i] = source.get(start + (long)i);
            }
            this.proj.doAction(new Change(this, (MemContents)source, start, oldValues, newValues));
        }
    }

    @Override
    public void metainfoChanged(HexModel source) {
    }

    void setEnabled(boolean value) {
        this.enabled = value;
    }

    private static class Change
    extends Action {
        private final RomContentsListener source;
        private final MemContents contents;
        private final long start;
        private final long[] oldValues;
        private final long[] newValues;
        private boolean completed = true;

        Change(RomContentsListener source, MemContents contents, long start, long[] oldValues, long[] newValues) {
            this.source = source;
            this.contents = contents;
            this.start = start;
            this.oldValues = oldValues;
            this.newValues = newValues;
        }

        @Override
        public Action append(Action other) {
            if (other instanceof Change) {
                Change o = (Change)other;
                long oEnd = o.start + (long)o.newValues.length;
                long end = this.start + (long)this.newValues.length;
                if (oEnd >= this.start && end >= o.start) {
                    long nStart = Math.min(this.start, o.start);
                    long nEnd = Math.max(end, oEnd);
                    long[] nOld = new long[(int)(nEnd - nStart)];
                    long[] nNew = new long[(int)(nEnd - nStart)];
                    System.arraycopy(o.oldValues, 0, nOld, (int)(o.start - nStart), o.oldValues.length);
                    System.arraycopy(this.oldValues, 0, nOld, (int)(this.start - nStart), this.oldValues.length);
                    System.arraycopy(this.newValues, 0, nNew, (int)(this.start - nStart), this.newValues.length);
                    System.arraycopy(o.newValues, 0, nNew, (int)(o.start - nStart), o.newValues.length);
                    return new Change(this.source, this.contents, nStart, nOld, nNew);
                }
            }
            return super.append(other);
        }

        @Override
        public void doIt(Project proj) {
            if (!this.completed) {
                this.completed = true;
                try {
                    this.source.setEnabled(false);
                    this.contents.set(this.start, this.newValues);
                }
                finally {
                    this.source.setEnabled(true);
                }
            }
        }

        @Override
        public String getName() {
            return Strings.S.get("romChangeAction");
        }

        @Override
        public boolean shouldAppendTo(Action other) {
            if (other instanceof Change) {
                Change o = (Change)other;
                long oEnd = o.start + (long)o.newValues.length;
                long end = this.start + (long)this.newValues.length;
                if (oEnd >= this.start && end >= o.start) {
                    return true;
                }
            }
            return super.shouldAppendTo(other);
        }

        @Override
        public void undo(Project proj) {
            if (this.completed) {
                this.completed = false;
                try {
                    this.source.setEnabled(false);
                    this.contents.set(this.start, this.oldValues);
                }
                finally {
                    this.source.setEnabled(true);
                }
            }
        }
    }
}

