/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.gui.hex.HexFrame;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.memory.Mem;
import com.cburch.logisim.std.memory.MemContents;
import com.cburch.logisim.std.memory.Rom;
import com.cburch.logisim.std.memory.RomContentsListener;
import java.awt.Font;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;

class RomAttributes
extends AbstractAttributeSet {
    private static final List<Attribute<?>> ATTRIBUTES = Arrays.asList(Mem.ADDR_ATTR, Mem.DATA_ATTR, Mem.LINE_ATTR, Mem.ALLOW_MISALIGNED, Rom.CONTENTS_ATTR, StdAttr.LABEL, StdAttr.LABEL_FONT, StdAttr.LABEL_VISIBILITY, StdAttr.APPEARANCE);
    private static final WeakHashMap<MemContents, RomContentsListener> listenerRegistry = new WeakHashMap();
    private static final WeakHashMap<MemContents, HexFrame> windowRegistry = new WeakHashMap();
    private BitWidth addrBits = BitWidth.create(8);
    private BitWidth dataBits = BitWidth.create(8);
    private MemContents contents;
    private AttributeOption lineSize = Mem.SINGLE;
    private Boolean allowMisaligned = false;
    private String label = "";
    private Font labelFont = StdAttr.DEFAULT_LABEL_FONT;
    private Boolean labelVisible = false;
    private AttributeOption appearance = AppPreferences.getDefaultAppearance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HexFrame getHexFrame(MemContents value, Project proj, Instance instance) {
        WeakHashMap<MemContents, HexFrame> weakHashMap = windowRegistry;
        synchronized (weakHashMap) {
            HexFrame ret = windowRegistry.get(value);
            if (ret == null) {
                ret = new HexFrame(proj, instance, value);
                windowRegistry.put(value, ret);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void closeHexFrame(MemContents value) {
        HexFrame ret;
        WeakHashMap<MemContents, HexFrame> weakHashMap = windowRegistry;
        synchronized (weakHashMap) {
            ret = windowRegistry.remove(value);
        }
        if (ret != null) {
            ret.closeAndDispose();
        }
    }

    static void register(MemContents value, Project proj) {
        if (proj == null || listenerRegistry.containsKey(value)) {
            return;
        }
        RomContentsListener l = new RomContentsListener(proj);
        value.addHexModelListener(l);
        listenerRegistry.put(value, l);
    }

    RomAttributes() {
        this.contents = MemContents.create(this.addrBits.getWidth(), this.dataBits.getWidth(), false);
    }

    @Override
    protected void copyInto(AbstractAttributeSet dest) {
        RomAttributes d = (RomAttributes)dest;
        d.addrBits = this.addrBits;
        d.dataBits = this.dataBits;
        d.lineSize = this.lineSize;
        d.allowMisaligned = this.allowMisaligned;
        d.contents = this.contents.clone();
        d.labelFont = this.labelFont;
        d.labelVisible = this.labelVisible;
        d.appearance = this.appearance;
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return ATTRIBUTES;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == Mem.ADDR_ATTR) {
            return (V)this.addrBits;
        }
        if (attr == Mem.DATA_ATTR) {
            return (V)this.dataBits;
        }
        if (attr == Mem.LINE_ATTR) {
            return (V)this.lineSize;
        }
        if (attr == Mem.ALLOW_MISALIGNED) {
            return (V)this.allowMisaligned;
        }
        if (attr == Rom.CONTENTS_ATTR) {
            return (V)this.contents;
        }
        if (attr == StdAttr.LABEL) {
            return (V)this.label;
        }
        if (attr == StdAttr.LABEL_FONT) {
            return (V)this.labelFont;
        }
        if (attr == StdAttr.LABEL_VISIBILITY) {
            return (V)this.labelVisible;
        }
        if (attr == StdAttr.APPEARANCE) {
            return (V)this.appearance;
        }
        return null;
    }

    void setProject(Project proj) {
        RomAttributes.register(this.contents, proj);
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        if (attr == Mem.ADDR_ATTR) {
            BitWidth newAddr = (BitWidth)value;
            if (newAddr == this.addrBits) {
                return;
            }
            this.addrBits = newAddr;
            this.contents.setDimensions(this.addrBits.getWidth(), this.dataBits.getWidth());
            this.fireAttributeValueChanged(attr, value, null);
        } else if (attr == Mem.DATA_ATTR) {
            BitWidth newData = (BitWidth)value;
            if (newData == this.dataBits) {
                return;
            }
            this.dataBits = newData;
            this.contents.setDimensions(this.addrBits.getWidth(), this.dataBits.getWidth());
            this.fireAttributeValueChanged(attr, value, null);
        } else if (attr == Mem.LINE_ATTR) {
            AttributeOption val = (AttributeOption)value;
            if (this.lineSize.equals(val)) {
                return;
            }
            this.lineSize = val;
            this.fireAttributeValueChanged(attr, value, null);
        } else if (attr == Mem.ALLOW_MISALIGNED) {
            Boolean val = (Boolean)value;
            if (this.allowMisaligned.equals(val)) {
                return;
            }
            this.allowMisaligned = val;
            this.fireAttributeValueChanged(attr, value, null);
        } else if (attr == Rom.CONTENTS_ATTR) {
            MemContents newContents = (MemContents)value;
            if (this.contents.equals(newContents)) {
                return;
            }
            this.contents = newContents;
            this.fireAttributeValueChanged(attr, value, null);
        } else if (attr == StdAttr.LABEL) {
            String newLabel = (String)value;
            if (this.label.equals(newLabel)) {
                return;
            }
            String oldLabel = this.label;
            this.label = newLabel;
            this.fireAttributeValueChanged(attr, value, oldLabel);
        } else if (attr == StdAttr.LABEL_FONT) {
            Font newFont = (Font)value;
            if (this.labelFont.equals(newFont)) {
                return;
            }
            this.labelFont = newFont;
            this.fireAttributeValueChanged(attr, value, null);
        } else if (attr == StdAttr.LABEL_VISIBILITY) {
            Boolean newVis = (Boolean)value;
            if (this.labelVisible.equals(newVis)) {
                return;
            }
            this.labelVisible = newVis;
            this.fireAttributeValueChanged(attr, value, null);
        } else if (attr == StdAttr.APPEARANCE) {
            AttributeOption newAppearance = (AttributeOption)value;
            if (this.appearance.equals(newAppearance)) {
                return;
            }
            this.appearance = newAppearance;
            this.fireAttributeValueChanged(attr, value, null);
        }
    }
}

