/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.HdlPorts;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.memory.Random;
import com.cburch.logisim.util.LineBuffer;
import java.util.SortedMap;
import java.util.TreeMap;

public class RandomHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String NR_OF_BITS_STR = "nrOfBits";
    private static final int NR_OF_BITS_ID = -1;
    private static final String SEED_STR = "seed";
    private static final int SEED_ID = -2;

    public RandomHdlGeneratorFactory() {
        this.myParametersList.add(NR_OF_BITS_STR, -1).addVector(SEED_STR, -2, 6, Random.ATTR_SEED, 32);
        this.myWires.addWire("s_initSeed", 48).addWire("s_reset", 1).addWire("s_resetNext", 3).addWire("s_multShiftNext", 36).addWire("s_seedShiftNext", 48).addWire("s_multBusy", 1).addWire("s_start", 1).addWire("s_macLowIn1", 25).addWire("s_macLowIn2", 25).addWire("s_macHigh1Next", 24).addWire("s_macHighIn2", 24).addWire("s_busyPipeNext", 2).addRegister("s_currentSeed", 48).addRegister("s_resetReg", 3).addRegister("s_multShiftReg", 36).addRegister("s_seedShiftReg", 48).addRegister("s_startReg", 1).addRegister("s_macLowReg", 25).addRegister("s_macHighReg", 24).addRegister("s_macHighReg1", 24).addRegister("s_busyPipeReg", 2).addRegister("s_outputReg", -1);
        this.myPorts.add("clock", HdlPorts.getClockName(1), 1, 1).add("input", "clear", 1, 3).add("input", "enable", 1, 2, false).add("output", "q", -1, 0);
    }

    public SortedMap<String, String> getPortMap(Netlist Nets, Object MapInfo2) {
        TreeMap<String, String> map = new TreeMap<String, String>(super.getPortMap(Nets, MapInfo2));
        if (MapInfo2 instanceof netlistComponent) {
            int nrOfBits;
            netlistComponent comp = (netlistComponent)MapInfo2;
            if (Hdl.isVhdl() && (nrOfBits = comp.getComponent().getAttributeSet().getValue(StdAttr.WIDTH).getWidth()) == 1) {
                String outMap = map.get("q");
                map.remove("q");
                map.put("q(0)", outMap);
            }
        }
        return map;
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist nets, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getBuffer().pair(SEED_STR, SEED_STR).pair(NR_OF_BITS_STR, NR_OF_BITS_STR).pair("GlobalClock", HdlPorts.getClockName(1)).pair("ClockEnable", HdlPorts.getTickName(1)).addRemarkBlock("This is a multicycle implementation of the Random Component").empty();
        if (Hdl.isVhdl()) {
            contents.empty().addVhdlKeywords().add("q               <= s_outputReg;\ns_initSeed      <= x\"0005DEECE66D\" {{when}} {{seed}} = x\"00000000\" {{else}}\n                   x\"0000\"&seed;\ns_reset         <= '1' {{when}} s_resetReg /= \"010\" {{else}} '0';\ns_resetNext     <= \"010\" {{when}} (s_resetReg = \"101\" {{or}}\n                               s_resetReg = \"010\") {{and}}\n                               clear = '0' {{else}}\n                   \"101\" {{when}} s_resetReg = \"001\" {{else}}\n                   \"001\";\ns_start         <= '1' {{when}} ({{ClockEnable}} = '1' {{and}} enable = '1') {{or}}\n                         (s_resetReg = \"101\" {{and}} clear = '0') {{else}} '0';\ns_multShiftNext <= ({{others}} => '0') {{when}} s_reset = '1' {{else}}\n                   X\"5DEECE66D\" {{when}} s_startReg = '1' {{else}}\n                   '0'&s_multShiftReg(35 {{downto}} 1);\ns_seedShiftNext <= ({{others}} => '0') {{when}} s_reset = '1' {{else}}\n                   s_currentSeed {{when}} s_startReg = '1' {{else}}\n                   s_seedShiftReg(46 {{downto}} 0)&'0';\ns_multBusy      <= '0' {{when}} s_multShiftReg = X\"000000000\" {{else}} '1';\n\ns_macLowIn1     <= ({{others}} => '0') {{when}} s_startReg = '1' {{or}}\n                                          s_reset = '1' {{else}}\n                   '0'&s_macLowReg(23 {{downto}} 0);\ns_macLowIn2     <= '0'&X\"00000B\"\n                        {{when}} s_startReg = '1' {{else}}\n                   '0'&s_seedShiftReg(23 {{downto}} 0)\n                        {{when}} s_multShiftReg(0) = '1' {{else}}\n                   ({{others}} => '0');\ns_macHighIn2    <= ({{others}} => '0') {{when}} s_startReg = '1' {{else}}\n                   s_macHighReg;\ns_macHigh1Next  <= s_seedShiftReg(47 {{downto}} 24)\n                      {{when}} s_multShiftReg(0) = '1' {{else}}\n                   ({{others}} => '0');\ns_busyPipeNext  <= \"00\" {{when}} s_reset = '1' {{else}}\n                   s_busyPipeReg(0)&s_multBusy;\n\nmakeCurrentSeed : {{process}}({{GlobalClock}}, s_busyPipeReg, s_reset) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{GlobalClock}})) {{then}}\n      {{if}} (s_reset = '1') {{then}} s_currentSeed <= s_initSeed;\n      {{elsif}} (s_busyPipeReg = \"10\") {{then}}\n         s_currentSeed <= s_macHighReg&s_macLowReg(23 {{downto}} 0);\n      {{end}} {{if}};\n   {{end}} {{if}};\n{{end}} {{process}} makeCurrentSeed;\n\nmakeShiftRegs : {{process}}({{GlobalClock}}, s_multShiftNext, s_seedShiftNext,\n                        s_macLowIn1, s_macLowIn2) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{GlobalClock}})) {{then}}\n      s_multShiftReg <= s_multShiftNext;\n      s_seedShiftReg <= s_seedShiftNext;\n      s_macLowReg    <= std_logic_vector( unsigned(s_macLowIn1) + unsigned(s_macLowIn2) );\n      s_macHighReg1  <= s_macHigh1Next;\n      s_macHighReg   <= std_logic_vector( unsigned(s_macHighReg1) + unsigned(s_macHighIn2) +\n                        unsigned(s_macLowReg(24 {{downto}} 24)) );\n      s_busyPipeReg  <= s_busyPipeNext;\n   {{end}} {{if}};\n{{end}} {{process}} makeShiftRegs;\n\nmakeStartReg : {{process}}({{GlobalClock}}, s_start) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{GlobalClock}})) {{then}}\n      s_startReg <= s_start;\n   {{end}} {{if}};\n{{end}} {{process}} makeStartReg;\n\nmakeResetReg : {{process}}({{GlobalClock}}, s_resetNext) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{GlobalClock}})) {{then}}\n      s_resetReg <= s_resetNext;\n   {{end}} {{if}};\n{{end}} {{process}} makeResetReg;\n\nmakeOutput : {{process}}({{GlobalClock}}, s_reset, s_initSeed) {{is}}\n{{begin}}\n   {{if}} (rising_edge({{GlobalClock}})) {{then}}\n      {{if}} (s_reset = '1') {{then}} s_outputReg <= s_initSeed( ({{nrOfBits}}-1) {{downto}} 0 );\n      {{elsif}} ({{ClockEnable}} = '1' {{and}} enable = '1') {{then}}\n         s_outputReg <= s_currentSeed(({{nrOfBits}}+11) {{downto}} 12);\n      {{end}} {{if}};\n   {{end}} {{if}};\n{{end}} {{process}} makeOutput;\n");
        } else {
            contents.add("assign q = s_outputReg;\nassign s_initSeed      = ({{seed}} == 0) ? 48'h5DEECE66D : {{seed}};\nassign s_reset         = (s_resetReg==3'b010) ? 1'b1 : 1'b0;\nassign s_resetNext     = (( (s_resetReg == 3'b101) | (s_resetReg == 3'b010)) & clear)\n                            ? 3'b010\n                            : (s_resetReg==3'b001) ? 3'b101 : 3'b001;\nassign s_start         = (({{ClockEnable}}&enable)|((s_resetReg == 3'b101)&clear)) ? 1'b1 : 1'b0;\nassign s_multShiftNext = (s_reset)\n                            ? 36'd0\n                            : (s_startReg) ? 36'h5DEECE66D : {1'b0,s_multShiftReg[35:1]};\nassign s_seedShiftNext = (s_reset)\n                            ? 48'd0\n                            : (s_startReg) ? s_currentSeed : {s_seedShiftReg[46:0],1'b0};\nassign s_multBusy      = (s_multShiftReg == 0) ? 1'b0 : 1'b1;\nassign s_macLowIn1     = (s_startReg|s_reset) ? 25'd0 : {1'b0,s_macLowReg[23:0]};\nassign s_macLowIn2     = (s_startReg) ? 25'hB\n                            : (s_multShiftReg[0])\n                            ? {1'b0,s_seedShiftReg[23:0]} : 25'd0;\nassign s_macHighIn2    = (s_startReg) ? 0 : s_macHighReg;\nassign s_macHigh1Next  = (s_multShiftReg[0]) ? s_seedShiftReg[47:24] : 0;\nassign s_busyPipeNext  = (s_reset) ? 2'd0 : {s_busyPipeReg[0],s_multBusy};\n\nalways @(posedge {{GlobalClock}})\nbegin\n   if (s_reset) s_currentSeed <= s_initSeed;\n   else if (s_busyPipeReg == 2'b10) s_currentSeed <= {s_macHighReg,s_macLowReg[23:0]};\nend\n\nalways @(posedge {{GlobalClock}})\nbegin\n      s_multShiftReg <= s_multShiftNext;\n      s_seedShiftReg <= s_seedShiftNext;\n      s_macLowReg    <= s_macLowIn1+s_macLowIn2;\n      s_macHighReg1  <= s_macHigh1Next;\n      s_macHighReg   <= s_macHighReg1+s_macHighIn2+s_macLowReg[24];\n      s_busyPipeReg  <= s_busyPipeNext;\n      s_startReg     <= s_start;\n      s_resetReg     <= s_resetNext;\nend\n\nalways @(posedge {{GlobalClock}})\nbegin\n   if (s_reset) s_outputReg <= s_initSeed[({{nrOfBits}}-1):0];\n   else if ({{ClockEnable}}&enable) s_outputReg <= s_currentSeed[({{nrOfBits}}+11):12];\nend\n");
        }
        return contents.empty();
    }
}

