/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.designrulecheck.CorrectLabel;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.gui.hex.HexFrame;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.memory.Mem;
import com.cburch.logisim.std.memory.MemContents;
import com.cburch.logisim.std.memory.MemState;
import com.cburch.logisim.std.memory.RamAppearance;
import com.cburch.logisim.std.memory.RamAttributes;
import com.cburch.logisim.std.memory.RamHdlGeneratorFactory;
import com.cburch.logisim.std.memory.RamState;
import java.util.WeakHashMap;
import java.util.function.Consumer;

public class Ram
extends Mem {
    public static final String _ID = "RAM";
    private static final Object[][] logOptions = new Object[9][];
    private static final WeakHashMap<MemContents, HexFrame> windowRegistry = new WeakHashMap();

    public Ram() {
        super(_ID, Strings.S.getter("ramComponent"), 3, new RamHdlGeneratorFactory(), true);
        this.setIcon(new ArithmeticIcon(_ID, 3));
        this.setInstanceLogger(Logger.class);
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        super.configureNewInstance(instance);
        instance.addAttributeListener();
    }

    @Override
    void configurePorts(Instance instance) {
        RamAppearance.configurePorts(instance);
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new RamAttributes();
    }

    @Override
    public String getHDLName(AttributeSet attrs) {
        String label = CorrectLabel.getCorrectLabel(attrs.getValue(StdAttr.LABEL));
        return label.length() == 0 ? _ID : "RAMCONTENTS_" + label;
    }

    private MemContents getNewContents(AttributeSet attrs) {
        MemContents contents = MemContents.create(attrs.getValue(Mem.ADDR_ATTR).getWidth(), attrs.getValue(Mem.DATA_ATTR).getWidth(), true);
        contents.condFillRandom();
        return contents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HexFrame getHexFrame(MemContents value, Project proj, Instance instance) {
        WeakHashMap<MemContents, HexFrame> weakHashMap = windowRegistry;
        synchronized (weakHashMap) {
            HexFrame ret = windowRegistry.get(value);
            if (ret == null) {
                ret = new HexFrame(proj, instance, value);
                windowRegistry.put(value, ret);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeHexFrame(RamState state) {
        HexFrame ret;
        MemContents contents = state.getContents();
        WeakHashMap<MemContents, HexFrame> weakHashMap = windowRegistry;
        synchronized (weakHashMap) {
            ret = windowRegistry.remove(contents);
        }
        if (ret == null) {
            return;
        }
        ret.closeAndDispose();
    }

    @Override
    public HexFrame getHexFrame(Project proj, Instance instance, CircuitState circState) {
        RamState ret = (RamState)instance.getData(circState);
        return Ram.getHexFrame(ret == null ? this.getNewContents(instance.getAttributeSet()) : ret.getContents(), proj, instance);
    }

    public boolean reset(CircuitState state, Instance instance) {
        RamState ret = (RamState)instance.getData(state);
        if (ret == null) {
            return true;
        }
        MemContents contents = ret.getContents();
        if (instance.getAttributeValue(RamAttributes.ATTR_TYPE).equals(RamAttributes.VOLATILE)) {
            contents.condClear();
        }
        return false;
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        return RamAppearance.getBounds(attrs);
    }

    public MemContents getContents(InstanceState ramState) {
        return this.getState(ramState).getContents();
    }

    @Override
    MemState getState(Instance instance, CircuitState state) {
        return this.getState(state.getInstanceState(instance));
    }

    @Override
    MemState getState(InstanceState state) {
        RamState ret = (RamState)state.getData();
        if (ret == null) {
            Instance instance = state.getInstance();
            ret = new RamState(instance, this.getNewContents(instance.getAttributeSet()), new Mem.MemListener(instance));
            state.setData(ret);
        } else {
            ret.setRam(state.getInstance());
        }
        return ret;
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        super.instanceAttributeChanged(instance, attr);
        if (attr == Mem.DATA_ATTR || attr == Mem.ADDR_ATTR || attr == RamAttributes.ATTR_DBUS || attr == StdAttr.TRIGGER || attr == RamAttributes.ATTR_ByteEnables || attr == StdAttr.APPEARANCE || attr == Mem.LINE_ATTR || attr == RamAttributes.CLEAR_PIN || attr == Mem.ENABLES_ATTR) {
            instance.recomputeBounds();
            this.configurePorts(instance);
        }
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        if (RamAppearance.classicAppearance(painter.getAttributeSet())) {
            RamAppearance.drawRamClassic(painter);
        } else {
            RamAppearance.drawRamEvolution(painter);
        }
    }

    @Override
    public void propagate(InstanceState state) {
        boolean goodAddr;
        Value clearValue;
        AttributeSet attrs = state.getAttributeSet();
        RamState myState = (RamState)this.getState(state);
        if (attrs.getValue(RamAttributes.CLEAR_PIN).booleanValue() && (clearValue = state.getPortValue(RamAppearance.getClrIndex(0, attrs))).equals(Value.TRUE)) {
            myState.getContents().clear();
            BitWidth dataBits = (BitWidth)state.getAttributeValue(DATA_ATTR);
            for (int i = 0; i < RamAppearance.getNrDataOutPorts(attrs); ++i) {
                Value portVal = Ram.isSeparate(attrs) ? Value.createKnown(dataBits, 0L) : Value.createUnknown(dataBits);
                state.setPort(RamAppearance.getDataOutIndex(i, attrs), portVal, 10);
            }
            return;
        }
        Value addrValue = state.getPortValue(RamAppearance.getAddrIndex(0, attrs));
        long addr = addrValue.toLongValue();
        boolean bl = goodAddr = addrValue.isFullyDefined() && addr >= 0L;
        if (goodAddr && addr != myState.getCurrent()) {
            myState.setCurrent(addr);
            myState.scrollToShow(addr);
        }
        if (attrs.getValue(Mem.ENABLES_ATTR).equals(Mem.USELINEENABLES)) {
            this.propagateLineEnables(state, addr, goodAddr, addrValue.isErrorValue());
        } else {
            this.propagateByteEnables(state, addr, goodAddr, addrValue.isErrorValue());
        }
    }

    private void propagateLineEnables(InstanceState state, long addr, boolean goodAddr, boolean errorValue) {
        boolean outputEnabled;
        boolean writeEnabled;
        AttributeSet attrs = state.getAttributeSet();
        RamState myState = (RamState)this.getState(state);
        boolean separate = Ram.isSeparate(attrs);
        int dataLines = Math.max(1, RamAppearance.getNrLEPorts(attrs));
        boolean misaligned = addr % (long)dataLines != 0L;
        boolean misalignError = misaligned && (Boolean)state.getAttributeValue(ALLOW_MISALIGNED) == false;
        AttributeOption trigger = state.getAttributeValue(StdAttr.TRIGGER);
        boolean triggered = myState.setClock(state.getPortValue(RamAppearance.getClkIndex(0, attrs)), trigger);
        boolean bl = writeEnabled = triggered && state.getPortValue(RamAppearance.getWEIndex(0, attrs)) == Value.TRUE;
        if (writeEnabled && goodAddr && !misalignError) {
            for (int i = 0; i < dataLines; ++i) {
                Value le;
                if (dataLines > 1 && (le = state.getPortValue(RamAppearance.getLEIndex(i, attrs))) != null && le.equals(Value.FALSE)) continue;
                long dataValue = state.getPortValue(RamAppearance.getDataInIndex(i, attrs)).toLongValue();
                myState.getContents().set(addr + (long)i, dataValue);
            }
        }
        BitWidth width = (BitWidth)state.getAttributeValue(DATA_ATTR);
        boolean bl2 = outputEnabled = separate || !state.getPortValue(RamAppearance.getOEIndex(0, attrs)).equals(Value.FALSE);
        if (outputEnabled && goodAddr && !misalignError) {
            for (int i = 0; i < dataLines; ++i) {
                long val = myState.getContents().get(addr + (long)i);
                state.setPort(RamAppearance.getDataOutIndex(i, attrs), Value.createKnown(width, val), 10);
            }
        } else if (outputEnabled && (errorValue || goodAddr && misalignError)) {
            for (int i = 0; i < dataLines; ++i) {
                state.setPort(RamAppearance.getDataOutIndex(i, attrs), Value.createError(width), 10);
            }
        } else {
            for (int i = 0; i < dataLines; ++i) {
                state.setPort(RamAppearance.getDataOutIndex(i, attrs), Value.createUnknown(width), 10);
            }
        }
    }

    private void propagateByteEnables(InstanceState state, long addr, boolean goodAddr, boolean errorValue) {
        boolean asyncRead;
        boolean weTriggered;
        long oldMemValue;
        AttributeSet attrs = state.getAttributeSet();
        RamState myState = (RamState)this.getState(state);
        boolean separate = Ram.isSeparate(attrs);
        long newMemValue = oldMemValue = myState.getContents().get(myState.getCurrent());
        AttributeOption trigger = state.getAttributeValue(StdAttr.TRIGGER);
        Value weValue = state.getPortValue(RamAppearance.getWEIndex(0, attrs));
        boolean async = trigger.equals(StdAttr.TRIG_HIGH) || trigger.equals(StdAttr.TRIG_LOW);
        boolean edge = !async && myState.setClock(state.getPortValue(RamAppearance.getClkIndex(0, attrs)), trigger);
        boolean weAsync = trigger.equals(StdAttr.TRIG_HIGH) && weValue.equals(Value.TRUE) || trigger.equals(StdAttr.TRIG_LOW) && weValue.equals(Value.FALSE);
        boolean bl = weTriggered = async && weAsync || edge && weValue.equals(Value.TRUE);
        if (goodAddr && weTriggered) {
            long dataInValue = state.getPortValue(RamAppearance.getDataInIndex(0, attrs)).toLongValue();
            if (RamAppearance.getNrBEPorts(attrs) == 0) {
                newMemValue = dataInValue;
            } else {
                for (int i = 0; i < RamAppearance.getNrBEPorts(attrs); ++i) {
                    long mask = 255L << i * 8;
                    long andMask = mask ^ 0xFFFFFFFFFFFFFFFFL;
                    if (!state.getPortValue(RamAppearance.getBEIndex(i, attrs)).equals(Value.TRUE)) continue;
                    newMemValue &= andMask;
                    newMemValue |= dataInValue & mask;
                }
            }
            myState.getContents().set(addr, newMemValue);
        }
        BitWidth dataBits = (BitWidth)state.getAttributeValue(DATA_ATTR);
        boolean outputNotEnabled = state.getPortValue(RamAppearance.getOEIndex(0, attrs)).equals(Value.FALSE);
        Consumer<Value> setValue = value -> state.setPort(RamAppearance.getDataOutIndex(0, attrs), (Value)value, 10);
        if (!separate && outputNotEnabled) {
            setValue.accept(Value.createUnknown(dataBits));
            return;
        }
        if (outputNotEnabled) {
            return;
        }
        if (errorValue) {
            setValue.accept(Value.createError(dataBits));
            return;
        }
        if (!goodAddr) {
            setValue.accept(Value.createUnknown(dataBits));
            return;
        }
        boolean bl2 = asyncRead = async || attrs.getValue(Mem.ASYNC_READ) != false;
        if (asyncRead) {
            setValue.accept(Value.createKnown(dataBits, newMemValue));
            return;
        }
        if (edge) {
            if (attrs.getValue(Mem.READ_ATTR).equals(Mem.READAFTERWRITE)) {
                setValue.accept(Value.createKnown(dataBits, newMemValue));
            } else {
                setValue.accept(Value.createKnown(dataBits, oldMemValue));
            }
        }
    }

    @Override
    public void removeComponent(Circuit circ, Component c, CircuitState state) {
        if (state != null) {
            Ram.closeHexFrame((RamState)state.getData(c));
        }
    }

    public static boolean isSeparate(AttributeSet attrs) {
        AttributeOption bus = attrs.getValue(RamAttributes.ATTR_DBUS);
        return bus == null || bus.equals(RamAttributes.BUS_SEP);
    }

    @Override
    public boolean checkForGatedClocks(netlistComponent comp) {
        return true;
    }

    @Override
    public int[] clockPinIndex(netlistComponent comp) {
        return new int[]{RamAppearance.getClkIndex(0, comp.getComponent().getAttributeSet())};
    }

    public static class Logger
    extends InstanceLogger {
        @Override
        public String getLogName(InstanceState state, Object option) {
            String label = state.getAttributeValue(StdAttr.LABEL);
            if (label.equals("")) {
                label = null;
            }
            if (option instanceof Long) {
                String disp = Strings.S.get("ramComponent");
                Location loc = state.getInstance().getLocation();
                return label == null ? disp + String.valueOf(loc) + "[" + String.valueOf(option) + "]" : label + "[" + String.valueOf(option) + "]";
            }
            return label;
        }

        @Override
        public BitWidth getBitWidth(InstanceState state, Object option) {
            return state.getAttributeValue(Mem.DATA_ATTR);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] getLogOptions(InstanceState state) {
            int addrBits = state.getAttributeValue(Mem.ADDR_ATTR).getWidth();
            if (addrBits >= logOptions.length) {
                addrBits = logOptions.length - 1;
            }
            Object[][] objectArray = logOptions;
            synchronized (logOptions) {
                Object[] ret = logOptions[addrBits];
                if (ret == null) {
                    ret = new Object[1 << addrBits];
                    Ram.logOptions[addrBits] = ret;
                    for (int i = 0; i < ret.length; ++i) {
                        ret[i] = i;
                    }
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return ret;
            }
        }

        @Override
        public Value getLogValue(InstanceState state, Object option) {
            if (option instanceof Long) {
                Long addr = (Long)option;
                MemState memState = (MemState)state.getData();
                return Value.createKnown(BitWidth.create(memState.getDataBits()), memState.getContents().get(addr));
            }
            return Value.NIL;
        }
    }
}

