/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.memory;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;
import java.util.Map;

public class AbstractFlipFlopHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    private static final String INVERT_CLOCK_STRING = "invertClockEnable";
    private static final int INVERT_CLOCK_ID = -1;
    private final int nrOfInputs;
    public static final Map<AttributeOption, Integer> TRIGGER_MAP = new HashMap<AttributeOption, Integer>(){
        {
            this.put(StdAttr.TRIG_HIGH, 0);
            this.put(StdAttr.TRIG_LOW, 1);
            this.put(StdAttr.TRIG_FALLING, 1);
            this.put(StdAttr.TRIG_RISING, 0);
        }
    };

    public AbstractFlipFlopHdlGeneratorFactory(int numInputs, Attribute<AttributeOption> triggerAttr) {
        this.nrOfInputs = numInputs;
        this.myParametersList.add(INVERT_CLOCK_STRING, -1, 4, triggerAttr, TRIGGER_MAP);
        this.myWires.addWire("s_clock", 1).addWire("s_nextState", 1).addRegister("s_currentState", 1);
        this.myPorts.add("input", "reset", 1, this.nrOfInputs + 3).add("input", "preset", 1, this.nrOfInputs + 4).add("clock", "clock", 1, this.nrOfInputs).add("output", "q", 1, this.nrOfInputs + 1).add("output", "qBar", 1, this.nrOfInputs + 2);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist nets, AttributeSet attrs) {
        LineBuffer contents = LineBuffer.getHdlBuffer();
        contents.pair("invertClock", INVERT_CLOCK_STRING).pair("Clock", "clock").pair("Tick", "tick").empty().addRemarkBlock("Here the output signals are defined").add("{{assign}}q       {{=}}s_currentState;\n{{assign}}qBar    {{=}}{{not}}(s_currentState);\n");
        if (Hdl.isVhdl()) {
            contents.addVhdlKeywords().add("s_clock {{=}}{{Clock}} {{when}} {{invertClock}} = 0 {{else}} {{not}}({{Clock}});").empty();
        } else {
            contents.add("assign s_clock {{=}}({{invertClock}} == 0) ? {{Clock}} : ~{{Clock}};").empty().addRemarkBlock("Here the initial register value is defined; for simulation only").add("initial\nbegin\n   s_currentState = 0;\nend\n").empty();
        }
        contents.addRemarkBlock("Here the update logic is defined").add(this.getUpdateLogic()).empty().addRemarkBlock("Here the actual state register is defined");
        if (Hdl.isVhdl()) {
            contents.add("makeMemory : {{process}}( s_clock , reset , preset , {{Tick}} , s_nextState ) {{is}}\n{{begin}}\n   {{if}} (reset = '1') {{then}} s_currentState <= '0';\n   {{elsif}} (preset = '1') {{then}} s_currentState <= '1';\n");
            if (Netlist.isFlipFlop(attrs)) {
                contents.add("   {{elsif}} (rising_edge(s_clock)) {{then}}");
            } else {
                contents.add("   {{elsif}} (s_clock = '1') {{then}}");
            }
            contents.add("      {{if}} ({{Tick}} = '1') {{then}}\n         s_currentState <= s_nextState;\n      {{end}} {{if}};\n   {{end}} {{if}};\n{{end}} {{process}} makeMemory;\n");
        } else if (Netlist.isFlipFlop(attrs)) {
            contents.add("always @(posedge reset or posedge preset or posedge s_clock)\nbegin\n   if (reset) s_currentState <= 1'b0;\n   else if (preset) s_currentState <= 1'b1;\n   else if ({{Tick}}) s_currentState <= s_nextState;\nend\n");
        } else {
            contents.add("always @(*)\nbegin\n   if (reset) s_currentState <= 1'b0;\n   else if (preset) s_currentState <= 1'b1;\n   else if ({{Tick}} & (s_clock == 1'b1)) s_currentState <= s_nextState;\nend\n");
        }
        return contents.empty();
    }

    public LineBuffer getUpdateLogic() {
        return LineBuffer.getHdlBuffer();
    }
}

