/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.io;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.designrulecheck.netlistComponent;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.fpga.hdlgenerator.InlinedHdlGeneratorFactory;
import com.cburch.logisim.std.io.DotMatrixBase;
import com.cburch.logisim.std.io.LedBar;
import com.cburch.logisim.util.LineBuffer;
import java.util.HashMap;

public class LedBarHdlGeneratorFactory
extends InlinedHdlGeneratorFactory {
    @Override
    public LineBuffer getInlinedCode(Netlist netlist, Long componentId, netlistComponent componentInfo, String circuitName) {
        LineBuffer contents = LineBuffer.getHdlBuffer();
        boolean isSingleBus = componentInfo.getComponent().getAttributeSet().getValue(LedBar.ATTR_INPUT_TYPE).equals(LedBar.INPUT_ONE_WIRE);
        int nrOfSegments = componentInfo.getComponent().getAttributeSet().getValue(LedBar.ATTR_MATRIX_COLS).getWidth();
        HashMap<String, String> wires = new HashMap<String, String>();
        for (int pin = 0; pin < nrOfSegments; ++pin) {
            String destPin = LineBuffer.format("{{1}}{{<}}{{2}}{{>}}", "logisimOutputBubbles", componentInfo.getLocalBubbleOutputStartId() + pin);
            String sourcePin = isSingleBus ? Hdl.getBusEntryName(componentInfo, 0, true, pin, netlist) : Hdl.getNetName(componentInfo, pin, true, netlist);
            wires.put(destPin, sourcePin);
        }
        Hdl.addAllWiresSorted(contents, wires);
        return contents;
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        return attrs.getValue(DotMatrixBase.ATTR_PERSIST) == 0;
    }
}

