/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.hdl.HdlModel;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.std.hdl.BlifParser;
import com.cburch.logisim.std.hdl.DenseLogicCircuit;
import com.cburch.logisim.std.hdl.HdlContent;
import com.cburch.logisim.vhdl.Strings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlifContentComponent
extends HdlContent {
    private static final String RESOURCE = "/resources/logisim/hdl/blif.templ";
    private static final String TEMPLATE = BlifContentComponent.loadTemplate();
    protected StringBuilder content;
    protected HdlModel.PortDescription[] inputs;
    protected HdlModel.PortDescription[] outputs;
    protected DenseLogicCircuit compiled;
    protected int[][] compiledInputPinsX;
    protected int[][] compiledInputPinsO;
    protected int[][] compiledOutputPinsX;
    protected int[][] compiledOutputPinsO;
    protected String name;

    public static BlifContentComponent create() {
        return new BlifContentComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadTemplate() {
        InputStream input = BlifContentComponent.class.getResourceAsStream(RESOURCE);
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        StringBuilder tmp = new StringBuilder();
        try {
            String line;
            while ((line = in.readLine()) != null) {
                tmp.append(line);
                tmp.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException ex) {
            String string = "";
            return string;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(BlifContentComponent.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return tmp.toString();
    }

    protected BlifContentComponent() {
        this.setContent(TEMPLATE);
    }

    @Override
    public BlifContentComponent clone() {
        try {
            BlifContentComponent ret = (BlifContentComponent)super.clone();
            ret.content = new StringBuilder(this.content);
            return ret;
        }
        catch (CloneNotSupportedException ex) {
            return this;
        }
    }

    @Override
    public boolean compare(HdlModel model) {
        return this.compare(model.getContent());
    }

    @Override
    public boolean compare(String value) {
        return this.content.toString().replaceAll("\\r\\n|\\r|\\n", " ").equals(value.replaceAll("\\r\\n|\\r|\\n", " "));
    }

    @Override
    public String getContent() {
        return this.content.toString();
    }

    @Override
    public HdlModel.PortDescription[] getInputs() {
        return this.inputs == null ? new HdlModel.PortDescription[]{} : this.inputs;
    }

    @Override
    public String getName() {
        return this.name == null ? "" : this.name;
    }

    @Override
    public HdlModel.PortDescription[] getOutputs() {
        return this.outputs == null ? new HdlModel.PortDescription[]{} : this.outputs;
    }

    @Override
    public boolean setContent(String content) {
        DenseLogicCircuit compiledCircuit;
        BlifParser parser = new BlifParser(content);
        try {
            parser.parse();
            compiledCircuit = parser.compile();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            OptionPane.showMessageDialog(null, ex.getMessage(), Strings.S.get("validationParseError"), 0);
            return false;
        }
        this.name = parser.getName();
        List<HdlModel.PortDescription> inputsDesc = parser.getInputs();
        List<HdlModel.PortDescription> outputsDesc = parser.getOutputs();
        this.inputs = inputsDesc.toArray(new HdlModel.PortDescription[0]);
        this.outputs = outputsDesc.toArray(new HdlModel.PortDescription[0]);
        this.compiled = compiledCircuit;
        this.compiledInputPinsX = this.derivePins(parser, this.compiled, this.inputs, false);
        this.compiledInputPinsO = this.derivePins(parser, this.compiled, this.inputs, true);
        this.compiledOutputPinsX = this.derivePins(parser, this.compiled, this.outputs, false);
        this.compiledOutputPinsO = this.derivePins(parser, this.compiled, this.outputs, true);
        this.content = new StringBuilder(content);
        this.fireContentSet();
        return true;
    }

    private int[][] derivePins(BlifParser parser, DenseLogicCircuit compiled, HdlModel.PortDescription[] ports, boolean output) {
        int[][] results = new int[ports.length][];
        for (int i = 0; i < ports.length; ++i) {
            HdlModel.PortDescription desc = ports[i];
            int[] result = new int[desc.getWidthInt()];
            for (int j = 0; j < result.length; ++j) {
                String symbol = parser.getPinDlcSymbol(desc, j, output);
                Integer symRes = compiled.symbolTable.get(symbol);
                result[j] = symRes != null ? symRes : -1;
            }
            results[i] = result;
        }
        return results;
    }
}

