/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.analyze.model.Expressions;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.std.gates.AbstractGate;
import com.cburch.logisim.std.gates.AbstractGateHdlGenerator;
import com.cburch.logisim.std.gates.GateAttributes;
import com.cburch.logisim.std.gates.GateFunctions;
import com.cburch.logisim.std.gates.PainterDin;
import com.cburch.logisim.std.gates.PainterShaped;
import com.cburch.logisim.tools.WireRepairData;
import com.cburch.logisim.util.LineBuffer;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

class XorGate
extends AbstractGate {
    public static final XorGate FACTORY = new XorGate();

    protected static Expression xorExpression(Expression[] inputs, int numInputs) {
        if (numInputs > 2) {
            throw new UnsupportedOperationException("XorGate");
        }
        Expression ret = inputs[0];
        for (int i = 1; i < numInputs; ++i) {
            ret = Expressions.xor(ret, inputs[i]);
        }
        return ret;
    }

    private XorGate() {
        super("XOR Gate", Strings.S.getter("xorGateComponent"), true, new XorGateHdlGeneratorFactory());
        this.setAdditionalWidth(10);
        this.setPaintInputLines(true);
    }

    @Override
    protected Expression computeExpression(Expression[] inputs, int numInputs) {
        return XorGate.xorExpression(inputs, numInputs);
    }

    @Override
    protected Value computeOutput(Value[] inputs, int numInputs, InstanceState state) {
        AttributeOption behavior = state.getAttributeValue(GateAttributes.ATTR_XOR);
        if (behavior == GateAttributes.XOR_ODD) {
            return GateFunctions.computeOddParity(inputs, numInputs);
        }
        return GateFunctions.computeExactlyOne(inputs, numInputs);
    }

    @Override
    protected Value getIdentity() {
        return Value.FALSE;
    }

    @Override
    public String getRectangularLabel(AttributeSet attrs) {
        Integer inputs;
        if (attrs == null) {
            return "";
        }
        boolean isOdd = false;
        AttributeOption behavior = attrs.getValue(GateAttributes.ATTR_XOR);
        if (behavior == GateAttributes.XOR_ODD && ((inputs = attrs.getValue(GateAttributes.ATTR_INPUTS)) == null || inputs != 2)) {
            isOdd = true;
        }
        return isOdd ? "2k+1" : "=1";
    }

    @Override
    protected void paintDinShape(InstancePainter painter, int width, int height, int inputs) {
        PainterDin.paintXor(painter, width, height, false);
    }

    @Override
    public void paintIconANSI(Graphics2D g, int iconSize, int borderSize, int negateSize) {
        XorGate.paintIconANSI(g, iconSize, borderSize, negateSize, false);
    }

    protected static void paintIconANSI(Graphics2D g, int iconSize, int borderSize, int negateSize, boolean inverted) {
        int xoff = negateSize >> 1;
        int ystart = negateSize >> 1;
        int yend = iconSize - ystart;
        int xstart = 0;
        int xend = iconSize - negateSize;
        GeneralPath shape = new GeneralPath();
        shape.moveTo(xend, iconSize >> 1);
        shape.quadTo(2 * xend / 3, ystart, xstart + xoff, ystart);
        shape.quadTo(xoff + xend / 3, iconSize >> 1, xstart + xoff, yend);
        shape.quadTo(2 * xend / 3, yend, xend, iconSize >> 1);
        shape.closePath();
        shape.moveTo(xstart, ystart);
        shape.quadTo(xend / 3, iconSize >> 1, xstart, yend);
        shape.moveTo(xstart, ystart);
        shape.closePath();
        AffineTransform af = g.getTransform();
        g.translate(borderSize, borderSize);
        g.draw(shape);
        XorGate.paintIconPins(g, iconSize, borderSize, negateSize, inverted, false);
        g.setTransform(af);
    }

    @Override
    protected void paintShape(InstancePainter painter, int width, int height) {
        PainterShaped.paintXor(painter, width, height);
    }

    @Override
    protected boolean shouldRepairWire(Instance instance, WireRepairData data) {
        return !data.getPoint().equals(instance.getLocation());
    }

    private static class XorGateHdlGeneratorFactory
    extends AbstractGateHdlGenerator {
        private XorGateHdlGeneratorFactory() {
        }

        @Override
        public LineBuffer getLogicFunction(int nrOfInputs, int bitwidth, boolean isOneHot) {
            return LineBuffer.getBuffer().add(isOneHot ? this.getOneHot(false, nrOfInputs, bitwidth > 1) : XorGateHdlGeneratorFactory.getParity(false, nrOfInputs, bitwidth > 1));
        }
    }
}

