/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.analyze.model.Expression;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.std.gates.AndGate;
import com.cburch.logisim.std.gates.EvenParityGate;
import com.cburch.logisim.std.gates.NandGate;
import com.cburch.logisim.std.gates.NorGate;
import com.cburch.logisim.std.gates.NotGate;
import com.cburch.logisim.std.gates.OddParityGate;
import com.cburch.logisim.std.gates.OrGate;
import com.cburch.logisim.std.gates.XnorGate;
import com.cburch.logisim.std.gates.XorGate;
import java.util.ArrayList;

abstract class CircuitDetermination {
    CircuitDetermination() {
    }

    static CircuitDetermination create(Expression expr) {
        if (expr == null) {
            return null;
        }
        return expr.visit(new Determine());
    }

    void convertToNands() {
    }

    void convertToTwoInputs() {
    }

    boolean isNandNot() {
        return false;
    }

    void repair() {
    }

    private static class Determine
    implements Expression.Visitor<CircuitDetermination> {
        private Determine() {
        }

        private Gate binary(CircuitDetermination aret, CircuitDetermination bret, ComponentFactory factory) {
            if (aret instanceof Gate) {
                Gate a = (Gate)aret;
                if (a.factory == factory) {
                    if (bret instanceof Gate) {
                        Gate b = (Gate)bret;
                        if (b.factory == factory) {
                            a.inputs.addAll(b.inputs);
                            return a;
                        }
                    }
                    a.inputs.add(bret);
                    return a;
                }
            }
            if (bret instanceof Gate) {
                Gate b = (Gate)bret;
                if (b.factory == factory) {
                    b.inputs.add(aret);
                    return b;
                }
            }
            Gate ret = new Gate(factory);
            ret.inputs.add(aret);
            ret.inputs.add(bret);
            return ret;
        }

        @Override
        public CircuitDetermination visitAnd(Expression a, Expression b) {
            return this.binary(a.visit(this), b.visit(this), AndGate.FACTORY);
        }

        @Override
        public CircuitDetermination visitConstant(int value) {
            return new Value(value);
        }

        @Override
        public CircuitDetermination visitNot(Expression aBase) {
            CircuitDetermination a;
            CircuitDetermination aret = aBase.visit(this);
            if (aret instanceof Gate) {
                a = (Gate)aret;
                if (((Gate)a).factory == AndGate.FACTORY) {
                    ((Gate)a).factory = NandGate.FACTORY;
                    return a;
                }
                if (((Gate)a).factory == OrGate.FACTORY) {
                    ((Gate)a).factory = NorGate.FACTORY;
                    return a;
                }
                if (((Gate)a).factory == XorGate.FACTORY) {
                    ((Gate)a).factory = XnorGate.FACTORY;
                    return a;
                }
            }
            if (aret instanceof Input) {
                a = (Input)aret;
                ((Input)a).togleInversion();
                return a;
            }
            Gate ret = new Gate(NotGate.FACTORY);
            ret.inputs.add(aret);
            return ret;
        }

        @Override
        public CircuitDetermination visitOr(Expression a, Expression b) {
            return this.binary(a.visit(this), b.visit(this), OrGate.FACTORY);
        }

        @Override
        public CircuitDetermination visitVariable(String name) {
            return new Input(name);
        }

        @Override
        public CircuitDetermination visitXor(Expression a, Expression b) {
            return this.binary(a.visit(this), b.visit(this), XorGate.FACTORY);
        }

        @Override
        public CircuitDetermination visitXnor(Expression a, Expression b) {
            return this.binary(a.visit(this), b.visit(this), XnorGate.FACTORY);
        }

        @Override
        public CircuitDetermination visitEq(Expression a, Expression b) {
            return this.binary(a.visit(this), b.visit(this), XnorGate.FACTORY);
        }
    }

    static class Value
    extends CircuitDetermination {
        private int value;

        private Value(int value) {
            this.value = value;
        }

        int getValue() {
            return this.value;
        }
    }

    static class Input
    extends CircuitDetermination {
        private final String name;
        private boolean inverted = false;

        private Input(String name) {
            this.name = name;
        }

        String getName() {
            return this.name;
        }

        public void togleInversion() {
            this.inverted = !this.inverted;
        }

        boolean isInvertedVersion() {
            return this.inverted;
        }
    }

    static class Gate
    extends CircuitDetermination {
        private ComponentFactory factory;
        private ArrayList<CircuitDetermination> inputs = new ArrayList();

        private Gate(ComponentFactory factory) {
            this.factory = factory;
        }

        @Override
        void convertToNands() {
            for (CircuitDetermination sub : this.inputs) {
                sub.convertToNands();
            }
            if (this.factory == NotGate.FACTORY) {
                this.inputs.add(this.inputs.get(0));
            } else if (this.factory == AndGate.FACTORY) {
                this.notOutput();
            } else if (this.factory == OrGate.FACTORY) {
                this.notAllInputs();
            } else if (this.factory == NorGate.FACTORY) {
                this.notAllInputs();
                this.notOutput();
            } else if (this.factory != NandGate.FACTORY) {
                throw new IllegalArgumentException("Cannot handle " + this.factory.getDisplayName());
            }
            this.factory = NandGate.FACTORY;
        }

        @Override
        void convertToTwoInputs() {
            if (this.inputs.size() <= 2) {
                for (CircuitDetermination a : this.inputs) {
                    a.convertToTwoInputs();
                }
            } else {
                ComponentFactory subFactory = this.factory == NorGate.FACTORY ? OrGate.FACTORY : (this.factory == NandGate.FACTORY ? AndGate.FACTORY : this.factory);
                int split = (this.inputs.size() + 1) / 2;
                CircuitDetermination a = this.convertToTwoInputsSub(0, split, subFactory);
                CircuitDetermination b = this.convertToTwoInputsSub(split, this.inputs.size(), subFactory);
                this.inputs.clear();
                this.inputs.add(a);
                this.inputs.add(b);
            }
        }

        private CircuitDetermination convertToTwoInputsSub(int start, int stop, ComponentFactory subFactory) {
            if (stop - start == 1) {
                CircuitDetermination a = this.inputs.get(start);
                a.convertToTwoInputs();
                return a;
            }
            int split = (start + stop + 1) / 2;
            CircuitDetermination a = this.convertToTwoInputsSub(start, split, subFactory);
            CircuitDetermination b = this.convertToTwoInputsSub(split, stop, subFactory);
            Gate ret = new Gate(subFactory);
            ret.inputs.add(a);
            ret.inputs.add(b);
            return ret;
        }

        ComponentFactory getFactory() {
            return this.factory;
        }

        ArrayList<CircuitDetermination> getInputs() {
            return this.inputs;
        }

        @Override
        boolean isNandNot() {
            return this.factory == NandGate.FACTORY && this.inputs.size() == 2 && this.inputs.get(0) == this.inputs.get(1);
        }

        private void notAllInputs() {
            for (int i = 0; i < this.inputs.size(); ++i) {
                CircuitDetermination old = this.inputs.get(i);
                CircuitDetermination circuitDetermination = this.inputs.get(i);
                if (circuitDetermination instanceof Value) {
                    Value inp = (Value)circuitDetermination;
                    inp.value ^= 1;
                    continue;
                }
                circuitDetermination = this.inputs.get(i);
                if (circuitDetermination instanceof Input) {
                    Input inp = (Input)circuitDetermination;
                    inp.togleInversion();
                    continue;
                }
                if (old.isNandNot()) {
                    this.inputs.set(i, ((Gate)old).inputs.get(0));
                    continue;
                }
                Gate now = new Gate(NandGate.FACTORY);
                now.inputs.add(old);
                now.inputs.add(old);
                this.inputs.set(i, now);
            }
        }

        private void notOutput() {
            Gate sub = new Gate(NandGate.FACTORY);
            sub.inputs = this.inputs;
            this.inputs = new ArrayList();
            this.inputs.add(sub);
            this.inputs.add(sub);
        }

        @Override
        void repair() {
            int num = this.inputs.size();
            if (num > 64) {
                int newNum = (num + 64 - 1) / 64;
                ArrayList<CircuitDetermination> oldInputs = this.inputs;
                this.inputs = new ArrayList();
                ComponentFactory subFactory = this.factory;
                if (subFactory == NandGate.FACTORY) {
                    subFactory = AndGate.FACTORY;
                }
                if (subFactory == NorGate.FACTORY) {
                    subFactory = OrGate.FACTORY;
                }
                int per = num / newNum;
                int numExtra = num - per * newNum;
                int k = 0;
                for (int i = 0; i < newNum; ++i) {
                    Gate sub = new Gate(subFactory);
                    int subCount = per + (i < numExtra ? 1 : 0);
                    for (int j = 0; j < subCount; ++j) {
                        sub.inputs.add(oldInputs.get(k));
                        ++k;
                    }
                    this.inputs.add(sub);
                }
            }
            if (this.inputs.size() > 2) {
                if (this.factory == XorGate.FACTORY) {
                    this.factory = OddParityGate.FACTORY;
                } else if (this.factory == XnorGate.FACTORY) {
                    this.factory = EvenParityGate.FACTORY;
                }
            }
            for (CircuitDetermination sub : this.inputs) {
                sub.repair();
            }
        }
    }
}

