/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.bfh;

import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.fpga.designrulecheck.Netlist;
import com.cburch.logisim.fpga.hdlgenerator.AbstractHdlGeneratorFactory;
import com.cburch.logisim.fpga.hdlgenerator.Hdl;
import com.cburch.logisim.util.LineBuffer;

public class BcdToSevenSegmentDisplayHdlGeneratorFactory
extends AbstractHdlGeneratorFactory {
    public BcdToSevenSegmentDisplayHdlGeneratorFactory() {
        this.myWires.addWire("s_outputValue", 7);
        this.myPorts.add("input", "bcdIn", 4, 7).add("output", "segmentA", 1, 0).add("output", "segmentB", 1, 1).add("output", "segmentC", 1, 2).add("output", "segmentD", 1, 3).add("output", "segmentE", 1, 4).add("output", "segmentF", 1, 5).add("output", "segmentG", 1, 6);
    }

    @Override
    public LineBuffer getModuleFunctionality(Netlist TheNetlist, AttributeSet attrs) {
        return Hdl.isVhdl() ? LineBuffer.getBuffer().addVhdlKeywords().empty().add("segmentA <= s_outputValue(0);\nsegmentB <= s_outputValue(1);\nsegmentC <= s_outputValue(2);\nsegmentD <= s_outputValue(3);\nsegmentE <= s_outputValue(4);\nsegmentF <= s_outputValue(5);\nsegmentG <= s_outputValue(6);\n\nmakeSegs : {{process}} ( bcdIn ) {{is}}\n{{begin}}\n   {{case}} (bcdIn) {{is}}\n      {{when}} \"0000\" => s_outputValue <= \"0111111\";\n      {{when}} \"0001\" => s_outputValue <= \"0000110\";\n      {{when}} \"0010\" => s_outputValue <= \"1011011\";\n      {{when}} \"0011\" => s_outputValue <= \"1001111\";\n      {{when}} \"0100\" => s_outputValue <= \"1100110\";\n      {{when}} \"0101\" => s_outputValue <= \"1101101\";\n      {{when}} \"0110\" => s_outputValue <= \"1111101\";\n      {{when}} \"0111\" => s_outputValue <= \"0000111\";\n      {{when}} \"1000\" => s_outputValue <= \"1111111\";\n      {{when}} \"1001\" => s_outputValue <= \"1101111\";\n      {{when}} {{others}} => s_outputValue <= \"-------\";\n   {{end}} {{case}};\n{{end}} {{process}} makeSegs;\n").empty() : LineBuffer.getBuffer().empty().add("    assign segmentA = s_outputValue[0];\n    assign segmentB = s_outputValue[1];\n    assign segmentC = s_outputValue[2];\n    assign segmentD = s_outputValue[3];\n    assign segmentE = s_outputValue[4];\n    assign segmentF = s_outputValue[5];\n    assign segmentG = s_outputValue[6];\n\n    reg [6:0] s_rOutputValue;\n    assign s_outputValue = s_rOutputValue;\n\n    always @*\n      begin\n        case (bcdIn)\n          4'h0 : s_rOutputValue <= 7'b0111111;\n          4'h1 : s_rOutputValue <= 7'b0000110;\n          4'h2 : s_rOutputValue <= 7'b1011011;\n          4'h3 : s_rOutputValue <= 7'b1001111;\n          4'h4 : s_rOutputValue <= 7'b1100110;\n          4'h5 : s_rOutputValue <= 7'b1101101;\n          4'h6 : s_rOutputValue <= 7'b1111101;\n          4'h7 : s_rOutputValue <= 7'b0000111;\n          4'h8 : s_rOutputValue <= 7'b1111111;\n          4'h9 : s_rOutputValue <= 7'b1101111;\n          default : s_rOutputValue <= 7'b0000000;\n        endcase\n      end\n");
    }

    @Override
    public boolean isHdlSupportedTarget(AttributeSet attrs) {
        return true;
    }
}

