/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.util;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocBusTransaction;
import com.cburch.logisim.soc.data.SocProcessorInterface;
import com.cburch.logisim.soc.data.SocSupport;
import com.cburch.logisim.soc.file.ElfProgramHeader;
import com.cburch.logisim.soc.file.ElfSectionHeader;
import com.cburch.logisim.soc.file.SectionHeader;
import com.cburch.logisim.soc.file.SymbolTable;
import com.cburch.logisim.soc.util.AbstractExecutionUnitWithLabelSupport;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import com.cburch.logisim.soc.util.AssemblerInterface;
import com.cburch.logisim.soc.util.AssemblerToken;
import com.cburch.logisim.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public abstract class AbstractAssembler
implements AssemblerInterface {
    private static final int nrOfBytesPerLine = 16;
    private final ArrayList<AssemblerExecutionInterface> exeUnits = new ArrayList();
    private final HashSet<Integer> acceptedParameterTypes = new HashSet();

    public AbstractAssembler() {
        this.acceptedParameterTypes.add(4);
        this.acceptedParameterTypes.add(6);
        this.acceptedParameterTypes.add(7);
        this.acceptedParameterTypes.add(16);
        this.acceptedParameterTypes.add(5);
        this.acceptedParameterTypes.add(10);
        this.acceptedParameterTypes.add(8);
        this.acceptedParameterTypes.add(22);
        this.acceptedParameterTypes.addAll(AssemblerToken.MATH_OPERATORS);
    }

    public void addAcceptedParameterType(int type) {
        this.acceptedParameterTypes.add(type);
    }

    @Override
    public HashSet<Integer> getAcceptedParameterTypes() {
        return this.acceptedParameterTypes;
    }

    public void addAssemblerExecutionUnit(AssemblerExecutionInterface exe) {
        this.exeUnits.add(exe);
    }

    @Override
    public void decode(int instruction) {
        for (AssemblerExecutionInterface exe : this.exeUnits) {
            exe.setBinInstruction(instruction);
        }
    }

    @Override
    public AssemblerExecutionInterface getExeUnit() {
        for (AssemblerExecutionInterface exe : this.exeUnits) {
            if (!exe.isValid()) continue;
            return exe;
        }
        return null;
    }

    @Override
    public ArrayList<String> getOpcodes() {
        ArrayList<String> opcodes = new ArrayList<String>();
        for (AssemblerExecutionInterface exe : this.exeUnits) {
            opcodes.addAll(exe.getInstructions());
        }
        return opcodes;
    }

    @Override
    public int getInstructionSize(String opcode) {
        for (AssemblerExecutionInterface exe : this.exeUnits) {
            int size = exe.getInstructionSizeInBytes(opcode);
            if (size <= 0) continue;
            return size;
        }
        return 1;
    }

    @Override
    public boolean assemble(AssemblerAsmInstruction instruction) {
        boolean found = false;
        for (AssemblerExecutionInterface exe : this.exeUnits) {
            found |= exe.setAsmInstruction(instruction);
        }
        if (!found) {
            instruction.setError(instruction.getInstruction(), Strings.S.getter("AssemblerUnknownOpcode"));
        }
        return !instruction.hasErrors();
    }

    private int addLabels(SectionHeader sh, HashMap<Integer, String> labels) {
        int maxSize = 0;
        for (SymbolTable st : sh.getSymbols()) {
            Integer addr;
            String stName = st.getName();
            if (!StringUtil.isNotEmpty(stName) || labels.containsKey(addr = st.getValue(1))) continue;
            if (stName.length() > maxSize) {
                maxSize = stName.length();
            }
            labels.put(addr, stName);
        }
        return maxSize;
    }

    private int getByte(Integer[] buffer, int byteIndex) {
        int index = byteIndex >> 2;
        int byteSelect = byteIndex & 3;
        int data = buffer[index];
        int info = switch (byteSelect) {
            case 0 -> data & 0xFF;
            case 1 -> data >> 8 & 0xFF;
            case 2 -> data >> 16 & 0xFF;
            default -> data >> 24 & 0xFF;
        };
        return info;
    }

    private int getData(boolean lookForStrings, Integer[] contents, long sizeInBytes, long startAddress, HashMap<Integer, String> labels, int maxLabelSize, StringBuilder lines, int lineNum) {
        int nrBytesWritten = 0;
        int size = (int)sizeInBytes;
        int i = 0;
        int newLineNum = lineNum;
        while (i < size) {
            boolean stringFound = false;
            boolean zerosFound = false;
            if (labels.containsKey(SocSupport.convUnsignedLong(startAddress + (long)i))) {
                StringBuilder label = new StringBuilder();
                label.append(labels.get(SocSupport.convUnsignedLong(startAddress + (long)i))).append(":");
                while (label.length() < maxLabelSize) {
                    label.append(" ");
                }
                if (nrBytesWritten != 0) {
                    newLineNum = this.addLine(lines, "\n", newLineNum, true);
                }
                newLineNum = this.addLine(lines, label.toString(), newLineNum, false);
                nrBytesWritten = -1;
            }
            int kar = this.getByte(contents, i);
            if (lookForStrings && kar >= 32 && kar <= 127) {
                int j;
                StringBuilder str = new StringBuilder();
                if (kar == 34 || kar == 92) {
                    str.append('\\');
                }
                str.append((char)kar);
                for (j = i + 1; j < size; ++j) {
                    kar = this.getByte(contents, j);
                    switch (kar) {
                        case 8: {
                            str.append("\\");
                            kar = 98;
                            break;
                        }
                        case 9: {
                            str.append("\\");
                            kar = 116;
                            break;
                        }
                        case 10: {
                            str.append("\\");
                            kar = 110;
                            break;
                        }
                        case 12: {
                            str.append("\\");
                            kar = 102;
                            break;
                        }
                        case 13: {
                            str.append("\\");
                            kar = 114;
                            break;
                        }
                        case 34: 
                        case 92: {
                            str.append("\\");
                        }
                    }
                    if (kar < 32 || kar >= 127) break;
                    str.append((char)kar);
                }
                if (str.length() > 2) {
                    stringFound = true;
                    i = j;
                    String type = ".ascii";
                    if (i < size && this.getByte(contents, i) == 0) {
                        ++i;
                        type = ".string";
                    }
                    if (nrBytesWritten > 0) {
                        newLineNum = this.addLine(lines, "\n", newLineNum, true);
                    }
                    if (nrBytesWritten >= 0) {
                        for (int sp = 0; sp < maxLabelSize; ++sp) {
                            newLineNum = this.addLine(lines, " ", newLineNum, false);
                        }
                    }
                    newLineNum = this.addLine(lines, " " + type + " \"" + String.valueOf(str) + "\"\n", newLineNum, true);
                    nrBytesWritten = 0;
                }
            }
            if (kar == 0) {
                int j;
                for (j = i + 1; j < size && (kar = this.getByte(contents, j)) == 0; ++j) {
                }
                if (j - i > 1) {
                    zerosFound = true;
                    if (nrBytesWritten > 0) {
                        newLineNum = this.addLine(lines, "\n", newLineNum, true);
                    }
                    if (nrBytesWritten >= 0) {
                        for (int sp = 0; sp < maxLabelSize; ++sp) {
                            newLineNum = this.addLine(lines, " ", newLineNum, false);
                        }
                    }
                    newLineNum = this.addLine(lines, " .zero " + (j - i) + "\n", newLineNum, true);
                    i = j;
                    nrBytesWritten = 0;
                }
            }
            if (stringFound || zerosFound) continue;
            if (nrBytesWritten <= 0 || nrBytesWritten >= 16) {
                StringBuilder label = new StringBuilder();
                while (label.length() < maxLabelSize) {
                    label.append(" ");
                }
                if (nrBytesWritten >= 16) {
                    newLineNum = this.addLine(lines, "\n", newLineNum, true);
                }
                if (nrBytesWritten == 0 || nrBytesWritten >= 16) {
                    newLineNum = this.addLine(lines, label.toString(), newLineNum, false);
                }
                newLineNum = this.addLine(lines, " .byte ", newLineNum, false);
                nrBytesWritten = 0;
            }
            if (nrBytesWritten > 0) {
                newLineNum = this.addLine(lines, ", ", newLineNum, false);
            }
            newLineNum = this.addLine(lines, String.format("0x%02X", this.getByte(contents, i)), newLineNum, false);
            ++nrBytesWritten;
            ++i;
        }
        if (nrBytesWritten != 0) {
            newLineNum = this.addLine(lines, "\n", newLineNum, true);
        }
        return newLineNum;
    }

    private int addLine(StringBuilder str, String val, int lineNum, boolean completedLine) {
        str.append(val);
        return completedLine ? lineNum + 1 : lineNum;
    }

    @Override
    public String getProgram(CircuitState circuitState, SocProcessorInterface processorInterface, ElfProgramHeader elfHeader, ElfSectionHeader elfSections, HashMap<Integer, Integer> validDebugLines) {
        StringBuilder lines;
        block34: {
            int lineNum;
            block33: {
                lines = new StringBuilder();
                lineNum = 1;
                if (elfSections == null || !elfSections.isValid()) break block33;
                HashMap<Integer, String> labels = new HashMap<Integer, String>();
                int maxLabelSize = 0;
                ArrayList<SectionHeader> sortedList = new ArrayList<SectionHeader>();
                for (SectionHeader sh : elfSections.getHeaders()) {
                    if (!sh.isAllocated()) continue;
                    if (sortedList.isEmpty()) {
                        sortedList.add(sh);
                        int size = this.addLabels(sh, labels);
                        if (size <= maxLabelSize) continue;
                        maxLabelSize = size;
                        continue;
                    }
                    boolean inserted = false;
                    long shStart = SocSupport.convUnsignedInt((Integer)sh.getValue(3));
                    for (int i = 0; i < sortedList.size(); ++i) {
                        long start = SocSupport.convUnsignedInt((Integer)((SectionHeader)sortedList.get(i)).getValue(3));
                        if (shStart >= start) continue;
                        inserted = true;
                        sortedList.add(i, sh);
                        int size = this.addLabels(sh, labels);
                        if (size <= maxLabelSize) break;
                        maxLabelSize = size;
                        break;
                    }
                    if (inserted) continue;
                    sortedList.add(sh);
                    int size = this.addLabels(sh, labels);
                    if (size <= maxLabelSize) continue;
                    maxLabelSize = size;
                }
                ++maxLabelSize;
                for (SectionHeader sh : sortedList) {
                    long startAddress = SocSupport.convUnsignedInt((Integer)sh.getValue(3));
                    long size = SocSupport.convUnsignedInt((Integer)sh.getValue(5));
                    if (lines.length() != 0) {
                        lineNum = this.addLine(lines, "\n", lineNum, true);
                    }
                    lineNum = this.addLine(lines, ".section " + sh.getName() + "\n", lineNum, true);
                    lineNum = this.addLine(lines, ".org " + String.format("0x%08X\n", startAddress), lineNum, true);
                    int toBeRead = (int)size % 4 != 0 ? (int)(size >> 2) + 1 : (int)(size >> 2);
                    Integer[] contents = new Integer[toBeRead];
                    for (int i = 0; i < toBeRead; ++i) {
                        SocBusTransaction trans = new SocBusTransaction(1, SocSupport.convUnsignedLong(startAddress + ((long)i << 2)), 0, 3, "assembler");
                        processorInterface.insertTransaction(trans, true, circuitState);
                        contents[i] = trans.getReadData();
                    }
                    if (sh.isExecutable()) {
                        ArrayList<Integer> newLabels = new ArrayList<Integer>();
                        int pc = 0;
                        while ((long)pc < size >> 2) {
                            long addr;
                            long target;
                            Integer labelLoc;
                            AbstractExecutionUnitWithLabelSupport jump;
                            this.decode(contents[pc]);
                            AssemblerExecutionInterface exe = this.getExeUnit();
                            if (exe instanceof AbstractExecutionUnitWithLabelSupport && (jump = (AbstractExecutionUnitWithLabelSupport)exe).isLabelSupported() && !labels.containsKey(labelLoc = Integer.valueOf(SocSupport.convUnsignedLong(target = jump.getLabelAddress(addr = startAddress + ((long)pc << 2))))) && !newLabels.contains(labelLoc)) {
                                if (newLabels.isEmpty()) {
                                    newLabels.add(labelLoc);
                                } else {
                                    boolean inserted = false;
                                    for (int j = 0; j < newLabels.size(); ++j) {
                                        if ((Integer)newLabels.get(j) <= labelLoc) continue;
                                        newLabels.add(j, labelLoc);
                                        inserted = true;
                                        break;
                                    }
                                    if (!inserted) {
                                        newLabels.add(labelLoc);
                                    }
                                }
                            }
                            ++pc;
                        }
                        int offset = 0;
                        for (Integer addr : labels.keySet()) {
                            String label = labels.get(addr);
                            if (label == null || !label.startsWith("logisim_label_")) continue;
                            int index = 0;
                            try {
                                index = Integer.parseUnsignedInt(label.substring(14));
                            }
                            catch (NumberFormatException target) {
                                // empty catch block
                            }
                            if (index < offset) continue;
                            offset = index + 1;
                        }
                        for (int i = 0; i < newLabels.size(); ++i) {
                            String label = "logisim_label_" + (i + offset);
                            labels.put((Integer)newLabels.get(i), label);
                            if (label.length() <= maxLabelSize) continue;
                            maxLabelSize = label.length();
                        }
                        StringBuilder remark = new StringBuilder();
                        int remarkOffset = Math.max(2 * maxLabelSize + 23, 60);
                        remark.append(" ".repeat(remarkOffset));
                        remark.append("#    pc:       opcode:\n");
                        lineNum = this.addLine(lines, remark.toString(), lineNum, true);
                        int pc2 = 0;
                        while ((long)pc2 < size >> 2) {
                            StringBuilder line = new StringBuilder();
                            long addr = startAddress + ((long)pc2 << 2);
                            StringBuilder label = new StringBuilder();
                            if (labels.containsKey(SocSupport.convUnsignedLong(addr))) {
                                label.append(labels.get(SocSupport.convUnsignedLong(addr))).append(":");
                            }
                            while (label.length() <= maxLabelSize) {
                                label.append(" ");
                            }
                            line.append((CharSequence)label).append(" ");
                            this.decode(contents[pc2]);
                            AssemblerExecutionInterface exe = this.getExeUnit();
                            if (exe instanceof AbstractExecutionUnitWithLabelSupport) {
                                AbstractExecutionUnitWithLabelSupport jump = (AbstractExecutionUnitWithLabelSupport)exe;
                                if (jump.isLabelSupported()) {
                                    long target = jump.getLabelAddress(addr);
                                    if (labels.containsKey(SocSupport.convUnsignedLong(target))) {
                                        line.append(jump.getAsmInstruction(labels.get(SocSupport.convUnsignedLong(target))));
                                    } else {
                                        line.append(jump.getAsmInstruction());
                                    }
                                } else {
                                    line.append(exe.getAsmInstruction());
                                }
                            } else if (exe != null) {
                                line.append(exe.getAsmInstruction());
                            } else {
                                line.append(Strings.S.get("UnknownInstruction"));
                            }
                            while (line.length() < remarkOffset) {
                                line.append(" ");
                            }
                            line.append("# ").append(String.format("0x%08X", SocSupport.convUnsignedLong(startAddress + ((long)pc2 << 2))));
                            line.append(" ").append(String.format("0x%08X", contents[pc2]));
                            validDebugLines.put(lineNum, SocSupport.convUnsignedLong(startAddress + ((long)pc2 << 2)));
                            lineNum = this.addLine(lines, String.valueOf(line) + "\n", lineNum, true);
                            ++pc2;
                        }
                        continue;
                    }
                    lineNum = this.getData(!sh.isWritable(), contents, size, startAddress, labels, maxLabelSize, lines, lineNum);
                }
                break block34;
            }
            if (elfHeader == null || !elfHeader.isValid()) break block34;
            for (int i = 0; i < elfHeader.getNrOfHeaders(); ++i) {
                ElfProgramHeader.ProgramHeader p = elfHeader.getHeader(i);
                if (((Integer)p.getValue(1) & 1) == 0) continue;
                long start = SocSupport.convUnsignedInt((Integer)p.getValue(4));
                long size = SocSupport.convUnsignedInt((Integer)p.getValue(6));
                lineNum = this.addLine(lines, String.format(".org 0x%08X\n", start), lineNum, true);
                for (long pc = 0L; pc < size; pc += 4L) {
                    long addr = start + pc;
                    SocBusTransaction trans = new SocBusTransaction(1, SocSupport.convUnsignedLong(addr), 0, 3, "assembler");
                    processorInterface.insertTransaction(trans, true, circuitState);
                    if (trans.hasError()) continue;
                    int instr = trans.getReadData();
                    lineNum = this.addLine(lines, String.format("0x%08X ", addr), lineNum, false);
                    lineNum = this.addLine(lines, String.format("0x%08X ", instr), lineNum, false);
                    lineNum = addr == (long)processorInterface.getEntryPoint(circuitState) ? this.addLine(lines, "_start: ", lineNum, false) : this.addLine(lines, "       ", lineNum, false);
                    this.decode(instr);
                    if (this.getExeUnit() != null) {
                        lineNum = this.addLine(lines, this.getExeUnit().getAsmInstruction(), lineNum, false);
                        validDebugLines.put(lineNum, SocSupport.convUnsignedLong(addr));
                    } else {
                        lineNum = this.addLine(lines, "????", lineNum, false);
                    }
                    lineNum = this.addLine(lines, "\n", lineNum, true);
                }
            }
        }
        return lines.toString();
    }
}

