/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.rv32im;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocBusTransaction;
import com.cburch.logisim.soc.file.ElfHeader;
import com.cburch.logisim.soc.rv32im.RV32imState;
import com.cburch.logisim.soc.rv32im.RV32imSupport;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import com.cburch.logisim.soc.util.AssemblerToken;
import java.util.ArrayList;
import java.util.Arrays;

public class RV32imLoadAndStoreInstructions
implements AssemblerExecutionInterface {
    private static final int LOAD = 3;
    private static final int STORE = 35;
    private static final int LB = 0;
    private static final int LH = 1;
    private static final int LW = 2;
    private static final int LBU = 4;
    private static final int LHU = 5;
    private static final int INSTR_LB = 0;
    private static final int INSTR_LH = 1;
    private static final int INSTR_LW = 2;
    private static final int INSTR_LBU = 3;
    private static final int INSTR_LHU = 4;
    private static final int INSTR_SB = 5;
    private static final int INSTR_SH = 6;
    private static final int INSTR_SW = 7;
    private static final String[] AsmOpcodes = new String[]{"LB", "LH", "LW", "LBU", "LHU", "SB", "SH", "SW"};
    private int instruction = 0;
    private boolean valid = false;
    private int operation;
    private int destination;
    private int immediate;
    private int base;
    private String errorMessage;

    @Override
    public ArrayList<String> getInstructions() {
        return new ArrayList<String>(Arrays.asList(AsmOpcodes));
    }

    @Override
    public boolean execute(Object state, CircuitState cState) {
        if (!this.valid) {
            return false;
        }
        RV32imState.ProcessorState cpuState = (RV32imState.ProcessorState)state;
        this.errorMessage = null;
        int toBeStored = cpuState.getRegisterValue(this.destination);
        long address = ElfHeader.getLongValue(cpuState.getRegisterValue(this.base)) + (long)this.immediate;
        int transType = -1;
        switch (this.operation) {
            case 5: {
                toBeStored &= 0xFF;
                transType = 1;
            }
            case 6: {
                toBeStored &= 0xFFFF;
                if (transType < 0) {
                    transType = 2;
                }
            }
            case 7: {
                if (transType < 0) {
                    transType = 3;
                }
                SocBusTransaction trans = new SocBusTransaction(2, ElfHeader.getIntValue(address), toBeStored, transType, cpuState.getMasterComponent());
                cpuState.insertTransaction(trans, false, cState);
                return !this.transactionHasError(trans);
            }
            case 0: 
            case 3: {
                transType = 1;
            }
            case 1: 
            case 4: {
                if (transType < 0) {
                    transType = 2;
                }
            }
            case 2: {
                if (transType < 0) {
                    transType = 3;
                }
                SocBusTransaction trans = new SocBusTransaction(1, ElfHeader.getIntValue(address), 0, transType, cpuState.getMasterComponent());
                cpuState.insertTransaction(trans, false, cState);
                if (this.transactionHasError(trans)) {
                    return false;
                }
                int toBeLoaded = trans.getReadData();
                switch (this.operation) {
                    case 3: {
                        toBeLoaded &= 0xFF;
                        break;
                    }
                    case 0: {
                        toBeLoaded <<= 24;
                        toBeLoaded >>= 24;
                        break;
                    }
                    case 4: {
                        toBeLoaded &= 0xFFFF;
                        break;
                    }
                    case 1: {
                        toBeLoaded <<= 16;
                        toBeLoaded >>= 16;
                    }
                }
                cpuState.writeRegister(this.destination, toBeLoaded);
                return true;
            }
        }
        return false;
    }

    private boolean transactionHasError(SocBusTransaction trans) {
        if (trans.hasError()) {
            StringBuilder s = new StringBuilder();
            if (trans.isReadTransaction()) {
                s.append(Strings.S.get("LoadStoreErrorInReadTransaction")).append("\n");
            } else {
                s.append(Strings.S.get("LoadStoreErrorInWriteTransaction")).append("\n");
            }
            s.append(trans.getErrorMessage());
            this.errorMessage = s.toString();
        }
        return trans.hasError();
    }

    @Override
    public String getAsmInstruction() {
        if (!this.valid) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        s.append(AsmOpcodes[this.operation].toLowerCase());
        while (s.length() < 10) {
            s.append(" ");
        }
        s.append(RV32imState.registerABINames[this.destination]).append(",");
        s.append(this.immediate);
        s.append("(").append(RV32imState.registerABINames[this.base]).append(")");
        return s.toString();
    }

    @Override
    public int getBinInstruction() {
        return this.instruction;
    }

    @Override
    public boolean setBinInstruction(int instr) {
        this.instruction = instr;
        this.valid = this.decodeBin();
        return this.valid;
    }

    @Override
    public boolean performedJump() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    private boolean decodeBin() {
        int opcode = RV32imSupport.getOpcode(this.instruction);
        if (opcode == 3) {
            this.destination = RV32imSupport.getDestinationRegisterIndex(this.instruction);
            this.immediate = RV32imSupport.getImmediateValue(this.instruction, 1);
            this.base = RV32imSupport.getSourceRegister1Index(this.instruction);
            int funct3 = RV32imSupport.getFunct3(this.instruction);
            switch (funct3) {
                case 0: 
                case 1: 
                case 2: {
                    this.operation = funct3;
                    return true;
                }
                case 4: 
                case 5: {
                    this.operation = funct3 - 1;
                    return true;
                }
            }
            return false;
        }
        if (opcode == 35) {
            int funct3 = RV32imSupport.getFunct3(this.instruction);
            if (funct3 > 2) {
                return false;
            }
            this.operation = funct3 + 5;
            this.immediate = RV32imSupport.getImmediateValue(this.instruction, 2);
            this.base = RV32imSupport.getSourceRegister1Index(this.instruction);
            this.destination = RV32imSupport.getSourceRegister2Index(this.instruction);
            return true;
        }
        return false;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public int getInstructionSizeInBytes(String instruction) {
        if (this.getInstructions().contains(instruction.toUpperCase())) {
            return 4;
        }
        return -1;
    }

    @Override
    public boolean setAsmInstruction(AssemblerAsmInstruction instr) {
        AssemblerToken[] param2;
        int operation = -1;
        for (int i = 0; i < AsmOpcodes.length; ++i) {
            if (!AsmOpcodes[i].equals(instr.getOpcode().toUpperCase())) continue;
            operation = i;
        }
        if (operation < 0) {
            this.valid = false;
            return false;
        }
        if (instr.getNrOfParameters() != 2) {
            instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedTwoArguments"));
            this.valid = false;
            return true;
        }
        this.valid = true;
        AssemblerToken[] param1 = instr.getParameter(0);
        if (param1.length != 1 || param1[0].getType() != 5) {
            instr.setError(param1[0], Strings.S.getter("AssemblerExpectedRegister"));
            this.valid = false;
        }
        if ((param2 = instr.getParameter(1)).length != 2) {
            instr.setError(param2[0], Strings.S.getter("RV32imAssemblerExpectedImmediateIndexedRegister"));
            this.valid = false;
            return true;
        }
        if (!param2[0].isNumber()) {
            instr.setError(param2[0], Strings.S.getter("AssemblerExpectedImmediateValue"));
            this.valid = false;
        }
        if (param2[1].getType() != 4) {
            instr.setError(param2[1], Strings.S.getter("RV32imAssemblerExpectedBracketedRegister"));
            this.valid = false;
        }
        if (!this.valid) {
            return true;
        }
        this.destination = RV32imState.getRegisterIndex(param1[0].getValue());
        if (this.destination < 0 || this.destination > 31) {
            instr.setError(param1[0], Strings.S.getter("AssemblerUnknownRegister"));
            this.valid = false;
        }
        this.base = RV32imState.getRegisterIndex(param2[1].getValue());
        if (this.base < 0 || this.base > 31) {
            instr.setError(param2[1], Strings.S.getter("AssemblerUnknownRegister"));
            this.valid = false;
        }
        this.immediate = param2[0].getNumberValue();
        if (this.immediate >= 2048 || this.immediate < -2048) {
            instr.setError(param2[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
            this.valid = false;
        }
        if (!this.valid) {
            return true;
        }
        switch (operation) {
            case 5: 
            case 6: 
            case 7: {
                int funct3 = operation - 5;
                this.instruction = RV32imSupport.getSTypeInstruction(35, this.base, this.destination, funct3, this.immediate);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                int funct3 = operation == 3 || operation == 4 ? operation + 1 : operation;
                this.instruction = RV32imSupport.getITypeInstruction(3, this.destination, funct3, this.base, this.immediate);
                break;
            }
            default: {
                this.valid = false;
                OptionPane.showMessageDialog(null, "Severe Bug in RV32imLoadAndStoreInstructions.java");
            }
        }
        if (this.valid) {
            instr.setInstructionByteCode(this.instruction, 4);
        }
        return true;
    }
}

