/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.rv32im;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.file.ElfHeader;
import com.cburch.logisim.soc.rv32im.RV32imState;
import com.cburch.logisim.soc.rv32im.RV32imSupport;
import com.cburch.logisim.soc.util.AssemblerAsmInstruction;
import com.cburch.logisim.soc.util.AssemblerExecutionInterface;
import com.cburch.logisim.soc.util.AssemblerToken;
import java.util.ArrayList;
import java.util.Arrays;

public class RV32imIntegerRegisterImmediateInstructions
implements AssemblerExecutionInterface {
    private static final int OP_IMM = 19;
    private static final int LUI = 55;
    private static final int AUIPC = 23;
    private static final int ADDI = 0;
    private static final int XORI = 4;
    private static final int SLTIU = 3;
    private static final int SLLI = 1;
    private static final int SRLAI = 5;
    private static final int INSTR_ADDI = 0;
    private static final int INSTR_SLTI = 2;
    private static final int INSTR_SLTIU = 3;
    private static final int INSTR_XORI = 4;
    private static final int INSTR_ORI = 6;
    private static final int INSTR_ANDI = 7;
    private static final int INSTR_SLLI = 1;
    private static final int INSTR_SRLI = 5;
    private static final int INSTR_SRAI = 8;
    private static final int INSTR_LUI = 9;
    private static final int INSTR_AUIPC = 10;
    private static final int INSTR_NOP = 11;
    private static final int INSTR_LI = 12;
    private static final int INSTR_SEQZ = 13;
    private static final int INSTR_NOT = 14;
    private static final int INSTR_MV = 15;
    private static final String[] AsmOpcodes = new String[]{"ADDI", "SLLI", "SLTI", "SLTIU", "XORI", "SRLI", "ORI", "ANDI", "SRAI", "LUI", "AUIPC", "NOP", "LI", "SEQZ", "NOT", "MV"};
    private int instruction = 0;
    private int destination;
    private int source;
    private int immediate;
    private int operation;
    private boolean valid = false;

    @Override
    public ArrayList<String> getInstructions() {
        return new ArrayList<String>(Arrays.asList(AsmOpcodes));
    }

    @Override
    public boolean execute(Object state, CircuitState cState) {
        if (!this.valid) {
            return false;
        }
        RV32imState.ProcessorState cpuState = (RV32imState.ProcessorState)state;
        int result = 0;
        int regVal = cpuState.getRegisterValue(this.source);
        switch (this.operation) {
            case 0: 
            case 11: 
            case 12: 
            case 15: {
                result = regVal + this.immediate;
                break;
            }
            case 2: {
                result = regVal < this.immediate ? 1 : 0;
                break;
            }
            case 3: 
            case 13: {
                result = ElfHeader.getLongValue(regVal) < ElfHeader.getLongValue(this.immediate) ? 1 : 0;
                break;
            }
            case 4: 
            case 14: {
                result = regVal ^ this.immediate;
                break;
            }
            case 6: {
                result = regVal | this.immediate;
                break;
            }
            case 7: {
                result = regVal & this.immediate;
                break;
            }
            case 1: {
                result = regVal << this.immediate;
                break;
            }
            case 5: {
                long val1 = ElfHeader.getLongValue(regVal);
                result = ElfHeader.getIntValue(val1 >>= this.immediate);
                break;
            }
            case 8: {
                result = regVal >> this.immediate;
                break;
            }
            case 9: {
                result = this.immediate;
                break;
            }
            case 10: {
                long pc = Long.parseUnsignedLong(String.format("%08X", cpuState.getProgramCounter()), 16);
                result = ElfHeader.getIntValue(pc + (long)this.immediate);
                break;
            }
            default: {
                return false;
            }
        }
        cpuState.writeRegister(this.destination, result);
        return true;
    }

    @Override
    public String getAsmInstruction() {
        if (!this.valid) {
            return "Unknown";
        }
        StringBuilder s = new StringBuilder();
        s.append(AsmOpcodes[this.operation].toLowerCase());
        while (s.length() < 10) {
            s.append(" ");
        }
        switch (this.operation) {
            case 11: {
                break;
            }
            case 12: {
                s.append(RV32imState.registerABINames[this.destination]).append(",").append(this.immediate);
                break;
            }
            case 9: 
            case 10: {
                s.append(RV32imState.registerABINames[this.destination]).append(",").append(this.immediate >> 12 & 0xFFFFF);
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                s.append(RV32imState.registerABINames[this.destination]).append(",").append(RV32imState.registerABINames[this.source]);
                break;
            }
            default: {
                s.append(RV32imState.registerABINames[this.destination]).append(",").append(RV32imState.registerABINames[this.source]).append(",").append(this.immediate);
            }
        }
        return s.toString();
    }

    @Override
    public int getBinInstruction() {
        return this.instruction;
    }

    @Override
    public boolean setBinInstruction(int instr) {
        this.instruction = instr;
        this.decodeBin();
        return this.valid;
    }

    @Override
    public boolean performedJump() {
        return false;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    private void decodeBin() {
        int opcode = RV32imSupport.getOpcode(this.instruction);
        switch (opcode) {
            case 23: 
            case 55: {
                this.valid = true;
                this.destination = RV32imSupport.getDestinationRegisterIndex(this.instruction);
                this.immediate = RV32imSupport.getImmediateValue(this.instruction, 4);
                this.operation = opcode == 55 ? 9 : 10;
                return;
            }
            case 19: {
                this.valid = true;
                this.source = RV32imSupport.getSourceRegister1Index(this.instruction);
                this.destination = RV32imSupport.getDestinationRegisterIndex(this.instruction);
                this.immediate = RV32imSupport.getImmediateValue(this.instruction, 1);
                break;
            }
            default: {
                this.valid = false;
                return;
            }
        }
        int op3 = RV32imSupport.getFunct3(this.instruction);
        if (op3 != 5) {
            this.operation = op3;
            if (op3 == 1) {
                if (RV32imSupport.getFunct7(this.instruction) != 0) {
                    this.valid = false;
                    return;
                }
                this.immediate = this.instruction >> 20 & 0x1F;
            }
            if (op3 == 0) {
                if (this.destination == 0 && this.source == 0 && this.immediate == 0) {
                    this.operation = 11;
                } else if (this.source == 0) {
                    this.operation = 12;
                } else if (this.immediate == 0) {
                    this.operation = 15;
                }
            }
            if (op3 == 3 && this.immediate == 1) {
                this.operation = 13;
            }
            if (op3 == 4 && this.immediate == -1) {
                this.operation = 14;
            }
            return;
        }
        int funct7 = RV32imSupport.getFunct7(this.instruction);
        if (funct7 == 0 || funct7 == 32) {
            int bit30 = this.instruction >> 30 & 1;
            this.operation = op3 + bit30 * 3;
            this.immediate = this.instruction >> 20 & 0x1F;
            return;
        }
        this.valid = false;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public int getInstructionSizeInBytes(String instruction) {
        if (this.getInstructions().contains(instruction.toUpperCase())) {
            return 4;
        }
        return -1;
    }

    @Override
    public boolean setAsmInstruction(AssemblerAsmInstruction instr) {
        int operation = -1;
        for (int i = 0; i < AsmOpcodes.length; ++i) {
            if (!AsmOpcodes[i].equals(instr.getOpcode().toUpperCase())) continue;
            operation = i;
        }
        if (operation < 0) {
            this.valid = false;
            return false;
        }
        boolean errors = false;
        block0 : switch (operation) {
            case 11: {
                if (instr.getNrOfParameters() != 0) {
                    instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedNoArguments"));
                    errors = true;
                    break;
                }
                operation = 0;
                this.immediate = 0;
                this.source = 0;
                this.destination = 0;
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                if (instr.getNrOfParameters() != 2) {
                    instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedTwoArguments"));
                    errors = true;
                    break;
                }
                AssemblerToken[] param1 = instr.getParameter(0);
                AssemblerToken[] param2 = instr.getParameter(1);
                if (param1.length != 1 || param1[0].getType() != 5) {
                    for (AssemblerToken assemblerToken : param1) {
                        instr.setError(assemblerToken, Strings.S.getter("AssemblerExpectedRegister"));
                    }
                    errors = true;
                    break;
                }
                if (param2.length != 1 || !param2[0].isNumber()) {
                    for (AssemblerToken assemblerToken : param2) {
                        instr.setError(assemblerToken, Strings.S.getter("AssemblerExpectedImmediateValue"));
                    }
                    errors = true;
                    break;
                }
                if (operation == 12) {
                    operation = 0;
                }
                this.source = 0;
                this.destination = RV32imState.getRegisterIndex(param1[0].getValue());
                if (this.destination < 0 || this.destination > 31) {
                    errors = true;
                    instr.setError(param1[0], Strings.S.getter("AssemblerUnknownRegister"));
                }
                this.immediate = param2[0].getNumberValue();
                if (operation == 9 && param2[0].isLabel()) {
                    this.immediate = this.immediate >> 12 & 0xFFFFF;
                }
                if (operation != 10 || !param2[0].isLabel()) break;
                long imm = this.immediate;
                this.immediate = (int)(imm -= instr.getProgramCounter());
                this.immediate = this.immediate >> 12 & 0xFFFFF;
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                if (instr.getNrOfParameters() != 2) {
                    instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedTwoArguments"));
                    errors = true;
                    break;
                }
                AssemblerToken[] param1 = instr.getParameter(0);
                AssemblerToken[] param2 = instr.getParameter(1);
                if (param1.length != 1 || param1[0].getType() != 5) {
                    for (AssemblerToken assemblerToken : param1) {
                        instr.setError(assemblerToken, Strings.S.getter("AssemblerExpectedRegister"));
                    }
                    errors = true;
                    break;
                }
                if (param2.length != 1 || param2[0].getType() != 5) {
                    for (AssemblerToken assemblerToken : param2) {
                        instr.setError(assemblerToken, Strings.S.getter("AssemblerExpectedRegister"));
                    }
                    errors = true;
                    break;
                }
                this.immediate = -1;
                this.source = RV32imState.getRegisterIndex(param2[0].getValue());
                if (this.source < 0 || this.source > 31) {
                    errors = true;
                    instr.setError(param2[0], Strings.S.getter("AssemblerUnknownRegister"));
                }
                this.destination = RV32imState.getRegisterIndex(param1[0].getValue());
                if (this.destination < 0 || this.destination > 31) {
                    errors = true;
                    instr.setError(param1[0], Strings.S.getter("AssemblerUnknownRegister"));
                }
                switch (operation) {
                    case 15: {
                        this.immediate = 0;
                        operation = 0;
                        break block0;
                    }
                    case 14: {
                        operation = 4;
                        break block0;
                    }
                }
                operation = 3;
                this.immediate = 1;
                break;
            }
            default: {
                if (instr.getNrOfParameters() != 3) {
                    instr.setError(instr.getInstruction(), Strings.S.getter("AssemblerExpectedThreeArguments"));
                    errors = true;
                    break;
                }
                AssemblerToken[] param1 = instr.getParameter(0);
                AssemblerToken[] param2 = instr.getParameter(1);
                AssemblerToken[] param3 = instr.getParameter(2);
                if (param1.length != 1 || param1[0].getType() != 5) {
                    for (AssemblerToken assemblerToken : param1) {
                        instr.setError(assemblerToken, Strings.S.getter("AssemblerExpectedRegister"));
                    }
                    errors = true;
                    break;
                }
                if (param2.length != 1 || param2[0].getType() != 5) {
                    for (AssemblerToken assemblerToken : param2) {
                        instr.setError(assemblerToken, Strings.S.getter("AssemblerExpectedRegister"));
                    }
                    errors = true;
                    break;
                }
                if (param3.length != 1 || !param3[0].isNumber()) {
                    for (AssemblerToken assemblerToken : param3) {
                        instr.setError(assemblerToken, Strings.S.getter("AssemblerExpectedImmediateValue"));
                    }
                    errors = true;
                    break;
                }
                this.immediate = param3[0].getNumberValue();
                this.source = RV32imState.getRegisterIndex(param2[0].getValue());
                if (this.source < 0 || this.source > 31) {
                    errors = true;
                    instr.setError(param2[0], Strings.S.getter("AssemblerUnknownRegister"));
                }
                this.destination = RV32imState.getRegisterIndex(param1[0].getValue());
                if (this.destination >= 0 && this.destination <= 31) break;
                errors = true;
                instr.setError(param1[0], Strings.S.getter("AssemblerUnknownRegister"));
            }
        }
        if (!errors) {
            switch (operation) {
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    if (this.immediate > 2047 || this.immediate < -2048) {
                        errors = true;
                        instr.setError(instr.getParameter(instr.getNrOfParameters() - 1)[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
                        break;
                    }
                    this.instruction = RV32imSupport.getITypeInstruction(19, this.destination, operation, this.source, this.immediate);
                    break;
                }
                case 1: 
                case 5: 
                case 8: {
                    if (this.immediate > 31 || this.immediate < 0) {
                        errors = true;
                        instr.setError(instr.getParameter(instr.getNrOfParameters() - 1)[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
                        break;
                    }
                    if (operation == 8) {
                        this.immediate |= 0x400;
                        operation = 5;
                    }
                    this.instruction = RV32imSupport.getITypeInstruction(19, this.destination, operation, this.source, this.immediate);
                    break;
                }
                case 9: 
                case 10: {
                    if (this.immediate < 0 || this.immediate >= 0x100000) {
                        errors = true;
                        instr.setError(instr.getParameter(instr.getNrOfParameters() - 1)[0], Strings.S.getter("AssemblerImmediateOutOfRange"));
                        break;
                    }
                    int opcode = operation == 9 ? 55 : 23;
                    this.instruction = RV32imSupport.getUTypeInstruction(opcode, this.destination, this.immediate);
                    break;
                }
                default: {
                    errors = true;
                    instr.setError(instr.getInstruction(), Strings.S.getter("RV32imAssemblerBUG"));
                }
            }
        }
        boolean bl = this.valid = !errors;
        if (this.valid) {
            instr.setInstructionByteCode(this.instruction, 4);
        }
        return true;
    }
}

