/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.pio;

import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeOption;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.icons.ArithmeticIcon;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocBusSlaveInterface;
import com.cburch.logisim.soc.data.SocBusSnifferInterface;
import com.cburch.logisim.soc.data.SocInstanceFactory;
import com.cburch.logisim.soc.data.SocProcessorInterface;
import com.cburch.logisim.soc.data.SocSimulationManager;
import com.cburch.logisim.soc.pio.PioAttributes;
import com.cburch.logisim.soc.pio.PioMenu;
import com.cburch.logisim.soc.pio.PioState;
import com.cburch.logisim.tools.MenuExtender;
import com.cburch.logisim.util.GraphicsUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public class SocPio
extends SocInstanceFactory {
    public static final String _ID = "SocPio";
    public static final int RESET_INDEX = 0;
    public static final int IRQ_INDEX = 1;

    public SocPio() {
        super(_ID, Strings.S.getter("SocPioComponent"), 2);
        this.setIcon(new ArithmeticIcon("SocPIO", 3));
        this.setOffsetBounds(Bounds.create(0, 0, 380, 120));
    }

    @Override
    public AttributeSet createAttributeSet() {
        return new PioAttributes();
    }

    @Override
    protected void configureNewInstance(Instance instance) {
        instance.addAttributeListener();
        this.updatePorts(instance);
        Bounds bds = instance.getBounds();
        instance.setTextField(StdAttr.LABEL, StdAttr.LABEL_FONT, bds.getX() + bds.getWidth() + 2, bds.getY() + bds.getHeight() / 2, -1, 0);
    }

    private void updatePorts(Instance instance) {
        int nrBits;
        int nrOfPorts = nrBits = instance.getAttributeValue(StdAttr.WIDTH).getWidth();
        AttributeOption dir = instance.getAttributeValue(PioAttributes.PIO_DIRECTION);
        boolean hasIrq = this.hasIrqPin(instance.getAttributeSet());
        if (dir == PioAttributes.PORT_INOUT) {
            nrOfPorts *= 2;
        }
        int index = hasIrq ? 2 : 1;
        Port[] ps = new Port[nrOfPorts += index];
        if (hasIrq) {
            ps[1] = new Port(20, 0, "output", 1);
            ps[1].setToolTip(Strings.S.getter("SocPioIrqOutput"));
        }
        ps[0] = new Port(0, 110, "input", 1);
        ps[0].setToolTip(Strings.S.getter("SocPioResetInput"));
        if (dir == PioAttributes.PORT_INPUT || dir == PioAttributes.PORT_INOUT) {
            for (int b = 0; b < nrBits; ++b) {
                ps[index + b] = new Port(370 - b * 10, 120, "input", 1);
                ps[index + b].setToolTip(Strings.S.getter("SocPioInputPinx", Integer.toString(b)));
            }
            index += nrBits;
        }
        if (dir == PioAttributes.PORT_INOUT || dir == PioAttributes.PORT_OUTPUT || dir == PioAttributes.PORT_BIDIR) {
            String portType = dir == PioAttributes.PORT_BIDIR ? "inout" : "output";
            for (int b = 0; b < nrBits; ++b) {
                ps[index + b] = new Port(370 - b * 10, 0, portType, 1);
                ps[index + b].setToolTip(dir == PioAttributes.PORT_BIDIR ? Strings.S.getter("SocPioBidirPinx", Integer.toString(b)) : Strings.S.getter("SocPioOutputPinx", Integer.toString(b)));
            }
        }
        instance.setPorts(ps);
    }

    private boolean hasIrqPin(AttributeSet attrs) {
        if (!attrs.containsAttribute(PioAttributes.PIO_GEN_IRQ)) {
            return false;
        }
        return attrs.getValue(PioAttributes.PIO_GEN_IRQ);
    }

    @Override
    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
        if (attr == SocSimulationManager.SOC_BUS_SELECT) {
            instance.fireInvalidated();
        } else if (attr == StdAttr.WIDTH || attr == PioAttributes.PIO_DIRECTION || attr == PioAttributes.PIO_GEN_IRQ) {
            this.updatePorts(instance);
        }
        super.instanceAttributeChanged(instance, attr);
    }

    private void paintPins(InstancePainter painter, Graphics2D g2, Location loc) {
        int b;
        painter.drawPort(0, "Reset", Direction.EAST);
        int nrBits = painter.getAttributeValue(StdAttr.WIDTH).getWidth();
        AttributeOption dir = painter.getAttributeValue(PioAttributes.PIO_DIRECTION);
        int index = 1;
        if (this.hasIrqPin(painter.getAttributeSet())) {
            ++index;
            painter.drawPort(1, "IRQ", Direction.NORTH);
        }
        if (dir == PioAttributes.PORT_INPUT || dir == PioAttributes.PORT_INOUT) {
            for (b = 0; b < nrBits; ++b) {
                painter.drawPort(index + b);
            }
            if (!painter.isPrintView()) {
                index += nrBits;
                g2.drawRect(loc.getX() + 40, loc.getY() + 80, 340, 40);
                GraphicsUtil.drawCenteredText(g2, Strings.S.get("SocPioInputs"), loc.getX() + 210, loc.getY() + 95);
                GraphicsUtil.drawCenteredText(g2, "0", loc.getX() + 370, loc.getY() + 110);
                if (nrBits > 9) {
                    GraphicsUtil.drawCenteredText(g2, Integer.toString(nrBits - 1), loc.getX() + 380 - nrBits * 10, loc.getY() + 110);
                } else {
                    for (b = 1; b < nrBits; ++b) {
                        GraphicsUtil.drawCenteredText(g2, Integer.toString(b), loc.getX() + 370 - b * 10, loc.getY() + 110);
                    }
                }
            }
        }
        if (dir == PioAttributes.PORT_INOUT || dir == PioAttributes.PORT_OUTPUT || dir == PioAttributes.PORT_BIDIR) {
            for (b = 0; b < nrBits; ++b) {
                painter.drawPort(index + b);
            }
            if (!painter.isPrintView()) {
                String name = dir == PioAttributes.PORT_BIDIR ? Strings.S.get("SocPioBidirs") : Strings.S.get("SocPioOutputs");
                g2.drawRect(loc.getX() + 40, loc.getY(), 340, 40);
                GraphicsUtil.drawCenteredText(g2, name, loc.getX() + 210, loc.getY() + 25);
                GraphicsUtil.drawCenteredText(g2, "0", loc.getX() + 370, loc.getY() + 10);
                if (nrBits > 9) {
                    GraphicsUtil.drawCenteredText(g2, Integer.toString(nrBits - 1), loc.getX() + 380 - nrBits * 10, loc.getY() + 10);
                } else {
                    for (int b2 = 1; b2 < nrBits; ++b2) {
                        GraphicsUtil.drawCenteredText(g2, Integer.toString(b2), loc.getX() + 370 - b2 * 10, loc.getY() + 10);
                    }
                }
            }
        }
    }

    @Override
    public void propagate(InstanceState state) {
        PioState myState = state.getAttributeValue(PioAttributes.PIO_STATE);
        myState.handleOperations(state, false);
    }

    @Override
    public void paintInstance(InstancePainter painter) {
        Graphics2D g2 = (Graphics2D)painter.getGraphics();
        Location loc = painter.getLocation();
        g2.setColor(new Color(AppPreferences.COMPONENT_COLOR.get()));
        painter.drawBounds();
        painter.drawLabel();
        this.paintPins(painter, g2, loc);
        Font f = g2.getFont();
        g2.setFont(StdAttr.DEFAULT_LABEL_FONT);
        GraphicsUtil.drawCenteredText(g2, "SOC parallel IO", loc.getX() + 210, loc.getY() + 50);
        g2.setFont(f);
        if (painter.isPrintView()) {
            return;
        }
        painter.getAttributeValue(SocSimulationManager.SOC_BUS_SELECT).paint(g2, Bounds.create(loc.getX() + 45, loc.getY() + 61, 330, 18));
    }

    @Override
    protected Object getInstanceFeature(Instance instance, Object key) {
        return key == MenuExtender.class ? new PioMenu(instance) : super.getInstanceFeature(instance, key);
    }

    @Override
    public SocBusSlaveInterface getSlaveInterface(AttributeSet attrs) {
        return attrs.getValue(PioAttributes.PIO_STATE);
    }

    @Override
    public SocBusSnifferInterface getSnifferInterface(AttributeSet attrs) {
        return null;
    }

    @Override
    public SocProcessorInterface getProcessorInterface(AttributeSet attrs) {
        return null;
    }
}

