/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.nios2;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocBusInfo;
import com.cburch.logisim.soc.data.SocSimulationManager;
import com.cburch.logisim.soc.nios2.Nios2State;
import java.awt.Font;
import java.util.Arrays;
import java.util.List;

public class Nios2Attributes
extends AbstractAttributeSet {
    public static final Attribute<Nios2State> NIOS2_STATE = new Nios2StateAttribute();
    public static final Attribute<BitWidth> NR_OF_IRQS = Attributes.forBitWidth("irqWidth", Strings.S.getter("rv32imIrqWidth"), 0, 32);
    public static final Attribute<Integer> RESET_VECTOR = Attributes.forHexInteger("resetVector", Strings.S.getter("rv32ResetVector"));
    public static final Attribute<Integer> EXCEPTION_VECTOR = Attributes.forHexInteger("exceptionVector", Strings.S.getter("rv32ExceptionVector"));
    public static final Attribute<Integer> BREAK_VECTOR = Attributes.forHexInteger("breakVector", Strings.S.getter("nios2BreakVector"));
    public static final Attribute<Boolean> NIOS_STATE_VISIBLE = Attributes.forBoolean("stateVisible", Strings.S.getter("rv32StateVisible"));
    private Font labelFont = StdAttr.DEFAULT_LABEL_FONT;
    private Boolean labelVisible = true;
    private Nios2State upState = new Nios2State();
    private Boolean stateVisible = true;
    private static final List<Attribute<?>> ATTRIBUTES = Arrays.asList(RESET_VECTOR, EXCEPTION_VECTOR, BREAK_VECTOR, NR_OF_IRQS, NIOS_STATE_VISIBLE, StdAttr.LABEL, StdAttr.LABEL_FONT, StdAttr.LABEL_VISIBILITY, SocSimulationManager.SOC_BUS_SELECT, NIOS2_STATE);

    @Override
    protected void copyInto(AbstractAttributeSet dest) {
        Nios2Attributes d = (Nios2Attributes)dest;
        d.labelFont = this.labelFont;
        d.labelVisible = this.labelVisible;
        d.stateVisible = this.stateVisible;
        d.upState = new Nios2State();
        this.upState.copyInto(d.upState);
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return ATTRIBUTES;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == RESET_VECTOR) {
            return (V)this.upState.getResetVector();
        }
        if (attr == EXCEPTION_VECTOR) {
            return (V)this.upState.getExceptionVector();
        }
        if (attr == BREAK_VECTOR) {
            return (V)this.upState.getBreakVector();
        }
        if (attr == NR_OF_IRQS) {
            return (V)BitWidth.create(this.upState.getNrOfIrqs());
        }
        if (attr == StdAttr.LABEL) {
            return (V)this.upState.getLabel();
        }
        if (attr == StdAttr.LABEL_FONT) {
            return (V)this.labelFont;
        }
        if (attr == StdAttr.LABEL_VISIBILITY) {
            return (V)this.labelVisible;
        }
        if (attr == SocSimulationManager.SOC_BUS_SELECT) {
            return (V)this.upState.getAttachedBus();
        }
        if (attr == NIOS2_STATE) {
            return (V)this.upState;
        }
        if (attr == NIOS_STATE_VISIBLE) {
            return (V)this.stateVisible;
        }
        return null;
    }

    @Override
    public boolean isReadOnly(Attribute<?> attr) {
        return attr == NIOS2_STATE;
    }

    @Override
    public boolean isToSave(Attribute<?> attr) {
        return attr.isToSave() && attr != NIOS2_STATE;
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        V oldValue = this.getValue(attr);
        if (attr == RESET_VECTOR) {
            if (this.upState.setResetVector((Integer)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == EXCEPTION_VECTOR) {
            if (this.upState.setExceptionVector((Integer)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == BREAK_VECTOR) {
            if (this.upState.setBreakVector((Integer)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == NR_OF_IRQS) {
            if (this.upState.setNrOfIrqs(((BitWidth)value).getWidth())) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == SocSimulationManager.SOC_BUS_SELECT) {
            if (this.upState.setAttachedBus((SocBusInfo)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == StdAttr.LABEL) {
            if (this.upState.setLabel((String)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == StdAttr.LABEL_FONT) {
            Font f = (Font)value;
            if (!this.labelFont.equals(f)) {
                this.labelFont = f;
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == StdAttr.LABEL_VISIBILITY) {
            Boolean v = (Boolean)value;
            if (v != this.labelVisible) {
                this.labelVisible = v;
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == NIOS_STATE_VISIBLE) {
            Boolean v = (Boolean)value;
            if (this.stateVisible != v) {
                this.stateVisible = v;
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
    }

    private static class Nios2StateAttribute
    extends Attribute<Nios2State> {
        private Nios2StateAttribute() {
        }

        @Override
        public Nios2State parse(String value) {
            return null;
        }

        @Override
        public boolean isHidden() {
            return true;
        }
    }
}

