/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.memory;

import com.cburch.logisim.data.AbstractAttributeSet;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.Attributes;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocBusInfo;
import com.cburch.logisim.soc.data.SocSimulationManager;
import com.cburch.logisim.soc.memory.SocMemoryState;
import java.awt.Font;
import java.util.Arrays;
import java.util.List;

public class SocMemoryAttributes
extends AbstractAttributeSet {
    public static final Attribute<SocMemoryState> SOCMEM_STATE = new SocMemoryStateAttribute();
    public static final Attribute<Integer> START_ADDRESS = Attributes.forHexInteger("StartAddress", Strings.S.getter("SocMemStartAddress"));
    public static final Attribute<BitWidth> MEM_SIZE = Attributes.forBitWidth("MemSize", Strings.S.getter("SocMemSize"), 10, 26);
    private Font labelFont = StdAttr.DEFAULT_LABEL_FONT;
    private Boolean labelVisible = true;
    private SocMemoryState memState = new SocMemoryState();
    private BitWidth memSize = BitWidth.create(10);
    private static final List<Attribute<?>> ATTRIBUTES = Arrays.asList(START_ADDRESS, MEM_SIZE, StdAttr.LABEL, StdAttr.LABEL_FONT, StdAttr.LABEL_VISIBILITY, SocSimulationManager.SOC_BUS_SELECT, SOCMEM_STATE);

    @Override
    protected void copyInto(AbstractAttributeSet dest) {
        SocMemoryAttributes d = (SocMemoryAttributes)dest;
        d.labelFont = this.labelFont;
        d.labelVisible = this.labelVisible;
        d.memState = new SocMemoryState();
        d.memSize = this.memSize;
        d.memState.setSize(this.memSize);
        d.memState.setStartAddress(this.memState.getStartAddress());
        d.memState.getSocBusInfo().setBusId(this.memState.getSocBusInfo().getBusId());
        d.memState.setLabel(this.memState.getLabel());
    }

    @Override
    public List<Attribute<?>> getAttributes() {
        return ATTRIBUTES;
    }

    @Override
    public <V> V getValue(Attribute<V> attr) {
        if (attr == START_ADDRESS) {
            return (V)this.memState.getStartAddress();
        }
        if (attr == MEM_SIZE) {
            return (V)this.memSize;
        }
        if (attr == StdAttr.LABEL) {
            return (V)this.memState.getLabel();
        }
        if (attr == StdAttr.LABEL_FONT) {
            return (V)this.labelFont;
        }
        if (attr == StdAttr.LABEL_VISIBILITY) {
            return (V)this.labelVisible;
        }
        if (attr == SocSimulationManager.SOC_BUS_SELECT) {
            return (V)this.memState.getSocBusInfo();
        }
        if (attr == SOCMEM_STATE) {
            return (V)this.memState;
        }
        return null;
    }

    @Override
    public boolean isReadOnly(Attribute<?> attr) {
        return attr == SOCMEM_STATE;
    }

    @Override
    public boolean isToSave(Attribute<?> attr) {
        return attr.isToSave() && attr != SOCMEM_STATE;
    }

    @Override
    public <V> void setValue(Attribute<V> attr, V value) {
        V oldValue = this.getValue(attr);
        if (attr == START_ADDRESS) {
            if (this.memState.setStartAddress((Integer)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == MEM_SIZE) {
            if (this.memState.setSize((BitWidth)value)) {
                this.memSize = (BitWidth)value;
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == StdAttr.LABEL) {
            String l = (String)value;
            if (this.memState.setLabel(l)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == StdAttr.LABEL_FONT) {
            Font f = (Font)value;
            if (!this.labelFont.equals(f)) {
                this.labelFont = f;
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == StdAttr.LABEL_VISIBILITY) {
            Boolean v = (Boolean)value;
            if (!this.labelVisible.equals(v)) {
                this.labelVisible = v;
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
        if (attr == SocSimulationManager.SOC_BUS_SELECT) {
            if (this.memState.setSocBusInfo((SocBusInfo)value)) {
                this.fireAttributeValueChanged(attr, value, oldValue);
            }
            return;
        }
    }

    private static class SocMemoryStateAttribute
    extends Attribute<SocMemoryState> {
        private SocMemoryStateAttribute() {
        }

        @Override
        public SocMemoryState parse(String value) {
            return null;
        }

        @Override
        public boolean isHidden() {
            return true;
        }
    }
}

