/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.file;

import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.file.ElfHeader;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class ElfProgramHeader {
    public static final int P_TYPE = 0;
    public static final int P_FLAGS = 1;
    public static final int P_OFFSET = 2;
    public static final int P_VADDR = 3;
    public static final int P_PADDR = 4;
    public static final int P_FILESZ = 5;
    public static final int P_MEMSZ = 6;
    public static final int P_ALIGN = 7;
    public static final int PT_NULL = 0;
    public static final int PT_LOAD = 1;
    public static final int PT_DYNAMIC = 2;
    public static final int PT_INTERP = 3;
    public static final int PT_NOTE = 4;
    public static final int PT_SHLIB = 5;
    public static final int PT_PHDR = 6;
    public static final int PT_LOPROC = 0x70000000;
    public static final int PT_HIPROC = Integer.MAX_VALUE;
    private static final Map<Integer, String> PT_TYPES = Map.of(0, "PT_NULL", 1, "PT_LOAD", 2, "PT_DYNAMIC", 3, "PT_INTERP", 4, "PT_NOTE", 5, "PT_SHLIB", 6, "PT_PHDR", 0x70000000, "PT_LOPROC", Integer.MAX_VALUE, "PT_HIPROC");
    public static final int PF_X = 1;
    public static final int PF_W = 2;
    public static final int PF_R = 4;
    private static final Map<Integer, String> PF_FLAGS = Map.of(1, "PF_X", 2, "PF_W", 4, "PF_R");
    private static final int SUCCESS = 0;
    private static final int PROGRAM_HEADER_NOT_FOUND_ERROR = 1;
    private static final int PROGRAM_HEADER_READ_ERROR = 2;
    private static final int PROGRAM_HEADER_SIZE_ERROR = 3;
    private int status = 0;
    private ArrayList<ProgramHeader> headers;
    private long programHeaderSize;

    public ElfProgramHeader(FileInputStream file, ElfHeader elfHeader) {
        try {
            file.skip(elfHeader.getSize());
        }
        catch (IOException e) {
            this.status = 1;
            return;
        }
        int nrOfProgramHeaders = ElfHeader.getIntValue(elfHeader.getValue(26));
        int progHeaderEntrySize = ElfHeader.getIntValue(elfHeader.getValue(25));
        this.programHeaderSize = nrOfProgramHeaders * progHeaderEntrySize;
        byte[] buffer = new byte[(int)this.programHeaderSize];
        int nrRead = 0;
        try {
            nrRead = file.read(buffer);
        }
        catch (IOException e) {
            this.status = 2;
            return;
        }
        if ((long)nrRead != this.programHeaderSize) {
            this.status = 3;
            return;
        }
        int index = 0;
        this.headers = new ArrayList();
        for (int i = 0; i < nrOfProgramHeaders; ++i) {
            this.headers.add(new ProgramHeader(buffer, elfHeader.is32Bit(), elfHeader.isLittleEndian(), index));
            index += progHeaderEntrySize;
        }
    }

    public boolean isValid() {
        return this.status == 0;
    }

    public long getSize() {
        return this.programHeaderSize;
    }

    public String getErrorString() {
        return switch (this.status) {
            case 0 -> Strings.S.get("ProgHeaderSuccess");
            case 1 -> Strings.S.get("ProgHeaderNotFound");
            case 2 -> Strings.S.get("ProgHeaderReadError");
            case 3 -> Strings.S.get("ProgHeaderSizeError");
            default -> "BUG: this should never happen in ElfProgramHeader";
        };
    }

    public int getNrOfHeaders() {
        return this.headers.size();
    }

    public ProgramHeader getHeader(int index) {
        if (index < 0 || index >= this.headers.size()) {
            return null;
        }
        return this.headers.get(index);
    }

    public static class ProgramHeader {
        private final Integer p_type;
        private Integer p_flags;
        private final Long p_offset;
        private final Long p_vaddr;
        private final Long p_paddr;
        private final Long p_filesz;
        private final Long p_memsz;
        private final Long p_align;
        private final boolean is32Bit;

        public ProgramHeader(byte[] buffer, boolean is32Bit, boolean isLittleEndian, int offset) {
            int increment;
            int index = offset;
            this.is32Bit = is32Bit;
            this.p_type = ElfHeader.getIntValue(buffer, index, 4, isLittleEndian);
            index += 4;
            int n = increment = is32Bit ? 4 : 8;
            if (!is32Bit) {
                this.p_flags = ElfHeader.getIntValue(buffer, index, 4, isLittleEndian);
                index += 4;
            }
            this.p_offset = ElfHeader.getLongValue(buffer, index, increment, isLittleEndian);
            this.p_vaddr = ElfHeader.getLongValue(buffer, index += increment, increment, isLittleEndian);
            this.p_paddr = ElfHeader.getLongValue(buffer, index += increment, increment, isLittleEndian);
            this.p_filesz = ElfHeader.getLongValue(buffer, index += increment, increment, isLittleEndian);
            this.p_memsz = ElfHeader.getLongValue(buffer, index += increment, increment, isLittleEndian);
            index += increment;
            if (is32Bit) {
                this.p_flags = ElfHeader.getIntValue(buffer, index, 4, isLittleEndian);
                index += 4;
            }
            this.p_align = ElfHeader.getLongValue(buffer, index, increment, isLittleEndian);
        }

        public Object getValue(int identifier) {
            return switch (identifier) {
                case 0 -> this.p_type;
                case 1 -> this.p_flags;
                case 2 -> ElfHeader.returnCorrectValue(this.p_offset, this.is32Bit);
                case 3 -> ElfHeader.returnCorrectValue(this.p_vaddr, this.is32Bit);
                case 4 -> ElfHeader.returnCorrectValue(this.p_paddr, this.is32Bit);
                case 5 -> ElfHeader.returnCorrectValue(this.p_filesz, this.is32Bit);
                case 6 -> ElfHeader.returnCorrectValue(this.p_memsz, this.is32Bit);
                case 7 -> ElfHeader.returnCorrectValue(this.p_align, this.is32Bit);
                default -> null;
            };
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            s.append("Program Header Info:\np_type   : ");
            s.append(PT_TYPES.getOrDefault(this.p_type, "unknown"));
            s.append("\np_flags  : ");
            boolean first = true;
            for (int i : PF_FLAGS.keySet()) {
                if ((this.p_flags & i) == 0) continue;
                if (!first) {
                    s.append(", ");
                }
                first = false;
                s.append(PF_FLAGS.get(i));
            }
            s.append("\np_offset : ").append(String.format("0x%X", this.p_offset)).append("\n");
            s.append("p_vaddr  : ").append(String.format("0x%X", this.p_vaddr)).append("\n");
            s.append("p_paddr  : ").append(String.format("0x%X", this.p_paddr)).append("\n");
            s.append("p_filesz : ").append(String.format("0x%X", this.p_filesz)).append("\n");
            s.append("p_memsz  : ").append(String.format("0x%X", this.p_memsz)).append("\n");
            s.append("p_align  : ").append(String.format("0x%X", this.p_align)).append("\n\n");
            return s.toString();
        }
    }
}

