/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.data;

import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocBusSlaveInterface;
import com.cburch.logisim.soc.data.SocBusSlaveListener;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class SocMemMapModel
extends AbstractTableModel
implements SocBusSlaveListener,
LocaleListener,
BaseMouseListenerContract {
    private static final long serialVersionUID = 1L;
    private static final long longMask = Long.parseUnsignedLong("FFFFFFFF", 16);
    private final ArrayList<SocBusSlaveInterface> slaves;
    private final SlaveMap slaveMap;
    private final SlaveInfoRenderer slaveRenderer;
    private final MemoryMapHeaderRenderer headRenderer;
    private InstanceComponent marked;

    public SocMemMapModel() {
        LocaleManager.addLocaleListener(this);
        this.slaveMap = new SlaveMap();
        this.slaves = new ArrayList();
        this.slaveRenderer = new SlaveInfoRenderer();
        this.headRenderer = new MemoryMapHeaderRenderer();
        this.marked = null;
        this.rebuild();
    }

    public void registerSocBusSlave(SocBusSlaveInterface slave) {
        if (!this.slaves.contains(slave)) {
            this.slaves.add(slave);
            slave.registerListener(this);
            this.rebuild();
        }
    }

    public void removeSocBusSlave(SocBusSlaveInterface slave) {
        if (this.slaves.contains(slave)) {
            this.slaves.remove(slave);
            slave.removeListener(this);
            this.rebuild();
        }
    }

    public List<SocBusSlaveInterface> getSlaves() {
        return this.slaves;
    }

    public SlaveInfoRenderer getCellRender() {
        return this.slaveRenderer;
    }

    public MemoryMapHeaderRenderer getHeaderRenderer() {
        return this.headRenderer;
    }

    @Override
    public String getColumnName(int col) {
        return switch (col) {
            case 0 -> Strings.S.get("SocMemMapStartAddress");
            case 1 -> Strings.S.get("SocMemMapEndAddress");
            case 2 -> Strings.S.get("SocMemMapSlaveName");
            default -> "";
        };
    }

    @Override
    public int getRowCount() {
        return this.slaveMap.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.slaveMap.getSlave(rowIndex);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void labelChanged() {
        this.rebuild();
    }

    @Override
    public void memoryMapChanged() {
        this.rebuild();
    }

    private void rebuild() {
        this.slaveMap.clear();
        if (this.slaves.isEmpty()) {
            this.slaveMap.add(new SlaveInfo(0L, -1L));
        } else {
            for (SocBusSlaveInterface s : this.slaves) {
                this.slaveMap.add(s);
            }
            ArrayList<SlaveInfo> empties = new ArrayList<SlaveInfo>();
            long addr = 0L;
            for (int i = 0; i < this.slaveMap.size(); ++i) {
                SlaveInfo s = this.slaveMap.getSlave(i);
                if (addr < s.getStartAddress()) {
                    empties.add(new SlaveInfo(addr, s.getStartAddress() - 1L));
                }
                addr = s.getEndAddress() + 1L;
            }
            if (addr < longMask) {
                empties.add(new SlaveInfo(addr, longMask));
            }
            for (SlaveInfo s : empties) {
                this.slaveMap.add(s);
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public void localeChanged() {
        this.rebuild();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        JTable table;
        int row;
        Component component = e.getComponent();
        if (component instanceof JTable && (row = (table = (JTable)component).rowAtPoint(e.getPoint())) >= 0 && row < this.slaveMap.size()) {
            InstanceComponent comp = this.slaveMap.getSlave(row).getComponent();
            if (this.marked != null) {
                this.marked.clearMarks();
            }
            comp.markInstance();
            comp.getInstance().fireInvalidated();
            this.marked = comp;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.marked != null) {
            this.marked.clearMarks();
            this.marked.getInstance().fireInvalidated();
            this.marked = null;
        }
    }

    private static class SlaveMap {
        private final LinkedList<SlaveInfo> slaves = new LinkedList();

        public void add(SocBusSlaveInterface s) {
            SlaveInfo slave = new SlaveInfo(s);
            this.add(slave);
        }

        public void add(SlaveInfo slave) {
            if (this.slaves.isEmpty()) {
                this.slaves.add(slave);
                return;
            }
            for (int i = 0; i < this.slaves.size(); ++i) {
                SlaveInfo cur = this.slaves.get(i);
                if (cur.contains(slave.getStartAddress())) {
                    slave.setOverlap();
                }
                if (cur.getStartAddress() < slave.getStartAddress()) continue;
                if (slave.contains(cur.getStartAddress())) {
                    cur.setOverlap();
                }
                this.slaves.add(i, slave);
                return;
            }
            this.slaves.add(slave);
        }

        public SlaveInfo getSlave(int index) {
            if (index < 0 || index >= this.slaves.size()) {
                return null;
            }
            return this.slaves.get(index);
        }

        public int size() {
            return this.slaves.size();
        }

        public void clear() {
            this.slaves.clear();
        }
    }

    public static class SlaveInfoRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public SlaveInfoRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            SlaveInfo s = (SlaveInfo)value;
            this.setBackground(s.getColor());
            this.setForeground(s.getTextColor());
            switch (column) {
                case 0: {
                    this.setText(String.format("0x%08X", s.getStartAddress()));
                    this.setHorizontalAlignment(0);
                    break;
                }
                case 1: {
                    this.setText(String.format("0x%08X", s.getEndAddress()));
                    this.setHorizontalAlignment(0);
                    break;
                }
                default: {
                    this.setText(s.getName());
                    this.setHorizontalAlignment(2);
                }
            }
            return this;
        }
    }

    public static class MemoryMapHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public MemoryMapHeaderRenderer() {
            this.setForeground(Color.BLUE);
            this.setBorder(BorderFactory.createEtchedBorder());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column < 2) {
                this.setHorizontalAlignment(0);
            } else {
                this.setHorizontalAlignment(2);
            }
            this.setText(value.toString());
            return this;
        }
    }

    public static class SlaveInfo {
        private boolean hasOverlap;
        private final SocBusSlaveInterface slave;
        private long start;
        private long end;

        public SlaveInfo(SocBusSlaveInterface s) {
            this.slave = s;
            this.hasOverlap = false;
        }

        public SlaveInfo(long start, long end) {
            this.slave = null;
            this.hasOverlap = false;
            this.start = start;
            this.end = end;
        }

        public void setOverlap() {
            this.hasOverlap = true;
        }

        public boolean hasMemoryOverlap() {
            return this.hasOverlap;
        }

        public long getStartAddress() {
            return this.slave == null ? this.start : (long)this.slave.getStartAddress().intValue() & longMask;
        }

        public long getEndAddress() {
            if (this.slave == null) {
                return this.end;
            }
            long start = (long)this.slave.getStartAddress().intValue() & longMask;
            long size = (long)this.slave.getMemorySize().intValue() & longMask;
            return start + size - 1L;
        }

        public String getName() {
            return this.slave == null ? Strings.S.get("SocMemMapEmpty") : this.slave.getName();
        }

        public boolean contains(long address) {
            boolean ret = address >= this.getStartAddress() && address <= this.getEndAddress();
            this.hasOverlap |= ret;
            return ret;
        }

        public Color getColor() {
            if (this.slave == null) {
                return Color.LIGHT_GRAY;
            }
            return this.hasOverlap ? Color.RED : Color.GREEN;
        }

        public Color getTextColor() {
            if (this.hasOverlap) {
                return Color.LIGHT_GRAY;
            }
            return Color.BLACK;
        }

        public InstanceComponent getComponent() {
            if (this.slave == null) {
                return null;
            }
            return this.slave.getComponent();
        }
    }
}

