/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.proj;

import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.proj.Strings;
import com.cburch.logisim.util.XmlUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ProjectBundleManifest {
    public static infofileInformation getInfoContainer(String logisimVersion, String mainCircuitFile) {
        return new infofileInformation(logisimVersion, mainCircuitFile);
    }

    public static void writeManifest(ZipOutputStream zipfile, infofileInformation info) throws IOException {
        if (zipfile == null) {
            return;
        }
        try {
            DocumentBuilderFactory factory = XmlUtil.getHardenedBuilderFactory();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document boardInfo = parser.newDocument();
            Element manifest = boardInfo.createElement("logisim");
            boardInfo.appendChild(manifest);
            manifest.setAttribute("type", "bundle");
            manifest.setAttribute("version", "1");
            Element meta = boardInfo.createElement("meta");
            manifest.appendChild(meta);
            Element progInfo = boardInfo.createElement("tool");
            meta.appendChild(progInfo);
            String[] parts = info.logisimVersion.split(" ");
            progInfo.setAttribute("name", parts[0]);
            if (parts.length > 1) {
                progInfo.setAttribute("version", parts[1]);
            }
            Element project = boardInfo.createElement("project");
            manifest.appendChild(project);
            Element files = boardInfo.createElement("files");
            project.appendChild(files);
            Element mainFile = boardInfo.createElement("file");
            files.appendChild(mainFile);
            mainFile.setAttribute("main", "true");
            Text fileName = boardInfo.createTextNode(info.mainCircuitFile);
            mainFile.appendChild(fileName);
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer aTransformer = tranFactory.newTransformer();
            aTransformer.setOutputProperty("indent", "yes");
            DOMSource src = new DOMSource(boardInfo);
            StreamResult dest = new StreamResult(new StringWriter());
            aTransformer.transform(src, dest);
            zipfile.putNextEntry(new ZipEntry("manifest.xml"));
            zipfile.write(dest.getWriter().toString().getBytes());
        }
        catch (ParserConfigurationException e) {
            System.err.println(e.getMessage());
        }
        catch (TransformerConfigurationException e) {
            System.err.println(e.getMessage());
        }
        catch (TransformerException e) {
            System.err.println(e.getMessage());
        }
    }

    public static infofileInformation getManifestInfo(ZipFile zipFile, Frame frame) throws IOException {
        try {
            DocumentBuilderFactory factory = XmlUtil.getHardenedBuilderFactory();
            DocumentBuilder parser = factory.newDocumentBuilder();
            ZipEntry projInfoEntry = zipFile.getEntry("manifest.xml");
            if (projInfoEntry == null) {
                OptionPane.showMessageDialog(frame, Strings.S.fmt("projBundleReadError", Strings.S.get("projBundleNoInfo")));
                return null;
            }
            InputStream projInfoStream = zipFile.getInputStream(projInfoEntry);
            Document docInfo = parser.parse(projInfoStream);
            NodeList manifestNodes = docInfo.getElementsByTagName("logisim");
            if (manifestNodes.getLength() != 1) {
                OptionPane.showMessageDialog(frame, Strings.S.fmt("projBundleReadError", Strings.S.get("projBundleMisformatted")));
                return null;
            }
            Node manifestNode = manifestNodes.item(0);
            NodeList manifestInfo = manifestNode.getChildNodes();
            NamedNodeMap nodeAttr = manifestNode.getAttributes();
            if (nodeAttr.getLength() != 2) {
                OptionPane.showMessageDialog(frame, Strings.S.fmt("projBundleReadError", Strings.S.get("projBundleMisformatted")));
                return null;
            }
            Node attr0 = nodeAttr.item(0);
            Node attr1 = nodeAttr.item(1);
            if (!("type".equals(attr0.getNodeName()) && "bundle".equals(attr0.getNodeValue()) && "version".equals(attr1.getNodeName()) && "1".equals(attr1.getNodeValue()))) {
                OptionPane.showMessageDialog(frame, Strings.S.fmt("projBundleReadError", Strings.S.get("projBundleMisformatted")));
                return null;
            }
            String main = "";
            String creator = "";
            for (int nodeId = 0; nodeId < manifestInfo.getLength(); ++nodeId) {
                Node node = manifestInfo.item(nodeId);
                if ("project".equals(node.getNodeName())) {
                    NodeList projectChilds = node.getChildNodes();
                    for (int childId = 0; childId < projectChilds.getLength(); ++childId) {
                        Node childNode = projectChilds.item(childId);
                        if (!"files".equals(childNode.getNodeName())) continue;
                        NodeList fileNodes = childNode.getChildNodes();
                        for (int fileId = 0; fileId < fileNodes.getLength(); ++fileId) {
                            Node node2;
                            NodeList mainNodes;
                            NamedNodeMap fileAttrs;
                            Node fileNode = fileNodes.item(fileId);
                            if (!"file".equals(fileNode.getNodeName()) || (fileAttrs = fileNode.getAttributes()).getLength() != 1 || !"main".equals(fileAttrs.item(0).getNodeName()) || !"true".equals(fileAttrs.item(0).getNodeValue()) || (mainNodes = fileNode.getChildNodes()).getLength() != 1 || !((node2 = mainNodes.item(0)) instanceof Text)) continue;
                            Text filename = (Text)node2;
                            main = filename.getNodeValue();
                        }
                    }
                    continue;
                }
                if (!"meta".equals(node.getNodeName())) continue;
                NodeList metaChilds = node.getChildNodes();
                for (int metaId = 0; metaId < metaChilds.getLength(); ++metaId) {
                    NamedNodeMap metaAttrs;
                    Node metaNode = metaChilds.item(metaId);
                    if (!"tool".equals(metaNode.getNodeName()) || (metaAttrs = metaNode.getAttributes()).getLength() != 2) continue;
                    Node metaAttr1 = metaAttrs.item(0);
                    Node metaAttr2 = metaAttrs.item(1);
                    if (!"name".equals(metaAttr1.getNodeName()) || !"version".equals(metaAttr2.getNodeName())) continue;
                    creator = String.format("%s %s", metaAttr1.getNodeValue(), metaAttr2.getNodeValue());
                }
            }
            if (!main.isEmpty() && !creator.isEmpty()) {
                return new infofileInformation(creator, main);
            }
        }
        catch (ParserConfigurationException e) {
            System.err.println(e.getMessage());
        }
        catch (SAXException e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    public static class infofileInformation {
        private final String logisimVersion;
        private final String mainCircuitFile;

        public infofileInformation(String logisimVersion, String mainCircuitFile) {
            this.logisimVersion = logisimVersion;
            this.mainCircuitFile = mainCircuitFile;
        }

        public String getBundleLogisimVersion() {
            return this.logisimVersion;
        }

        public String getMainLogisimFilename() {
            return this.mainCircuitFile;
        }
    }
}

