/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.proj;

import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import java.util.Arrays;
import java.util.List;

public class JoinedAction
extends Action {
    private Action[] todo;

    public JoinedAction(Action ... actions) {
        this.todo = actions;
    }

    @Override
    public Action append(Action other) {
        int oldLen = this.todo.length;
        Action[] newToDo = new Action[oldLen + 1];
        System.arraycopy(this.todo, 0, newToDo, 0, oldLen);
        newToDo[oldLen] = other;
        this.todo = newToDo;
        return this;
    }

    @Override
    public void doIt(Project proj) {
        for (Action act : this.todo) {
            act.doIt(proj);
        }
    }

    public List<Action> getActions() {
        return Arrays.asList(this.todo);
    }

    public Action getFirstAction() {
        return this.todo[0];
    }

    public Action getLastAction() {
        return this.todo[this.todo.length - 1];
    }

    @Override
    public String getName() {
        return this.todo[0].getName();
    }

    @Override
    public boolean isModification() {
        for (Action act : this.todo) {
            if (!act.isModification()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void undo(Project proj) {
        for (int i = this.todo.length - 1; i >= 0; --i) {
            this.todo[i].undo(proj);
        }
    }
}

