/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.instance;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.comp.ComponentUserEvent;
import com.cburch.logisim.comp.TextField;
import com.cburch.logisim.comp.TextFieldEvent;
import com.cburch.logisim.comp.TextFieldListener;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.std.Strings;
import com.cburch.logisim.tools.Caret;
import com.cburch.logisim.tools.SetAttributeAction;
import com.cburch.logisim.tools.TextEditable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class InstanceTextField
implements AttributeListener,
TextFieldListener,
TextEditable {
    private Canvas canvas;
    private final InstanceComponent comp;
    private TextField field;
    private Attribute<String> labelAttr;
    private Attribute<Font> fontAttr;
    private boolean isLabelVisible = true;
    private Color fontColor;
    private int fieldX;
    private int fieldY;
    private int halign;
    private int valign;

    InstanceTextField(InstanceComponent comp) {
        this.comp = comp;
        this.field = null;
        this.labelAttr = null;
        this.fontAttr = null;
        this.fontColor = StdAttr.DEFAULT_LABEL_COLOR;
    }

    @Override
    public void attributeValueChanged(AttributeEvent e) {
        Attribute<?> attr = e.getAttribute();
        if (attr == this.labelAttr) {
            this.updateField(this.comp.getAttributeSet());
        } else if (attr == this.fontAttr) {
            if (this.field != null) {
                this.field.setFont((Font)e.getValue());
            }
        } else if (attr == StdAttr.LABEL_COLOR) {
            this.fontColor = (Color)e.getValue();
        } else if (attr == StdAttr.LABEL_VISIBILITY) {
            this.isLabelVisible = (Boolean)e.getValue();
        }
    }

    private void createField(AttributeSet attrs, String text) {
        Font font = attrs.getValue(this.fontAttr);
        this.field = new TextField(this.fieldX, this.fieldY, this.halign, this.valign, font);
        this.field.setText(text);
        this.field.addTextFieldListener(this);
    }

    void draw(Component comp, ComponentDrawContext context) {
        if (this.field != null && this.isLabelVisible) {
            Graphics gfx = context.getGraphics().create();
            Color currentColor = gfx.getColor();
            if (!context.isPrintView()) {
                gfx.setColor(this.fontColor);
            }
            this.field.draw(gfx);
            gfx.setColor(currentColor);
            gfx.dispose();
        }
    }

    Bounds getBounds(Graphics g) {
        return this.field == null || !this.isLabelVisible ? Bounds.EMPTY_BOUNDS : this.field.getBounds(g);
    }

    @Override
    public Action getCommitAction(Circuit circuit, String oldText, String newText) {
        SetAttributeAction act = new SetAttributeAction(circuit, Strings.S.getter("changeLabelAction"));
        act.set(this.comp, this.labelAttr, newText);
        return act;
    }

    @Override
    public Caret getTextCaret(ComponentUserEvent event) {
        int y;
        int x;
        String text;
        this.canvas = event.getCanvas();
        Graphics gfx = this.canvas.getGraphics();
        if (this.field == null) {
            this.createField(this.comp.getAttributeSet(), "");
        }
        if ((text = this.field.getText()) == null || text.equals("")) {
            return this.field.getCaret(gfx, 0);
        }
        Bounds bds = this.field.getBounds(gfx);
        if (bds.getWidth() < 4 || bds.getHeight() < 4) {
            Location loc = this.comp.getLocation();
            bds = bds.add(Bounds.create(loc).expand(2));
        }
        return bds.contains(x = event.getX(), y = event.getY()) ? this.field.getCaret(gfx, x, y) : null;
    }

    private boolean shouldRegister() {
        return this.labelAttr != null || this.fontAttr != null;
    }

    @Override
    public void textChanged(TextFieldEvent e) {
        String prev = e.getOldText();
        String next = e.getText();
        if (!next.equals(prev)) {
            this.comp.getAttributeSet().setValue(this.labelAttr, next);
        }
    }

    void update(Attribute<String> labelAttr, Attribute<Font> fontAttr, int x, int y, int halign, int valign) {
        boolean wasReg = this.shouldRegister();
        this.labelAttr = labelAttr;
        this.fontAttr = fontAttr;
        this.fieldX = x;
        this.fieldY = y;
        this.halign = halign;
        this.valign = valign;
        boolean shouldReg = this.shouldRegister();
        AttributeSet attrs = this.comp.getAttributeSet();
        if (attrs.containsAttribute(StdAttr.LABEL_VISIBILITY)) {
            this.isLabelVisible = attrs.getValue(StdAttr.LABEL_VISIBILITY);
        }
        if (!wasReg && shouldReg) {
            attrs.addAttributeListener(this);
        }
        if (wasReg && !shouldReg) {
            attrs.removeAttributeListener(this);
        }
        this.updateField(attrs);
    }

    private void updateField(AttributeSet attrs) {
        String text = attrs.getValue(this.labelAttr);
        if (text == null || text.equals("")) {
            if (this.field != null) {
                this.field.removeTextFieldListener(this);
                this.field = null;
            }
        } else if (this.field == null) {
            this.createField(attrs, text);
        } else {
            Font font = attrs.getValue(this.fontAttr);
            if (font != null) {
                this.field.setFont(font);
            }
            this.field.setLocation(this.fieldX, this.fieldY, this.halign, this.valign);
            this.field.setText(text);
        }
    }
}

