/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.instance;

import com.cburch.logisim.LogisimVersion;
import com.cburch.logisim.comp.AbstractComponentFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.AttributeSets;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.gui.log.LoggableContract;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.InstanceComponent;
import com.cburch.logisim.instance.InstanceLogger;
import com.cburch.logisim.instance.InstanceLoggerAdapter;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstancePoker;
import com.cburch.logisim.instance.InstancePokerAdapter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.instance.Port;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.tools.Pokable;
import com.cburch.logisim.tools.key.KeyConfigurator;
import com.cburch.logisim.util.IconsUtil;
import com.cburch.logisim.util.StringGetter;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.util.UnmodifiableList;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InstanceFactory
extends AbstractComponentFactory {
    static final Logger logger = LoggerFactory.getLogger(InstanceFactory.class);
    private final String name;
    private final StringGetter displayName;
    private StringGetter defaultToolTip;
    private String iconName;
    private Icon icon;
    private Attribute<?>[] attrs;
    private Object[] defaults;
    private AttributeSet defaultSet;
    private Bounds bounds;
    private List<Port> portList;
    private Attribute<Direction> facingAttribute;
    private Boolean shouldSnap;
    private KeyConfigurator keyConfigurator;
    private Class<? extends InstancePoker> pokerClass;
    private Class<? extends InstanceLogger> loggerClass;

    public InstanceFactory(String name) {
        this(name, StringUtil.constantGetter(name));
    }

    public InstanceFactory(String name, HdlGeneratorFactory generator) {
        this(name, StringUtil.constantGetter(name), generator, false, false);
    }

    public InstanceFactory(String name, HdlGeneratorFactory generator, boolean requiresGlobalClock) {
        this(name, StringUtil.constantGetter(name), generator, requiresGlobalClock, false);
    }

    public InstanceFactory(String name, HdlGeneratorFactory generator, boolean requiresLabel, boolean requiresGlobalClock) {
        this(name, StringUtil.constantGetter(name), generator, requiresGlobalClock, requiresGlobalClock);
    }

    public InstanceFactory(String name, StringGetter displayName) {
        this(name, displayName, null, false, false);
    }

    public InstanceFactory(String name, StringGetter displayName, HdlGeneratorFactory generator) {
        this(name, displayName, generator, false, false);
    }

    public InstanceFactory(String name, StringGetter displayName, HdlGeneratorFactory generator, boolean requiresGlobalClock) {
        this(name, displayName, generator, requiresGlobalClock, false);
    }

    public InstanceFactory(String name, StringGetter displayName, HdlGeneratorFactory generator, boolean requiresLabel, boolean requiresGlobalClock) {
        super(generator, requiresLabel, requiresGlobalClock);
        this.name = name;
        this.displayName = displayName;
        this.iconName = null;
        this.icon = null;
        this.attrs = null;
        this.defaults = null;
        this.bounds = Bounds.EMPTY_BOUNDS;
        this.portList = Collections.emptyList();
        this.keyConfigurator = null;
        this.facingAttribute = null;
        this.shouldSnap = Boolean.TRUE;
    }

    protected void configureNewInstance(Instance instance) {
    }

    public boolean contains(Location loc, AttributeSet attrs) {
        Bounds bds = this.getOffsetBounds(attrs);
        if (bds == null) {
            return false;
        }
        return bds.contains(loc, 1);
    }

    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public AttributeSet createAttributeSet() {
        Attribute<?>[] as = this.attrs;
        return as == null ? AttributeSets.EMPTY : AttributeSets.fixedSet(as, this.defaults);
    }

    @Override
    public Component createComponent(Location loc, AttributeSet attrs) {
        InstanceComponent ret = new InstanceComponent(this, loc, attrs);
        this.configureNewInstance(ret.getInstance());
        return ret;
    }

    @Override
    public final void drawGhost(ComponentDrawContext context, Color color, int x, int y, AttributeSet attrs) {
        InstancePainter painter = context.getInstancePainter();
        Graphics gfx = painter.getGraphics();
        gfx.setColor(color);
        gfx.translate(x, y);
        painter.setFactory(this, attrs);
        this.paintGhost(painter);
        gfx.translate(-x, -y);
        if (painter.getFactory() == null) {
            super.drawGhost(context, color, x, y, attrs);
        }
    }

    @Override
    public Object getDefaultAttributeValue(Attribute<?> attr, LogisimVersion ver) {
        Attribute<?>[] as = this.attrs;
        if (as != null) {
            for (int i = 0; i < as.length; ++i) {
                if (as[i] != attr) continue;
                return this.defaults[i];
            }
            return null;
        }
        AttributeSet dfltSet = this.defaultSet;
        if (dfltSet == null) {
            this.defaultSet = dfltSet = this.createAttributeSet();
        }
        return ((AttributeSet)dfltSet.clone()).getValue(attr);
    }

    public StringGetter getDefaultToolTip() {
        return this.defaultToolTip;
    }

    @Override
    public StringGetter getDisplayGetter() {
        return this.displayName;
    }

    @Override
    public String getDisplayName() {
        return this.getDisplayGetter().toString();
    }

    public Attribute<Direction> getFacingAttribute() {
        return this.facingAttribute;
    }

    @Override
    public final Object getFeature(Object key, AttributeSet attrs) {
        if (key == FACING_ATTRIBUTE_KEY) {
            return this.facingAttribute;
        }
        if (key == KeyConfigurator.class) {
            return this.keyConfigurator;
        }
        if (key == SHOULD_SNAP) {
            return this.shouldSnap;
        }
        return super.getFeature(key, attrs);
    }

    protected Object getInstanceFeature(Instance instance, Object key) {
        if (key == Pokable.class && this.pokerClass != null) {
            return new InstancePokerAdapter(instance.getComponent(), this.pokerClass);
        }
        if (key == LoggableContract.class && this.loggerClass != null) {
            return new InstanceLoggerAdapter(instance.getComponent(), this.loggerClass);
        }
        return null;
    }

    public KeyConfigurator getKeyConfigurator() {
        return this.keyConfigurator;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Bounds getOffsetBounds(AttributeSet attrs) {
        if (this.bounds != null) {
            return this.bounds;
        }
        throw new RuntimeException("offset bounds unknown: use setOffsetBounds() or override getOffsetBounds()");
    }

    public List<Port> getPorts() {
        return this.portList;
    }

    protected void instanceAttributeChanged(Instance instance, Attribute<?> attr) {
    }

    private boolean isClassOk(Class<?> sub, Class<?> sup) {
        boolean isSub = sup.isAssignableFrom(sub);
        if (!isSub) {
            logger.error("{}  must be a subclass of {}", (Object)sub.getName(), (Object)sup.getName());
            return false;
        }
        try {
            sub.getConstructor(new Class[0]);
            return true;
        }
        catch (SecurityException e) {
            logger.error("{} needs its no-args constructor to be public", (Object)sub.getName());
        }
        catch (NoSuchMethodException e) {
            logger.error("{} is missing a no-arguments constructor", (Object)sub.getName());
        }
        return true;
    }

    public void paintGhost(InstancePainter painter) {
        painter.setFactory(null, null);
    }

    @Override
    public final void paintIcon(ComponentDrawContext context, int x, int y, AttributeSet attrs) {
        InstancePainter painter = context.getInstancePainter();
        painter.setFactory(this, attrs);
        Graphics gfx = painter.getGraphics();
        gfx.translate(x, y);
        gfx.setColor(new Color(AppPreferences.COMPONENT_ICON_COLOR.get()));
        this.paintIcon(painter);
        gfx.translate(-x, -y);
        if (painter.getFactory() == null) {
            String n;
            Icon i = this.icon;
            if (i == null && (n = this.iconName) != null && (i = IconsUtil.getIcon(n)) == null) {
                n = null;
            }
            if (i != null) {
                i.paintIcon(context.getDestination(), gfx, x + 2, y + 2);
            } else {
                super.paintIcon(context, x, y, attrs);
            }
        }
    }

    public void paintIcon(InstancePainter painter) {
        painter.setFactory(null, null);
    }

    public abstract void paintInstance(InstancePainter var1);

    public abstract void propagate(InstanceState var1);

    public void setAttributes(Attribute<?>[] attrs, Object[] defaults) {
        this.attrs = attrs;
        this.defaults = defaults;
    }

    public void setDefaultToolTip(StringGetter value) {
        this.defaultToolTip = value;
    }

    public void setFacingAttribute(Attribute<Direction> value) {
        this.facingAttribute = value;
    }

    public void setIcon(Icon value) {
        this.iconName = "";
        this.icon = value;
    }

    public void setIconName(String value) {
        this.iconName = value;
        this.icon = null;
    }

    public void setInstanceLogger(Class<? extends InstanceLogger> loggerClass) {
        if (this.isClassOk(loggerClass, InstanceLogger.class)) {
            this.loggerClass = loggerClass;
        }
    }

    public void setInstancePoker(Class<? extends InstancePoker> pokerClass) {
        if (this.isClassOk(pokerClass, InstancePoker.class)) {
            this.pokerClass = pokerClass;
        }
    }

    public void setKeyConfigurator(KeyConfigurator value) {
        this.keyConfigurator = value;
    }

    public void setOffsetBounds(Bounds value) {
        this.bounds = value;
    }

    public void setPorts(List<Port> ports) {
        this.portList = Collections.unmodifiableList(ports);
    }

    public void setPorts(Port[] ports) {
        this.portList = new UnmodifiableList<Port>(ports);
    }

    public void setShouldSnap(boolean value) {
        this.shouldSnap = value;
    }

    public boolean providesSubCircuitMenu() {
        return false;
    }
}

