/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.test;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.data.TestException;
import com.cburch.logisim.data.TestVector;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.LFrame;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.test.Model;
import com.cburch.logisim.gui.test.ModelListener;
import com.cburch.logisim.gui.test.TestPanel;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.util.WindowMenuItemManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TestFrame
extends LFrame.SubWindowWithSimulation {
    private static final long serialVersionUID = 1L;
    private final Map<Circuit, Model> modelMap = new HashMap<Circuit, Model>();
    private final MyListener myListener = new MyListener();
    private final WindowMenuManager windowManager;
    private final JFileChooser chooser = new JFileChooser();
    private final TestPanel panel;
    private final JButton load = new JButton();
    private final JButton run = new JButton();
    private final JButton stop = new JButton();
    private final JButton reset = new JButton();
    private final JButton close = new JButton();
    private final JLabel pass = new JLabel();
    private final JLabel fail = new JLabel();
    private Simulator curSimulator = null;
    private Model curModel;
    private int finished;
    private int count;
    private File curFile;

    public TestFrame(Project project) {
        super(project);
        this.windowManager = new WindowMenuManager();
        project.addProjectListener(this.myListener);
        this.setSimulator(project.getSimulator(), project.getCircuitState().getCircuit());
        this.chooser.addChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
        this.chooser.addChoosableFileFilter(TestVector.FILE_FILTER);
        this.chooser.setFileFilter(TestVector.FILE_FILTER);
        this.panel = new TestPanel(this);
        JPanel statusPanel = new JPanel();
        statusPanel.add(this.pass);
        statusPanel.add(this.fail);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.load);
        buttonPanel.add(this.run);
        buttonPanel.add(this.stop);
        buttonPanel.add(this.reset);
        buttonPanel.add(this.close);
        this.load.addActionListener(this.myListener);
        this.run.addActionListener(this.myListener);
        this.stop.addActionListener(this.myListener);
        this.reset.addActionListener(this.myListener);
        this.close.addActionListener(this.myListener);
        this.run.setEnabled(false);
        this.stop.setEnabled(false);
        this.reset.setEnabled(false);
        Container contents = this.getContentPane();
        this.panel.setPreferredSize(new Dimension(450, 300));
        contents.add((Component)statusPanel, "North");
        contents.add((Component)this.panel, "Center");
        contents.add((Component)buttonPanel, "South");
        LocaleManager.addLocaleListener(this.myListener);
        this.myListener.localeChanged();
        this.pack();
    }

    private static String computeTitle(Model data, Project proj) {
        String name = data == null ? "???" : data.getCircuit().getName();
        return Strings.S.get("testFrameTitle", name, proj.getLogisimFile().getDisplayName());
    }

    Model getModel() {
        return this.curModel;
    }

    private void setSimulator(Simulator value, Circuit circuit) {
        if (value == null == (this.curModel == null) && (value == null || value.getCircuitState().getCircuit() == this.curModel.getCircuit())) {
            return;
        }
        this.menubar.setCircuitState(value, value.getCircuitState());
        if (this.curSimulator != null) {
            this.curSimulator.removeSimulatorListener(this.myListener);
        }
        if (this.curModel != null) {
            this.curModel.setSelected(false);
        }
        if (this.curModel != null) {
            this.curModel.removeModelListener(this.myListener);
        }
        Model oldModel = this.curModel;
        Model data = null;
        if (value != null && (data = this.modelMap.get(value.getCircuitState().getCircuit())) == null) {
            data = new Model(this.project, value.getCircuitState().getCircuit());
            this.modelMap.put(data.getCircuit(), data);
        }
        this.curSimulator = value;
        this.curModel = data;
        if (this.curSimulator != null) {
            this.curSimulator.addSimulatorListener(this.myListener);
        }
        if (this.curModel != null) {
            this.curModel.setSelected(true);
        }
        if (this.curModel != null) {
            this.curModel.addModelListener(this.myListener);
        }
        this.setTitle(TestFrame.computeTitle(this.curModel, this.project));
        if (this.panel != null) {
            this.panel.modelChanged(oldModel, this.curModel);
        }
    }

    @Override
    public void setVisible(boolean value) {
        if (value) {
            this.windowManager.frameOpened(this);
        }
        super.setVisible(value);
    }

    private class MyListener
    implements ActionListener,
    ProjectListener,
    Simulator.Listener,
    LocaleListener,
    ModelListener {
        private MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object src = event.getSource();
            if (src == TestFrame.this.close) {
                TestFrame.this.requestClose();
            } else if (src == TestFrame.this.load) {
                int result = TestFrame.this.chooser.showOpenDialog(TestFrame.this);
                if (result != 0) {
                    return;
                }
                File file = TestFrame.this.chooser.getSelectedFile();
                if (!file.exists() || !file.canRead() || file.isDirectory()) {
                    OptionPane.showMessageDialog(TestFrame.this, Strings.S.get("fileCannotReadMessage", file.getName()), Strings.S.get("fileCannotReadTitle"), 0);
                    return;
                }
                try {
                    TestVector vec = new TestVector(file);
                    TestFrame.this.finished = 0;
                    TestFrame.this.count = vec.data.size();
                    TestFrame.this.getModel().setVector(vec);
                    TestFrame.this.curFile = file;
                    TestFrame.this.getModel().setPaused(true);
                    TestFrame.this.getModel().start();
                }
                catch (IOException e) {
                    OptionPane.showMessageDialog(TestFrame.this, Strings.S.get("fileCannotParseMessage", file.getName(), e.getMessage()), Strings.S.get("fileCannotReadTitle"), 0);
                }
                catch (TestException e) {
                    OptionPane.showMessageDialog(TestFrame.this, Strings.S.get("fileWrongPinsMessage", file.getName(), e.getMessage()), Strings.S.get("fileWrongPinsTitle"), 0);
                }
            } else if (src == TestFrame.this.run) {
                try {
                    TestFrame.this.getModel().start();
                }
                catch (TestException e) {
                    OptionPane.showMessageDialog(TestFrame.this, Strings.S.get("fileWrongPinsMessage", TestFrame.this.curFile.getName(), e.getMessage()), Strings.S.get("fileWrongPinsTitle"), 0);
                }
            } else if (src == TestFrame.this.stop) {
                TestFrame.this.getModel().setPaused(true);
            } else if (src == TestFrame.this.reset) {
                TestFrame.this.getModel().clearResults();
                this.testingChanged();
            }
        }

        @Override
        public void localeChanged() {
            TestFrame.this.setTitle(TestFrame.computeTitle(TestFrame.this.curModel, TestFrame.this.project));
            TestFrame.this.panel.localeChanged();
            TestFrame.this.load.setText(Strings.S.get("loadButton"));
            TestFrame.this.run.setText(Strings.S.get("runButton"));
            TestFrame.this.stop.setText(Strings.S.get("stopButton"));
            TestFrame.this.reset.setText(Strings.S.get("resetButton"));
            TestFrame.this.close.setText(Strings.S.get("closeButton"));
            TestFrame.this.myListener.testResultsChanged(TestFrame.this.getModel().getPass(), TestFrame.this.getModel().getFail());
            TestFrame.this.windowManager.localeChanged();
        }

        @Override
        public void projectChanged(ProjectEvent event) {
            int action = event.getAction();
            if (action == 4) {
                TestFrame.this.setSimulator(event.getProject().getSimulator(), event.getProject().getCircuitState().getCircuit());
            } else if (action == 0) {
                TestFrame.this.setTitle(TestFrame.computeTitle(TestFrame.this.curModel, TestFrame.this.project));
            }
        }

        @Override
        public void testingChanged() {
            if (TestFrame.this.getModel().isRunning() && !TestFrame.this.getModel().isPaused()) {
                TestFrame.this.run.setEnabled(false);
                TestFrame.this.stop.setEnabled(true);
            } else if (TestFrame.this.getModel().getVector() != null && TestFrame.this.finished != TestFrame.this.count) {
                TestFrame.this.run.setEnabled(true);
                TestFrame.this.stop.setEnabled(false);
            } else {
                TestFrame.this.run.setEnabled(false);
                TestFrame.this.stop.setEnabled(false);
            }
            TestFrame.this.reset.setEnabled(TestFrame.this.getModel().getVector() != null && TestFrame.this.finished > 0);
        }

        @Override
        public void testResultsChanged(int numPass, int numFail) {
            TestFrame.this.pass.setText(Strings.S.get("passMessage", Integer.toString(numPass)));
            TestFrame.this.fail.setText(Strings.S.get("failMessage", Integer.toString(numFail)));
            TestFrame.this.finished = numPass + numFail;
        }

        @Override
        public void vectorChanged() {
        }

        @Override
        public void simulatorReset(Simulator.Event e) {
        }

        @Override
        public void propagationCompleted(Simulator.Event e) {
        }

        @Override
        public void simulatorStateChanged(Simulator.Event e) {
        }
    }

    private class WindowMenuManager
    extends WindowMenuItemManager
    implements LocaleListener,
    ProjectListener {
        WindowMenuManager() {
            super(Strings.S.get("logFrameMenuItem"), false);
            TestFrame.this.project.addProjectListener(this);
        }

        @Override
        public JFrame getJFrame(boolean create, Component parent) {
            return TestFrame.this;
        }

        @Override
        public void localeChanged() {
            String title = TestFrame.this.project.getLogisimFile().getDisplayName();
            this.setText(Strings.S.get("testFrameMenuItem", title));
        }

        @Override
        public void projectChanged(ProjectEvent event) {
            if (event.getAction() == 0) {
                this.localeChanged();
            }
        }
    }
}

