/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.start;

import com.cburch.logisim.generated.BuildInfo;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.LineBuffer;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

class AboutCredits
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final int MILLIS_PER_RASTER = 20;
    private static final String HENDRIX_LOGO_PATH = "resources/logisim/hendrix.png";
    private final Lines lines;
    private long startMillis = 0L;

    public AboutCredits(int width, int height) {
        String jvm = LineBuffer.format("{{1}} v{{2}} ({{3}})", System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("java.vendor"));
        System.out.println(Strings.S.get("appVersionJvm", jvm));
        this.lines = new Lines();
        this.lines.title("Logisim-evolution v4.0.0").h2(String.format("Copyright \u00a9 2001-%s %s developers", "2025", "Logisim-evolution")).url("https://github.com/logisim-evolution/").space().h1(Strings.S.get("creditsDevelopedBy")).text("Moshe Berman").text("Theldo Cruz Franqueira").text("Zhao Hanyuan").text("David H. Hutchens").text("Theo Kluter").text("Torsten Maehne").text("Tom Niget").text("Marcin Or\u0142owski").text("Kevin Walsh").text("Liu Yuchen").tiny(Strings.S.get("creditsDevelopedByAndOthers")).space().h1(Strings.S.get("creditsRoleFork")).text("Berner Fachhochschule | Haute \u00e9cole sp\u00e9cialis\u00e9e bernoise").url("https://www.bfh.ch/").text("College of the Holy Cross").url("https://www.holycross.edu").text("Haute \u00c9cole d'Ing\u00e9nierie et de Gestion du Canton de Vaud").url("https://www.heig-vd.ch/").text("Haute \u00e9cole du paysage, d'ing\u00e9nierie").text("et d'architecture de Gen\u00e8ve").url("https://hepia.hesge.ch").space().h1(Strings.S.get("creditsRoleOriginal")).text("Carl Burch").text("Hendrix College").url("http://www.cburch.com/logisim/").img(this.getClass().getClassLoader().getResource(HENDRIX_LOGO_PATH)).space().space().h1(Strings.S.get("creditsBuildInfo")).text(Strings.S.get("creditsCompiled", "2025-12-09T03:36:58+0000")).text("(Not built from Git repo)").space().text(BuildInfo.jvm_version).text(BuildInfo.jvm_vendor);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (AppPreferences.AntiAliassing.getBoolean()) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (this.startMillis == 0L) {
            this.startMillis = System.currentTimeMillis();
            this.lines.initialize(this.getGraphics(), this.getWidth(), this.getHeight());
        }
        int height = this.getHeight();
        int maxOffsetY = this.lines.totalScrollLinesHeight + height;
        int offsetY = (int)(System.currentTimeMillis() - this.startMillis) / 20 % maxOffsetY;
        int yPos = offsetY - height;
        for (CreditsLine line : this.lines) {
            int y = line.startY - yPos;
            if (y < -line.displayHeight && y > height + line.displayHeight) continue;
            Class<?> cls = line.getClass();
            if (cls.equals(ImgLine.class)) {
                g.drawImage(line.img.getImage(), line.x, y, this);
                continue;
            }
            if (!cls.equals(TextLine.class)) continue;
            ((Graphics2D)g).setPaint(line.paint);
            g.setFont(line.font);
            g.drawString(line.text, line.x, y);
        }
    }

    private class Lines
    extends ArrayList<CreditsLine> {
        private static final int SPACE_HEIGHT = 20;
        private boolean initialized = false;
        private int totalScrollLinesHeight = 0;

        private Lines() {
        }

        public void initialize(Graphics g, int displayWidth, int displayHeight) {
            if (this.initialized) {
                return;
            }
            for (CreditsLine line : AboutCredits.this.lines) {
                line.init(g, displayWidth, displayHeight, this.totalScrollLinesHeight);
                this.totalScrollLinesHeight += line.displayHeight;
            }
            this.initialized = true;
        }

        public Lines space() {
            this.add(new SpaceLine());
            return this;
        }

        public Lines title(String text) {
            this.add(new TextLine(new Font("Sans Serif", 3, 30), new Color(0, 128, 0), text));
            return this;
        }

        public Lines h1(String text) {
            this.add(new TextLine(new Font("Sans Serif", 3, 24), new Color(143, 0, 0), text));
            return this;
        }

        public Lines h2(String text) {
            this.add(new TextLine(new Font("Sans Serif", 1, 20), new Color(105, 0, 0), text));
            return this;
        }

        public Lines url(String text) {
            this.add(new TextLine(new Font("Sans Serif", 1, 18), new Color(204, 128, 0), text));
            return this;
        }

        public Lines text(String text) {
            this.add(new TextLine(new Font("Sans Serif", 1, 20), new Color(48, 0, 96), text));
            return this;
        }

        public Lines tiny(String text) {
            this.add(new TextLine(new Font("Sans Serif", 0, 16), new Color(48, 0, 96), text));
            return this;
        }

        public Lines img(URL url) {
            this.add(new ImgLine(url));
            return this;
        }
    }

    private static abstract class CreditsLine {
        protected String text = null;
        protected ImageIcon img = null;
        protected int displayWidth = 0;
        protected int displayHeight = 0;
        protected int startY = 0;
        protected int x = 0;
        protected Graphics g = null;
        protected Color color = null;
        protected GradientPaint paint = null;
        protected Font font = null;
        protected FontMetrics fm = null;

        private CreditsLine() {
        }

        public void center(int displayAreaWidth) {
            this.x = displayAreaWidth - this.displayWidth >> 1;
        }

        public void init(Graphics g, int displayAreaWidth, int displayAreaHeight, int currentY) {
            this.g = g;
            if (this.font != null) {
                this.fm = g.getFontMetrics(this.font);
            }
            if (this.color != null) {
                int alpha = displayAreaHeight / 4;
                Color derrived = new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue(), alpha);
                this.paint = new GradientPaint(0.0f, 0.0f, derrived, 0.0f, alpha, this.color);
            }
        }
    }

    private static class ImgLine
    extends CreditsLine
    implements ImageObserver {
        public ImgLine(URL url) {
            this.img = new ImageIcon(url);
            this.displayHeight = this.img.getIconHeight();
            this.displayWidth = this.img.getIconWidth();
        }

        @Override
        public boolean imageUpdate(Image image, int i, int i1, int i2, int i3, int i4) {
            return false;
        }

        @Override
        public void init(Graphics g, int displayAreaWidth, int displayAreaHeight, int currentY) {
            super.init(g, displayAreaWidth, displayAreaHeight, currentY);
            int padding = 20;
            this.displayHeight = this.img.getIconHeight();
            this.displayWidth = this.img.getIconWidth();
            this.startY = currentY + 10;
            this.center(displayAreaWidth);
        }
    }

    private static class TextLine
    extends CreditsLine {
        public TextLine(Font font, Color color, String text) {
            this.font = font;
            this.color = color;
            this.text = text;
        }

        @Override
        public void init(Graphics g, int displayAreaWidth, int displayAreaHeight, int currentY) {
            super.init(g, displayAreaWidth, displayAreaHeight, currentY);
            this.displayWidth = this.fm.stringWidth(this.text);
            this.displayHeight = this.fm.getHeight();
            this.startY = currentY + this.displayHeight;
            this.center(displayAreaWidth);
        }
    }

    private static class SpaceLine
    extends CreditsLine {
        public SpaceLine() {
            this.displayHeight = 20;
        }
    }
}

