/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.start;

import com.cburch.logisim.Main;
import com.cburch.logisim.generated.BuildInfo;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.start.AboutCredits;
import com.cburch.logisim.util.LineBuffer;
import com.cburch.logisim.util.UniquelyNamedThread;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class About {
    static final int PADDING = 20;
    static final int PANEL_WIDTH = 600;
    static final int LOGO_HEIGHT = 200;
    static final int SCROLLER_HEIGHT = 200;
    private static final String LOGO_IMG = "resources/logisim/img/logisim-evolution-logo.png";

    private About() {
    }

    public static AboutPanel getImagePanel() {
        return new AboutPanel();
    }

    public static void showAboutDialog(JFrame owner) {
        if (!Main.hasGui()) {
            return;
        }
        JPanel content = new JPanel(new BorderLayout());
        content.add(new AboutPanel(true));
        content.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
        JDialog dialog = new JDialog(owner, Strings.S.get("aboutDialogTitle"), true);
        JOptionPane optionPane = new JOptionPane(content, -1);
        JButton copyDetailsButton = new JButton(Strings.S.get("aboutDialogCopyDetails"));
        copyDetailsButton.addActionListener(event -> {
            StringBuilder info = new StringBuilder();
            info.append("Product: Logisim-evolution v4.0.0").append("\n").append(LineBuffer.format("Runs on: {{1}} v{{2}}\n", System.getProperty("java.vm.name"), System.getProperty("java.version"))).append("\n").append(LineBuffer.format("Compiled: {{1}}\n", "2025-12-09T03:36:58+0000")).append(LineBuffer.format("Build ID: {{1}}\n", "(Not built from Git repo)")).append(LineBuffer.format("Built on: {{1}}\n", BuildInfo.jvm_version));
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(info.toString());
            clipboard.setContents(stringSelection, null);
        });
        JButton closeButton = new JButton(Strings.S.get("aboutDialogClose"));
        closeButton.addActionListener(e -> dialog.dispose());
        optionPane.setOptions(new JButton[]{copyDetailsButton, closeButton});
        dialog.setContentPane(optionPane);
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
    }

    private static class AboutPanel
    extends JPanel
    implements AncestorListener {
        private static final long serialVersionUID = 1L;
        private AboutCredits credits = null;
        private PanelThread thread = null;

        public AboutPanel() {
            this(false);
        }

        public AboutPanel(boolean includeCredits) {
            this.setLayout(null);
            int prefWidth = 640;
            int prefHeight = 240;
            if (includeCredits) {
                prefHeight += 200;
            }
            this.setPreferredSize(new Dimension(640, prefHeight));
            this.setBackground(Color.WHITE);
            this.addAncestorListener(this);
            JLabel logo = new JLabel(new ImageIcon(this.getClass().getClassLoader().getResource(About.LOGO_IMG)));
            logo.setBounds(0, 20, 640, 200);
            this.add(logo);
            if (includeCredits) {
                this.credits = new AboutCredits(600, 200);
                this.credits.setBounds(0, prefHeight / 2, 640, 200);
                this.add(this.credits);
            }
        }

        @Override
        public void ancestorAdded(AncestorEvent arg0) {
            if (this.credits != null) {
                if (this.thread == null) {
                    this.thread = new PanelThread(this);
                }
                this.thread.start();
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent arg0) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent arg0) {
            if (this.thread != null) {
                this.thread.running = false;
            }
        }
    }

    private static class PanelThread
    extends UniquelyNamedThread {
        private final AboutPanel panel;
        private boolean running = true;

        PanelThread(AboutPanel panel) {
            super("About-PanelThread");
            this.panel = panel;
        }

        @Override
        public void run() {
            while (this.running) {
                this.panel.repaint();
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

