/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.Simulator;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.menu.AssemblyWindow;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.menu.Menu;
import com.cburch.logisim.gui.menu.MenuItemCheckImpl;
import com.cburch.logisim.gui.menu.MenuItemImpl;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.prefs.PrefMonitorKeyStroke;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.vhdl.sim.VhdlSimulatorTop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MenuSimulate
extends Menu {
    public static final Double[] SUPPORTED_TICK_FREQUENCIES = new Double[]{2048000.0, 1024000.0, 512000.0, 256000.0, 128000.0, 64000.0, 32000.0, 16000.0, 8000.0, 4000.0, 2000.0, 1000.0, 512.0, 256.0, 128.0, 64.0, 32.0, 16.0, 8.0, 4.0, 2.0, 1.0, 0.5, 0.25};
    private final LogisimMenuBar menubar;
    private final MyListener myListener = new MyListener();
    private final MenuItemCheckImpl runToggle;
    private final JMenuItem reset = new JMenuItem();
    private final MenuItemImpl step;
    private final MenuItemImpl vhdlSimFiles;
    private final MenuItemCheckImpl simulateVhdlEnable;
    private final MenuItemCheckImpl ticksEnabled;
    private final MenuItemImpl tickHalf;
    private final MenuItemImpl tickFull;
    private final JMenu tickFreq = new JMenu();
    private final TickFrequencyChoice[] tickFreqs = new TickFrequencyChoice[SUPPORTED_TICK_FREQUENCIES.length];
    private final JMenu downStateMenu = new JMenu();
    private final ArrayList<CircuitStateMenuItem> downStateItems = new ArrayList();
    private final JMenu upStateMenu = new JMenu();
    private final ArrayList<CircuitStateMenuItem> upStateItems = new ArrayList();
    private final JMenuItem log = new JMenuItem();
    private final JMenuItem test = new JMenuItem();
    private final JMenuItem assemblyWindow = new JMenuItem();
    AssemblyWindow assWin = null;
    private CircuitState currentState = null;
    private CircuitState bottomState = null;
    private Simulator currentSim = null;
    private final int menuMask;

    public MenuSimulate(LogisimMenuBar menubar) {
        this.menubar = menubar;
        this.runToggle = new MenuItemCheckImpl(this, LogisimMenuBar.SIMULATE_RUN_TOGGLE);
        this.step = new MenuItemImpl(this, LogisimMenuBar.SIMULATE_STEP);
        this.simulateVhdlEnable = new MenuItemCheckImpl(this, LogisimMenuBar.SIMULATE_VHDL_ENABLE);
        this.vhdlSimFiles = new MenuItemImpl(this, LogisimMenuBar.GENERATE_VHDL_SIM_FILES);
        this.ticksEnabled = new MenuItemCheckImpl(this, LogisimMenuBar.TICK_ENABLE);
        this.tickHalf = new MenuItemImpl(this, LogisimMenuBar.TICK_HALF);
        this.tickFull = new MenuItemImpl(this, LogisimMenuBar.TICK_FULL);
        menubar.registerItem(LogisimMenuBar.SIMULATE_RUN_TOGGLE, this.runToggle);
        menubar.registerItem(LogisimMenuBar.SIMULATE_STEP, this.step);
        menubar.registerItem(LogisimMenuBar.SIMULATE_VHDL_ENABLE, this.simulateVhdlEnable);
        menubar.registerItem(LogisimMenuBar.GENERATE_VHDL_SIM_FILES, this.vhdlSimFiles);
        menubar.registerItem(LogisimMenuBar.TICK_ENABLE, this.ticksEnabled);
        menubar.registerItem(LogisimMenuBar.TICK_HALF, this.tickHalf);
        menubar.registerItem(LogisimMenuBar.TICK_FULL, this.tickFull);
        this.menuMask = this.getToolkit().getMenuShortcutKeyMaskEx();
        this.runToggle.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_SIM_AUTO_PROPAGATE).getWithMask(0));
        this.reset.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_SIM_RESET).getWithMask(0));
        this.step.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_SIM_STEP).getWithMask(0));
        this.tickHalf.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_SIM_TICK_HALF).getWithMask(0));
        this.tickFull.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_SIM_TICK_FULL).getWithMask(0));
        this.ticksEnabled.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_SIM_TICK_ENABLED).getWithMask(0));
        AppPreferences.gui_sync_objects.add(this);
        ButtonGroup bgroup = new ButtonGroup();
        for (int i = 0; i < SUPPORTED_TICK_FREQUENCIES.length; ++i) {
            this.tickFreqs[i] = new TickFrequencyChoice(SUPPORTED_TICK_FREQUENCIES[i]);
            bgroup.add(this.tickFreqs[i]);
            this.tickFreq.add(this.tickFreqs[i]);
        }
        this.add(this.runToggle);
        this.add(this.step);
        this.add(this.reset);
        this.add(this.simulateVhdlEnable);
        this.add(this.vhdlSimFiles);
        this.addSeparator();
        this.add(this.upStateMenu);
        this.add(this.downStateMenu);
        this.addSeparator();
        this.add(this.tickHalf);
        this.add(this.tickFull);
        this.add(this.ticksEnabled);
        this.add(this.tickFreq);
        this.addSeparator();
        this.add(this.log);
        this.add(this.test);
        this.addSeparator();
        this.add(this.assemblyWindow);
        this.setEnabled(false);
        this.runToggle.setEnabled(false);
        this.reset.setEnabled(false);
        this.step.setEnabled(false);
        this.simulateVhdlEnable.setEnabled(false);
        this.vhdlSimFiles.setEnabled(false);
        this.upStateMenu.setEnabled(false);
        this.downStateMenu.setEnabled(false);
        this.tickHalf.setEnabled(false);
        this.tickFull.setEnabled(false);
        this.ticksEnabled.setEnabled(false);
        this.tickFreq.setEnabled(false);
        this.runToggle.addChangeListener(this.myListener);
        menubar.addActionListener(LogisimMenuBar.SIMULATE_RUN_TOGGLE, this.myListener);
        menubar.addActionListener(LogisimMenuBar.SIMULATE_STEP, this.myListener);
        menubar.addActionListener(LogisimMenuBar.SIMULATE_VHDL_ENABLE, this.myListener);
        menubar.addActionListener(LogisimMenuBar.GENERATE_VHDL_SIM_FILES, this.myListener);
        menubar.addActionListener(LogisimMenuBar.TICK_ENABLE, this.myListener);
        menubar.addActionListener(LogisimMenuBar.TICK_HALF, this.myListener);
        menubar.addActionListener(LogisimMenuBar.TICK_FULL, this.myListener);
        this.reset.addActionListener(this.myListener);
        this.log.addActionListener(this.myListener);
        this.test.addActionListener(this.myListener);
        this.assemblyWindow.addActionListener(this.myListener);
        this.computeEnabled();
    }

    @Override
    public void hotkeyUpdate() {
        this.runToggle.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_SIM_AUTO_PROPAGATE).getWithMask(0));
        this.reset.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_SIM_RESET).getWithMask(0));
        this.step.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_SIM_STEP).getWithMask(0));
        this.tickHalf.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_SIM_TICK_HALF).getWithMask(0));
        this.tickFull.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_SIM_TICK_FULL).getWithMask(0));
        this.ticksEnabled.setAccelerator(((PrefMonitorKeyStroke)AppPreferences.HOTKEY_SIM_TICK_ENABLED).getWithMask(0));
    }

    public static List<String> getTickFrequencyStrings() {
        ArrayList<String> result = new ArrayList<String>();
        for (Double supportedTickFrequency : SUPPORTED_TICK_FREQUENCIES) {
            if (supportedTickFrequency < 1000.0) {
                boolean small = Math.abs(supportedTickFrequency - (double)Math.round(supportedTickFrequency)) < 1.0E-4;
                String freqHz = "" + (small ? (double)((int)Math.round(supportedTickFrequency)) : supportedTickFrequency);
                result.add(Strings.S.get("simulateTickFreqItem", freqHz));
                continue;
            }
            double kf = (double)Math.round(supportedTickFrequency / 100.0) / 10.0;
            String freqKhz = "" + (kf == (double)Math.round(kf) ? (double)((int)kf) : kf);
            result.add(Strings.S.get("simulateTickKFreqItem", freqKhz));
        }
        return result;
    }

    private void clearItems(ArrayList<CircuitStateMenuItem> items) {
        for (CircuitStateMenuItem item : items) {
            item.unregister();
        }
        items.clear();
    }

    @Override
    protected void computeEnabled() {
        boolean present = this.currentState != null;
        this.setEnabled(present);
        this.runToggle.setEnabled(present);
        this.reset.setEnabled(present);
        this.step.setEnabled(present);
        this.simulateVhdlEnable.setEnabled(present);
        this.vhdlSimFiles.setEnabled(present);
        this.upStateMenu.setEnabled(present);
        this.downStateMenu.setEnabled(present);
        this.tickHalf.setEnabled(present);
        this.tickFull.setEnabled(present);
        this.ticksEnabled.setEnabled(present);
        this.tickFreq.setEnabled(present);
        this.menubar.fireEnableChanged();
    }

    public void localeChanged() {
        this.setText(Strings.S.get("simulateMenu"));
        this.runToggle.setText(Strings.S.get("simulateRunItem"));
        this.reset.setText(Strings.S.get("simulateResetItem"));
        this.step.setText(Strings.S.get("simulateStepItem"));
        this.simulateVhdlEnable.setText(Strings.S.get("simulateVhdlEnableItem"));
        this.vhdlSimFiles.setText(Strings.S.get("simulateGenVhdlFilesItem"));
        this.tickHalf.setText(Strings.S.get("simulateTickHalfItem"));
        this.tickFull.setText(Strings.S.get("simulateTickFullItem"));
        this.ticksEnabled.setText(Strings.S.get("simulateTickItem"));
        this.tickFreq.setText(Strings.S.get("simulateTickFreqMenu"));
        for (TickFrequencyChoice freq : this.tickFreqs) {
            freq.localeChanged();
        }
        this.downStateMenu.setText(Strings.S.get("simulateDownStateMenu"));
        this.upStateMenu.setText(Strings.S.get("simulateUpStateMenu"));
        this.log.setText(Strings.S.get("simulateLogItem"));
        this.test.setText(Strings.S.get("simulateTestItem"));
        this.assemblyWindow.setText(Strings.S.get("simulateAssemblyViewer"));
    }

    private void recreateStateMenu(JMenu menu, List<CircuitStateMenuItem> items, int code) {
        menu.removeAll();
        menu.setEnabled(!items.isEmpty());
        boolean first = true;
        int mask = this.getToolkit().getMenuShortcutKeyMaskEx();
        for (int i = items.size() - 1; i >= 0; --i) {
            CircuitStateMenuItem item = items.get(i);
            menu.add(item);
            if (first) {
                item.setAccelerator(KeyStroke.getKeyStroke(code, mask));
                first = false;
                continue;
            }
            item.setAccelerator(null);
        }
    }

    private void recreateStateMenus() {
        this.recreateStateMenu(this.downStateMenu, this.downStateItems, 39);
        this.recreateStateMenu(this.upStateMenu, this.upStateItems, 37);
    }

    public void setCurrentState(Simulator sim, CircuitState value) {
        CircuitState cur;
        boolean present;
        if (this.currentState == value) {
            return;
        }
        Simulator oldSim = this.currentSim;
        CircuitState oldState = this.currentState;
        this.currentSim = sim;
        this.currentState = value;
        if (this.bottomState == null) {
            this.bottomState = this.currentState;
        } else if (this.currentState == null) {
            this.bottomState = null;
        } else {
            CircuitState cur2;
            for (cur2 = this.bottomState; cur2 != null && cur2 != this.currentState; cur2 = cur2.getParentState()) {
            }
            if (cur2 == null) {
                this.bottomState = this.currentState;
            }
        }
        boolean oldPresent = oldState != null;
        boolean bl = present = this.currentState != null;
        if (oldPresent != present) {
            this.computeEnabled();
        }
        if (this.currentSim != oldSim) {
            double freq = this.currentSim == null ? 1.0 : this.currentSim.getTickFrequency();
            for (TickFrequencyChoice tickFrequencyChoice : this.tickFreqs) {
                tickFrequencyChoice.setSelected(Math.abs(tickFrequencyChoice.freq - freq) < 0.001);
            }
            if (oldSim != null) {
                oldSim.removeSimulatorListener(this.myListener);
            }
            if (this.currentSim != null) {
                this.currentSim.addSimulatorListener(this.myListener);
            }
            this.myListener.simulatorStateChanged(new Simulator.Event(sim, false, false, false));
        }
        this.clearItems(this.downStateItems);
        for (cur = this.bottomState; cur != null && cur != this.currentState; cur = cur.getParentState()) {
            this.downStateItems.add(new CircuitStateMenuItem(cur));
        }
        if (cur != null) {
            cur = cur.getParentState();
        }
        this.clearItems(this.upStateItems);
        while (cur != null) {
            this.upStateItems.add(0, new CircuitStateMenuItem(cur));
            cur = cur.getParentState();
        }
        this.recreateStateMenus();
    }

    private class MyListener
    implements ActionListener,
    Simulator.StatusListener,
    ChangeListener {
        private MyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            Project proj = MenuSimulate.this.menubar.getSimulationProject();
            if (proj == null) {
                return;
            }
            VhdlSimulatorTop vhdl = proj.getVhdlSimulator();
            if (vhdl != null && (src == MenuSimulate.this.simulateVhdlEnable || src == LogisimMenuBar.SIMULATE_VHDL_ENABLE)) {
                vhdl.setEnabled(!vhdl.isEnabled());
            } else if (vhdl != null && (src == MenuSimulate.this.vhdlSimFiles || src == LogisimMenuBar.GENERATE_VHDL_SIM_FILES)) {
                vhdl.restart();
            } else if (src == MenuSimulate.this.log) {
                proj.getLogFrame().setVisible(true);
            } else if (src == MenuSimulate.this.test) {
                proj.getTestFrame().setVisible(true);
            }
            Simulator sim = proj.getSimulator();
            if (sim == null) {
                return;
            }
            if (src == LogisimMenuBar.SIMULATE_STOP) {
                sim.setAutoPropagation(false);
                proj.repaintCanvas();
            } else if (src == LogisimMenuBar.SIMULATE_RUN) {
                sim.setAutoPropagation(true);
                proj.repaintCanvas();
            } else if (src == MenuSimulate.this.runToggle || src == LogisimMenuBar.SIMULATE_RUN_TOGGLE) {
                sim.setAutoPropagation(!sim.isAutoPropagating());
                proj.repaintCanvas();
            } else if (src == MenuSimulate.this.reset) {
                if (vhdl != null && vhdl.isRunning()) {
                    vhdl.reset();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                sim.reset();
                proj.repaintCanvas();
            } else if (src == MenuSimulate.this.step || src == LogisimMenuBar.SIMULATE_STEP) {
                sim.setAutoPropagation(false);
                sim.step();
            } else if (src == MenuSimulate.this.tickHalf || src == LogisimMenuBar.TICK_HALF) {
                sim.tick(1);
            } else if (src == MenuSimulate.this.tickFull || src == LogisimMenuBar.TICK_FULL) {
                sim.tick(2);
            } else if (src == MenuSimulate.this.ticksEnabled || src == LogisimMenuBar.TICK_ENABLE) {
                sim.setAutoTicking(!sim.isAutoTicking());
            } else if (src == MenuSimulate.this.assemblyWindow) {
                if (MenuSimulate.this.assWin == null || !MenuSimulate.this.assWin.isVisible()) {
                    MenuSimulate.this.assWin = new AssemblyWindow(proj);
                    MenuSimulate.this.assWin.setVisible(true);
                } else {
                    MenuSimulate.this.assWin.toFront();
                }
            }
        }

        @Override
        public void simulatorReset(Simulator.Event e) {
            this.updateSimulator(e);
        }

        @Override
        public void simulatorStateChanged(Simulator.Event e) {
            this.updateSimulator(e);
        }

        void updateSimulator(Simulator.Event e) {
            Simulator sim = e.getSource();
            if (sim != MenuSimulate.this.currentSim) {
                return;
            }
            MenuSimulate.this.computeEnabled();
            MenuSimulate.this.runToggle.setSelected(sim.isAutoPropagating());
            MenuSimulate.this.ticksEnabled.setSelected(sim.isAutoTicking());
            double freq = sim.getTickFrequency();
            for (TickFrequencyChoice item : MenuSimulate.this.tickFreqs) {
                item.setSelected(freq == item.freq);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
        }
    }

    private class TickFrequencyChoice
    extends JRadioButtonMenuItem
    implements ActionListener {
        private final double freq;

        public TickFrequencyChoice(double value) {
            this.freq = value;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MenuSimulate.this.currentSim != null) {
                MenuSimulate.this.currentSim.setTickFrequency(this.freq);
            }
        }

        public void localeChanged() {
            double f = this.freq;
            if (f < 1000.0) {
                boolean small = Math.abs(f - (double)Math.round(f)) < 1.0E-4;
                String freqHz = "" + (small ? (double)((int)Math.round(f)) : f);
                this.setText(Strings.S.get("simulateTickFreqItem", freqHz));
            } else {
                double kf = (double)Math.round(f / 100.0) / 10.0;
                String freqKhz = "" + (kf == (double)Math.round(kf) ? (double)((int)kf) : kf);
                this.setText(Strings.S.get("simulateTickKFreqItem", freqKhz));
            }
        }
    }

    private class CircuitStateMenuItem
    extends JMenuItem
    implements CircuitListener,
    ActionListener {
        private final CircuitState circuitState;

        public CircuitStateMenuItem(CircuitState circuitState) {
            this.circuitState = circuitState;
            Circuit circuit = circuitState.getCircuit();
            circuit.addCircuitListener(this);
            this.setText(circuit.getName());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuSimulate.this.menubar.fireStateChanged(MenuSimulate.this.currentSim, this.circuitState);
        }

        @Override
        public void circuitChanged(CircuitEvent event) {
            if (event.getAction() == 0) {
                this.setText(this.circuitState.getCircuit().getName());
            }
        }

        void unregister() {
            this.circuitState.getCircuit().removeCircuitListener(this);
        }
    }
}

