/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.menu;

import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.LFrame;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.gui.start.About;
import com.cburch.logisim.util.MacCompatibility;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

class MenuHelp
extends JMenu
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final LogisimMenuBar menubar;
    private final JMenuItem tutorial = new JMenuItem();
    private final JMenuItem guide = new JMenuItem();
    private final JMenuItem library = new JMenuItem();
    private final JMenuItem about = new JMenuItem();
    private final JMenuItem www = new JMenuItem();
    private HelpSet helpSet;
    private String helpSetUrl = "";
    private JHelp helpComponent;
    private LFrame helpFrame;

    public MenuHelp(LogisimMenuBar menubar) {
        this.menubar = menubar;
        this.tutorial.addActionListener(this);
        this.guide.addActionListener(this);
        this.library.addActionListener(this);
        this.about.addActionListener(this);
        this.www.addActionListener(this);
        this.add(this.tutorial);
        this.add(this.guide);
        this.add(this.library);
        if (this.browserIntegrationSupported()) {
            this.addSeparator();
            this.add(this.www);
        }
        if (!MacCompatibility.isAboutAutomaticallyPresent()) {
            this.addSeparator();
            this.add(this.about);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (this.guide.equals(src)) {
            this.showHelp("guide");
        } else if (this.tutorial.equals(src)) {
            this.showHelp("tutorial");
        } else if (this.library.equals(src)) {
            this.showHelp("libs");
        } else if (this.about.equals(src)) {
            About.showAboutDialog(this.menubar.getParentFrame());
        } else if (this.www.equals(src)) {
            this.openProjectWebsite();
        }
    }

    private void disableHelp() {
        this.guide.setEnabled(false);
        this.tutorial.setEnabled(false);
        this.library.setEnabled(false);
        this.www.setEnabled(false);
    }

    private void loadBroker() {
        String helpUrl = Strings.S.get("helpsetUrl");
        if (helpUrl == null) {
            helpUrl = "doc/doc_en.hs";
        }
        if (this.helpSet == null || this.helpFrame == null || !helpUrl.equals(this.helpSetUrl)) {
            ClassLoader loader = MenuHelp.class.getClassLoader();
            try {
                URL hsUrl = HelpSet.findHelpSet(loader, helpUrl);
                if (hsUrl == null) {
                    this.disableHelp();
                    OptionPane.showMessageDialog(this.menubar.getParentFrame(), Strings.S.get("helpNotFoundError"));
                    return;
                }
                this.helpSetUrl = helpUrl;
                this.helpSet = new HelpSet(null, hsUrl);
                this.helpComponent = new JHelp(this.helpSet);
                if (this.helpFrame == null) {
                    this.helpFrame = new LFrame.Dialog(null);
                    this.helpFrame.setTitle(Strings.S.get("helpWindowTitle"));
                    this.helpFrame.getContentPane().add(this.helpComponent);
                    this.helpFrame.setPreferredSize(new Dimension((int)Toolkit.getDefaultToolkit().getScreenSize().getWidth() >> 1, (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() >> 1));
                    this.helpFrame.pack();
                } else {
                    this.helpFrame.getContentPane().removeAll();
                    this.helpFrame.getContentPane().add(this.helpComponent);
                    this.helpComponent.revalidate();
                }
            }
            catch (Exception e) {
                this.disableHelp();
                e.printStackTrace();
                OptionPane.showMessageDialog(this.menubar.getParentFrame(), Strings.S.get("helpUnavailableError"));
            }
        }
    }

    private boolean browserIntegrationSupported() {
        return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
    }

    public void openProjectWebsite() {
        if (!this.browserIntegrationSupported()) {
            return;
        }
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(new URI("https://github.com/logisim-evolution/"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void localeChanged() {
        this.setText(Strings.S.get("helpMenu"));
        if (this.helpFrame != null) {
            this.helpFrame.setTitle(Strings.S.get("helpWindowTitle"));
        }
        this.tutorial.setText(Strings.S.get("helpTutorialItem"));
        this.guide.setText(Strings.S.get("helpGuideItem"));
        this.library.setText(Strings.S.get("helpLibraryItem"));
        this.about.setText(Strings.S.get("helpAboutItem"));
        this.www.setText(Strings.S.get("helpProjectWebsite"));
        if (this.helpFrame != null) {
            this.helpFrame.setLocale(Locale.getDefault());
            this.loadBroker();
        }
    }

    private void showHelp(String target) {
        this.loadBroker();
        try {
            this.helpComponent.setCurrentID(target);
            this.helpFrame.toFront();
            this.helpFrame.setVisible(true);
        }
        catch (Exception e) {
            this.disableHelp();
            e.printStackTrace();
            OptionPane.showMessageDialog(this.menubar.getParentFrame(), Strings.S.get("helpDisplayError"));
        }
    }
}

