/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitAttributes;
import com.cburch.logisim.circuit.CircuitMutator;
import com.cburch.logisim.circuit.CircuitTransaction;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Action;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.FactoryAttributes;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.tools.key.KeyConfigurationEvent;
import com.cburch.logisim.tools.key.KeyConfigurationResult;
import com.cburch.logisim.vhdl.base.VhdlEntity;
import java.util.HashMap;
import java.util.Map;

public class ToolAttributeAction
extends Action {
    private final KeyConfigurationResult config;
    private Map<Attribute<?>, Object> oldValues;

    private ToolAttributeAction(KeyConfigurationResult config) {
        this.config = config;
        this.oldValues = new HashMap(2);
    }

    public static Action create(KeyConfigurationResult results) {
        return new ToolAttributeAction(results);
    }

    public static Action create(Tool tool, Attribute<?> attr, Object value) {
        AttributeSet attrs = tool.getAttributeSet();
        KeyConfigurationEvent e = new KeyConfigurationEvent(0, attrs, null, null);
        KeyConfigurationResult r = new KeyConfigurationResult(e, attr, value);
        return new ToolAttributeAction(r);
    }

    @Override
    public String getName() {
        return Strings.S.get("changeToolAttrAction");
    }

    @Override
    public void doIt(Project proj) {
        if (this.affectsAppearance()) {
            ActionTransaction xn = new ActionTransaction(true);
            xn.execute();
        } else {
            this.execute(true);
        }
    }

    @Override
    public void undo(Project proj) {
        if (this.affectsAppearance()) {
            ActionTransaction xn = new ActionTransaction(true);
            xn.execute();
        } else {
            this.execute(false);
        }
    }

    boolean affectsAppearance() {
        block2: {
            ComponentFactory factory;
            block3: {
                AttributeSet attrs = this.config.getEvent().getAttributeSet();
                if (!(attrs instanceof FactoryAttributes)) break block2;
                FactoryAttributes factoryAttributes = (FactoryAttributes)attrs;
                factory = factoryAttributes.getFactory();
                if (!(factory instanceof SubcircuitFactory)) break block3;
                for (Attribute<?> attr : this.config.getAttributeValues().keySet()) {
                    if (attr != CircuitAttributes.APPEARANCE_ATTR) continue;
                    return true;
                }
                break block2;
            }
            if (!(factory instanceof VhdlEntity)) break block2;
            for (Attribute<?> attr : this.config.getAttributeValues().keySet()) {
                if (attr != StdAttr.APPEARANCE) continue;
                return true;
            }
        }
        return false;
    }

    private void execute(boolean forward) {
        if (forward) {
            AttributeSet attrs = this.config.getEvent().getAttributeSet();
            Map<Attribute<?>, Object> newValues = this.config.getAttributeValues();
            HashMap oldValues = new HashMap(newValues.size());
            for (Map.Entry<Attribute<?>, Object> entry : newValues.entrySet()) {
                Attribute<?> attr = entry.getKey();
                oldValues.put(attr, attrs.getValue(attr));
                attrs.setValue(attr, entry.getValue());
            }
            this.oldValues = oldValues;
        } else {
            AttributeSet attrs = this.config.getEvent().getAttributeSet();
            Map<Attribute<?>, Object> oldValues = this.oldValues;
            for (Map.Entry<Attribute<?>, Object> entry : oldValues.entrySet()) {
                Attribute<?> attr = entry.getKey();
                attrs.setValue(attr, entry.getValue());
            }
        }
    }

    private class ActionTransaction
    extends CircuitTransaction {
        private final boolean forward;

        ActionTransaction(boolean forward) {
            this.forward = forward;
        }

        @Override
        protected Map<Circuit, Integer> getAccessedCircuits() {
            HashMap<Circuit, Integer> accessMap;
            block2: {
                ComponentFactory factory;
                block3: {
                    accessMap = new HashMap<Circuit, Integer>();
                    AttributeSet attrs = ToolAttributeAction.this.config.getEvent().getAttributeSet();
                    if (!(attrs instanceof FactoryAttributes)) break block2;
                    FactoryAttributes factoryAttributes = (FactoryAttributes)attrs;
                    factory = factoryAttributes.getFactory();
                    if (!(factory instanceof SubcircuitFactory)) break block3;
                    SubcircuitFactory sub = (SubcircuitFactory)factory;
                    Circuit circuit = sub.getSubcircuit();
                    for (Circuit supercirc : circuit.getCircuitsUsingThis()) {
                        accessMap.put(supercirc, READ_WRITE);
                    }
                    break block2;
                }
                if (!(factory instanceof VhdlEntity)) break block2;
                VhdlEntity vhdl = (VhdlEntity)factory;
                for (Circuit supercirc : vhdl.getCircuitsUsingThis()) {
                    accessMap.put(supercirc, READ_WRITE);
                }
            }
            return accessMap;
        }

        @Override
        protected void run(CircuitMutator mutator) {
            ToolAttributeAction.this.execute(this.forward);
        }
    }
}

