/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.gui.main.SimulationTreeCircuitNode;
import com.cburch.logisim.gui.main.SimulationTreeModel;
import com.cburch.logisim.gui.main.SimulationTreeNode;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.TreeNode;

class SimulationTreeTopNode
extends SimulationTreeNode {
    public SimulationTreeTopNode(SimulationTreeModel model, List<CircuitState> allRootStates) {
        super(model, null);
        for (CircuitState state : allRootStates) {
            this.children.add(new SimulationTreeCircuitNode(model, null, state, null));
        }
    }

    public void updateSimulationList(List<CircuitState> allRootStates) {
        boolean changed = false;
        HashMap<CircuitState, TreeNode> old = new HashMap<CircuitState, TreeNode>();
        HashMap<CircuitState, Integer> oldPos = new HashMap<CircuitState, Integer>();
        int i = 0;
        for (TreeNode node : this.children) {
            CircuitState state = ((SimulationTreeCircuitNode)node).getCircuitState();
            old.put(state, node);
            oldPos.put(state, i++);
        }
        this.children.clear();
        i = 0;
        for (CircuitState state : allRootStates) {
            TreeNode node = (TreeNode)old.get(state);
            if (node == null) {
                changed = true;
                node = new SimulationTreeCircuitNode(this.model, null, state, null);
            } else if ((Integer)oldPos.get(state) != i++) {
                changed = true;
            }
            this.children.add(node);
        }
        if (changed) {
            this.model.fireStructureChanged(this);
        }
    }

    public String toString() {
        return "Active Simulations";
    }
}

