/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.proj.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JList;

class CircuitJList
extends JList {
    private static final long serialVersionUID = 1L;

    public CircuitJList(Project proj, boolean includeEmpty) {
        LogisimFile file = proj.getLogisimFile();
        Circuit current = proj.getCurrentCircuit();
        Vector<Circuit> options = new Vector<Circuit>();
        boolean currentFound = false;
        for (Circuit circ : file.getCircuits()) {
            if (includeEmpty && circ.getBounds() == Bounds.EMPTY_BOUNDS) continue;
            if (circ == current) {
                currentFound = true;
            }
            options.add(circ);
        }
        this.setListData(options);
        if (currentFound) {
            this.setSelectedValue(current, true);
        }
        this.setVisibleRowCount(Math.min(6, options.size()));
    }

    public List<Circuit> getSelectedCircuits() {
        Object[] selected = this.getSelectedValuesList().toArray();
        if (selected.length > 0) {
            ArrayList<Circuit> ret = new ArrayList<Circuit>(selected.length);
            for (Object sel : selected) {
                if (!(sel instanceof Circuit)) continue;
                Circuit circ = (Circuit)sel;
                ret.add(circ);
            }
            return ret;
        }
        return Collections.emptyList();
    }
}

