/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.AttrTableSetException;
import com.cburch.logisim.gui.generic.AttributeSetTableModel;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.tools.SetAttributeAction;
import java.util.List;

class AttrTableComponentModel
extends AttributeSetTableModel {
    final Project proj;
    final Circuit circ;
    final Component comp;

    AttrTableComponentModel(Project proj, Circuit circ, Component comp) {
        super(comp.getAttributeSet());
        this.proj = proj;
        this.circ = circ;
        this.comp = comp;
        this.setInstance(comp.getFactory());
    }

    public Circuit getCircuit() {
        return this.circ;
    }

    public Component getComponent() {
        return this.comp;
    }

    @Override
    public String getTitle() {
        String label = this.comp.getAttributeSet().getValue(StdAttr.LABEL);
        Location loc = this.comp.getLocation();
        Object s = this.comp.getFactory().getDisplayName();
        if (label != null && label.length() > 0) {
            s = (String)s + " \"" + label + "\"";
        } else if (loc != null) {
            s = (String)s + " " + String.valueOf(loc);
        }
        return s;
    }

    @Override
    public void setValueRequested(Attribute<Object> attr, Object value) throws AttrTableSetException {
        List<Attribute<?>> mayBeChangedList;
        if (!this.proj.getLogisimFile().contains(this.circ)) {
            String msg = Strings.S.get("cannotModifyCircuitError");
            throw new AttrTableSetException(msg);
        }
        SetAttributeAction act = new SetAttributeAction(this.circ, Strings.S.getter("changeAttributeAction"));
        AttributeSet compAttrSet = this.comp.getAttributeSet();
        if (compAttrSet != null && (mayBeChangedList = compAttrSet.attributesMayAlsoBeChanged(attr, value)) != null) {
            for (Attribute<?> mayChangeAttr : mayBeChangedList) {
                act.set(this.comp, mayChangeAttr, compAttrSet.getValue(mayChangeAttr));
            }
        }
        act.set(this.comp, attr, value);
        this.proj.doAction(act);
    }
}

