/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.log;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.RadixOption;
import com.cburch.logisim.circuit.ReplacementMap;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.ComponentDrawContext;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeListener;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.data.Value;
import com.cburch.logisim.gui.log.LoggableContract;
import com.cburch.logisim.instance.StdAttr;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.swing.Icon;

public class SignalInfo
implements AttributeListener,
CircuitListener,
Location.At {
    private final int n;
    private final com.cburch.logisim.comp.Component[] path;
    private final Circuit[] circ;
    private final Object option;
    private RadixOption radix = RadixOption.RADIX_2;
    private String nickname;
    private String fullname;
    private int width = -1;
    private boolean obsoleted;
    private Listener listener;
    public final Icon icon = new Icon(){

        @Override
        public int getIconHeight() {
            return 20;
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            SignalInfo.paintIcon(SignalInfo.this.path[SignalInfo.this.n - 1], SignalInfo.this.option, c, g, x, y);
        }
    };

    public SignalInfo(Circuit root, com.cburch.logisim.comp.Component[] p, Object o) {
        this.path = p;
        this.option = o;
        this.n = this.path.length;
        this.circ = new Circuit[this.n];
        this.circ[0] = root;
        for (int i = 1; i < this.n; ++i) {
            SubcircuitFactory f = (SubcircuitFactory)this.path[i - 1].getFactory();
            this.circ[i] = f.getSubcircuit();
        }
        this.computeName();
        for (Circuit t : this.circ) {
            t.addCircuitListener(this);
        }
        for (com.cburch.logisim.comp.Component c : this.path) {
            c.getAttributeSet().addAttributeListener(this);
        }
    }

    public void setListener(Listener l) {
        if (this.listener != null && l != null && l != this.listener) {
            throw new IllegalStateException("already have a different listener");
        }
        this.listener = l;
    }

    @Override
    public void attributeValueChanged(AttributeEvent e) {
        this.recomputeName();
    }

    @Override
    public void circuitChanged(CircuitEvent event) {
        if (this.obsoleted) {
            return;
        }
        int action = event.getAction();
        if (action == 5) {
            this.remove();
        } else if (action == 6) {
            boolean changed = false;
            for (int i = 0; i < this.n; ++i) {
                Circuit t = this.circ[i];
                com.cburch.logisim.comp.Component c = this.path[i];
                ReplacementMap repl = event.getResult().getReplacementMap(t);
                if (repl.isEmpty() || !repl.getRemovals().contains(c)) continue;
                com.cburch.logisim.comp.Component componentNew = null;
                Collection<com.cburch.logisim.comp.Component> newComps = repl.getReplacementsFor(c);
                for (com.cburch.logisim.comp.Component c2 : newComps) {
                    if (c2 != c && c2.getFactory() != c.getFactory()) continue;
                    componentNew = c2;
                    break;
                }
                if (componentNew == c) continue;
                if (componentNew != null) {
                    SubcircuitFactory factory;
                    changed = true;
                    this.path[i].getAttributeSet().removeAttributeListener(this);
                    this.path[i] = componentNew;
                    this.path[i].getAttributeSet().addAttributeListener(this);
                    if (i >= this.n - 1 || this.circ[i + 1] == (factory = (SubcircuitFactory)this.path[i].getFactory()).getSubcircuit()) continue;
                    System.out.println("**** failure: subcircuit changed!");
                    this.remove();
                    return;
                }
                this.remove();
                return;
            }
            if (changed) {
                this.computeName();
                if (this.listener != null) {
                    this.listener.signalInfoNameChanged(this);
                }
            }
        } else if (action == 4) {
            this.recomputeName();
        }
    }

    private static String normalize(String s, Object o) {
        return s == null || s.equals("") ? null : (o == null ? s : s + "." + String.valueOf(o));
    }

    private static String logName(com.cburch.logisim.comp.Component c, Object option) {
        String s = null;
        LoggableContract log = (LoggableContract)c.getFeature(LoggableContract.class);
        if (log != null) {
            s = SignalInfo.normalize(log.getLogName(option), null);
        }
        if (s == null) {
            s = SignalInfo.normalize(c.getAttributeSet().getValue(StdAttr.LABEL), option);
        }
        if (s == null) {
            s = SignalInfo.normalize(c.getFactory().getDisplayName() + String.valueOf(c.getLocation()), option);
        }
        return s;
    }

    private boolean recomputeName() {
        if (this.computeName()) {
            if (this.listener != null) {
                this.listener.signalInfoNameChanged(this);
            }
            return true;
        }
        return false;
    }

    private boolean computeName() {
        String f;
        String s;
        int w;
        boolean changed = false;
        LoggableContract log = (LoggableContract)this.path[this.n - 1].getFeature(LoggableContract.class);
        BitWidth bw = null;
        if (log != null) {
            bw = log.getBitWidth(this.option);
        }
        if (bw == null) {
            bw = this.path[this.n - 1].getAttributeSet().getValue(StdAttr.WIDTH);
        }
        if ((w = bw.getWidth()) != this.width) {
            changed = true;
            this.width = w;
        }
        if (!(s = SignalInfo.logName(this.path[this.n - 1], this.option)).equals(this.nickname)) {
            changed = true;
            this.nickname = s;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.n - 1; ++i) {
            buf.append(SignalInfo.logName(this.path[i], null)).append("/");
        }
        buf.append(this.nickname);
        if (this.width > 1) {
            buf.append("[").append(this.width - 1).append("..0]");
        }
        if (!(f = buf.toString()).equals(this.fullname)) {
            changed = true;
            this.fullname = f;
        }
        return changed;
    }

    public Value fetchValue(CircuitState root) {
        LoggableContract log = (LoggableContract)this.path[this.n - 1].getFeature(LoggableContract.class);
        if (log == null) {
            return Value.NIL;
        }
        CircuitState cur = root;
        for (int i = 0; i < this.n - 1; ++i) {
            cur = this.circ[i].getSubcircuitFactory().getSubstate(cur, this.path[i]);
        }
        return log.getLogValue(cur, this.option);
    }

    public com.cburch.logisim.comp.Component getComponent() {
        return this.path[this.n - 1];
    }

    public Circuit getTopLevelCircuit() {
        return this.circ[0];
    }

    public int getDepth() {
        return this.n;
    }

    public boolean isInput(Object option) {
        LoggableContract log = (LoggableContract)this.path[this.n - 1].getFeature(LoggableContract.class);
        return log != null && log.isInput(option);
    }

    public RadixOption getRadix() {
        return this.radix;
    }

    public String format(Value v) {
        return this.radix.toString(v);
    }

    public boolean setRadix(RadixOption value) {
        if (value == this.radix) {
            return false;
        }
        this.radix = value;
        return true;
    }

    public String getShortName() {
        return this.nickname;
    }

    public String toString() {
        return this.fullname;
    }

    public String getDisplayName() {
        return this.fullname;
    }

    @Override
    public Location getLocation() {
        return this.path[this.n - 1].getLocation();
    }

    public int getWidth() {
        return this.width;
    }

    public Object getOption() {
        return this.option;
    }

    public static void paintIcon(com.cburch.logisim.comp.Component comp, Object opt, Component c, Graphics g, int x, int y) {
        if (comp == null) {
            return;
        }
        if (opt != null) {
            g.setColor(Color.MAGENTA);
            g.fillRect(x + 3, x + 3, 15, 15);
        } else {
            Graphics g2 = g.create();
            ComponentDrawContext context = new ComponentDrawContext(c, null, null, g, g2);
            comp.getFactory().paintIcon(context, x, y, comp.getAttributeSet());
            g2.dispose();
        }
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof SignalInfo)) {
            return false;
        }
        SignalInfo o = (SignalInfo)other;
        return Arrays.equals(this.path, o.path) && Objects.equals(this.option, o.option);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.path), this.option);
    }

    private void remove() {
        if (this.obsoleted) {
            return;
        }
        this.obsoleted = true;
        for (Circuit t : this.circ) {
            t.removeCircuitListener(this);
        }
        for (com.cburch.logisim.comp.Component c : this.path) {
            c.getAttributeSet().removeAttributeListener(this);
        }
        if (this.listener != null) {
            this.listener.signalInfoObsoleted(this);
        }
    }

    public static interface Listener {
        public void signalInfoNameChanged(SignalInfo var1);

        public void signalInfoObsoleted(SignalInfo var1);
    }

    public static class List
    extends ArrayList<SignalInfo>
    implements Transferable {
        public static final DataFlavor dataFlavor;
        public static final DataFlavor[] dataFlavors;

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return dataFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return dataFlavor.equals(flavor);
        }

        static {
            DataFlavor f = null;
            try {
                f = new DataFlavor(String.format("%s;class=\"%s\"", "application/x-java-jvm-local-objectref", List.class.getName()));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            dataFlavor = f;
            dataFlavors = new DataFlavor[]{dataFlavor};
        }
    }
}

