/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.log;

import com.cburch.logisim.data.Direction;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.icons.FatArrowIcon;
import com.cburch.logisim.gui.log.ComponentSelector;
import com.cburch.logisim.gui.log.LogFrame;
import com.cburch.logisim.gui.log.LogPanel;
import com.cburch.logisim.gui.log.Model;
import com.cburch.logisim.gui.log.SelectionList;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.JDialogOk;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

public class SelectionPanel
extends LogPanel {
    private static final long serialVersionUID = 1L;
    private final ComponentSelector selector = new ComponentSelector(this.getModel().getCircuit(), 1);
    private final SelectionList list = new SelectionList();
    private final JLabel selectDesc;
    private final JLabel exploreLabel;
    private final JLabel listLabel;

    public SelectionPanel(LogFrame window) {
        super(window);
        this.list.setLogModel(this.getModel());
        JScrollPane explorerPane = new JScrollPane(this.selector, 22, 30);
        JScrollPane listPane = new JScrollPane(this.list, 22, 30);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gridbag);
        gbc.fill = 2;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(15, 10, 0, 10);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        this.selectDesc = new JLabel();
        gridbag.setConstraints(this.selectDesc, gbc);
        this.add(this.selectDesc);
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 1;
        this.exploreLabel = new JLabel();
        gridbag.setConstraints(this.exploreLabel, gbc);
        this.add(this.exploreLabel);
        gbc.gridx = 2;
        gbc.gridy = 1;
        this.listLabel = new JLabel();
        gridbag.setConstraints(this.listLabel, gbc);
        this.add(this.listLabel);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gridbag.setConstraints(explorerPane, gbc);
        this.add(explorerPane);
        explorerPane.setPreferredSize(new Dimension(120, 200));
        JButton addArrow = new JButton(new FatArrowIcon(Direction.EAST));
        JButton delArrow = new JButton(new FatArrowIcon(Direction.WEST));
        addArrow.setBorder(BorderFactory.createEmptyBorder());
        delArrow.setBorder(BorderFactory.createEmptyBorder());
        addArrow.setContentAreaFilled(false);
        delArrow.setContentAreaFilled(false);
        addArrow.setEnabled(false);
        delArrow.setEnabled(false);
        this.selector.getSelectionModel().addListSelectionListener(e -> addArrow.setEnabled(!this.selector.getSelectionModel().isSelectionEmpty()));
        this.list.getSelectionModel().addListSelectionListener(e -> delArrow.setEnabled(!this.list.getSelectionModel().isSelectionEmpty()));
        addArrow.addActionListener(e -> this.list.add(this.selector.getSelectedItems()));
        delArrow.addActionListener(e -> this.list.removeSelected());
        Box arrowBox = new Box(1);
        arrowBox.add(addArrow);
        arrowBox.add(delArrow);
        gbc.fill = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.gridx = 1;
        gbc.gridy = 2;
        gridbag.setConstraints(arrowBox, gbc);
        this.add(arrowBox);
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(10, 10, 10, 10);
        gbc.gridx = 2;
        gbc.gridy = 2;
        gridbag.setConstraints(listPane, gbc);
        this.add(listPane);
        listPane.setPreferredSize(new Dimension(AppPreferences.getScaled(180), AppPreferences.getScaled(200)));
    }

    @Override
    public String getHelpText() {
        return Strings.S.get("selectionHelp");
    }

    @Override
    public String getTitle() {
        return Strings.S.get("selectionTab");
    }

    @Override
    public void localeChanged() {
        this.selectDesc.setText(Strings.S.get("selectionDesc"));
        this.exploreLabel.setText(Strings.S.get("exploreLabel"));
        this.listLabel.setText(Strings.S.get("listLabel"));
        this.selector.localeChanged();
        this.list.localeChanged();
    }

    @Override
    public void modelChanged(Model oldModel, Model newModel) {
        this.selector.setRootCircuit(newModel.getCircuit());
        this.list.setLogModel(newModel);
    }

    public static void doDialog(LogFrame logFrame) {
        SelectionDialog d = new SelectionDialog(logFrame);
        d.setVisible(true);
    }

    static class SelectionDialog
    extends JDialogOk {
        private static final long serialVersionUID = 1L;
        final SelectionPanel selPanel;

        SelectionDialog(LogFrame logFrame) {
            super("Signal Selection", false);
            this.selPanel = new SelectionPanel(logFrame);
            this.selPanel.localeChanged();
            this.getContentPane().add(this.selPanel);
            this.setMinimumSize(new Dimension(350, 300));
            this.setSize(400, 400);
            this.pack();
        }

        @Override
        public void cancelClicked() {
            this.okClicked();
        }

        @Override
        public void okClicked() {
        }
    }
}

