/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.log;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.gui.log.LoggableContract;
import com.cburch.logisim.gui.log.SignalInfo;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.wiring.Clock;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.util.CollectionUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class ComponentSelector
extends JTable {
    private static final long serialVersionUID = 1L;
    static final Comparator<com.cburch.logisim.comp.Component> compareComponents = (a, b) -> {
        String nameB;
        String nameA = a.getFactory().getDisplayName();
        int ret = nameA.compareToIgnoreCase(nameB = b.getFactory().getDisplayName());
        if (ret != 0) {
            return ret;
        }
        return a.getLocation().toString().compareTo(b.getLocation().toString());
    };
    static final Comparator<Object> compareNames = (a, b) -> a.toString().compareToIgnoreCase(b.toString());
    private Circuit rootCircuit;
    private final TableTreeModel tableModel = new TableTreeModel();
    private final int mode;
    public static final int ANY_SIGNAL = 1;
    public static final int OBSERVEABLE_CLOCKS = 2;
    public static final int DRIVEABLE_CLOCKS = 3;
    public static final int ACTUAL_CLOCKS = 4;

    public ComponentSelector(Circuit circ, int mode) {
        this.mode = mode;
        this.setRootCircuit(circ);
        this.setModel(this.tableModel);
        this.setDefaultRenderer(TreeNode.class, new TreeNodeRenderer());
        if (mode == 1) {
            this.setSelectionMode(2);
        } else {
            this.setSelectionMode(0);
        }
        this.getTableHeader().setUI(null);
        this.setRowHeight(24);
        this.setShowGrid(false);
        this.setFillsViewportHeight(true);
        this.setDragEnabled(true);
        this.setDropMode(DropMode.ON_OR_INSERT);
        this.setTransferHandler(new ComponentTransferHandler());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = ComponentSelector.this.rowAtPoint(e.getPoint());
                int col = ComponentSelector.this.columnAtPoint(e.getPoint());
                if (row < 0 || col < 0) {
                    return;
                }
                ComponentSelector.this.tableModel.toggleExpand(row);
            }
        });
    }

    public SignalInfo.List getSelectedItems() {
        int[] sel;
        SignalInfo.List items = new SignalInfo.List();
        for (int i : sel = this.getSelectedRows()) {
            TreeNode<?> node = this.tableModel.rows.get(i);
            SignalInfo item = this.makeSignalInfo(node);
            if (item == null) continue;
            items.add(item);
        }
        return items.size() > 0 ? items : null;
    }

    private SignalInfo makeSignalInfo(TreeNode<?> node) {
        ComponentNode n = null;
        Object opt = null;
        if (node instanceof OptionNode) {
            OptionNode optNode = (OptionNode)node;
            n = (ComponentNode)optNode.parent;
            opt = optNode.option;
        } else if (node instanceof ComponentNode) {
            ComponentNode compNode;
            n = compNode = (ComponentNode)node;
            if (n.children.size() > 0) {
                return null;
            }
        } else {
            return null;
        }
        int count = 0;
        CircuitNode cur = (CircuitNode)n.parent;
        while (cur != null) {
            ++count;
            cur = (CircuitNode)cur.parent;
        }
        com.cburch.logisim.comp.Component[] paths = new com.cburch.logisim.comp.Component[count];
        paths[paths.length - 1] = n.comp;
        CircuitNode cur2 = (CircuitNode)n.parent;
        for (int j = paths.length - 2; j >= 0; --j) {
            paths[j] = cur2.comp;
            cur2 = (CircuitNode)cur2.parent;
        }
        return new SignalInfo(this.rootCircuit, paths, opt);
    }

    public void localeChanged() {
        this.repaint();
    }

    public void setRootCircuit(Circuit circ) {
        if (this.rootCircuit == circ) {
            return;
        }
        this.rootCircuit = circ;
        if (this.rootCircuit == null) {
            this.tableModel.setRoot(null);
            return;
        }
        this.tableModel.setRoot(new CircuitNode(null, this.rootCircuit, null));
    }

    private void enumerate(ArrayList<SignalInfo> result, TreeNode<?> node) {
        for (TreeNode<?> child : node.children) {
            SignalInfo item = this.makeSignalInfo(child);
            if (item != null) {
                result.add(item);
            }
            this.enumerate(result, child);
        }
    }

    public static ArrayList<SignalInfo> findClocks(Circuit circ) {
        ComponentSelector sel = new ComponentSelector(circ, 4);
        ArrayList<SignalInfo> clocks = new ArrayList<SignalInfo>();
        sel.enumerate(clocks, sel.tableModel.root);
        if (clocks.size() > 0) {
            return clocks;
        }
        sel = new ComponentSelector(circ, 2);
        sel.enumerate(clocks, sel.tableModel.root);
        if (clocks.size() > 0) {
            clocks.clear();
        } else {
            clocks = null;
        }
        return clocks;
    }

    static class TableTreeModel
    extends AbstractTableModel {
        TreeNode<CircuitNode> root;
        final ArrayList<TreeNode<?>> rows = new ArrayList();

        TableTreeModel() {
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.rows.get(row);
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return TreeNode.class;
        }

        @Override
        public String getColumnName(int column) {
            return "";
        }

        void toggleExpand(int row) {
            if (row < 0 || row >= this.rows.size()) {
                return;
            }
            TreeNode<?> o = this.rows.get(row);
            int n = o.children.size();
            if (n == 0) {
                return;
            }
            if (o.expanded) {
                for (int i = 0; i < n; ++i) {
                    this.removeAll(row + 1);
                }
                o.expanded = false;
            } else {
                for (int i = n - 1; i >= 0; --i) {
                    this.insertAll(row + 1, o.children.get(i));
                }
                o.expanded = true;
            }
            super.fireTableDataChanged();
        }

        void removeAll(int row) {
            TreeNode<?> item = this.rows.remove(row);
            if (item.expanded) {
                int n = item.children.size();
                for (int i = 0; i < n; ++i) {
                    this.removeAll(row);
                }
            }
        }

        void insertAll(int row, TreeNode<?> item) {
            this.rows.add(row, item);
            if (item.expanded) {
                int n = item.children.size();
                for (int i = n - 1; i >= 0; --i) {
                    this.insertAll(row + 1, item.children.get(i));
                }
            }
        }

        @Override
        public void fireTableDataChanged() {
            this.setRoot(this.root);
        }

        void setRoot(TreeNode<CircuitNode> r) {
            this.root = r;
            this.rows.clear();
            int n = this.root == null ? 0 : this.root.children.size();
            for (int i = n - 1; i >= 0; --i) {
                this.insertAll(0, this.root.children.get(i));
            }
            super.fireTableDataChanged();
        }
    }

    private static class TreeNode<P extends TreeNode<?>> {
        final P parent;
        final int depth;
        boolean expanded;
        ArrayList<TreeNode<?>> children = new ArrayList();

        TreeNode(P p) {
            this.parent = p;
            this.depth = this.parent == null ? 0 : ((TreeNode)this.parent).depth + 1;
        }

        void addChild(TreeNode<?> child) {
            this.children.add(child);
        }
    }

    private class TreeNodeRenderer
    extends DefaultTableCellRenderer
    implements Icon {
        private TreeNode<?> node;

        private TreeNodeRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component ret;
            if (value instanceof CircuitNode) {
                isSelected = false;
            }
            if ((ret = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JLabel && value instanceof TreeNode) {
                this.node = (TreeNode)value;
                ((JLabel)ret).setIcon(this);
            }
            return ret;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }

        @Override
        public int getIconWidth() {
            return 10 * (this.node.depth - 1) + (this.needsTriangle() ? 40 : 20);
        }

        boolean needsTriangle() {
            return this.node instanceof CircuitNode || this.node instanceof ComponentNode && this.node.children.size() > 0;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int[] yp;
            int[] xp;
            com.cburch.logisim.comp.Component comp;
            g.setColor(Color.GRAY);
            for (int i = 1; i < this.node.depth; ++i) {
                g.drawLine(x + 5, 0, x + 5, 20);
                x += 10;
            }
            Object opt = null;
            TreeNode<?> treeNode = this.node;
            if (treeNode instanceof ComponentNode) {
                ComponentNode compNode = (ComponentNode)treeNode;
                comp = compNode.comp;
            } else {
                treeNode = this.node;
                if (treeNode instanceof CircuitNode) {
                    CircuitNode circNode = (CircuitNode)treeNode;
                    comp = circNode.comp;
                } else {
                    treeNode = this.node;
                    if (treeNode instanceof OptionNode) {
                        OptionNode optNode = (OptionNode)treeNode;
                        comp = ((ComponentNode)optNode.parent).comp;
                        opt = optNode.option;
                    } else {
                        return;
                    }
                }
            }
            SignalInfo.paintIcon(comp, opt, c, g, this.needsTriangle() ? x + 10 : x, y);
            if (!this.needsTriangle()) {
                return;
            }
            if (this.node.expanded) {
                xp = new int[]{x + 0, x + 10, x + 5};
                yp = new int[]{y + 9, y + 9, y + 14};
            } else {
                xp = new int[]{x + 3, x + 3, x + 8};
                yp = new int[]{y + 5, y + 15, y + 10};
            }
            g.setColor(new Color(51, 102, 255));
            g.fillPolygon(xp, yp, 3);
            g.setColor(Color.BLACK);
            g.drawPolygon(xp, yp, 3);
        }
    }

    static class ComponentTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;
        boolean sending;

        ComponentTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return !this.sending && support.isDataFlavorSupported(SignalInfo.List.dataFlavor);
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            this.sending = true;
            ComponentSelector tree = (ComponentSelector)c;
            SignalInfo.List items = tree.getSelectedItems();
            return CollectionUtil.isNullOrEmpty(items) ? null : items;
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            this.sending = false;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            this.sending = false;
            return false;
        }
    }

    private class OptionNode
    extends TreeNode<ComponentNode> {
        private final Object option;

        public OptionNode(ComponentSelector componentSelector, ComponentNode p, Object o) {
            super(p);
            this.option = o;
        }

        public String toString() {
            return this.option.toString();
        }
    }

    private class ComponentNode
    extends TreeNode<CircuitNode> {
        final com.cburch.logisim.comp.Component comp;

        public ComponentNode(ComponentSelector componentSelector, CircuitNode p, com.cburch.logisim.comp.Component c) {
            super(p);
            this.comp = c;
            LoggableContract log = (LoggableContract)this.comp.getFeature(LoggableContract.class);
            if (log == null) {
                return;
            }
            Object[] opts = log.getLogOptions();
            if (opts == null) {
                return;
            }
            for (Object opt : opts) {
                this.addChild(new OptionNode(componentSelector, this, opt));
            }
        }

        public String toString() {
            String ret;
            LoggableContract log = (LoggableContract)this.comp.getFeature(LoggableContract.class);
            if (log != null && (ret = log.getLogName(null)) != null && !ret.equals("")) {
                return ret;
            }
            return this.comp.getFactory().getDisplayName() + " " + String.valueOf(this.comp.getLocation());
        }
    }

    private class CircuitNode
    extends TreeNode<CircuitNode>
    implements CircuitListener {
        final Circuit circ;
        final com.cburch.logisim.comp.Component comp;

        public CircuitNode(CircuitNode p, Circuit t, com.cburch.logisim.comp.Component c) {
            super(p);
            this.circ = t;
            this.comp = c;
            this.circ.addCircuitListener(this);
            this.computeChildren();
        }

        @Override
        public void circuitChanged(CircuitEvent event) {
            int action = event.getAction();
            if (action == 0 || this.computeChildren() || action == 4) {
                ComponentSelector.this.tableModel.fireTableDataChanged();
            }
        }

        private ComponentNode findChildFor(com.cburch.logisim.comp.Component c) {
            for (TreeNode o : this.children) {
                if (!(o instanceof ComponentNode)) continue;
                ComponentNode child = (ComponentNode)o;
                if (child.comp != c) continue;
                return child;
            }
            return null;
        }

        private CircuitNode findChildFor(Circuit c) {
            for (TreeNode o : this.children) {
                if (!(o instanceof CircuitNode)) continue;
                CircuitNode child = (CircuitNode)o;
                if (child.circ != c) continue;
                return child;
            }
            return null;
        }

        private boolean computeChildren() {
            ArrayList<Object> newChildren = new ArrayList<Object>();
            ArrayList<com.cburch.logisim.comp.Component> subcircs = new ArrayList<com.cburch.logisim.comp.Component>();
            boolean changed = false;
            for (com.cburch.logisim.comp.Component c : this.circ.getNonWires()) {
                if (c.getFactory() instanceof SubcircuitFactory && ComponentSelector.this.mode != 3) {
                    subcircs.add(c);
                    continue;
                }
                LoggableContract log = (LoggableContract)c.getFeature(LoggableContract.class);
                if (log == null) continue;
                BitWidth bitWidth = log.getBitWidth(null);
                if (bitWidth == null) {
                    bitWidth = c.getAttributeSet().getValue(StdAttr.WIDTH);
                }
                int w = bitWidth.getWidth();
                if (ComponentSelector.this.mode != 1 && w != 1 || (ComponentSelector.this.mode != 3 ? ComponentSelector.this.mode == 4 && !(c.getFactory() instanceof Clock) : !(c.getFactory() instanceof Pin) || !log.isInput(null))) continue;
                ComponentNode toAdd = this.findChildFor(c);
                if (toAdd == null) {
                    toAdd = new ComponentNode(ComponentSelector.this, this, c);
                    changed = true;
                }
                newChildren.add(toAdd);
            }
            newChildren.sort(compareNames);
            subcircs.sort(compareComponents);
            for (com.cburch.logisim.comp.Component c : subcircs) {
                SubcircuitFactory factory = (SubcircuitFactory)c.getFactory();
                Circuit subCircuit = factory.getSubcircuit();
                CircuitNode toAdd = this.findChildFor(subCircuit);
                if (toAdd == null) {
                    changed = true;
                    toAdd = new CircuitNode(this, subCircuit, c);
                }
                newChildren.add(toAdd);
            }
            boolean bl = changed = changed || !this.children.equals(newChildren);
            if (changed) {
                this.children = newChildren;
            }
            return changed;
        }

        public String toString() {
            String label;
            if (this.comp != null && (label = this.comp.getAttributeSet().getValue(StdAttr.LABEL)) != null && !label.equals("")) {
                return label;
            }
            Object ret = this.circ.getName();
            if (this.comp != null) {
                ret = (String)ret + String.valueOf(this.comp.getLocation());
            }
            return ret;
        }
    }
}

