/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.hex;

import com.cburch.logisim.Main;
import com.cburch.logisim.file.Loader;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.hex.BufferedLineReader;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.memory.Mem;
import com.cburch.logisim.std.memory.MemContents;
import com.cburch.logisim.util.JDialogOk;
import com.cburch.logisim.util.JFileChoosers;
import com.cburch.logisim.util.OutputStreamBinarySanitizer;
import com.cburch.logisim.util.OutputStreamEscaper;
import com.cburch.logisim.util.TextLineNumber;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexFile {
    static final int MAX_PREVIEW_SIZE = 10240;
    private static final Logger logger = LoggerFactory.getLogger(HexFile.class);
    private static final String autoFormat = "Any data file (auto-detects format)";
    protected static final String[] formatDescriptions = new String[]{"v3.0 hex words addressed", "v3.0 hex words plain", "v3.0 hex bytes addressed big-endian", "v3.0 hex bytes addressed little-endian", "v3.0 hex bytes plain big-endian", "v3.0 hex bytes plain little-endian", "v2.0 raw (run-length-endcoded hex words)", "Binary data big-endian", "Binary data little-endian", "ASCII bytes, with escapes, big-endian", "ASCII bytes, with escapes, little-endian"};

    private HexFile() {
    }

    public static void open(MemContents dst, Frame parent, Project proj, Instance instance) {
        Mem mem = instance == null ? null : (Mem)instance.getFactory();
        File recent = HexFile.getRecent(proj, mem, instance);
        JFileChooser chooser = HexFile.createFileOpenChooser(recent);
        chooser.setDialogTitle(Strings.S.get("ramLoadDialogTitle"));
        int choice = chooser.showOpenDialog(parent);
        if (choice == 0) {
            File f = chooser.getSelectedFile();
            try {
                HexFile.open(dst, f);
                mem.setCurrentImage(instance, f);
            }
            catch (IOException e) {
                OptionPane.showMessageDialog(parent, e.getMessage(), Strings.S.get("ramLoadErrorTitle"), 0);
            }
        }
    }

    public static boolean open(MemContents dst, File src) throws IOException {
        return HexFile.open(dst, src, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean open(MemContents dst, File src, String desc) throws IOException {
        BufferedLineReader in = BufferedLineReader.forFile(src);
        try {
            MemContents loaded;
            HexReader r = new HexReader(in, dst.getLogLength(), dst.getValueWidth());
            if (desc == null) {
                loaded = r.detectFormatAndDecode();
            } else {
                r.parseFormat(desc);
                loaded = r.decodeOrWarn();
            }
            if (loaded == null) {
                boolean bl = false;
                return bl;
            }
            dst.copyFrom(0L, loaded, 0L, (int)(loaded.getLastOffset() + 1L));
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    public static ParseResult parseFromClipboard(String src, int addrSize, int wordSize) throws IOException {
        return HexFile.parse(true, src, "v3.0 hex plain words", addrSize, wordSize);
    }

    public static MemContents parseFromCircFile(String src, int addrSize, int wordSize) throws IOException {
        return HexFile.parse((boolean)false, (String)src, (String)"v2.0 raw", (int)addrSize, (int)wordSize).model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ParseResult parse(boolean interactive, String src, String desc, int addrSize, int wordSize) throws IOException {
        BufferedLineReader in = BufferedLineReader.forString(src);
        try {
            MemContents loaded;
            HexReader r = new HexReader(in, addrSize, wordSize);
            r.parseFormat(desc);
            MemContents memContents = loaded = interactive ? r.decodeOrWarn() : r.decode();
            if (loaded == null) {
                throw new IOException("Could not parse memory image data.");
            }
            ParseResult parseResult = new ParseResult(loaded, (int)(r.memMaxAddr + 1L));
            return parseResult;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void save(MemContents src, Frame parent, Project proj, Instance instance) {
        Mem mem = instance == null ? null : (Mem)instance.getFactory();
        File recent = HexFile.getRecent(proj, mem, instance);
        JFileChooser chooser = HexFile.createFileSaveChooser(recent, src);
        chooser.setDialogTitle(Strings.S.get("ramSaveDialogTitle"));
        int choice = chooser.showSaveDialog(parent);
        if (choice == 0) {
            int confirm;
            File f = chooser.getSelectedFile();
            if (f.exists() && (confirm = OptionPane.showConfirmDialog(parent, Strings.S.get("confirmOverwriteMessage", f.getName()), Strings.S.get("confirmOverwriteTitle"), 0)) != 0) {
                return;
            }
            try {
                HexFile.save(f, src, chooser.getFileFilter().getDescription());
                if (mem != null) {
                    mem.setCurrentImage(instance, f);
                }
            }
            catch (IOException e) {
                OptionPane.showMessageDialog(parent, e.getMessage(), Strings.S.get("ramSaveErrorTitle"), 0);
            }
        }
    }

    public static void save(File f, MemContents src, String desc) throws IOException {
        FileOutputStream out;
        try {
            out = new FileOutputStream(f);
        }
        catch (IOException e) {
            throw new IOException(Strings.S.get("hexFileOpenError", e.getMessage()));
        }
        ((OutputStream)out).write(HexFile.headerForFormat(desc).getBytes(StandardCharsets.UTF_8));
        new HexWriter(out, src, desc).save();
    }

    public static String saveToString(MemContents src) {
        return HexFile.saveToString(src, null, -1);
    }

    private static String saveToString(MemContents src, String desc, int limit) {
        try {
            StringWriter out = new StringWriter();
            if (desc == null) {
                desc = "v2.0 raw";
            }
            OutputStream stream = desc.startsWith("Binary") ? new OutputStreamBinarySanitizer(out) : new OutputStreamEscaper(out, true, 0);
            HexWriter w = new HexWriter(stream, src, desc);
            if (limit > 0 && (long)(limit - 1) < w.memEnd) {
                w.memEnd = limit - 1;
            }
            w.save();
            return out.toString();
        }
        catch (IOException e) {
            logger.error("HexFile.saveToString: {}", (Object)e.getMessage());
            throw new IllegalStateException("HexFile.saveToString: " + e.getMessage());
        }
    }

    private static FileFilter getFilter(final String desc) {
        return new FileFilter(){

            @Override
            public String getDescription() {
                return desc;
            }

            @Override
            public boolean accept(File f) {
                return true;
            }
        };
    }

    private static String headerForFormat(String desc) {
        if (desc.startsWith("Binary") || desc.startsWith("ASCII")) {
            return "";
        }
        if (desc.startsWith("v2.0 raw")) {
            return "v2.0 raw\n";
        }
        return desc + "\n";
    }

    private static File getRecent(Project proj, Mem mem, Instance instance) {
        File recent;
        File file = recent = mem == null ? null : mem.getCurrentImage(instance);
        if (recent == null) {
            LogisimFile lf = proj == null ? null : proj.getLogisimFile();
            Loader ld = lf == null ? null : lf.getLoader();
            recent = ld == null ? null : ld.getCurrentDirectory();
        }
        return recent;
    }

    private static JFileChooser createFileSaveChooser(File lastFile, MemContents preview) {
        JFileChooser chooser = HexFile.createFileChooser(lastFile, false);
        chooser.setAccessory(new Preview(chooser, preview));
        return chooser;
    }

    private static JFileChooser createFileOpenChooser(File lastFile) {
        return HexFile.createFileChooser(lastFile, true);
    }

    private static JFileChooser createFileChooser(File lastFile, boolean auto) {
        JFileChooser chooser = JFileChoosers.createSelected(lastFile);
        if (auto) {
            chooser.addChoosableFileFilter(HexFile.getFilter(autoFormat));
        } else {
            for (String desc : formatDescriptions) {
                chooser.addChoosableFileFilter(HexFile.getFilter(desc));
            }
        }
        chooser.setAcceptAllFileFilterUsed(false);
        return chooser;
    }

    private static int scaled(int i) {
        return AppPreferences.getScaled(i);
    }

    private static class HexReader
    extends FormatOptions {
        private final long[] data = new long[4096];
        final BufferedLineReader in;
        final MemContents dst;
        int decodedWordCount;
        final StringWriter warnings = new StringWriter();
        int numWarnings = 0;
        final byte[] bytes = new byte[4096];
        int bLen;
        long memAddr;
        long memMaxAddr;
        long memAddrFrac;
        long memEnd;
        int memWidth;
        boolean bigEndian;
        private int curLineNo;
        private String curLine;
        private String[] curWords;
        private int curWordIdx;
        private boolean skipDoubleSpaces;
        private long rleCount;
        private long rleValue;

        protected HexReader(BufferedLineReader in, int addrBits, int width) {
            this.in = in;
            this.dst = MemContents.create(addrBits, width, false);
        }

        static int hex2int(int c) throws NumberFormatException {
            if (c >= 48 && c <= 57) {
                return c - 48;
            }
            if (c >= 97 && c <= 102) {
                return 10 + (c - 97);
            }
            if (c >= 65 && c <= 70) {
                return 10 + (c - 65);
            }
            throw new NumberFormatException("Invalid hex digit: " + (char)c);
        }

        static long hex2ulong(String s) {
            long val = 0L;
            int n = s.length();
            for (int i = 0; i < n; ++i) {
                int d = HexReader.hex2int(s.charAt(i));
                val = (val << 4) + (long)d;
            }
            return val;
        }

        void warn(String msg, Object ... args) {
            if (this.numWarnings > 0) {
                this.warnings.write("\n");
            }
            if (this.curLineNo > 0) {
                this.warnings.write("Line " + this.curLineNo + ": ");
            }
            this.warnings.write(String.format(msg, args));
            ++this.numWarnings;
        }

        protected MemContents warnAndAsk(String errmsg) {
            if (Main.headless) {
                System.out.println(errmsg);
                System.out.println("Warnings:\n" + this.warnings.toString());
                return null;
            }
            HexFormatDialog d = new HexFormatDialog(errmsg, this);
            d.setVisible(true);
            if (!d.ok()) {
                return null;
            }
            return this.dst;
        }

        protected MemContents detectFormatAndDecode() throws IOException {
            if (this.in.byteLength() == 0L) {
                throw new IOException("File contains no data.");
            }
            String hdr = this.in.readLine();
            while (hdr != null && (hdr = hdr.trim()).length() == 0) {
                hdr = this.in.readLine();
            }
            if (hdr == null) {
                return this.warnAndAsk("File does not contain any header, and appears to contain only whitespace.");
            }
            String err = this.parseHeader(hdr);
            if (err != null) {
                return this.warnAndAsk(err);
            }
            if (!this.tags.containsKey("radix")) {
                return this.warnAndAsk("Incomplete file header.");
            }
            if (this.tagged("radix", "hex") && !this.tags.containsKey("size")) {
                return this.warnAndAsk("File header should specify either 'bytes' or 'words'.");
            }
            return this.decodeOrWarn();
        }

        protected MemContents decode() throws IOException {
            this.reset();
            if (this.taggedOrUnset("radix", "binary")) {
                this.decodeBinary();
            } else if (this.tagged("radix", "ascii")) {
                this.decodeEscapedAscii();
            } else if (this.tagged("radix", "raw")) {
                this.decodeRaw();
            } else if (this.tagged("style", "plain")) {
                this.decodeHexPlain();
            } else if (this.tagged("style", "addressed")) {
                this.decodeHexAddressed();
            } else {
                this.decodeHexAuto();
            }
            return this.dst;
        }

        protected MemContents decodeOrWarn() throws IOException {
            this.decode();
            if (this.tagged("size", "bytes") && (this.memMaxAddr - this.memEnd) * (long)this.memWidth >= 8L) {
                this.warn("File contained %f extra bytes.", (double)((this.memMaxAddr - this.memEnd) * (long)this.memWidth) / 8.0);
            } else if (!this.tagged("size", "bytes") && this.memMaxAddr - this.memEnd > 0L) {
                this.warn("File contained %d extra words.", this.memMaxAddr - this.memEnd);
            }
            if (this.numWarnings > 0) {
                return this.warnAndAsk("Decoding with format '" + this.headerToString() + "' produced " + this.numWarnings + " warnings.");
            }
            return this.dst;
        }

        protected void reset() throws IOException {
            this.in.reset();
            this.dst.clear();
            this.curLineNo = 0;
            this.decodedWordCount = 0;
            this.warnings.getBuffer().setLength(0);
            this.numWarnings = 0;
            this.curLine = null;
            this.curWords = null;
            this.curWordIdx = 0;
            this.skipDoubleSpaces = false;
            this.bLen = 0;
            this.memAddr = 0L;
            this.memAddrFrac = 0L;
            this.memMaxAddr = 0L;
            this.memEnd = this.dst.getLastOffset();
            this.memWidth = this.dst.getWidth();
            this.bigEndian = this.bigEndian();
        }

        private void findNonemptyLine(boolean skipHeader) throws IOException {
            this.curLine = null;
            this.curWords = null;
            this.curWordIdx = 0;
            String line = this.in.readLine();
            while (line != null) {
                block8: {
                    String[] t;
                    int idx;
                    block7: {
                        ++this.curLineNo;
                        int index = line.indexOf("#");
                        if (index >= 0) {
                            line = line.substring(0, index);
                        }
                        if (!skipHeader) break block7;
                        if ((line = line.trim()).length() == 0) break block8;
                        skipHeader = false;
                        if (line.charAt(0) == 'v') break block8;
                    }
                    if (this.skipDoubleSpaces && (idx = line.indexOf("  ")) >= 0) {
                        line = line.substring(0, idx);
                    }
                    if ((line = line.trim()).length() != 0 && (t = line.split("\\s+")).length > 0) {
                        this.curLine = line;
                        this.curWords = t;
                        return;
                    }
                }
                line = this.in.readLine();
            }
        }

        private String nextWord() throws IOException {
            return this.hasNextWord() ? this.curWords[this.curWordIdx++] : null;
        }

        public boolean hasNextWord() throws IOException {
            if (this.curWords == null || this.curWordIdx >= this.curWords.length) {
                this.findNonemptyLine(false);
            }
            return this.curWords != null;
        }

        private long[] subarray(long[] a, int n) {
            if (n >= a.length) {
                return a;
            }
            long[] s = new long[n];
            System.arraycopy(a, 0, s, 0, n);
            return s;
        }

        void decodeRaw() throws IOException {
            this.rleCount = 0L;
            this.rleValue = 0L;
            long offs = 0L;
            this.findNonemptyLine(true);
            while (this.rleHasNextVals()) {
                long[] v = this.rleNextVals();
                long end = offs + (long)v.length - 1L;
                if (end > this.memMaxAddr) {
                    this.memMaxAddr = end;
                }
                if (end > this.memEnd) {
                    if (offs <= this.memEnd) {
                        int n = (int)(this.memEnd - offs + 1L);
                        this.dst.set(offs, this.subarray(this.data, n));
                    }
                } else {
                    this.dst.set(offs, v);
                }
                offs += (long)v.length;
                this.decodedWordCount += v.length;
            }
        }

        public boolean rleHasNextVals() throws IOException {
            return this.rleCount > 0L || this.hasNextWord();
        }

        public long[] rleNextVals() throws IOException {
            int pos = 0;
            if (this.rleCount > 0L) {
                int n = (int)Math.min((long)(this.data.length - pos), this.rleCount);
                if (n == 1) {
                    this.data[pos] = (int)this.rleValue;
                    ++pos;
                    --this.rleCount;
                } else {
                    Arrays.fill(this.data, pos, pos + n, this.rleValue);
                    pos += n;
                    this.rleCount -= (long)n;
                }
            }
            if (pos >= this.data.length) {
                return this.data;
            }
            String word = this.nextWord();
            while (word != null) {
                block18: {
                    int star = word.indexOf("*");
                    if (star == 0) {
                        this.warn("Run-length encoded token \"%s\" missing count, use \"count*data\" instead.", word);
                    } else if (star == word.length() - 1) {
                        this.warn("Run-length encoded token \"%s\" missing hex data, use \"count*data\" instead.", word);
                    } else {
                        String hexWord = star < 0 ? word : word.substring(star + 1);
                        try {
                            this.rleValue = Long.parseUnsignedLong(hexWord, 16);
                        }
                        catch (NumberFormatException e) {
                            try {
                                this.rleValue = Long.parseLong(hexWord, 16);
                            }
                            catch (NumberFormatException f) {
                                this.warn("\"%s\" is not valid hex data.", hexWord);
                                break block18;
                            }
                        }
                        if (star < 0) {
                            this.rleCount = 1L;
                        } else {
                            try {
                                this.rleCount = Long.parseUnsignedLong(word.substring(0, star));
                            }
                            catch (NumberFormatException e) {
                                this.warn("\"%s\" is not valid (base-10 decimal) count.", word.substring(0, star));
                                break block18;
                            }
                        }
                        int n = (int)Math.min((long)(this.data.length - pos), this.rleCount);
                        Arrays.fill(this.data, pos, pos + n, this.rleValue);
                        this.rleCount -= (long)n;
                        if ((pos += n) >= this.data.length) {
                            return this.data;
                        }
                    }
                }
                word = this.nextWord();
            }
            return this.subarray(this.data, pos);
        }

        private long get(long addr) {
            return addr > this.memEnd ? 0L : this.dst.get(addr);
        }

        private BigInteger getBigInteger(long addr) {
            long value = this.get(addr);
            return BigInteger.valueOf(value >>> 1).shiftLeft(1).or(BigInteger.valueOf(value & 1L));
        }

        void set(long addr, long val) {
            ++this.decodedWordCount;
            if (addr > this.memMaxAddr) {
                this.memMaxAddr = addr;
            }
            if (addr <= this.memEnd) {
                this.dst.set(addr, val);
            }
        }

        boolean deliver() {
            if (this.bigEndian) {
                BigInteger val = this.getBigInteger(this.memAddr).shiftRight((int)((long)this.memWidth - this.memAddrFrac));
                int nbits = (int)this.memAddrFrac;
                for (int i = 0; i < this.bLen; ++i) {
                    val = val.shiftLeft(8).or(BigInteger.valueOf(0xFFL & (long)this.bytes[i]));
                    nbits += 8;
                    while (nbits >= this.memWidth) {
                        this.set(this.memAddr++, val.shiftRight(nbits - this.memWidth).longValue());
                        nbits -= this.memWidth;
                    }
                }
                if (nbits > 0) {
                    this.set(this.memAddr, this.dst.get(this.memAddr) | val.shiftLeft(this.memWidth - nbits).longValue());
                    this.memAddrFrac = nbits;
                    --this.decodedWordCount;
                } else {
                    this.memAddrFrac = 0L;
                }
            } else {
                BigInteger val = this.getBigInteger(this.memAddr);
                int nbits = (int)this.memAddrFrac;
                for (int i = 0; i < this.bLen; ++i) {
                    val = val.or(BigInteger.valueOf(0xFFL & (long)this.bytes[i]).shiftLeft(nbits));
                    nbits += 8;
                    while (nbits >= this.memWidth) {
                        this.set(this.memAddr++, val.longValue());
                        nbits -= this.memWidth;
                        val = val.shiftRight(this.memWidth);
                    }
                }
                if (nbits > 0) {
                    this.set(this.memAddr, this.get(this.memAddr) | val.longValue());
                    this.memAddrFrac = nbits;
                    --this.decodedWordCount;
                } else {
                    this.memAddrFrac = 0L;
                }
            }
            this.bLen = 0;
            if (this.memAddr > this.memEnd + 100L) {
                this.warn("Halting decoding early, since plenty of words have been decoded.", new Object[0]);
                return false;
            }
            return true;
        }

        void decodeHexAuto() throws IOException {
            this.findNonemptyLine(true);
            if (this.curLine == null) {
                return;
            }
            if (this.curLine.contains(":")) {
                this.reset();
                this.decodeHexAddressed();
            } else {
                this.reset();
                this.decodeHexPlain();
            }
        }

        void decodeHexPlain() throws IOException {
            if (this.tagged("size", "words")) {
                this.decodeHexPlainWords();
            } else {
                this.decodeHexPlainBytes();
            }
        }

        void decodeHexPlainBytes() throws IOException {
            String word;
            this.bLen = 0;
            this.findNonemptyLine(true);
            boolean left = true;
            while ((word = this.nextWord()) != null) {
                int i = 0;
                int n = word.length();
                if (n >= 2 && (word.startsWith("0x") || word.startsWith("0X"))) {
                    i += 2;
                }
                while (i < n) {
                    block10: {
                        int d;
                        try {
                            d = HexReader.hex2int(word.charAt(i));
                        }
                        catch (NumberFormatException e) {
                            this.warn("Character '%s' is not a hex digit.", OutputStreamEscaper.escape(word.charAt(i)));
                            break block10;
                        }
                        if (left) {
                            this.bytes[this.bLen++] = (byte)(d << 4);
                        } else {
                            int n2 = this.bLen - 1;
                            this.bytes[n2] = (byte)(this.bytes[n2] | (byte)d);
                        }
                        boolean bl = left = !left;
                        if (left && this.bLen >= 4096 && !this.deliver()) {
                            return;
                        }
                    }
                    ++i;
                }
            }
            if (!left) {
                this.warn("Odd number of hex digits found in file.", new Object[0]);
            }
            if (this.bLen > 0) {
                this.deliver();
            }
        }

        void decodeHexPlainWords() throws IOException {
            String word;
            long offs = 0L;
            this.findNonemptyLine(true);
            while ((word = this.nextWord()) != null) {
                int i = 0;
                int n = word.length();
                if (n >= 2 && (word.startsWith("0x") || word.startsWith("0X"))) {
                    i += 2;
                }
                long v = 0L;
                while (i < n) {
                    block5: {
                        long d;
                        try {
                            d = HexReader.hex2int(word.charAt(i));
                        }
                        catch (NumberFormatException e) {
                            this.warn("Character '%s' is not a hex digit.", OutputStreamEscaper.escape(word.charAt(i)));
                            break block5;
                        }
                        v = v << 4 | d;
                    }
                    ++i;
                }
                this.set(offs++, v);
            }
        }

        void decodeHexAddressed() throws IOException {
            if (this.tagged("size", "words")) {
                this.decodeHexAddressedWords();
            } else {
                this.decodeHexAddressedBytes();
            }
        }

        void decodeHexAddressedBytes() throws IOException {
            this.skipDoubleSpaces = true;
            this.findNonemptyLine(true);
            while (this.curWords != null) {
                boolean stripOx;
                String addr = this.curWords[0];
                boolean foundColon = addr.endsWith(":");
                boolean bl = stripOx = addr.startsWith("0x") || addr.startsWith("0X");
                if (foundColon) {
                    addr = addr.substring(stripOx ? 2 : 0, addr.length() - 1);
                } else if (stripOx) {
                    addr = addr.substring(2);
                }
                this.bLen = 0;
                long boffs = 0L;
                try {
                    boffs = HexReader.hex2ulong(addr);
                    if (!this.deliver()) {
                        return;
                    }
                    this.memAddr = boffs * 8L / (long)this.memWidth;
                    this.memAddrFrac = boffs * 8L % (long)this.memWidth;
                }
                catch (Exception e) {
                    this.warn("\"%s\" is not a valid hex address.", addr);
                }
                int i = 1;
                int n = this.curWords.length;
                if (!foundColon && n >= 2 && this.curWords[1].equals(":")) {
                    ++i;
                }
                while (i < n) {
                    String word = this.curWords[i];
                    boolean left = true;
                    int j = 0;
                    int m = word.length();
                    if (word.startsWith("0x") || word.startsWith("0X")) {
                        j = 2;
                    }
                    while (j < m) {
                        block18: {
                            int d;
                            try {
                                d = HexReader.hex2int(word.charAt(j));
                            }
                            catch (NumberFormatException e) {
                                this.warn("Character '%s' is not a hex digit.", OutputStreamEscaper.escape(word.charAt(i)));
                                break block18;
                            }
                            if (left) {
                                this.bytes[this.bLen++] = (byte)(d << 4);
                            } else {
                                int n2 = this.bLen - 1;
                                this.bytes[n2] = (byte)(this.bytes[n2] | (byte)d);
                            }
                            boolean bl2 = left = !left;
                            if (left && this.bLen >= 4096 && !this.deliver()) {
                                return;
                            }
                        }
                        ++j;
                    }
                    if (!left) {
                        this.warn("Odd number of hex digits found in line.", new Object[0]);
                    }
                    ++i;
                }
                if (this.bLen > 0 && !this.deliver()) {
                    return;
                }
                this.findNonemptyLine(false);
            }
        }

        void decodeHexAddressedWords() throws IOException {
            this.findNonemptyLine(true);
            this.skipDoubleSpaces = true;
            long offs = 0L;
            while (this.curWords != null) {
                boolean stripOx;
                String addr = this.curWords[0];
                boolean foundColon = addr.endsWith(":");
                boolean bl = stripOx = addr.startsWith("0x") || addr.startsWith("0X");
                if (foundColon) {
                    addr = addr.substring(stripOx ? 2 : 0, addr.length() - 1);
                } else if (stripOx) {
                    addr = addr.substring(2);
                }
                try {
                    offs = HexReader.hex2ulong(addr);
                }
                catch (Exception e) {
                    this.warn("\"%s\" is not a valid hex address.", this.curWords[0]);
                }
                int i = 1;
                int n = this.curWords.length;
                if (!foundColon && n >= 2 && this.curWords[1].equals(":")) {
                    ++i;
                }
                while (i < n) {
                    block11: {
                        long val;
                        String word = this.curWords[i];
                        if (word.startsWith("0x") || word.startsWith("0X")) {
                            word = word.substring(2);
                        }
                        try {
                            val = HexReader.hex2ulong(word);
                        }
                        catch (Exception e) {
                            this.warn("Data word \"%s\" contains non-hex characters.", OutputStreamEscaper.escape(word));
                            break block11;
                        }
                        this.set(offs++, val);
                    }
                    ++i;
                }
                this.findNonemptyLine(false);
            }
        }

        void decodeBinary() throws IOException {
            this.bLen = 0;
            int n = this.in.readBytes(this.bytes, 0, 4096);
            while (n > 0) {
                this.bLen += n;
                if (!this.deliver()) {
                    return;
                }
                n = this.in.readBytes(this.bytes, this.bLen, 4096 - this.bLen);
            }
        }

        void decodeEscapedAscii() throws IOException {
            byte[] buf = new byte[4096];
            this.bLen = 0;
            int n = this.in.readBytes(buf, 0, 4096);
            this.curLineNo = 1;
            int esc = 0;
            int ehex = 0;
            while (n > 0) {
                for (int i = 0; i < n; ++i) {
                    int d;
                    byte c = buf[i];
                    if (c == 10) {
                        ++this.curLineNo;
                    }
                    if (c < 32 || c > 126) continue;
                    if (esc == 3) {
                        try {
                            d = HexReader.hex2int(c);
                            this.bytes[this.bLen++] = (byte)(16 * ehex + d);
                        }
                        catch (NumberFormatException e) {
                            this.warn("Invalid hex escape sequence.", new Object[0]);
                        }
                        esc = 0;
                        continue;
                    }
                    if (esc == 2) {
                        try {
                            ehex = d = HexReader.hex2int(c);
                            ++esc;
                        }
                        catch (NumberFormatException e) {
                            this.warn("Invalid hex escape sequence.", new Object[0]);
                            esc = 0;
                        }
                        continue;
                    }
                    if (esc == 1 && c == 120) {
                        ++esc;
                        continue;
                    }
                    if (esc == 1) {
                        esc = 0;
                        if (c == 110) {
                            this.bytes[this.bLen++] = 10;
                            continue;
                        }
                        if (c == 114) {
                            this.bytes[this.bLen++] = 13;
                            continue;
                        }
                        if (c == 116) {
                            this.bytes[this.bLen++] = 9;
                            continue;
                        }
                        if (c == 48) {
                            this.bytes[this.bLen++] = 0;
                            continue;
                        }
                        if (c == 92) {
                            this.bytes[this.bLen++] = 92;
                            continue;
                        }
                        if (c == 39) {
                            this.bytes[this.bLen++] = 39;
                            continue;
                        }
                        if (c == 34) {
                            this.bytes[this.bLen++] = 34;
                            continue;
                        }
                        if (c == 97) {
                            this.bytes[this.bLen++] = 7;
                            continue;
                        }
                        if (c == 98) {
                            this.bytes[this.bLen++] = 8;
                            continue;
                        }
                        if (c == 118) {
                            this.bytes[this.bLen++] = 11;
                            continue;
                        }
                        if (c == 102) {
                            this.bytes[this.bLen++] = 12;
                            continue;
                        }
                        if (c == 63) {
                            this.bytes[this.bLen++] = 63;
                            continue;
                        }
                        this.warn("Invalid ascii escape sequence.", new Object[0]);
                        continue;
                    }
                    if (c == 92) {
                        esc = 1;
                        continue;
                    }
                    if (c < 32 || c > 126) continue;
                    this.bytes[this.bLen++] = c;
                }
                if (!this.deliver()) {
                    return;
                }
                n = this.in.readBytes(buf, 0, 4096 - this.bLen);
            }
            if (esc != 0) {
                this.warn("Truncated escape sequence at end of file.", new Object[0]);
            }
        }
    }

    public static class ParseResult {
        public final MemContents model;
        public final int numWords;

        ParseResult(MemContents m, int n) {
            this.model = m;
            this.numWords = n;
        }
    }

    private static class HexWriter
    extends FormatOptions {
        final MemContents src;
        final byte[] bytes = new byte[4096];
        int bLen;
        final int memWidth;
        long memAddr;
        long memEnd;
        int mAddrFrac;
        final boolean bigEndian;
        PrintWriter cOut;
        OutputStream bOut;

        HexWriter(OutputStream out, MemContents src, String desc) {
            super(desc);
            this.src = src;
            this.bOut = out;
            this.memEnd = src.getLastOffset();
            this.memWidth = src.getWidth();
            this.bigEndian = this.bigEndian();
        }

        private long get(long addr) {
            return addr > this.memEnd ? 0L : this.src.get(addr);
        }

        private BigInteger getBigInteger(long addr) {
            long value = this.get(addr);
            return BigInteger.valueOf(value >>> 1).shiftLeft(1).or(BigInteger.valueOf(value & 1L));
        }

        void buffer() {
            this.bLen = 0;
            if (this.bigEndian) {
                BigInteger val = BigInteger.ZERO;
                int nbits = -this.mAddrFrac;
                while (this.memAddr <= this.memEnd) {
                    while (nbits < 8) {
                        val = val.shiftLeft(this.memWidth).or(this.getBigInteger(this.memAddr++));
                        nbits += this.memWidth;
                    }
                    while (nbits >= 8) {
                        this.bytes[this.bLen++] = (byte)(val.shiftRight(nbits - 8).longValue() & 0xFFL);
                        nbits -= 8;
                        if (this.bLen < 4096) continue;
                        this.memAddr -= (long)((nbits + this.memWidth - 1) / this.memWidth);
                        this.mAddrFrac = this.memWidth - (nbits + this.memWidth - 1) % this.memWidth - 1;
                        return;
                    }
                    val = nbits == 0 ? BigInteger.ZERO : val.and(BigInteger.valueOf((1L << nbits) - 1L));
                }
                if (this.memAddr <= this.memEnd && nbits > 0) {
                    this.bytes[this.bLen++] = (byte)(val.longValue() << 8 - nbits & 0xFFL);
                }
            } else {
                BigInteger val = BigInteger.ZERO;
                int nbits = -this.mAddrFrac;
                while (this.memAddr <= this.memEnd) {
                    while (nbits < 8) {
                        val = nbits < 0 ? this.getBigInteger(this.memAddr++).shiftRight(-nbits) : val.or(this.getBigInteger(this.memAddr++).shiftLeft(nbits));
                        nbits += this.memWidth;
                    }
                    while (nbits >= 8) {
                        this.bytes[this.bLen++] = (byte)(val.longValue() & 0xFFL);
                        val = val.shiftRight(8);
                        nbits -= 8;
                        if (this.bLen < 4096) continue;
                        this.memAddr -= (long)((nbits + this.memWidth - 1) / this.memWidth);
                        this.mAddrFrac = this.memWidth - (nbits + this.memWidth - 1) % this.memWidth - 1;
                        return;
                    }
                }
                if (this.memAddr <= this.memEnd && nbits > 0) {
                    this.bytes[this.bLen++] = (byte)(val.longValue() & (1L << nbits) - 1L);
                }
            }
        }

        void save() throws IOException {
            try {
                if (this.taggedOrUnset("radix", "binary")) {
                    this.saveBinary();
                } else if (this.tagged("radix", "ascii")) {
                    this.saveEscapedAscii();
                } else if (this.tagged("radix", "raw")) {
                    this.saveRaw();
                } else if (this.tagged("style", "plain")) {
                    this.saveHexPlain();
                } else {
                    this.saveHexAddressed();
                }
            }
            catch (IOException e) {
                Closeable o2;
                try {
                    if (this.cOut != null) {
                        o2 = this.cOut;
                        this.cOut = null;
                        ((Writer)o2).close();
                    }
                }
                catch (IOException o2) {
                    // empty catch block
                }
                try {
                    o2 = this.bOut;
                    this.bOut = null;
                    ((OutputStream)o2).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new IOException(Strings.S.get("hexFileWriteError", e.getMessage()));
            }
            finally {
                if (this.cOut != null) {
                    this.cOut.close();
                }
                this.bOut.close();
            }
        }

        void saveRaw() {
            this.cOut = new PrintWriter(new OutputStreamWriter(this.bOut));
            while (this.memEnd > 0L && this.src.get(this.memEnd) == 0L) {
                --this.memEnd;
            }
            int tokens = 0;
            long offs = 0L;
            while (offs <= this.memEnd) {
                long val = this.src.get(offs);
                long start = offs++;
                while (offs <= this.memEnd && this.src.get(offs) == val) {
                    ++offs;
                }
                long len = offs - start;
                if (len < 4L) {
                    offs = start + 1L;
                    len = 1L;
                }
                if (tokens > 0) {
                    this.cOut.write(tokens % 8 == 0 ? 10 : 32);
                }
                if (offs != start + 1L) {
                    this.cOut.write(offs - start + "*");
                }
                this.cOut.write(Long.toHexString(val));
                ++tokens;
            }
            if (tokens > 0) {
                this.cOut.write(10);
            }
        }

        void saveBinary() throws IOException {
            this.buffer();
            while (this.bLen > 0) {
                this.bOut.write(this.bytes, 0, this.bLen);
                this.buffer();
            }
        }

        void saveEscapedAscii() throws IOException {
            this.buffer();
            OutputStreamEscaper escaper = new OutputStreamEscaper(new OutputStreamWriter(this.bOut));
            escaper.textWidth(70);
            while (this.bLen > 0) {
                escaper.write(this.bytes, 0, this.bLen);
                this.buffer();
            }
            escaper.flush();
            escaper.close();
        }

        void saveHexPlain() {
            if (this.tagged("size", "words")) {
                this.saveHexWords(false);
            } else {
                this.saveHexBytes(false);
            }
        }

        String addrfmt(long maxAddr) {
            int w = String.format("%x", maxAddr).length();
            return "%0" + w + "x: ";
        }

        void saveHexBytes(boolean addressed) {
            this.cOut = new PrintWriter(new OutputStreamWriter(this.bOut));
            String afmt = this.addrfmt(this.memEnd);
            int col = 0;
            this.buffer();
            long offs = 0L;
            while (this.bLen > 0) {
                for (int i = 0; i < this.bLen; ++i) {
                    if (col == 0 && addressed) {
                        this.cOut.printf(afmt, offs);
                    }
                    ++offs;
                    byte b = this.bytes[i];
                    this.cOut.printf("%02x", b);
                    if ((col += 2) < 64) continue;
                    this.cOut.printf("\n", new Object[0]);
                    col = 0;
                }
                this.buffer();
            }
            if (col != 0) {
                this.cOut.printf("\n", new Object[0]);
            }
        }

        void saveHexWords(boolean addressed) {
            this.cOut = new PrintWriter(new OutputStreamWriter(this.bOut));
            String afmt = this.addrfmt(this.memEnd);
            int col = 0;
            int w = (this.memWidth + 3) / 4;
            int ncol = w == 1 ? 32 : (w <= 4 ? 16 : 8);
            String fmt = "%0" + w + "x";
            int offs = 0;
            while ((long)offs <= this.memEnd) {
                if (col == 0 && addressed) {
                    this.cOut.printf(afmt, offs);
                } else if (col != 0) {
                    this.cOut.print(" ");
                }
                this.cOut.printf(fmt, this.src.get(offs));
                if (++col >= ncol) {
                    this.cOut.print("\n");
                    col = 0;
                }
                ++offs;
            }
            if (col != 0) {
                this.cOut.printf("\n", new Object[0]);
            }
        }

        void saveHexAddressed() {
            if (this.tagged("size", "words")) {
                this.saveHexWords(true);
            } else {
                this.saveHexBytes(true);
            }
        }
    }

    private static class Preview
    extends JPanel
    implements PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        final JFileChooser chooser;
        final JTextArea preview;
        final MemContents memContents;

        Preview(JFileChooser chooser, MemContents memContents) {
            this.chooser = chooser;
            this.memContents = memContents;
            this.setLayout(new BorderLayout());
            this.preview = new JTextArea();
            this.preview.setEditable(false);
            this.preview.setFont(new Font("monospaced", 0, HexFile.scaled(10)));
            JTabbedPane tabs = new JTabbedPane();
            tabs.setBorder(BorderFactory.createEmptyBorder(0, HexFile.scaled(8), 0, 0));
            tabs.setFont(new Font("Dialog", 1, HexFile.scaled(9)));
            tabs.addTab("Preview", new JScrollPane(this.preview));
            this.add((Component)tabs, "Center");
            chooser.addPropertyChangeListener(this);
            this.setPreferredSize(new Dimension(HexFile.scaled(240), HexFile.scaled(220)));
            this.refresh();
        }

        @Override
        public void propertyChange(PropertyChangeEvent changeEvent) {
            String changeName = changeEvent.getPropertyName();
            if (changeName.equals("fileFilterChanged")) {
                this.refresh();
            }
        }

        void refresh() {
            String desc = this.chooser.getFileFilter().getDescription();
            String hdr = HexFile.headerForFormat(desc);
            this.preview.setText(hdr + HexFile.saveToString(this.memContents, desc, -1));
            this.preview.setCaretPosition(0);
        }
    }

    static class FormatOptions {
        final HashMap<String, String> tags = new HashMap();

        FormatOptions() {
        }

        FormatOptions(String desc) {
            this.parseFormat(desc);
        }

        void parseFormat(String desc) {
            this.tags.clear();
            if (desc.startsWith("Binary")) {
                boolean le = desc.endsWith("little-endian");
                this.tags.put("version", "v3.0");
                this.tags.put("radix", "binary");
                this.tags.put("endian", le ? "little-endian" : "big-endian");
                this.tags.put("size", "bytes");
                this.tags.put("style", "plain");
            } else if (desc.startsWith("ASCII")) {
                boolean le = desc.endsWith("little-endian");
                this.tags.put("version", "v3.0");
                this.tags.put("radix", "ascii");
                this.tags.put("endian", le ? "little-endian" : "big-endian");
                this.tags.put("size", "bytes");
                this.tags.put("style", "plain");
            } else if (desc.startsWith("v2.0 raw")) {
                this.tags.put("version", "v2.0");
                this.tags.put("radix", "raw");
                this.tags.put("size", "words");
                this.tags.put("style", "rle");
            } else {
                String msg = this.parseHeader(desc);
                if (msg != null) {
                    throw new IllegalArgumentException(msg + ": " + desc);
                }
            }
        }

        String parseHeader(String hdr) {
            this.tags.clear();
            String[] t = hdr.split("\\s+");
            if (t.length < 1) {
                return "File does not contain any header, and appears to contain only whitespace.";
            }
            if (!t[0].equalsIgnoreCase("v2.0") && !t[0].equalsIgnoreCase("v3.0")) {
                return "Hex file header not recognized";
            }
            this.tags.put("version", t[0]);
            String err = null;
            for (int i = 1; i < t.length; ++i) {
                String key;
                String tag = t[i];
                switch (tag.toLowerCase()) {
                    case "hex": 
                    case "raw": {
                        String string = "radix";
                        break;
                    }
                    case "bytes": 
                    case "words": {
                        String string = "size";
                        break;
                    }
                    case "plain": 
                    case "addressed": {
                        String string = "style";
                        break;
                    }
                    case "little-endian": 
                    case "big-endian": {
                        String string = "endian";
                        break;
                    }
                    default: {
                        String string = key = null;
                    }
                }
                if (key == null) {
                    err = err != null ? err : "File header tag '" + tag + "' not recognized.";
                    continue;
                }
                if (this.tags.containsKey(key) && this.tags.get(key).equalsIgnoreCase(tag)) {
                    err = err != null ? err : "File header tag '" + tag + "' appears more than once.";
                    continue;
                }
                if (this.tags.containsKey(key)) {
                    err = err != null ? err : "File header tag '" + tag + "' conflicts with '" + this.tags.get(key) + "'.";
                    continue;
                }
                this.tags.put(key, tag);
            }
            return err;
        }

        boolean tagged(String key, String val) {
            return this.tags.containsKey(key) && this.tags.get(key).equalsIgnoreCase(val);
        }

        boolean taggedOrUnset(String key, String val) {
            return !this.tags.containsKey(key) || this.tags.get(key).equalsIgnoreCase(val);
        }

        boolean bigEndian() {
            return this.taggedOrUnset("endian", "big-endian");
        }

        protected String endian() {
            return this.bigEndian() ? "big-endian" : "little-endian";
        }

        protected String headerToString() {
            if (this.tagged("radix", "raw")) {
                return "v2.0 raw";
            }
            if (this.taggedOrUnset("radix", "binary")) {
                return "v3.0 binary " + this.endian();
            }
            if (this.tagged("radix", "ascii")) {
                return "v3.0 ascii " + this.endian();
            }
            if (this.tagged("size", "words")) {
                return "v3.0 hex words" + (String)(this.tags.containsKey("style") ? " " + this.tags.get("style") : "");
            }
            return "v3.0 hex bytes" + (String)(this.tags.containsKey("style") ? " " + this.tags.get("style") : "") + " " + this.endian();
        }
    }

    static class HexFormatDialog
    extends JDialogOk {
        private static final long serialVersionUID = 1L;
        JRadioButton raw;
        JRadioButton hex;
        JRadioButton bin;
        JRadioButton asc;
        JCheckBox hexWords;
        JCheckBox hexBytes;
        JCheckBox hexAddr;
        JCheckBox hexPlain;
        JCheckBox hexAuto;
        JCheckBox hexBig;
        JCheckBox hexLittle;
        JCheckBox binBig;
        JCheckBox binLittle;
        JCheckBox ascBig;
        JCheckBox ascLittle;
        JTextArea warnings;
        JTextArea previewMem;
        JTextArea originalTxt;
        JLabel previewHdr;
        JLabel originalHdr;
        JTabbedPane tabs;
        HexReader reader;
        boolean value = false;

        public HexFormatDialog(String msg, HexReader reader) {
            super(Strings.S.get("hexFormatTitle"));
            this.configure(msg, reader);
        }

        private void configure(String msg, HexReader reader) {
            this.reader = reader;
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            int scaledTen = HexFile.scaled(10);
            p.setBorder(BorderFactory.createEmptyBorder(scaledTen, scaledTen, 0, scaledTen));
            JLabel m = new JLabel("<html>" + msg + "<br><br>Please select an appropriate file format to load this file into memory:</html>");
            Font f = m.getFont();
            m.setFont(f.deriveFont(f.getStyle() & 0xFFFFFFFE));
            m.setAlignmentX(0.5f);
            m.setBorder(BorderFactory.createEmptyBorder(0, 0, scaledTen, 0));
            p.add(m);
            GridBagLayout grid = new GridBagLayout();
            GridBagConstraints pos = new GridBagConstraints();
            JPanel opts = new JPanel(grid);
            pos.gridheight = 1;
            pos.weighty = 0.0;
            pos.weightx = 0.0;
            pos.anchor = 17;
            pos.gridy = 0;
            pos.gridx = 0;
            pos.gridwidth = 4;
            this.raw = new JRadioButton("v2.0 raw", this.reader.tagged("radix", "raw"));
            grid.setConstraints(this.raw, pos);
            opts.add(this.raw);
            pos.gridy = 1;
            pos.gridx = 0;
            pos.gridwidth = 4;
            this.hex = new JRadioButton("v3.0 hex", this.reader.tagged("radix", "hex"));
            grid.setConstraints(this.hex, pos);
            opts.add(this.hex);
            pos.gridy = 2;
            pos.gridx = 0;
            pos.gridwidth = 1;
            Component strut = Box.createHorizontalStrut(HexFile.scaled(20));
            grid.setConstraints(strut, pos);
            opts.add(strut);
            pos.gridx = 1;
            this.hexWords = new JCheckBox("words", this.reader.taggedOrUnset("size", "words"));
            grid.setConstraints(this.hexWords, pos);
            opts.add(this.hexWords);
            pos.gridx = 2;
            this.hexBytes = new JCheckBox("bytes", this.reader.tagged("size", "bytes"));
            grid.setConstraints(this.hexBytes, pos);
            opts.add(this.hexBytes);
            pos.gridy = 3;
            pos.gridx = 1;
            this.hexAuto = new JCheckBox("auto", !this.reader.tags.containsKey("style"));
            grid.setConstraints(this.hexAuto, pos);
            opts.add(this.hexAuto);
            pos.gridx = 2;
            this.hexAddr = new JCheckBox("addressed", this.reader.tagged("style", "addressed"));
            grid.setConstraints(this.hexAddr, pos);
            opts.add(this.hexAddr);
            pos.gridx = 3;
            this.hexPlain = new JCheckBox("plain", this.reader.tagged("style", "plain"));
            grid.setConstraints(this.hexPlain, pos);
            opts.add(this.hexPlain);
            pos.gridy = 4;
            pos.gridx = 1;
            this.hexBig = new JCheckBox("big-endian", this.reader.bigEndian());
            grid.setConstraints(this.hexBig, pos);
            opts.add(this.hexBig);
            pos.gridx = 2;
            this.hexLittle = new JCheckBox("little-endian", !this.reader.bigEndian());
            grid.setConstraints(this.hexLittle, pos);
            opts.add(this.hexLittle);
            pos.gridy = 5;
            pos.gridx = 0;
            pos.gridwidth = 4;
            this.bin = new JRadioButton("Binary", this.reader.taggedOrUnset("radix", "binary"));
            grid.setConstraints(this.bin, pos);
            opts.add(this.bin);
            pos.gridy = 6;
            pos.gridx = 1;
            pos.gridwidth = 1;
            this.binBig = new JCheckBox("big-endian", this.reader.bigEndian());
            grid.setConstraints(this.binBig, pos);
            opts.add(this.binBig);
            pos.gridx = 2;
            this.binLittle = new JCheckBox("little-endian", !this.reader.bigEndian());
            grid.setConstraints(this.binLittle, pos);
            opts.add(this.binLittle);
            pos.gridy = 7;
            pos.gridx = 0;
            pos.gridwidth = 4;
            this.asc = new JRadioButton("ASCII with C-style escapes", this.reader.tagged("radix", "ascii"));
            grid.setConstraints(this.asc, pos);
            opts.add(this.asc);
            pos.gridy = 8;
            pos.gridx = 1;
            pos.gridwidth = 1;
            this.ascBig = new JCheckBox("big-endian", this.reader.bigEndian());
            grid.setConstraints(this.ascBig, pos);
            opts.add(this.ascBig);
            pos.gridx = 2;
            this.ascLittle = new JCheckBox("little-endian", !this.reader.bigEndian());
            grid.setConstraints(this.ascLittle, pos);
            opts.add(this.ascLittle);
            ButtonGroup radix = new ButtonGroup();
            radix.add(this.raw);
            radix.add(this.hex);
            radix.add(this.bin);
            radix.add(this.asc);
            ButtonGroup hs = new ButtonGroup();
            hs.add(this.hexWords);
            hs.add(this.hexBytes);
            ButtonGroup hy = new ButtonGroup();
            hy.add(this.hexPlain);
            hy.add(this.hexAddr);
            hy.add(this.hexAuto);
            ButtonGroup he = new ButtonGroup();
            he.add(this.hexBig);
            he.add(this.hexLittle);
            ButtonGroup be = new ButtonGroup();
            be.add(this.binBig);
            be.add(this.binLittle);
            ButtonGroup ae = new ButtonGroup();
            ae.add(this.ascBig);
            ae.add(this.ascLittle);
            this.previewHdr = new JLabel("words...");
            this.previewMem = new JTextArea();
            this.previewMem.setEditable(false);
            this.previewMem.setFont(new Font("monospaced", 0, scaledTen));
            JPanel preview = new JPanel();
            preview.setLayout(new BoxLayout(preview, 1));
            preview.add(this.previewHdr);
            preview.add(new JScrollPane(this.previewMem));
            this.originalHdr = new JLabel(this.reader.in.byteLength() + " bytes");
            this.originalTxt = new JTextArea();
            this.originalTxt.setEditable(false);
            this.originalTxt.setFont(new Font("monospaced", 0, scaledTen));
            JPanel original = new JPanel();
            original.setLayout(new BoxLayout(original, 1));
            original.add(this.originalHdr);
            JScrollPane scroller = new JScrollPane(this.originalTxt);
            scroller.setRowHeaderView(new TextLineNumber(this.originalTxt));
            original.add(scroller);
            try {
                char[] buf = new char[1024];
                this.reader.in.reset();
                int n = this.reader.in.readUtf8(buf, 0, 1024);
                int count = 0;
                if (n < 0) {
                    this.originalTxt.setText("(error reading data)");
                } else {
                    StringWriter b = new StringWriter();
                    do {
                        b.write(buf, 0, n);
                        if ((count += n) < 10240) continue;
                        b.write("..\n(rest of fole omitted)\n");
                        break;
                    } while ((n = this.reader.in.readUtf8(buf, 0, 1024)) > 0);
                    this.originalTxt.setText(b.toString());
                }
            }
            catch (IOException e) {
                try {
                    byte[] buf = new byte[1024];
                    this.reader.in.reset();
                    int n = this.reader.in.readBytes(buf, 0, 1024);
                    int count = 0;
                    if (n < 0) {
                        this.originalTxt.setText("(error reading data)");
                    } else {
                        StringWriter b = new StringWriter();
                        OutputStreamBinarySanitizer sanitizer = new OutputStreamBinarySanitizer(b);
                        do {
                            sanitizer.write(buf, 0, n);
                            if ((count += n) < 10240) continue;
                            b.write("..\n(rest of fole omitted)\n");
                            break;
                        } while ((n = this.reader.in.readBytes(buf, 0, 1024)) > 0);
                        sanitizer.flush();
                        sanitizer.close();
                        this.originalTxt.setText(b.toString());
                    }
                }
                catch (Exception e2) {
                    this.originalTxt.setText("(error reading data)");
                }
            }
            this.originalTxt.setCaretPosition(0);
            this.tabs = new JTabbedPane();
            this.tabs.setBorder(BorderFactory.createEmptyBorder(0, scaledTen, 0, 0));
            this.tabs.setFont(new Font("Dialog", 1, HexFile.scaled(9)));
            this.tabs.addTab("Decoded", preview);
            this.tabs.addTab("Original", original);
            JPanel split = new JPanel(new BorderLayout());
            JPanel optp = new JPanel();
            optp.setLayout(new BoxLayout(optp, 0));
            opts.setAlignmentY(0.0f);
            optp.add(opts);
            split.add((Component)optp, "West");
            split.add((Component)this.tabs, "Center");
            split.setBorder(BorderFactory.createEmptyBorder(0, 0, scaledTen, 0));
            p.add(split);
            this.warnings = new JTextArea();
            this.warnings.setEditable(false);
            p.add(new JScrollPane(this.warnings){
                private static final long serialVersionUID = 1L;

                @Override
                public Dimension getMinimumSize() {
                    Dimension d = super.getMaximumSize();
                    d.height = HexFile.scaled(60);
                    return d;
                }

                @Override
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    d.height = HexFile.scaled(80);
                    return d;
                }

                @Override
                public Dimension getMaximumSize() {
                    Dimension d = super.getMaximumSize();
                    d.height = HexFile.scaled(120);
                    return d;
                }
            });
            MyListener listener = new MyListener();
            this.raw.addActionListener(listener);
            this.hex.addActionListener(listener);
            this.hexWords.addActionListener(listener);
            this.hexBytes.addActionListener(listener);
            this.hexAuto.addActionListener(listener);
            this.hexAddr.addActionListener(listener);
            this.hexPlain.addActionListener(listener);
            this.hexBig.addActionListener(listener);
            this.hexLittle.addActionListener(listener);
            this.bin.addActionListener(listener);
            this.binBig.addActionListener(listener);
            this.binLittle.addActionListener(listener);
            this.asc.addActionListener(listener);
            this.ascBig.addActionListener(listener);
            this.ascLittle.addActionListener(listener);
            listener.actionPerformed(null);
            this.getContentPane().add((Component)p, "Center");
            this.setMinimumSize(new Dimension(HexFile.scaled(600), HexFile.scaled(400)));
            opts.setMaximumSize(opts.getMinimumSize());
            this.pack();
        }

        void setWarnings() {
            StringWriter s = new StringWriter();
            if (this.reader.numWarnings == 0) {
                s.write("No errors encountered decoding with this format.");
            } else if (this.reader.numWarnings == 1) {
                s.write("There was one error encountered decoding with this format:\n");
            } else {
                s.write("There were " + this.reader.numWarnings + " errors encountered decoding with this format:\n");
            }
            s.write(this.reader.warnings.toString());
            this.warnings.setText(s.toString());
            this.warnings.setCaretPosition(0);
        }

        void setEnables() {
            this.hexWords.setEnabled(this.hex.isSelected());
            this.hexBytes.setEnabled(this.hex.isSelected());
            this.hexAuto.setEnabled(this.hex.isSelected());
            this.hexAddr.setEnabled(this.hex.isSelected());
            this.hexPlain.setEnabled(this.hex.isSelected());
            this.hexBig.setEnabled(this.hex.isSelected() && this.hexBytes.isSelected());
            this.hexLittle.setEnabled(this.hex.isSelected() && this.hexBytes.isSelected());
            this.binBig.setEnabled(this.bin.isSelected());
            this.binLittle.setEnabled(this.bin.isSelected());
            this.ascBig.setEnabled(this.asc.isSelected());
            this.ascLittle.setEnabled(this.asc.isSelected());
        }

        void setPreview() {
            int n = this.reader.decodedWordCount;
            this.previewHdr.setText(String.format("decoded %d of %d words, %d bits each", n, this.reader.memEnd + 1L, this.reader.memWidth));
            if (n > 0) {
                this.previewMem.setText(HexFile.saveToString(this.reader.dst, "v3.0 hex words addressed", n));
            } else {
                this.previewMem.setText("");
            }
            this.previewMem.setCaretPosition(0);
        }

        public boolean ok() {
            return this.value;
        }

        @Override
        public void okClicked() {
            this.value = true;
        }

        @Override
        public void cancelClicked() {
            this.value = false;
        }

        private class MyListener
        implements ActionListener {
            private MyListener() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                HexFormatDialog.this.setEnables();
                HexFormatDialog.this.reader.tags.clear();
                if (HexFormatDialog.this.raw.isSelected()) {
                    HexFormatDialog.this.reader.tags.put("version", "v2.0");
                    HexFormatDialog.this.reader.tags.put("radix", "raw");
                } else if (HexFormatDialog.this.hex.isSelected()) {
                    HexFormatDialog.this.reader.tags.put("version", "v3.0");
                    HexFormatDialog.this.reader.tags.put("radix", "hex");
                    HexFormatDialog.this.reader.tags.put("size", HexFormatDialog.this.hexWords.isSelected() ? "words" : "bytes");
                    if (HexFormatDialog.this.hexPlain.isSelected()) {
                        HexFormatDialog.this.reader.tags.put("style", "plain");
                    } else if (HexFormatDialog.this.hexAddr.isSelected()) {
                        HexFormatDialog.this.reader.tags.put("style", "addressed");
                    }
                    if (HexFormatDialog.this.hexBytes.isSelected()) {
                        HexFormatDialog.this.reader.tags.put("endian", HexFormatDialog.this.hexBig.isSelected() ? "big-endian" : "little-endian");
                    }
                } else if (HexFormatDialog.this.asc.isSelected()) {
                    HexFormatDialog.this.reader.tags.put("version", "v3.0");
                    HexFormatDialog.this.reader.tags.put("radix", "ascii");
                    HexFormatDialog.this.reader.tags.put("endian", HexFormatDialog.this.ascBig.isSelected() ? "big-endian" : "little-endian");
                } else {
                    HexFormatDialog.this.reader.tags.put("version", "v3.0");
                    HexFormatDialog.this.reader.tags.put("radix", "binary");
                    HexFormatDialog.this.reader.tags.put("endian", HexFormatDialog.this.binBig.isSelected() ? "big-endian" : "little-endian");
                }
                try {
                    HexFormatDialog.this.reader.decode();
                }
                catch (IOException e) {
                    HexFormatDialog.this.reader.warn(e.getMessage(), new Object[0]);
                }
                HexFormatDialog.this.setPreview();
                HexFormatDialog.this.setWarnings();
            }
        }
    }
}

