/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.appear;

import com.cburch.draw.actions.ModelDeleteHandleAction;
import com.cburch.draw.actions.ModelInsertHandleAction;
import com.cburch.draw.actions.ModelReorderAction;
import com.cburch.draw.canvas.Selection;
import com.cburch.draw.canvas.SelectionEvent;
import com.cburch.draw.canvas.SelectionListener;
import com.cburch.draw.model.CanvasModel;
import com.cburch.draw.model.CanvasModelEvent;
import com.cburch.draw.model.CanvasModelListener;
import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.model.Handle;
import com.cburch.draw.util.MatchingSet;
import com.cburch.draw.util.ZOrder;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.appear.AppearanceAnchor;
import com.cburch.logisim.circuit.appear.AppearanceElement;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.appear.AppearanceCanvas;
import com.cburch.logisim.gui.appear.Clipboard;
import com.cburch.logisim.gui.appear.ClipboardActions;
import com.cburch.logisim.gui.appear.ClipboardContents;
import com.cburch.logisim.gui.appear.SelectionAction;
import com.cburch.logisim.gui.menu.EditHandler;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.proj.Project;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class AppearanceEditHandler
extends EditHandler
implements SelectionListener,
PropertyChangeListener,
CanvasModelListener {
    private final AppearanceCanvas canvas;

    AppearanceEditHandler(AppearanceCanvas canvas) {
        this.canvas = canvas;
        canvas.getSelection().addSelectionListener(this);
        CanvasModel model = canvas.getModel();
        if (model != null) {
            model.addCanvasModelListener(this);
        }
        canvas.addPropertyChangeListener("model", this);
    }

    @Override
    public void addControlPoint() {
        Selection sel = this.canvas.getSelection();
        Handle handle = sel.getSelectedHandle();
        this.canvas.doAction(new ModelInsertHandleAction(this.canvas.getModel(), handle));
    }

    @Override
    public void computeEnabled() {
        boolean canLower;
        boolean canRaise;
        Project proj = this.canvas.getProject();
        Circuit circ = this.canvas.getCircuit();
        Selection sel = this.canvas.getSelection();
        boolean selEmpty = sel.isEmpty();
        boolean canChange = proj.getLogisimFile().contains(circ);
        boolean clipExists = !Clipboard.isEmpty();
        boolean selHasRemovable = false;
        for (CanvasObject o : sel.getSelected()) {
            if (o instanceof AppearanceElement) continue;
            selHasRemovable = true;
            break;
        }
        if (!selEmpty && canChange) {
            Map<CanvasObject, Integer> zs = ZOrder.getZIndex(sel.getSelected(), this.canvas.getModel());
            int zMin = Integer.MAX_VALUE;
            int zMax = Integer.MIN_VALUE;
            int count = 0;
            for (Map.Entry<CanvasObject, Integer> entry : zs.entrySet()) {
                if (entry.getKey() instanceof AppearanceElement) continue;
                ++count;
                int z = entry.getValue();
                if (z < zMin) {
                    zMin = z;
                }
                if (z <= zMax) continue;
                zMax = z;
            }
            int maxPoss = AppearanceCanvas.getMaxIndex(this.canvas.getModel());
            if (count > 0 && count <= maxPoss) {
                canRaise = zMin <= maxPoss - count;
                canLower = zMax >= count;
            } else {
                canRaise = false;
                canLower = false;
            }
        } else {
            canRaise = false;
            canLower = false;
        }
        boolean canAddCtrl = false;
        boolean canRemCtrl = false;
        Handle handle = sel.getSelectedHandle();
        if (handle != null && canChange) {
            CanvasObject o = handle.getObject();
            canAddCtrl = o.canInsertHandle(handle.getLocation()) != null;
            canRemCtrl = o.canDeleteHandle(handle.getLocation()) != null;
        }
        this.setEnabled(LogisimMenuBar.CUT, selHasRemovable && canChange);
        this.setEnabled(LogisimMenuBar.COPY, !selEmpty);
        this.setEnabled(LogisimMenuBar.PASTE, canChange && clipExists);
        this.setEnabled(LogisimMenuBar.DELETE, selHasRemovable && canChange);
        this.setEnabled(LogisimMenuBar.DUPLICATE, !selEmpty && canChange);
        this.setEnabled(LogisimMenuBar.SELECT_ALL, true);
        this.setEnabled(LogisimMenuBar.RAISE, canRaise);
        this.setEnabled(LogisimMenuBar.LOWER, canLower);
        this.setEnabled(LogisimMenuBar.RAISE_TOP, canRaise);
        this.setEnabled(LogisimMenuBar.LOWER_BOTTOM, canLower);
        this.setEnabled(LogisimMenuBar.ADD_CONTROL, canAddCtrl);
        this.setEnabled(LogisimMenuBar.REMOVE_CONTROL, canRemCtrl);
    }

    @Override
    public void copy() {
        if (!this.canvas.getSelection().isEmpty()) {
            this.canvas.getProject().doAction(ClipboardActions.copy(this.canvas));
        }
    }

    @Override
    public void cut() {
        if (!this.canvas.getSelection().isEmpty()) {
            this.canvas.getProject().doAction(ClipboardActions.cut(this.canvas));
        }
    }

    @Override
    public void delete() {
        Selection sel = this.canvas.getSelection();
        int n = sel.getSelected().size();
        ArrayList<CanvasObject> select = new ArrayList<CanvasObject>(n);
        ArrayList<CanvasObject> remove = new ArrayList<CanvasObject>(n);
        Location anchorLocation = null;
        Direction anchorFacing = null;
        for (CanvasObject obj : sel.getSelected()) {
            if (obj.canRemove()) {
                remove.add(obj);
                continue;
            }
            select.add(obj);
            if (!(obj instanceof AppearanceAnchor)) continue;
            AppearanceAnchor anchor = (AppearanceAnchor)obj;
            anchorLocation = anchor.getLocation();
            anchorFacing = anchor.getFacingDirection();
        }
        if (!remove.isEmpty()) {
            this.canvas.getProject().doAction(new SelectionAction(this.canvas, Strings.S.getter("deleteSelectionAction"), remove, null, select, anchorLocation, anchorFacing));
        }
    }

    @Override
    public void duplicate() {
        Selection sel = this.canvas.getSelection();
        int n = sel.getSelected().size();
        ArrayList<CanvasObject> select = new ArrayList<CanvasObject>(n);
        ArrayList<CanvasObject> clones = new ArrayList<CanvasObject>(n);
        for (CanvasObject obj : sel.getSelected()) {
            if (obj.canRemove()) {
                CanvasObject copy = obj.clone();
                copy.translate(10, 10);
                clones.add(copy);
                select.add(copy);
                continue;
            }
            select.add(obj);
        }
        if (!clones.isEmpty()) {
            this.canvas.getProject().doAction(new SelectionAction(this.canvas, Strings.S.getter("duplicateSelectionAction"), null, clones, select, null, null));
        }
    }

    @Override
    public void lower() {
        ModelReorderAction act = ModelReorderAction.createLower(this.canvas.getModel(), this.canvas.getSelection().getSelected());
        if (act != null) {
            this.canvas.doAction(act);
        }
    }

    @Override
    public void lowerBottom() {
        ModelReorderAction act = ModelReorderAction.createLowerBottom(this.canvas.getModel(), this.canvas.getSelection().getSelected());
        if (act != null) {
            this.canvas.doAction(act);
        }
    }

    @Override
    public void modelChanged(CanvasModelEvent event) {
        this.computeEnabled();
    }

    @Override
    public void paste() {
        ClipboardContents clip = Clipboard.get();
        Collection<CanvasObject> contents = clip.getElements();
        ArrayList<CanvasObject> add = new ArrayList<CanvasObject>(contents.size());
        for (CanvasObject obj : contents) {
            add.add(obj.clone());
        }
        if (add.isEmpty()) {
            return;
        }
        List<CanvasObject> raw = this.canvas.getModel().getObjectsFromBottom();
        MatchingSet<CanvasObject> cur = new MatchingSet<CanvasObject>(raw);
        int dx = 0;
        while (true) {
            boolean allMatch = true;
            for (CanvasObject obj : add) {
                if (cur.contains(obj)) continue;
                allMatch = false;
                break;
            }
            if (!allMatch) break;
            for (CanvasObject obj : add) {
                obj.translate(10, 10);
            }
            dx += 10;
        }
        Location anchorLocation = clip.getAnchorLocation();
        if (anchorLocation != null && dx != 0) {
            anchorLocation = anchorLocation.translate(dx, dx);
        }
        this.canvas.getProject().doAction(new SelectionAction(this.canvas, Strings.S.getter("pasteClipboardAction"), null, add, add, anchorLocation, clip.getAnchorFacing()));
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String prop = e.getPropertyName();
        if (prop.equals("model")) {
            CanvasModel newModel;
            CanvasModel oldModel = (CanvasModel)e.getOldValue();
            if (oldModel != null) {
                oldModel.removeCanvasModelListener(this);
            }
            if ((newModel = (CanvasModel)e.getNewValue()) != null) {
                newModel.addCanvasModelListener(this);
            }
        }
    }

    @Override
    public void raise() {
        ModelReorderAction act = ModelReorderAction.createRaise(this.canvas.getModel(), this.canvas.getSelection().getSelected());
        if (act != null) {
            this.canvas.doAction(act);
        }
    }

    @Override
    public void raiseTop() {
        ModelReorderAction act = ModelReorderAction.createRaiseTop(this.canvas.getModel(), this.canvas.getSelection().getSelected());
        if (act != null) {
            this.canvas.doAction(act);
        }
    }

    @Override
    public void removeControlPoint() {
        Selection sel = this.canvas.getSelection();
        Handle handle = sel.getSelectedHandle();
        this.canvas.doAction(new ModelDeleteHandleAction(this.canvas.getModel(), handle));
    }

    @Override
    public void selectAll() {
        Selection sel = this.canvas.getSelection();
        sel.setSelected(this.canvas.getModel().getObjectsFromBottom(), true);
        this.canvas.repaint();
    }

    @Override
    public void selectionChanged(SelectionEvent e) {
        this.computeEnabled();
    }
}

