/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.menu;

import com.cburch.logisim.fpga.Strings;
import com.cburch.logisim.fpga.gui.BoardEditor;
import com.cburch.logisim.fpga.gui.FpgaCommander;
import com.cburch.logisim.gui.main.Frame;
import com.cburch.logisim.gui.menu.LogisimMenuBar;
import com.cburch.logisim.proj.Project;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class MenuFpga
extends JMenu
implements ActionListener {
    private final Project ThisCircuit;
    private final JMenuItem BoardEditor = new JMenuItem();
    private final JMenuItem FPGACommander = new JMenuItem();
    private BoardEditor Editor = null;
    private FpgaCommander Commander = null;

    public MenuFpga(JFrame parent, LogisimMenuBar menubar, Project proj) {
        this.ThisCircuit = proj;
        this.BoardEditor.addActionListener(this);
        this.FPGACommander.addActionListener(this);
        this.add(this.BoardEditor);
        this.add(this.FPGACommander);
        this.setEnabled(parent instanceof Frame);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.BoardEditor) {
            if (this.Editor == null) {
                this.Editor = new BoardEditor();
            } else if (!this.Editor.isActive()) {
                this.Editor.setActive();
            }
        } else if (src == this.FPGACommander) {
            if (this.Commander == null) {
                this.Commander = new FpgaCommander(this.ThisCircuit);
            }
            this.Commander.showGui();
        }
    }

    public void localeChanged() {
        this.setText(Strings.S.get("FPGAMenu"));
        this.BoardEditor.setText(Strings.S.get("FPGABoardEditor"));
        this.FPGACommander.setText(Strings.S.get("FPGACommander"));
    }
}

