/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.designrulecheck;

import com.cburch.logisim.comp.Component;
import com.cburch.logisim.fpga.data.ComponentMapInformationContainer;
import com.cburch.logisim.fpga.designrulecheck.BubbleInformationContainer;
import com.cburch.logisim.fpga.designrulecheck.ConnectionEnd;
import com.cburch.logisim.fpga.designrulecheck.ConnectionPoint;
import com.cburch.logisim.fpga.designrulecheck.Net;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.std.wiring.Pin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class netlistComponent {
    private final int nrOfEnds;
    private final Component compReference;
    private final ArrayList<ConnectionEnd> endEnds;
    final ComponentMapInformationContainer myMapInformation;
    private Map<List<String>, BubbleInformationContainer> globalIds;
    private BubbleInformationContainer localId;
    private boolean isGatedInstance = false;

    public netlistComponent(Component ref) {
        this.nrOfEnds = ref.getEnds().size();
        this.compReference = ref;
        this.endEnds = new ArrayList();
        for (int i = 0; i < ref.getEnds().size(); ++i) {
            this.endEnds.add(new ConnectionEnd(ref.getEnd(i).isOutput(), (byte)ref.getEnd(i).getWidth().getWidth(), ref));
        }
        if (ref.getAttributeSet().containsAttribute(StdAttr.MAPINFO)) {
            this.myMapInformation = ref.getAttributeSet().getValue(StdAttr.MAPINFO).clone();
        } else if (ref.getFactory() instanceof Pin) {
            int nrOfBits = ref.getEnd(0).getWidth().getWidth();
            this.myMapInformation = ref.getEnd(0).isInput() && ref.getEnd(0).isOutput() ? new ComponentMapInformationContainer(0, 0, nrOfBits) : (ref.getEnd(0).isInput() ? new ComponentMapInformationContainer(0, nrOfBits, 0) : new ComponentMapInformationContainer(nrOfBits, 0, 0));
        } else {
            this.myMapInformation = null;
        }
        this.globalIds = null;
        this.localId = null;
    }

    public void addGlobalBubbleId(List<String> hierarchyName, int inputBubblesStartId, int nrOfInputBubbles, int outputBubblesStartId, int nrOfOutputBubbles, int inOutBubblesStartId, int nrOfInOutBubbles) {
        if (nrOfInputBubbles == 0 && nrOfOutputBubbles == 0 && nrOfInOutBubbles == 0) {
            return;
        }
        if (this.globalIds == null) {
            this.globalIds = new HashMap<List<String>, BubbleInformationContainer>();
        }
        BubbleInformationContainer thisInfo = new BubbleInformationContainer();
        if (nrOfInputBubbles > 0) {
            thisInfo.setInputBubblesInformation(inputBubblesStartId, inputBubblesStartId + nrOfInputBubbles - 1);
        }
        if (nrOfInOutBubbles > 0) {
            thisInfo.setInOutBubblesInformation(inOutBubblesStartId, inOutBubblesStartId + nrOfInOutBubbles - 1);
        }
        if (nrOfOutputBubbles > 0) {
            thisInfo.setOutputBubblesInformation(outputBubblesStartId, outputBubblesStartId + nrOfOutputBubbles - 1);
        }
        this.globalIds.put(hierarchyName, thisInfo);
    }

    public boolean isEndConnected(int index) {
        if (index < 0 || index >= this.nrOfEnds) {
            return false;
        }
        boolean isConnected = false;
        ConnectionEnd ThisEnd = this.endEnds.get(index);
        for (int i = 0; i < ThisEnd.getNrOfBits(); ++i) {
            isConnected |= ThisEnd.get((byte)i).getParentNet() != null;
        }
        return isConnected;
    }

    public boolean isEndInput(int index) {
        if (index < 0 || index >= this.nrOfEnds) {
            return false;
        }
        return this.compReference.getEnd(index).isInput();
    }

    public Component getComponent() {
        return this.compReference;
    }

    public byte getConnectionBitIndex(Net rootNet, byte bitIndex) {
        for (ConnectionEnd search : this.endEnds) {
            for (byte bit = 0; bit < search.getNrOfBits(); bit = (byte)(bit + 1)) {
                ConnectionPoint connection = search.get(bit);
                if (connection.getParentNet() != rootNet || connection.getParentNetBitIndex() != bitIndex) continue;
                return bit;
            }
        }
        return -1;
    }

    public List<ConnectionPoint> getConnections(Net rootNet, byte bitIndex, boolean isOutput) {
        ArrayList<ConnectionPoint> connections = new ArrayList<ConnectionPoint>();
        for (ConnectionEnd search : this.endEnds) {
            for (byte bit = 0; bit < search.getNrOfBits(); bit = (byte)(bit + 1)) {
                ConnectionPoint connection = search.get(bit);
                if (connection.getParentNet() != rootNet || connection.getParentNetBitIndex() != bitIndex || search.isOutputEnd() != isOutput) continue;
                connections.add(connection);
            }
        }
        return connections;
    }

    public ConnectionEnd getEnd(int index) {
        if (index < 0 || index >= this.nrOfEnds) {
            return null;
        }
        return this.endEnds.get(index);
    }

    public BubbleInformationContainer getGlobalBubbleId(List<String> hierarchyName) {
        return this.globalIds == null ? null : (BubbleInformationContainer)this.globalIds.getOrDefault(hierarchyName, null);
    }

    public ComponentMapInformationContainer getMapInformationContainer() {
        return this.myMapInformation;
    }

    public int getLocalBubbleInOutEndId() {
        return this.localId == null ? 0 : this.localId.getInOutEndIndex();
    }

    public int getLocalBubbleInOutStartId() {
        return this.localId == null ? 0 : this.localId.getInOutStartIndex();
    }

    public int getLocalBubbleInputEndId() {
        return this.localId == null ? 0 : this.localId.getInputEndIndex();
    }

    public int getLocalBubbleInputStartId() {
        return this.localId == null ? 0 : this.localId.getInputStartIndex();
    }

    public int getLocalBubbleOutputEndId() {
        return this.localId == null ? 0 : this.localId.getOutputEndIndex();
    }

    public int getLocalBubbleOutputStartId() {
        return this.localId == null ? 0 : this.localId.getOutputStartIndex();
    }

    public boolean hasConnection(Net rootNet, byte bitIndex) {
        for (ConnectionEnd search : this.endEnds) {
            for (byte bit = 0; bit < search.getNrOfBits(); bit = (byte)(bit + 1)) {
                ConnectionPoint connection = search.get(bit);
                if (connection.getParentNet() != rootNet || connection.getParentNetBitIndex() != bitIndex) continue;
                return true;
            }
        }
        return false;
    }

    public int nrOfEnds() {
        return this.nrOfEnds;
    }

    public boolean setEnd(int index, ConnectionEnd End2) {
        if (index < 0 || index >= this.nrOfEnds) {
            return false;
        }
        this.endEnds.set(index, End2);
        return true;
    }

    public void setLocalBubbleID(int inputBubblesStartId, int nrOfInputBubbles, int outputBubblesStartId, int nrOfOutputBubbles, int inOutBubblesStartId, int nrOfInOutBubbles) {
        if (this.localId == null) {
            this.localId = new BubbleInformationContainer();
        }
        if (nrOfInputBubbles > 0) {
            this.localId.setInputBubblesInformation(inputBubblesStartId, inputBubblesStartId + nrOfInputBubbles - 1);
        }
        if (nrOfInOutBubbles > 0) {
            this.localId.setInOutBubblesInformation(inOutBubblesStartId, inOutBubblesStartId + nrOfInOutBubbles - 1);
        }
        if (nrOfOutputBubbles > 0) {
            this.localId.setOutputBubblesInformation(outputBubblesStartId, outputBubblesStartId + nrOfOutputBubbles - 1);
        }
    }

    public boolean isGatedInstance() {
        return this.isGatedInstance;
    }

    public void setIsGatedInstance() {
        this.isGatedInstance = true;
    }
}

