/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import com.cburch.logisim.fpga.Strings;
import java.util.LinkedList;
import java.util.List;

public class LedArrayDriving {
    public static final String LED_ARRAY_DRIVE_STRING = "LedArrayDriveMode";
    public static final char LED_DEFAULT = '\u0000';
    public static final char LED_ROW_SCANNING = '\u0001';
    public static final char LED_COLUMN_SCANNING = '\u0002';
    public static final char RGB_DEFAULT = '\u0003';
    public static final char RGB_ROW_SCANNING = '\u0004';
    public static final char RGB_COLUMN_SCANNING = '\u0005';
    public static final char UNKNOWN = '\u00ff';
    public static final String[] DRIVING_STRINGS = new String[]{"LedDefault", "LedRowScanning", "LedColumnScanning", "RgbDefault", "RgbRowScanning", "RgbColScanning"};

    public static String getConstrainedDriveMode(char id) {
        return id >= '\u0000' && id <= '\u0005' ? DRIVING_STRINGS[id] : "Unknown";
    }

    public static char getId(String identifier) {
        char result = '\u0000';
        List<String> thelist = LedArrayDriving.getStrings();
        for (String s : thelist) {
            if (s.equals(identifier)) {
                return result;
            }
            result = (char)(result + '\u0001');
        }
        return '\u00ff';
    }

    public static List<String> getStrings() {
        LinkedList<String> result = new LinkedList<String>();
        result.add(DRIVING_STRINGS[0]);
        result.add(DRIVING_STRINGS[1]);
        result.add(DRIVING_STRINGS[2]);
        result.add(DRIVING_STRINGS[3]);
        result.add(DRIVING_STRINGS[4]);
        result.add(DRIVING_STRINGS[5]);
        return result;
    }

    public static List<String> getDisplayStrings() {
        LinkedList<String> result = new LinkedList<String>();
        result.add(Strings.S.get(DRIVING_STRINGS[0]));
        result.add(Strings.S.get(DRIVING_STRINGS[1]));
        result.add(Strings.S.get(DRIVING_STRINGS[2]));
        result.add(Strings.S.get(DRIVING_STRINGS[3]));
        result.add(Strings.S.get(DRIVING_STRINGS[4]));
        result.add(Strings.S.get(DRIVING_STRINGS[5]));
        return result;
    }
}

