/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.fpga.data;

import com.cburch.draw.shapes.Rectangle;

public class BoardRectangle {
    private int xPosition;
    private int yPosition;
    private int width;
    private int height;
    private boolean isActiveHigh = true;
    private int nrBits = 0;
    private Long value = null;
    private String label;

    public BoardRectangle(int x, int y, int w, int h) {
        this.set(x, y, w, h);
    }

    public BoardRectangle(Rectangle rect) {
        this.set(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
    }

    public boolean equals(Object rectangle) {
        BoardRectangle rect;
        return rectangle instanceof BoardRectangle ? (rect = (BoardRectangle)rectangle).getHeight() == this.height && rect.getWidth() == this.width && rect.getXpos() == this.xPosition && rect.getYpos() == this.yPosition : false;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getXpos() {
        return this.xPosition;
    }

    public int getYpos() {
        return this.yPosition;
    }

    public boolean isActiveOnHigh() {
        return this.isActiveHigh;
    }

    public String getLabel() {
        return this.label;
    }

    public int getNrBits() {
        return this.nrBits;
    }

    public void setNrBits(int nr) {
        this.nrBits = nr;
    }

    public void updateRectangle(BoardRectangle other) {
        this.xPosition = other.getXpos();
        this.yPosition = other.getYpos();
        this.width = other.getWidth();
        this.height = other.getHeight();
    }

    public void updateRectangle(Rectangle other) {
        this.xPosition = other.getX();
        this.yPosition = other.getY();
        this.width = other.getWidth();
        this.height = other.getHeight();
    }

    public Boolean overlap(Rectangle rect) {
        return this.overlap(new BoardRectangle(rect));
    }

    public Boolean overlap(BoardRectangle rect) {
        int xl = rect.getXpos();
        int xr = xl + rect.getWidth();
        int yt = rect.getYpos();
        int yb = yt + rect.getHeight();
        Boolean result = this.isPointInside(xl, yt);
        result = result | this.isPointInside(xl, yb);
        result = result | this.isPointInside(xr, yt);
        result = result | this.isPointInside(xr, yb);
        result = result | rect.isPointInside(this.xPosition, this.yPosition);
        result = result | rect.isPointInside(this.xPosition + this.width, this.yPosition);
        result = result | rect.isPointInside(this.xPosition, this.yPosition + this.height);
        if (!(result = Boolean.valueOf(result | rect.isPointInside(this.xPosition + this.width, this.yPosition + this.height))).booleanValue()) {
            result = xl >= this.xPosition && xl <= this.xPosition + this.width && yt <= this.yPosition && yb >= this.yPosition + this.height;
            result = result | (xr >= this.xPosition && xr <= this.xPosition + this.width && yt <= this.yPosition && yb >= this.yPosition + this.height);
            result = result | (xl <= this.xPosition && xr >= this.xPosition + this.width && yt >= this.yPosition && yt <= this.yPosition + this.height);
            result = result | (xl <= this.xPosition && xr >= this.xPosition + this.width && yb >= this.yPosition && yb <= this.yPosition + this.height);
        }
        if (!result.booleanValue()) {
            result = this.xPosition >= xl && this.xPosition <= xr && this.yPosition <= yt && this.yPosition + this.height >= yb;
            result = result | (this.xPosition + this.width >= xl && this.xPosition + this.width <= xr && this.yPosition <= yt && this.yPosition + this.height >= yb);
            result = result | (this.xPosition <= xl && this.xPosition + this.width >= xr && this.yPosition >= yt && this.yPosition <= yb);
            result = result | (this.xPosition <= xl && this.xPosition + this.width >= xr && this.yPosition + this.height >= yt && this.yPosition + this.height <= yb);
        }
        return result;
    }

    public Boolean isPointInside(int x, int y) {
        return x >= this.xPosition && x <= this.xPosition + this.width && y >= this.yPosition && y <= this.yPosition + this.height;
    }

    private void set(int x, int y, int w, int h) {
        if (w < 0) {
            this.xPosition = x + w;
            this.width = -w;
        } else {
            this.xPosition = x;
            this.width = w;
        }
        if (h < 0) {
            this.yPosition = y + h;
            this.height = -h;
        } else {
            this.yPosition = y;
            this.height = h;
        }
    }

    public void setActiveOnHigh(boolean isActiveHigh) {
        this.isActiveHigh = isActiveHigh;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setValue(Long val) {
        this.value = val;
    }

    public Long getValue() {
        return this.value;
    }
}

