/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.file;

import com.cburch.draw.model.AbstractCanvasObject;
import com.cburch.logisim.LogisimVersion;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitMapInfo;
import com.cburch.logisim.circuit.appear.AppearanceSvgReader;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeDefaultProvider;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.file.LibraryLoader;
import com.cburch.logisim.file.LibraryManager;
import com.cburch.logisim.file.LoadedLibrary;
import com.cburch.logisim.file.Loader;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.file.MouseMappings;
import com.cburch.logisim.file.Strings;
import com.cburch.logisim.file.ToolbarData;
import com.cburch.logisim.file.XmlCircuitReader;
import com.cburch.logisim.file.XmlIterator;
import com.cburch.logisim.file.XmlReaderException;
import com.cburch.logisim.fpga.data.BoardRectangle;
import com.cburch.logisim.fpga.data.MapComponent;
import com.cburch.logisim.generated.BuildInfo;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.std.wiring.Pin;
import com.cburch.logisim.std.wiring.ProbeAttributes;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.InputEventUtil;
import com.cburch.logisim.util.LineBuffer;
import com.cburch.logisim.util.StringUtil;
import com.cburch.logisim.util.XmlUtil;
import com.cburch.logisim.vhdl.base.VhdlContent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class XmlReader {
    public static final Logger logger = LoggerFactory.getLogger(XmlReader.class);
    private final LibraryLoader loader;
    private final String srcFilePath;

    XmlReader(Loader loader, File file) {
        this.loader = loader;
        this.srcFilePath = file != null ? file.getAbsolutePath() : null;
    }

    public static void applyValidLabels(Element root, String nodeType, String attrType, Map<String, String> validLabels) throws IllegalArgumentException {
        if (root == null) {
            throw new RuntimeException("Value of 'root' cannot be null");
        }
        if (nodeType == null) {
            throw new RuntimeException("Value of 'nodeType' cannot be null");
        }
        if (attrType == null) {
            throw new RuntimeException("Value of 'attrType' cannot be null");
        }
        if (nodeType.length() == 0) {
            throw new RuntimeException("Empty string is not a valid value of 'nodeType'.");
        }
        if (attrType.length() == 0) {
            throw new RuntimeException("Empty string is not a valid value of 'attrType'.");
        }
        if (validLabels == null) {
            throw new RuntimeException("Value of 'validLabels' cannot be null");
        }
        switch (nodeType) {
            case "circuit": {
                XmlReader.replaceCircuitNodes(root, attrType, validLabels);
                break;
            }
            case "comp": {
                XmlReader.replaceCompNodes(root, validLabels);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid node type requested: " + nodeType);
            }
        }
    }

    private static void cleanupToolsLabel(Element root) {
        if (root == null) {
            throw new RuntimeException("Value of 'root' cannot be null");
        }
        for (Element toolElt : XmlIterator.forChildElements(root, "tool")) {
            for (Element attrElt : XmlIterator.forChildElements(toolElt, "a")) {
                String aName;
                if (!attrElt.hasAttribute("name") || !"label".equals(aName = attrElt.getAttribute("name"))) continue;
                attrElt.setAttribute("val", "");
            }
        }
    }

    public static Element ensureLogisimCompatibility(Element elt) {
        Map<String, String> validLabels = XmlReader.findValidLabels(elt, "circuit", "name");
        XmlReader.applyValidLabels(elt, "circuit", "name", validLabels);
        validLabels = XmlReader.findValidLabels(elt, "circuit", "label");
        XmlReader.applyValidLabels(elt, "circuit", "label", validLabels);
        validLabels = XmlReader.findValidLabels(elt, "comp", "label");
        XmlReader.applyValidLabels(elt, "comp", "label", validLabels);
        XmlReader.fixInvalidToolbarLib(elt);
        return elt;
    }

    private static void findLibraryUses(ArrayList<Element> dest, String label, Iterable<Element> candidates) {
        for (Element elt : candidates) {
            String lib = elt.getAttribute("lib");
            if (!lib.equals(label)) continue;
            dest.add(elt);
        }
    }

    public static Map<String, String> findValidLabels(Element root, String nodeType, String attrType) {
        if (root == null) {
            throw new RuntimeException("Value of 'root' cannot be null");
        }
        if (nodeType == null) {
            throw new RuntimeException("Value of 'nodeType' cannot be null");
        }
        if (attrType == null) {
            throw new RuntimeException("Value of 'attrType' cannot be null");
        }
        if (nodeType.length() == 0) {
            throw new RuntimeException("Empty string is not a valid value of 'nodeType'.");
        }
        if (attrType.length() == 0) {
            throw new RuntimeException("Empty string is not a valid value of 'attrType'.");
        }
        HashMap<String, String> validLabels = new HashMap<String, String>();
        List<String> initialLabels = XmlReader.getXMLLabels(root, nodeType, attrType);
        for (String label : initialLabels) {
            if (validLabels.containsKey(label) || !VhdlContent.labelVHDLInvalid(label)) continue;
            String initialLabel = label;
            label = XmlReader.generateValidVHDLLabel(label);
            validLabels.put(initialLabel, label);
        }
        return validLabels;
    }

    private static void fixInvalidToolbarLib(Element root) {
        if (root == null) {
            throw new RuntimeException("Value of 'root' cannot be null");
        }
        for (Element toolbarElt : XmlIterator.forChildElements(root, "toolbar")) {
            XmlReader.cleanupToolsLabel(toolbarElt);
        }
        for (Element libsElt : XmlIterator.forChildElements(root, "lib")) {
            XmlReader.cleanupToolsLabel(libsElt);
        }
    }

    public static String generateValidVHDLLabel(String initialLabel) {
        return XmlReader.generateValidVHDLLabel(initialLabel, UUID.randomUUID().toString().substring(0, 8));
    }

    public static String generateValidVHDLLabel(String initialLabel, String suffix) {
        if (initialLabel == null) {
            throw new RuntimeException("Value of 'initialLabel' cannot be null.");
        }
        Object label = initialLabel = initialLabel.trim();
        if (((String)label).isEmpty()) {
            logger.warn("Empty label is not a valid VHDL label");
            label = "L_";
        }
        if (!((String)(label = ((String)label).replaceAll("[!~]", "NOT_"))).matches("^[A-Za-z].*$")) {
            label = "L_" + (String)label;
        }
        label = ((String)label).replaceAll("\\W", "_");
        if (((String)(label = ((String)label).replaceAll("_+", "_"))).endsWith("_")) {
            label = ((String)label).substring(0, ((String)label).length() - 1);
        }
        if (!((String)label).equals(initialLabel)) {
            label = (String)label + "_" + suffix;
            label = ((String)label).replaceAll("-", "_");
        }
        return label;
    }

    public static List<String> getXMLLabels(Element root, String nodeType, String attrType) throws IllegalArgumentException {
        if (root == null) {
            throw new RuntimeException("Value of 'root' cannot be null.");
        }
        if (nodeType == null) {
            throw new RuntimeException("Value of 'nodeType' cannot be null.");
        }
        if (attrType == null) {
            throw new RuntimeException("Value of 'attrType' cannot be null.");
        }
        if (nodeType.length() == 0) {
            throw new RuntimeException("Empty string is not a valid value of 'nodeType'.");
        }
        if (attrType.length() == 0) {
            throw new RuntimeException("Empty string is not a valid value of 'attrType'.");
        }
        ArrayList<String> attrValuesList = new ArrayList<String>();
        switch (nodeType) {
            case "circuit": {
                XmlReader.inspectCircuitNodes(root, attrType, attrValuesList);
                break;
            }
            case "comp": {
                XmlReader.inspectCompNodes(root, attrValuesList);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid node type requested: " + nodeType);
            }
        }
        return attrValuesList;
    }

    private static void inspectCircuitNodes(Element root, String attrType, List<String> attrValuesList) throws IllegalArgumentException {
        if (root == null) {
            throw new RuntimeException("Value of 'root' cannot be null.");
        }
        if (attrType == null) {
            throw new RuntimeException("Value of 'attrType' cannot be null.");
        }
        if (attrValuesList == null) {
            throw new RuntimeException("Value of 'attrValuesList' cannot be null.");
        }
        switch (attrType) {
            case "name": {
                for (Element circElt : XmlIterator.forChildElements(root, "circuit")) {
                    String name = circElt.getAttribute("name");
                    attrValuesList.add(name);
                }
                break;
            }
            case "label": {
                for (Element circElt : XmlIterator.forChildElements(root, "circuit")) {
                    for (Element attrElt : XmlIterator.forChildElements(circElt, "a")) {
                        String label;
                        String aName;
                        if (!attrElt.hasAttribute("name") || !"label".equals(aName = attrElt.getAttribute("name")) || (label = attrElt.getAttribute("val")).length() <= 0) continue;
                        attrValuesList.add(label);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException(LineBuffer.format("Invalid attribute type requested: {{1}} for node type: circuit", attrType));
            }
        }
    }

    private static void inspectCompNodes(Element root, List<String> attrValuesList) {
        if (root == null) {
            throw new RuntimeException("Value of 'root' cannot be null.");
        }
        if (attrValuesList == null) {
            throw new RuntimeException("Value of 'attrValuesList' cannot be null.");
        }
        if (!attrValuesList.isEmpty()) {
            throw new RuntimeException("The 'attrValuesList' must be empty.");
        }
        for (Element circElt : XmlIterator.forChildElements(root, "circuit")) {
            for (Element compElt : XmlIterator.forChildElements(circElt, "comp")) {
                if (!compElt.hasAttribute("lib")) continue;
                for (Element attrElt : XmlIterator.forChildElements(compElt, "a")) {
                    String label;
                    String aName;
                    if (!attrElt.hasAttribute("name") || !"label".equals(aName = attrElt.getAttribute("name")) || (label = attrElt.getAttribute("val")).length() <= 0) continue;
                    attrValuesList.add(label);
                }
            }
        }
    }

    public static boolean labelVHDLInvalid(String label) {
        return !label.matches("^[A-Za-z]\\w*") || label.endsWith("_") || label.matches(".*__.*");
    }

    private static void replaceCircuitNodes(Element root, String attrType, Map<String, String> validLabels) throws IllegalArgumentException {
        if (root == null) {
            throw new RuntimeException("Value of 'root' cannot be null.");
        }
        if (attrType == null) {
            throw new RuntimeException("Value of 'attrType' cannot be null.");
        }
        if (validLabels == null) {
            throw new RuntimeException("Value of 'validLabels' cannot be null.");
        }
        if (validLabels.isEmpty()) {
            return;
        }
        switch (attrType) {
            case "name": {
                for (Element circElt : XmlIterator.forChildElements(root, "circuit")) {
                    String name = circElt.getAttribute("name");
                    if (validLabels.containsKey(name)) {
                        circElt.setAttribute("name", validLabels.get(name));
                        for (Element attrElt : XmlIterator.forChildElements(circElt, "a")) {
                            String aName;
                            if (!attrElt.hasAttribute("name") || !(aName = attrElt.getAttribute("name")).equals("circuit")) continue;
                            attrElt.setAttribute("val", validLabels.get(name));
                        }
                    }
                    for (Element compElt : XmlIterator.forChildElements(circElt, "comp")) {
                        String cName;
                        if (compElt.hasAttribute("lib") || !compElt.hasAttribute("name") || !validLabels.containsKey(cName = compElt.getAttribute("name"))) continue;
                        compElt.setAttribute("name", validLabels.get(cName));
                    }
                }
                break;
            }
            case "label": {
                for (Element circElt : XmlIterator.forChildElements(root, "circuit")) {
                    for (Element attrElt : XmlIterator.forChildElements(circElt, "a")) {
                        String label;
                        String aName;
                        if (!attrElt.hasAttribute("name") || !"label".equals(aName = attrElt.getAttribute("name")) || !validLabels.containsKey(label = attrElt.getAttribute("val"))) continue;
                        attrElt.setAttribute("val", validLabels.get(label));
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid attribute type requested: " + attrType + " for node type: circuit");
            }
        }
    }

    private static void replaceCompNodes(Element root, Map<String, String> validLabels) {
        if (root == null) {
            throw new RuntimeException("Value of 'root' cannot be null.");
        }
        if (validLabels == null) {
            throw new RuntimeException("Value of 'validLabels' cannot be null.");
        }
        if (validLabels.isEmpty()) {
            return;
        }
        for (Element circElt : XmlIterator.forChildElements(root, "circuit")) {
            for (Element compElt : XmlIterator.forChildElements(circElt, "comp")) {
                if (!compElt.hasAttribute("lib")) continue;
                for (Element attrElt : XmlIterator.forChildElements(compElt, "a")) {
                    String label;
                    String aName;
                    if (!attrElt.hasAttribute("name") || !"label".equals(aName = attrElt.getAttribute("name")) || !validLabels.containsKey(label = attrElt.getAttribute("val"))) continue;
                    attrElt.setAttribute("val", validLabels.get(label));
                }
            }
        }
    }

    private void addToLabelMap(HashMap<String, String> labelMap, String srcLabel, String dstLabel, String toolNames) {
        if (srcLabel != null && dstLabel != null) {
            for (String tool : toolNames.split(";")) {
                labelMap.put(srcLabel + ":" + tool, dstLabel);
            }
        }
    }

    private void considerRepairs(Document doc, Element root) {
        LogisimVersion version = LogisimVersion.fromString(root.getAttribute("source"));
        if (version.compareTo(new LogisimVersion(2, 3, 0)) < 0) {
            for (Element toolbar : XmlIterator.forChildElements(root, "toolbar")) {
                Object wiring = null;
                Element select = null;
                Element edit = null;
                for (Element elt : XmlIterator.forChildElements(toolbar, "tool")) {
                    String eltName = elt.getAttribute("name");
                    if (!StringUtil.isNotEmpty(eltName)) continue;
                    if (eltName.equals("Select Tool")) {
                        select = elt;
                    }
                    if (eltName.equals("Wiring Tool")) {
                        wiring = elt;
                    }
                    if (!eltName.equals("Edit Tool")) continue;
                    edit = elt;
                }
                if (select == null || wiring == null || edit != null) continue;
                select.setAttribute("name", "Edit Tool");
                toolbar.removeChild((Node)wiring);
            }
        }
        if (version.compareTo(new LogisimVersion(2, 6, 3)) < 0) {
            for (Element circElt : XmlIterator.forChildElements(root, "circuit")) {
                for (Element attrElt : XmlIterator.forChildElements(circElt, "a")) {
                    String name = attrElt.getAttribute("name");
                    if (!StringUtil.startsWith(name, "label")) continue;
                    attrElt.setAttribute("name", "c" + name);
                }
            }
            this.repairForWiringLibrary(doc, root);
            this.repairForLegacyLibrary(doc, root);
        }
        String wiringLibName = XmlReader.findLibNameByDesc(root, "#Wiring");
        for (Element compElt : XmlIterator.forDescendantElements(root, "comp")) {
            this.convertObsoletePinAttributes(doc, compElt, wiringLibName);
        }
        for (Element toolElt : XmlIterator.forDescendantElements(root, "tool")) {
            this.convertObsoletePinAttributes(doc, toolElt, wiringLibName);
        }
    }

    private void convertObsoletePinAttributes(Document doc, Element elt, String wiringLibName) {
        String lib = elt.getAttribute("lib");
        String name = elt.getAttribute("name");
        if (name == null || lib == null || !name.equals("Pin") || !lib.equals(wiringLibName)) {
            return;
        }
        String output = null;
        String tristate = null;
        String pull = null;
        String type = null;
        String behavior = null;
        ArrayList<Element> bad = new ArrayList<Element>();
        for (Element attrElt : XmlIterator.forChildElements(elt, "a")) {
            String aname = attrElt.getAttribute("name");
            String aval = attrElt.getAttribute("val");
            if ("output".equalsIgnoreCase(aname)) {
                output = aval;
                bad.add(attrElt);
                continue;
            }
            if ("tristate".equalsIgnoreCase(aname)) {
                tristate = aval;
                bad.add(attrElt);
                continue;
            }
            if ("pull".equalsIgnoreCase(aname)) {
                pull = aval;
                bad.add(attrElt);
                continue;
            }
            if ("type".equalsIgnoreCase(aname)) {
                type = aval;
                continue;
            }
            if (!"behavior".equalsIgnoreCase(aname)) continue;
            behavior = aval;
        }
        for (Element badElement : bad) {
            elt.removeChild(badElement);
        }
        if (type == null && output != null) {
            XmlReader.appendChildAttribute(doc, elt, "type", output.equalsIgnoreCase("true") ? "output" : "input");
        }
        if (behavior == null) {
            if ("up".equalsIgnoreCase(pull)) {
                XmlReader.appendChildAttribute(doc, elt, "behavior", "pullup");
            } else if ("down".equalsIgnoreCase(pull)) {
                XmlReader.appendChildAttribute(doc, elt, "behavior", "pulldown");
            } else if ("true".equalsIgnoreCase(tristate)) {
                XmlReader.appendChildAttribute(doc, elt, "behavior", "tristate");
            }
        }
    }

    private static void appendChildAttribute(Document doc, Element elt, String name, String val) {
        Element attr = doc.createElement("a");
        attr.setAttribute("name", name);
        attr.setAttribute("val", val);
        elt.appendChild(attr);
    }

    private Document loadXmlFrom(InputStream is) throws SAXException, IOException {
        DocumentBuilderFactory factory = XmlUtil.getHardenedBuilderFactory();
        factory.setNamespaceAware(true);
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return builder.parse(is);
    }

    LogisimFile readLibrary(InputStream is, Project proj) throws IOException, SAXException {
        Document doc = this.loadXmlFrom(is);
        Element elt = doc.getDocumentElement();
        elt = XmlReader.ensureLogisimCompatibility(elt);
        this.considerRepairs(doc, elt);
        LogisimFile file = new LogisimFile((Loader)this.loader);
        ReadContext context = new ReadContext(file);
        context.toLogisimFile(elt, proj);
        if (file.getCircuitCount() == 0) {
            file.addCircuit(new Circuit("main", file, proj));
        }
        if (!context.messages.isEmpty()) {
            StringBuilder all = new StringBuilder();
            for (String msg : context.messages) {
                all.append(msg).append("\n");
            }
            this.loader.showError(all.substring(0, all.length() - 1));
        }
        return file;
    }

    private void relocateTools(Element src, Element dest, HashMap<String, String> labelMap) {
        if (src == null || src == dest) {
            return;
        }
        String srcLabel = src.getAttribute("name");
        if (srcLabel == null) {
            return;
        }
        ArrayList<Element> toRemove = new ArrayList<Element>();
        for (Element elt : XmlIterator.forChildElements(src, "tool")) {
            String name = elt.getAttribute("name");
            if (name == null || !labelMap.containsKey(srcLabel + ":" + name)) continue;
            toRemove.add(elt);
        }
        for (Element elt : toRemove) {
            src.removeChild(elt);
            if (dest == null) continue;
            dest.appendChild(elt);
        }
    }

    private void repairForLegacyLibrary(Document doc, Element root) {
        Element legacyElt = null;
        String legacyLabel = null;
        for (Element libElt : XmlIterator.forChildElements(root, "lib")) {
            String desc = libElt.getAttribute("desc");
            String label = libElt.getAttribute("name");
            if (!"#Legacy".equals(desc)) continue;
            legacyElt = libElt;
            legacyLabel = label;
        }
        if (legacyElt != null) {
            root.removeChild(legacyElt);
            ArrayList<Element> toRemove = new ArrayList<Element>();
            XmlReader.findLibraryUses(toRemove, legacyLabel, XmlIterator.forDescendantElements(root, "comp"));
            boolean componentsRemoved = !toRemove.isEmpty();
            XmlReader.findLibraryUses(toRemove, legacyLabel, XmlIterator.forDescendantElements(root, "tool"));
            for (Element elt : toRemove) {
                elt.getParentNode().removeChild(elt);
            }
            if (componentsRemoved) {
                Element elt;
                String error = "Some components have been deleted. The Legacy library is not supported.";
                elt = doc.createElement("message");
                elt.setAttribute("value", "Some components have been deleted. The Legacy library is not supported.");
                root.appendChild(elt);
            }
        }
    }

    private void repairForWiringLibrary(Document doc, Element root) {
        Element newBaseElt;
        String newBaseLabel;
        Element wiringElt;
        String wiringLabel;
        Element oldBaseElt = null;
        Object oldBaseLabel = null;
        Element gatesElt = null;
        String gatesLabel = null;
        int maxLabel = -1;
        Element firstLibElt = null;
        Element lastLibElt = null;
        for (Element libElt : XmlIterator.forChildElements(root, "lib")) {
            String desc = libElt.getAttribute("desc");
            String label = libElt.getAttribute("name");
            if (desc != null) {
                switch (desc) {
                    case "#Base": {
                        oldBaseElt = libElt;
                        oldBaseLabel = label;
                        break;
                    }
                    case "#Wiring": {
                        return;
                    }
                    case "#Gates": {
                        gatesElt = libElt;
                        gatesLabel = label;
                    }
                }
            }
            if (firstLibElt == null) {
                firstLibElt = libElt;
            }
            lastLibElt = libElt;
            try {
                int thisLabel;
                if (label == null || (thisLabel = Integer.parseInt(label)) <= maxLabel) continue;
                maxLabel = thisLabel;
            }
            catch (NumberFormatException thisLabel) {}
        }
        if (oldBaseElt != null) {
            wiringLabel = oldBaseLabel;
            wiringElt = oldBaseElt;
            wiringElt.setAttribute("desc", "#Wiring");
            newBaseLabel = "" + (maxLabel + 1);
            newBaseElt = doc.createElement("lib");
            newBaseElt.setAttribute("desc", "#Base");
            newBaseElt.setAttribute("name", newBaseLabel);
            root.insertBefore(newBaseElt, lastLibElt.getNextSibling());
        } else {
            wiringLabel = "" + (maxLabel + 1);
            wiringElt = doc.createElement("lib");
            wiringElt.setAttribute("desc", "#Wiring");
            wiringElt.setAttribute("name", wiringLabel);
            root.insertBefore(wiringElt, lastLibElt.getNextSibling());
            newBaseLabel = null;
            newBaseElt = null;
        }
        HashMap<String, String> labelMap = new HashMap<String, String>();
        this.addToLabelMap(labelMap, (String)oldBaseLabel, newBaseLabel, String.join((CharSequence)";", Arrays.asList("Poke Tool", "Edit Tool", "Select Tool", "Wiring Tool", "Text Tool", "Menu Tool", "Text")));
        this.addToLabelMap(labelMap, (String)oldBaseLabel, wiringLabel, String.join((CharSequence)";", Arrays.asList("Splitter", "Pin", "Probe", "Tunnel", "Clock", "Pull Resistor", "Bit Extender")));
        this.addToLabelMap(labelMap, gatesLabel, wiringLabel, "Constant");
        this.relocateTools(oldBaseElt, newBaseElt, labelMap);
        this.relocateTools(oldBaseElt, wiringElt, labelMap);
        this.relocateTools(gatesElt, wiringElt, labelMap);
        this.updateFromLabelMap(XmlIterator.forDescendantElements(root, "comp"), labelMap);
        this.updateFromLabelMap(XmlIterator.forDescendantElements(root, "tool"), labelMap);
    }

    private void updateFromLabelMap(Iterable<Element> elts, HashMap<String, String> labelMap) {
        for (Element elt : elts) {
            String newLib;
            String oldLib = elt.getAttribute("lib");
            String name = elt.getAttribute("name");
            if (oldLib == null || name == null || (newLib = labelMap.get(oldLib + ":" + name)) == null) continue;
            elt.setAttribute("lib", newLib);
        }
    }

    private static String findLibNameByDesc(Element root, String libdesc) {
        for (Element libElt : XmlIterator.forChildElements(root, "lib")) {
            String desc = libElt.getAttribute("desc");
            String name = libElt.getAttribute("name");
            if (name == null || desc == null || !desc.equals(libdesc)) continue;
            return name;
        }
        return null;
    }

    class ReadContext {
        final LogisimFile file;
        LogisimVersion sourceVersion;
        final HashMap<String, Library> libs = new HashMap();
        private final ArrayList<String> messages;

        ReadContext(LogisimFile file) {
            this.file = file;
            this.messages = new ArrayList();
        }

        void addError(String message, String context) {
            this.messages.add(message + " [" + context + "]");
        }

        void addErrors(XmlReaderException exception, String context) {
            for (String msg : exception.getMessages()) {
                this.messages.add(msg + " [" + context + "]");
            }
        }

        Library findLibrary(String libName) throws XmlReaderException {
            if (StringUtil.isNullOrEmpty(libName)) {
                return this.file;
            }
            Library ret = this.libs.get(libName);
            if (ret == null) {
                throw new XmlReaderException(Strings.S.get("libMissingError", libName));
            }
            return ret;
        }

        void initAttributeSet(Element parent, AttributeSet attrs, AttributeDefaultProvider defaults, boolean isHolyCross, boolean isEvolution) throws XmlReaderException {
            List<Attribute<?>> attrList;
            ArrayList<String> messages = null;
            HashMap<String, String> attrsDefined = new HashMap<String, String>();
            for (Element attrElt : XmlIterator.forChildElements(parent, "a")) {
                String attrVal;
                if (!attrElt.hasAttribute("name")) {
                    if (messages == null) {
                        messages = new ArrayList<String>();
                    }
                    messages.add(Strings.S.get("attrNameMissingError"));
                    continue;
                }
                String attrName = attrElt.getAttribute("name");
                if (attrElt.hasAttribute("val")) {
                    attrVal = attrElt.getAttribute("val");
                    if ("filePath".equals(attrName)) {
                        String dirPath = "";
                        if (XmlReader.this.srcFilePath != null) {
                            dirPath = XmlReader.this.srcFilePath.substring(0, XmlReader.this.srcFilePath.lastIndexOf(File.separator));
                        }
                        Path tmp = Paths.get(dirPath, attrVal);
                        attrVal = tmp.toString();
                    }
                } else {
                    attrVal = attrElt.getTextContent();
                }
                attrsDefined.put(attrName, attrVal);
            }
            if (attrs == null) {
                return;
            }
            LogisimVersion ver = this.sourceVersion;
            boolean setDefaults = defaults != null && !defaults.isAllDefaultValues(attrs, ver);
            for (int i = 0; i < (attrList = attrs.getAttributes()).size(); ++i) {
                Object val;
                Attribute<?> attr = attrList.get(i);
                String attrName = attr.getName();
                String attrVal = (String)attrsDefined.get(attrName);
                if (attrVal == null) {
                    if (attr.equals(ProbeAttributes.PROBEAPPEARANCE)) {
                        attrs.setValue(ProbeAttributes.PROBEAPPEARANCE, StdAttr.APPEAR_CLASSIC);
                        continue;
                    }
                    if (attr.equals(StdAttr.APPEARANCE)) {
                        if (isHolyCross) {
                            attrs.setValue(StdAttr.APPEARANCE, StdAttr.APPEAR_CLASSIC);
                            continue;
                        }
                        if (isEvolution) {
                            attrs.setValue(StdAttr.APPEARANCE, StdAttr.APPEAR_EVOLUTION);
                            continue;
                        }
                        val = defaults.getDefaultAttributeValue(attr, ver);
                        if (val == null) continue;
                        attrs.setValue(attr, val);
                        continue;
                    }
                    if (!setDefaults || (val = defaults.getDefaultAttributeValue(attr, ver)) == null) continue;
                    attrs.setValue(attr, val);
                    continue;
                }
                try {
                    val = attr.parse(attrVal);
                    attrs.setValue(attr, val);
                    continue;
                }
                catch (NumberFormatException e) {
                    if (messages == null) {
                        messages = new ArrayList();
                    }
                    messages.add(Strings.S.get("attrValueInvalidError", attrVal, attrName));
                }
            }
            if (messages != null) {
                throw new XmlReaderException(messages);
            }
        }

        private void initMouseMappings(Element elt, boolean isHolyCross, boolean isEvolution) {
            MouseMappings map = this.file.getOptions().getMouseMappings();
            for (Element sub_elt : XmlIterator.forChildElements(elt, "tool")) {
                int mods;
                Tool tool;
                try {
                    tool = this.toTool(sub_elt);
                }
                catch (XmlReaderException e) {
                    this.addErrors(e, "mapping");
                    continue;
                }
                String modsStr = sub_elt.getAttribute("map");
                if (modsStr == null || "".equals(modsStr)) {
                    XmlReader.this.loader.showError(Strings.S.get("mappingMissingError"));
                    continue;
                }
                try {
                    mods = InputEventUtil.fromString(modsStr);
                }
                catch (NumberFormatException e) {
                    XmlReader.this.loader.showError(Strings.S.get("mappingBadError", modsStr));
                    continue;
                }
                tool = tool.cloneTool();
                try {
                    this.initAttributeSet(sub_elt, tool.getAttributeSet(), tool, isHolyCross, isEvolution);
                }
                catch (XmlReaderException e) {
                    this.addErrors(e, "mapping." + tool.getName());
                }
                map.setToolFor(mods, tool);
            }
        }

        private void initToolbarData(Element elt, boolean isHolyCross, boolean isEvolution) {
            ToolbarData toolbar = this.file.getOptions().getToolbarData();
            for (Element subElement : XmlIterator.forChildElements(elt)) {
                Tool tool;
                if ("sep".equals(subElement.getTagName())) {
                    toolbar.addSeparator();
                    continue;
                }
                if (!"tool".equals(subElement.getTagName())) continue;
                try {
                    tool = this.toTool(subElement);
                }
                catch (XmlReaderException e) {
                    this.addErrors(e, "toolbar");
                    continue;
                }
                if (tool == null) continue;
                tool = tool.cloneTool();
                try {
                    this.initAttributeSet(subElement, tool.getAttributeSet(), tool, isHolyCross, isEvolution);
                }
                catch (XmlReaderException e) {
                    this.addErrors(e, "toolbar." + tool.getName());
                }
                if (tool.getAttributeSet() != null) {
                    if (tool.getAttributeSet().containsAttribute(ProbeAttributes.PROBEAPPEARANCE)) {
                        tool.getAttributeSet().setValue(ProbeAttributes.PROBEAPPEARANCE, ProbeAttributes.getDefaultProbeAppearance());
                    }
                    if (tool.getAttributeSet().containsAttribute(StdAttr.APPEARANCE)) {
                        tool.getAttributeSet().setValue(StdAttr.APPEARANCE, AppPreferences.getDefaultAppearance());
                    }
                }
                toolbar.addTool(tool);
            }
        }

        private Map<Element, Component> loadKnownComponents(Element elt, boolean isHolyCross, boolean isEvolution) {
            HashMap<Element, Component> known = new HashMap<Element, Component>();
            for (Element sub : XmlIterator.forChildElements(elt, "comp")) {
                try {
                    Component comp = XmlCircuitReader.getComponent(sub, this, isHolyCross, isEvolution);
                    if (comp == null) continue;
                    known.put(sub, comp);
                }
                catch (XmlReaderException xmlReaderException) {}
            }
            return known;
        }

        void loadMap(Element board, String boardName, Circuit circ) {
            HashMap<String, CircuitMapInfo> map = new HashMap<String, CircuitMapInfo>();
            for (Element cmap : XmlIterator.forChildElements(board, "mc")) {
                String key = cmap.getAttribute("key");
                if (StringUtil.isNullOrEmpty(key)) continue;
                if (cmap.hasAttribute("open")) {
                    map.put(key, new CircuitMapInfo());
                    continue;
                }
                if (cmap.hasAttribute("vconst")) {
                    long v;
                    try {
                        v = Long.parseLong(cmap.getAttribute("vconst"));
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    map.put(key, new CircuitMapInfo(v));
                    continue;
                }
                if (cmap.hasAttribute("valx") && cmap.hasAttribute("valy") && cmap.hasAttribute("valw") && cmap.hasAttribute("valh")) {
                    int h;
                    int w;
                    int y;
                    int x;
                    try {
                        x = Integer.parseUnsignedInt(cmap.getAttribute("valx"));
                        y = Integer.parseUnsignedInt(cmap.getAttribute("valy"));
                        w = Integer.parseUnsignedInt(cmap.getAttribute("valw"));
                        h = Integer.parseUnsignedInt(cmap.getAttribute("valh"));
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    BoardRectangle br = new BoardRectangle(x, y, w, h);
                    map.put(key, new CircuitMapInfo(br));
                    continue;
                }
                CircuitMapInfo cmapi = MapComponent.getMapInfo(cmap);
                if (cmapi == null) continue;
                map.put(key, cmapi);
            }
            if (!map.isEmpty()) {
                circ.addLoadedMap(boardName, map);
            }
        }

        void loadAppearance(Element appearElt, CircuitData circData, String context) {
            ArrayList<AppearanceSvgReader.PinInfo> pins = new ArrayList<AppearanceSvgReader.PinInfo>();
            for (Component comp : circData.knownComponents.values()) {
                if (comp.getFactory() != Pin.FACTORY) continue;
                pins.add(AppearanceSvgReader.getPinInfo(comp.getLocation(), Instance.getInstanceFor(comp)));
            }
            ArrayList<AbstractCanvasObject> shapes = new ArrayList<AbstractCanvasObject>();
            for (Element sub : XmlIterator.forChildElements(appearElt)) {
                if (sub.getTagName().startsWith("visible-")) continue;
                try {
                    AbstractCanvasObject m = AppearanceSvgReader.createShape(sub, pins, null);
                    if (m == null) {
                        this.addError(Strings.S.get("fileAppearanceNotFound", sub.getTagName()), context + "." + sub.getTagName());
                        continue;
                    }
                    shapes.add(m);
                }
                catch (RuntimeException e) {
                    this.addError(Strings.S.get("fileAppearanceError", sub.getTagName()), context + "." + sub.getTagName());
                }
            }
            if (!shapes.isEmpty()) {
                if (circData.appearance == null) {
                    circData.appearance = shapes;
                } else {
                    circData.appearance.addAll(shapes);
                }
            }
        }

        private Library toLibrary(Element elt, boolean isHolyCross, boolean isEvolution) {
            if (!elt.hasAttribute("name")) {
                XmlReader.this.loader.showError(Strings.S.get("libNameMissingError"));
                return null;
            }
            if (!elt.hasAttribute("desc")) {
                XmlReader.this.loader.showError(Strings.S.get("libDescMissingError"));
                return null;
            }
            String name = elt.getAttribute("name");
            String desc = elt.getAttribute("desc");
            Library ret = XmlReader.this.loader.loadLibrary(desc);
            if (ret == null) {
                return null;
            }
            this.libs.put(name, ret);
            for (Element subElt : XmlIterator.forChildElements(elt, "tool")) {
                if (!subElt.hasAttribute("name")) {
                    XmlReader.this.loader.showError(Strings.S.get("toolNameMissingError"));
                    continue;
                }
                String toolStr = subElt.getAttribute("name");
                Tool tool = ret.getTool(toolStr);
                if (tool == null) continue;
                try {
                    this.initAttributeSet(subElt, tool.getAttributeSet(), tool, isHolyCross, isEvolution);
                }
                catch (XmlReaderException e) {
                    this.addErrors(e, "lib." + name + "." + toolStr);
                }
            }
            return ret;
        }

        private void toLogisimFile(Element elt, Project proj) {
            String name;
            String versionString = elt.getAttribute("source");
            boolean isHolyCrossFile = false;
            boolean isEvolutionFile = true;
            if ("".equals(versionString)) {
                this.sourceVersion = BuildInfo.version;
            } else {
                this.sourceVersion = LogisimVersion.fromString(versionString);
                isHolyCrossFile = versionString.endsWith("-HC");
            }
            if (this.sourceVersion.compareTo(new LogisimVersion(2, 7, 2)) < 0) {
                isEvolutionFile = true;
                OptionPane.showMessageDialog(null, "You are opening a file created with original Logisim code.\nYou might encounter some problems in the execution, since some components evolved since then.\nMoreover, labels will be converted to match VHDL limitations for variable names.", "Old file format -- compatibility mode", 2);
            }
            HashSet<Library> libsToAddAfter = new HashSet<Library>();
            HashSet<String> baseLibsToEnable = new HashSet<String>();
            HashSet<String> libsLoaded = new HashSet<String>();
            for (Element element : XmlIterator.forChildElements(elt, "lib")) {
                LoadedLibrary loadedLib;
                Library library = this.toLibrary(element, isHolyCrossFile, isEvolutionFile);
                if (library instanceof LoadedLibrary && (loadedLib = (LoadedLibrary)library).getBase() instanceof LogisimFile) {
                    libsToAddAfter.add(library);
                    continue;
                }
                if (library == null) continue;
                this.file.addLibrary(library);
                libsLoaded.add(library.getName());
            }
            for (Library library : libsToAddAfter) {
                LibraryManager.removeUnusedLibraries(library);
                baseLibsToEnable.addAll(LibraryManager.getUsedBaseLibraries(library));
            }
            Set<String> builtinLibraries = LibraryManager.getBuildinNames((Loader)XmlReader.this.loader);
            for (Library library : libsToAddAfter) {
                String libName = library.getName();
                if (!baseLibsToEnable.contains(libName) && builtinLibraries.contains(libName)) continue;
                baseLibsToEnable.remove(libName);
            }
            for (Library library : libsToAddAfter) {
                LibraryManager.removeBaseLibraries(library, baseLibsToEnable);
                this.file.addLibrary(library);
            }
            ArrayList<CircuitData> arrayList = new ArrayList<CircuitData>();
            block32: for (Element circElt : XmlIterator.forChildElements(elt)) {
                switch (circElt.getTagName()) {
                    case "vhdl": {
                        String vhdl;
                        Iterator<Element> contents;
                        name = circElt.getAttribute("name");
                        if (name == null || "".equals(name)) {
                            this.addError(Strings.S.get("circNameMissingError"), "C??");
                        }
                        if ((contents = VhdlContent.parse(name, vhdl = circElt.getTextContent(), this.file)) == null) continue block32;
                        this.file.addVhdlContent((VhdlContent)((Object)contents));
                        break;
                    }
                    case "circuit": {
                        name = circElt.getAttribute("name");
                        if (name == null || "".equals(name)) {
                            this.addError(Strings.S.get("circNameMissingError"), "C??");
                        }
                        CircuitData circData = new CircuitData(circElt, new Circuit(name, this.file, proj));
                        this.file.addCircuit(circData.circuit);
                        circData.knownComponents = this.loadKnownComponents(circElt, isHolyCrossFile, isEvolutionFile);
                        for (Element appearElt : XmlIterator.forChildElements(circElt, "appear")) {
                            this.loadAppearance(appearElt, circData, name + ".appear");
                        }
                        Iterator<Element> contents = XmlIterator.forChildElements(circElt, "boardmap").iterator();
                        while (contents.hasNext()) {
                            Element boardMap = contents.next();
                            String boardName = boardMap.getAttribute("boardname");
                            if (StringUtil.isNullOrEmpty(boardName)) continue;
                            this.loadMap(boardMap, boardName, circData.circuit);
                        }
                        arrayList.add(circData);
                        break;
                    }
                }
            }
            block35: for (Element sub_elt : XmlIterator.forChildElements(elt)) {
                switch (name = sub_elt.getTagName()) {
                    case "circuit": 
                    case "vhdl": 
                    case "lib": {
                        continue block35;
                    }
                    case "options": {
                        try {
                            this.initAttributeSet(sub_elt, this.file.getOptions().getAttributeSet(), null, isHolyCrossFile, isEvolutionFile);
                        }
                        catch (XmlReaderException e) {
                            this.addErrors(e, "options");
                        }
                        continue block35;
                    }
                    case "mappings": {
                        this.initMouseMappings(sub_elt, isHolyCrossFile, isEvolutionFile);
                        continue block35;
                    }
                    case "toolbar": {
                        this.initToolbarData(sub_elt, isHolyCrossFile, isEvolutionFile);
                        continue block35;
                    }
                    case "main": {
                        String main = sub_elt.getAttribute("name");
                        Circuit circ = this.file.getCircuit(main);
                        if (circ == null) continue block35;
                        this.file.setMainCircuit(circ);
                        continue block35;
                    }
                    case "message": {
                        this.file.addMessage(sub_elt.getAttribute("value"));
                        continue block35;
                    }
                }
                throw new IllegalArgumentException("Invalid node in logisim file: " + name);
            }
            XmlCircuitReader xmlCircuitReader = new XmlCircuitReader(this, arrayList, isHolyCrossFile, isEvolutionFile);
            xmlCircuitReader.execute();
        }

        Tool toTool(Element elt) throws XmlReaderException {
            Library lib = this.findLibrary(elt.getAttribute("lib"));
            String name = elt.getAttribute("name");
            if (name == null || "".equals(name)) {
                throw new XmlReaderException(Strings.S.get("toolNameMissing"));
            }
            Tool tool = lib.getTool(name);
            if (tool == null) {
                throw new XmlReaderException(Strings.S.get("toolNotFound"));
            }
            return tool;
        }
    }

    static class CircuitData {
        final Element circuitElement;
        final Circuit circuit;
        Map<Element, Component> knownComponents;
        List<AbstractCanvasObject> appearance;

        public CircuitData(Element circuitElement, Circuit circuit) {
            this.circuitElement = circuitElement;
            this.circuit = circuit;
        }
    }
}

