/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.file;

import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitAttributes;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.SubcircuitFactory;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.comp.ComponentFactory;
import com.cburch.logisim.data.Attribute;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.file.LibraryEvent;
import com.cburch.logisim.file.LibraryEventSource;
import com.cburch.logisim.file.LibraryListener;
import com.cburch.logisim.file.LibraryLoader;
import com.cburch.logisim.file.LoadFailedException;
import com.cburch.logisim.file.Loader;
import com.cburch.logisim.file.MouseMappings;
import com.cburch.logisim.file.Options;
import com.cburch.logisim.file.ReaderInputStream;
import com.cburch.logisim.file.Strings;
import com.cburch.logisim.file.ToolbarData;
import com.cburch.logisim.file.XmlReader;
import com.cburch.logisim.file.XmlWriter;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.Projects;
import com.cburch.logisim.tools.AddTool;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.EventSourceWeakSupport;
import com.cburch.logisim.util.UniquelyNamedThread;
import com.cburch.logisim.vhdl.base.VhdlContent;
import com.cburch.logisim.vhdl.base.VhdlEntity;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class LogisimFile
extends Library
implements LibraryEventSource,
CircuitListener {
    private final EventSourceWeakSupport<LibraryListener> listeners = new EventSourceWeakSupport();
    private final LinkedList<String> messages = new LinkedList();
    private final Options options = new Options();
    private final List<AddTool> tools = new LinkedList<AddTool>();
    private final List<Library> libraries = new LinkedList<Library>();
    private Loader loader;
    private Circuit main = null;
    private String name;
    private boolean isDirty = false;
    private boolean isAutosaveDirty = false;
    private AutosaveThread autosaveThread = null;
    private boolean autosaveLoaded = false;

    LogisimFile(Loader loader) {
        this.loader = loader;
        if (AppPreferences.AUTOSAVE_ENABLED.getBoolean()) {
            this.autosaveThread = new AutosaveThread(this);
            this.autosaveThread.start();
        }
        this.name = Strings.S.get("defaultProjectName");
        if (Projects.windowNamed(this.name)) {
            int i = 2;
            while (true) {
                if (!Projects.windowNamed(this.name + "_" + i)) {
                    this.name = this.name + "_" + i;
                    break;
                }
                ++i;
            }
        }
    }

    @Override
    public void circuitChanged(CircuitEvent event) {
        int act = event.getAction();
        if (act == 8) {
            String oldname = (String)event.getData();
            String newname = event.getCircuit().getName();
            if (this.isNameInUse(newname, event.getCircuit())) {
                OptionPane.showMessageDialog(null, "\"" + newname + "\": " + Strings.S.get("circuitNameExists"), "", 0);
                event.getCircuit().getStaticAttributes().setValue(CircuitAttributes.NAME_ATTR, oldname);
            }
        }
    }

    private boolean isNameInUse(String name, Circuit changed) {
        if (name.isEmpty()) {
            return false;
        }
        for (Library mylib : this.getLibraries()) {
            if (!this.isNameInLibraries(mylib, name)) continue;
            return true;
        }
        for (Circuit mytool : this.getCircuits()) {
            if (!name.equalsIgnoreCase(mytool.getName()) || mytool.equals(changed)) continue;
            return true;
        }
        return false;
    }

    private boolean isNameInLibraries(Library lib, String name) {
        if (name.isEmpty()) {
            return false;
        }
        for (Library library : lib.getLibraries()) {
            if (!this.isNameInLibraries(library, name)) continue;
            return true;
        }
        for (Tool tool : lib.getTools()) {
            if (!name.equalsIgnoreCase(tool.getName())) continue;
            return true;
        }
        return false;
    }

    public static LogisimFile createNew(Loader loader, Project proj) {
        LogisimFile ret = new LogisimFile(loader);
        ret.main = new Circuit("main", ret, proj);
        ret.tools.add(new AddTool(ret.main.getSubcircuitFactory()));
        return ret;
    }

    private static String getFirstLine(BufferedInputStream in) throws IOException {
        byte[] first = new byte[512];
        in.mark(first.length - 1);
        in.read(first);
        in.reset();
        int lineBreak = first.length;
        for (int i = 0; i < lineBreak; ++i) {
            if (first[i] != 10) continue;
            lineBreak = i;
        }
        return new String(first, 0, lineBreak, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogisimFile load(File file, Loader loader) throws IOException {
        Optional<File> autosave = Loader.findAutosaveFile(file);
        File loadFile = file;
        boolean autosaveLoading = false;
        if (autosave.isPresent()) {
            int res = loader.showOptions(Strings.S.get("contentHandleAutosave", file.getName()), Strings.S.get("titleHandleAutosave"), new String[]{Strings.S.get("loadOption"), Strings.S.get("discardOption")}, 0);
            if (res == -1) {
                return null;
            }
            if (res == 0) {
                loadFile = autosave.get();
                loader.setAutosavePath(autosave.get());
                autosaveLoading = true;
            } else if (res == 1) {
                autosave.get().delete();
            }
        }
        LogisimFile result = null;
        Throwable firstExcept = null;
        try (FileInputStream inputStream = new FileInputStream(loadFile);){
            result = LogisimFile.loadSub(inputStream, loader, file);
        }
        if (firstExcept != null) {
            try {
                ReaderInputStream readerInputStream = new ReaderInputStream(new FileReader(loadFile), "UTF8");
                result = LogisimFile.loadSub(readerInputStream, loader, file);
            }
            catch (Exception t) {
                firstExcept.printStackTrace();
                loader.showError(Strings.S.get("xmlFormatError", firstExcept.toString()));
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        if (result != null) {
            result.autosaveLoaded = autosaveLoading;
        }
        return result;
    }

    public static LogisimFile load(InputStream in, Loader loader) throws IOException {
        try {
            return LogisimFile.loadSub(in, loader);
        }
        catch (SAXException e) {
            e.printStackTrace();
            loader.showError(Strings.S.get("xmlFormatError", e.toString()));
            return null;
        }
    }

    public static LogisimFile loadSub(InputStream in, Loader loader) throws IOException, SAXException {
        return LogisimFile.loadSub(in, loader, null);
    }

    public static LogisimFile loadSub(InputStream in, Loader loader, File file) throws IOException, SAXException {
        BufferedInputStream inBuffered = new BufferedInputStream(in);
        String firstLine = LogisimFile.getFirstLine(inBuffered);
        if (firstLine == null) {
            throw new IOException("File is empty");
        }
        if (firstLine.equals("Logisim v1.0")) {
            throw new IOException("Version 1.0 files no longer supported");
        }
        XmlReader xmlReader = new XmlReader(loader, file);
        LogisimFile ret = xmlReader.readLibrary(inBuffered, null);
        ret.loader = loader;
        return ret;
    }

    public void addCircuit(Circuit circuit) {
        this.addCircuit(circuit, this.tools.size());
    }

    public void addCircuit(Circuit circuit, int index) {
        circuit.addCircuitListener(this);
        AddTool tool = new AddTool(circuit.getSubcircuitFactory());
        this.tools.add(index, tool);
        if (this.tools.size() == 1) {
            this.setMainCircuit(circuit);
        }
        this.fireEvent(0, tool);
    }

    public void addVhdlContent(VhdlContent content) {
        this.addVhdlContent(content, this.tools.size());
    }

    public void addVhdlContent(VhdlContent content, int index) {
        AddTool tool = new AddTool(new VhdlEntity(content));
        this.tools.add(index, tool);
        this.fireEvent(0, tool);
    }

    public void addLibrary(Library lib) {
        if (!lib.getName().equals("Base")) {
            for (Tool tool : lib.getTools()) {
                if (!(tool instanceof AddTool)) continue;
                AddTool addTool = (AddTool)tool;
                AttributeSet atrs = addTool.getAttributeSet();
                for (Attribute<?> attr : atrs.getAttributes()) {
                    if (attr != CircuitAttributes.NAME_ATTR) continue;
                    atrs.setReadOnly(attr, true);
                }
            }
        }
        this.libraries.add(lib);
        this.fireEvent(3, lib);
    }

    @Override
    public void addLibraryListener(LibraryListener what) {
        this.listeners.add(what);
    }

    public void addMessage(String msg) {
        this.messages.addLast(msg);
    }

    public LogisimFile cloneLogisimFile(Loader newloader) {
        PipedInputStream reader = new PipedInputStream();
        PipedOutputStream writer = new PipedOutputStream();
        try {
            reader.connect(writer);
        }
        catch (IOException e) {
            newloader.showError(Strings.S.get("fileDuplicateError", e.toString()));
            return null;
        }
        new WritingThread(writer, this).start();
        try {
            return LogisimFile.load(reader, newloader);
        }
        catch (IOException e) {
            newloader.showError(Strings.S.get("fileDuplicateError", e.toString()));
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    public boolean contains(Circuit circ) {
        for (AddTool tool : this.tools) {
            SubcircuitFactory factory;
            ComponentFactory componentFactory = tool.getFactory();
            if (!(componentFactory instanceof SubcircuitFactory) || (factory = (SubcircuitFactory)componentFactory).getSubcircuit() != circ) continue;
            return true;
        }
        return false;
    }

    public boolean contains(VhdlContent content) {
        for (AddTool tool : this.tools) {
            VhdlEntity factory;
            ComponentFactory componentFactory = tool.getFactory();
            if (!(componentFactory instanceof VhdlEntity) || (factory = (VhdlEntity)componentFactory).getContent() != content) continue;
            return true;
        }
        return false;
    }

    public boolean containsFactory(String name) {
        for (AddTool tool : this.tools) {
            SubcircuitFactory factory;
            VhdlEntity factory2;
            ComponentFactory componentFactory = tool.getFactory();
            if (!(componentFactory instanceof VhdlEntity ? (factory2 = (VhdlEntity)componentFactory).getContent().getName().equals(name) : (componentFactory = tool.getFactory()) instanceof SubcircuitFactory && (factory = (SubcircuitFactory)componentFactory).getSubcircuit().getName().equals(name))) continue;
            return true;
        }
        return false;
    }

    private Tool findTool(Library lib, Tool query) {
        for (Tool tool : lib.getTools()) {
            if (!tool.equals(query)) continue;
            return tool;
        }
        return null;
    }

    Tool findTool(Tool query) {
        for (Library lib : this.getLibraries()) {
            Tool ret = this.findTool(lib, query);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private void fireEvent(int action, Object data) {
        LibraryEvent e = new LibraryEvent(this, action, data);
        for (LibraryListener l : this.listeners) {
            l.libraryChanged(e);
        }
    }

    public AddTool getAddTool(Circuit circ) {
        for (AddTool tool : this.tools) {
            SubcircuitFactory factory;
            ComponentFactory componentFactory = tool.getFactory();
            if (!(componentFactory instanceof SubcircuitFactory) || (factory = (SubcircuitFactory)componentFactory).getSubcircuit() != circ) continue;
            return tool;
        }
        return null;
    }

    public AddTool getAddTool(VhdlContent content) {
        for (AddTool tool : this.tools) {
            VhdlEntity factory;
            ComponentFactory componentFactory = tool.getFactory();
            if (!(componentFactory instanceof VhdlEntity) || (factory = (VhdlEntity)componentFactory).getContent() != content) continue;
            return tool;
        }
        return null;
    }

    public Circuit getCircuit(String name) {
        if (name == null) {
            return null;
        }
        for (AddTool tool : this.tools) {
            SubcircuitFactory factory;
            ComponentFactory componentFactory = tool.getFactory();
            if (!(componentFactory instanceof SubcircuitFactory) || !name.equals((factory = (SubcircuitFactory)componentFactory).getName())) continue;
            return factory.getSubcircuit();
        }
        return null;
    }

    public VhdlContent getVhdlContent(String name) {
        if (name == null) {
            return null;
        }
        for (AddTool tool : this.tools) {
            VhdlEntity factory;
            ComponentFactory componentFactory = tool.getFactory();
            if (!(componentFactory instanceof VhdlEntity) || !name.equals((factory = (VhdlEntity)componentFactory).getName())) continue;
            return factory.getContent();
        }
        return null;
    }

    public int getCircuitCount() {
        return this.getCircuits().size();
    }

    public List<Circuit> getCircuits() {
        ArrayList<Circuit> ret = new ArrayList<Circuit>(this.tools.size());
        for (AddTool tool : this.tools) {
            ComponentFactory componentFactory = tool.getFactory();
            if (!(componentFactory instanceof SubcircuitFactory)) continue;
            SubcircuitFactory factory = (SubcircuitFactory)componentFactory;
            ret.add(factory.getSubcircuit());
        }
        return ret;
    }

    public int indexOfCircuit(Circuit circ) {
        for (int i = 0; i < this.tools.size(); ++i) {
            SubcircuitFactory factory;
            AddTool tool = this.tools.get(i);
            ComponentFactory componentFactory = tool.getFactory();
            if (!(componentFactory instanceof SubcircuitFactory) || (factory = (SubcircuitFactory)componentFactory).getSubcircuit() != circ) continue;
            return i;
        }
        return -1;
    }

    public List<VhdlContent> getVhdlContents() {
        ArrayList<VhdlContent> ret = new ArrayList<VhdlContent>(this.tools.size());
        for (AddTool tool : this.tools) {
            ComponentFactory componentFactory = tool.getFactory();
            if (!(componentFactory instanceof VhdlEntity)) continue;
            VhdlEntity factory = (VhdlEntity)componentFactory;
            ret.add(factory.getContent());
        }
        return ret;
    }

    public int indexOfVhdl(VhdlContent vhdl) {
        for (int i = 0; i < this.tools.size(); ++i) {
            VhdlEntity factory;
            AddTool tool = this.tools.get(i);
            ComponentFactory componentFactory = tool.getFactory();
            if (!(componentFactory instanceof VhdlEntity) || (factory = (VhdlEntity)componentFactory).getContent() != vhdl) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Library> getLibraries() {
        return this.libraries;
    }

    public Loader getLoader() {
        return this.loader;
    }

    public Circuit getMainCircuit() {
        return this.main;
    }

    public String getMessage() {
        return this.messages.isEmpty() ? null : this.messages.removeFirst();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Options getOptions() {
        return this.options;
    }

    public List<AddTool> getTools() {
        return this.tools;
    }

    public String getUnloadLibraryMessage(Library lib) {
        HashSet<ComponentFactory> factories = new HashSet<ComponentFactory>();
        for (Tool tool : lib.getTools()) {
            if (!(tool instanceof AddTool)) continue;
            AddTool addTool = (AddTool)tool;
            factories.add(addTool.getFactory());
        }
        for (Circuit circuit : this.getCircuits()) {
            for (Component component : circuit.getNonWires()) {
                if (!factories.contains(component.getFactory())) continue;
                return Strings.S.get("unloadUsedError", circuit.getName());
            }
        }
        ToolbarData tb = this.options.getToolbarData();
        MouseMappings mouseMappings = this.options.getMouseMappings();
        for (Tool tool : lib.getTools()) {
            if (tb.usesToolFromSource(tool)) {
                return Strings.S.get("unloadToolbarError");
            }
            if (!mouseMappings.usesToolFromSource(tool)) continue;
            return Strings.S.get("unloadMappingError");
        }
        return null;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    public void moveCircuit(AddTool tool, int index) {
        int oldIndex = this.tools.indexOf(tool);
        if (oldIndex < 0) {
            this.tools.add(index, tool);
            this.fireEvent(0, tool);
        } else {
            AddTool value = this.tools.remove(oldIndex);
            this.tools.add(index, value);
            this.fireEvent(2, tool);
        }
    }

    public void removeCircuit(Circuit circuit) {
        if (this.getCircuitCount() <= 1) {
            throw new RuntimeException("Cannot remove last circuit");
        }
        int index = this.indexOfCircuit(circuit);
        if (index >= 0) {
            Tool circuitTool = this.tools.remove(index);
            if (this.main == circuit) {
                this.setMainCircuit(((SubcircuitFactory)this.tools.get(0).getFactory()).getSubcircuit());
            }
            this.fireEvent(1, circuitTool);
        }
    }

    public void removeVhdl(VhdlContent vhdl) {
        int index = this.indexOfVhdl(vhdl);
        if (index >= 0) {
            Tool vhdlTool = this.tools.remove(index);
            this.fireEvent(1, vhdlTool);
        }
    }

    @Override
    public boolean removeLibrary(String name) {
        int index = -1;
        for (Library lib : this.libraries) {
            if (!lib.getName().equals(name)) continue;
            index = this.libraries.indexOf(lib);
        }
        if (index < 0) {
            return false;
        }
        this.libraries.remove(index);
        return true;
    }

    public void removeLibrary(Library lib) {
        this.libraries.remove(lib);
        this.fireEvent(4, lib);
    }

    @Override
    public void removeLibraryListener(LibraryListener what) {
        this.listeners.remove(what);
    }

    public void setDirty(boolean value) {
        if (this.isDirty != value) {
            this.isDirty = value;
            this.fireEvent(7, value ? Boolean.TRUE : Boolean.FALSE);
        }
        if (this.isAutosaveDirty != value) {
            this.isAutosaveDirty = value;
        }
    }

    public void setMainCircuit(Circuit circuit) {
        if (circuit == null) {
            return;
        }
        this.main = circuit;
        this.fireEvent(5, circuit);
    }

    public void setName(String name) {
        this.name = name;
        this.fireEvent(6, name);
    }

    void write(OutputStream out, LibraryLoader loader) {
        this.write(out, loader, null, null, false);
    }

    void write(OutputStream out, LibraryLoader loader, String mainCircFile) {
        this.write(out, loader, null, mainCircFile, false);
    }

    void write(OutputStream out, LibraryLoader loader, String mainCircFile, boolean recurse) {
        this.write(out, loader, null, mainCircFile, recurse);
    }

    void write(OutputStream out, LibraryLoader loader, File dest, String mainCircFile) {
        this.write(out, loader, dest, mainCircFile, false);
    }

    void write(OutputStream out, LibraryLoader loader, File dest, String mainCircFile, boolean recurse) {
        try {
            XmlWriter.write(this, out, loader, dest, mainCircFile, recurse);
        }
        catch (TransformerConfigurationException e) {
            loader.showError("internal error configuring transformer");
        }
        catch (ParserConfigurationException e) {
            loader.showError("internal error configuring parser");
        }
        catch (TransformerException e) {
            String msg = e.getMessage();
            Object err = Strings.S.get("xmlConversionError");
            if (msg == null) {
                err = (String)err + ": " + msg;
            }
            loader.showError((String)err);
        }
        catch (IOException e) {
            loader.showError("Unable to create zip file");
        }
        catch (LoadFailedException e) {
            loader.showError("Unable to create zip file");
        }
    }

    void interruptAutosaveThread() {
        if (this.autosaveThread == null) {
            return;
        }
        this.autosaveThread.interrupt();
    }

    public void stopAutosaveThread(boolean delete) {
        if (this.autosaveThread == null) {
            return;
        }
        try {
            this.autosaveThread.abort(delete);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isAutosaveLoaded() {
        return this.autosaveLoaded;
    }

    private static class AutosaveThread
    extends UniquelyNamedThread {
        private static int threadCount = 0;
        private boolean run;
        private LogisimFile file;

        public AutosaveThread(LogisimFile file) {
            super("AutosaveThread-" + threadCount++);
            this.file = file;
            this.run = true;
        }

        @Override
        public void run() {
            while (this.run) {
                try {
                    AutosaveThread.sleep(AppPreferences.AUTOSAVE_INTERVAL.get() * 1000);
                }
                catch (InterruptedException ignored) {
                    continue;
                }
                if (!this.file.isAutosaveDirty) continue;
                if (this.file.getLoader().autosave(this.file)) {
                    this.file.isAutosaveDirty = false;
                } else {
                    this.file.loader.showError(Strings.S.get("autosaveError", this.file.name));
                    this.run = false;
                }
                AutosaveThread.interrupted();
            }
        }

        public void abort(boolean delete) throws InterruptedException {
            this.run = false;
            this.interrupt();
            if (delete) {
                this.join();
                this.file.getLoader().deleteAutosave();
            }
        }
    }

    private static class WritingThread
    extends UniquelyNamedThread {
        final OutputStream out;
        final LogisimFile file;

        WritingThread(OutputStream out, LogisimFile file) {
            super("WritingThread");
            this.out = out;
            this.file = file;
        }

        @Override
        public void run() {
            this.file.write(this.out, this.file.loader);
            try {
                this.out.close();
            }
            catch (IOException e) {
                this.file.loader.showError(Strings.S.get("fileDuplicateError", e.toString()));
            }
        }
    }
}

