/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.file;

import com.cburch.logisim.file.LibraryLoader;
import com.cburch.logisim.file.LibraryManager;
import com.cburch.logisim.file.LoadFailedException;
import com.cburch.logisim.file.LoadedLibrary;
import com.cburch.logisim.file.LoaderException;
import com.cburch.logisim.file.LogisimFile;
import com.cburch.logisim.file.Strings;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.std.Builtin;
import com.cburch.logisim.tools.Library;
import com.cburch.logisim.util.JFileChoosers;
import com.cburch.logisim.util.LineBuffer;
import com.cburch.logisim.util.ZipClassLoader;
import com.cburch.logisim.vhdl.file.HdlFile;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;

public class Loader
implements LibraryLoader {
    public static final String LOGISIM_EXTENSION = ".circ";
    public static final String LOGISIM_PROJECT_BUNDLE_EXTENSION = ".lsebdl";
    public static final String LOGISIM_PROJECT_BUNDLE_INFO_FILE = "LogisimEvolutionBundle.info";
    public static final String LOGISIM_LIBRARY_DIR = "library";
    public static final String LOGISIM_CIRCUIT_DIR = "circuit";
    public static final String LOGISIM_UNNAMED_AUTOSAVE_PREFIX = ".logisim-unnamed-autosave_";
    public static final String LOGISIM_UNNAMED_AUTOSAVE_SUFFIX = ".circ.autosave";
    public static final FileFilter LOGISIM_FILTER = new LogisimFileFilter();
    public static final FileFilter LOGISIM_BUNDLE_FILTER = new LogisimProjectBundleFilter();
    public static final FileFilter LOGISIM_DIRECTORY = new LogisimDirectoryFilter();
    public static final FileFilter JAR_FILTER = new JarFileFilter();
    public static final FileFilter TXT_FILTER = new TxtFileFilter();
    public static final FileFilter TCL_FILTER = new TclFileFilter();
    public static final FileFilter VHDL_FILTER = new VhdlFileFilter();
    private Component parent;
    private final Builtin builtin = new Builtin();
    private File mainFile = null;
    private File autosaveFile = null;
    private final Stack<File> filesOpening = new Stack();
    private Map<File, File> substitutions = new HashMap<File, File>();
    private ZipOutputStream zipFile;

    public Loader(Component parent) {
        this.parent = parent;
        this.clear();
    }

    private static File determineBackupName(File base) {
        File dir = base.getParentFile();
        String name = base.getName();
        if (name.endsWith(LOGISIM_EXTENSION)) {
            name = name.substring(0, name.length() - LOGISIM_EXTENSION.length());
        }
        for (int i = 1; i <= 20; ++i) {
            Object ext = i == 1 ? ".bak" : ".bak" + i;
            File candidate = new File(dir, name + (String)ext);
            if (candidate.exists()) continue;
            return candidate;
        }
        return null;
    }

    private static File determineAutosaveName(File base) {
        if (base == null) {
            String timestamp = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").format(LocalDateTime.now());
            File candidate = new File(System.getProperty("user.home") + File.separator + LOGISIM_UNNAMED_AUTOSAVE_PREFIX + timestamp + LOGISIM_UNNAMED_AUTOSAVE_SUFFIX);
            if (!candidate.exists()) {
                return candidate;
            }
            return null;
        }
        String extension = ".autosave";
        if (!base.getName().endsWith(LOGISIM_EXTENSION)) {
            extension = LOGISIM_UNNAMED_AUTOSAVE_SUFFIX;
        }
        File dir = base.getParentFile();
        String name = "." + base.getName() + extension;
        return new File(dir, name);
    }

    static Optional<File> findAutosaveFile(File base) {
        File as = Loader.determineAutosaveName(base);
        if (as == null || !as.exists()) {
            return Optional.empty();
        }
        return Optional.of(as);
    }

    private static void recoverBackup(File backup, File dest) {
        if (backup != null && backup.exists()) {
            if (dest.exists()) {
                dest.delete();
            }
            backup.renameTo(dest);
        }
    }

    public void clear() {
        this.filesOpening.clear();
        this.mainFile = null;
    }

    public JFileChooser createChooser() {
        return JFileChoosers.createAt(this.getCurrentDirectory());
    }

    public Builtin getBuiltin() {
        return this.builtin;
    }

    public File getCurrentDirectory() {
        File ref = !this.filesOpening.empty() ? this.filesOpening.peek() : this.mainFile;
        return ref == null ? null : ref.getParentFile();
    }

    @Override
    public String getDescriptor(Library lib) {
        return LibraryManager.instance.getDescriptor(this, lib);
    }

    File getFileFor(String name, FileFilter filter) {
        File currentDirectory;
        File file = new File(name);
        if (!file.isAbsolute() && (currentDirectory = this.getCurrentDirectory()) != null) {
            file = new File(currentDirectory, name);
        }
        while (!file.canRead()) {
            OptionPane.showMessageDialog(this.parent, String.format(Strings.S.get("fileLibraryMissingError"), file.getName()));
            JFileChooser chooser = this.createChooser();
            chooser.setFileFilter(filter);
            chooser.setDialogTitle(Strings.S.get("fileLibraryMissingTitle", file.getName()));
            int action = chooser.showDialog(this.parent, Strings.S.get("fileLibraryMissingButton"));
            if (action != 0) {
                throw new LoaderException(Strings.S.get("fileLoadCanceledError"));
            }
            file = chooser.getSelectedFile();
        }
        return file;
    }

    public File getMainFile() {
        return this.mainFile;
    }

    private File getSubstitution(File source) {
        File ret = this.substitutions.get(source);
        return ret == null ? source : ret;
    }

    Library loadJarFile(File request, String className) throws LoadFailedException {
        Library ret;
        Class<?> retClass;
        File actual = this.getSubstitution(request);
        ZipClassLoader loader = new ZipClassLoader(actual);
        try {
            retClass = loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new LoadFailedException(Strings.S.get("jarClassNotFoundError", className));
        }
        if (!Library.class.isAssignableFrom(retClass)) {
            throw new LoadFailedException(Strings.S.get("jarClassNotLibraryError", className));
        }
        try {
            ret = (Library)retClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new LoadFailedException(Strings.S.get("jarLibraryNotCreatedError", className));
        }
        return ret;
    }

    public Library loadJarLibrary(File file, String className) {
        File actual = this.getSubstitution(file);
        return LibraryManager.instance.loadJarLibrary(this, actual, className);
    }

    @Override
    public Library loadLibrary(String desc) {
        return LibraryManager.instance.loadLibrary(this, desc);
    }

    LogisimFile loadLogisimFile(File request) throws LoadFailedException {
        File actual = this.getSubstitution(request);
        for (File fileOpening : this.filesOpening) {
            if (!fileOpening.equals(actual)) continue;
            throw new LoadFailedException(Strings.S.get("logisimCircularError", this.toProjectName(actual)));
        }
        LogisimFile ret = null;
        this.filesOpening.push(actual);
        try {
            ret = LogisimFile.load(actual, this);
        }
        catch (IOException e) {
            throw new LoadFailedException(Strings.S.get("logisimLoadError", this.toProjectName(actual), e.toString()));
        }
        finally {
            this.filesOpening.pop();
        }
        if (ret != null) {
            ret.setName(this.toProjectName(actual));
        }
        return ret;
    }

    public Library loadLogisimLibrary(File file) {
        File actual = this.getSubstitution(file);
        LoadedLibrary ret = LibraryManager.instance.loadLogisimLibrary(this, actual);
        if (ret != null) {
            LogisimFile retBase = (LogisimFile)ret.getBase();
            this.showMessages(retBase);
        }
        return ret;
    }

    public LogisimFile openLogisimFile(File file) throws LoadFailedException {
        try {
            LogisimFile ret = this.loadLogisimFile(file);
            if (ret == null) {
                throw new LoadFailedException("File could not be opened");
            }
            this.setMainFile(file);
            this.showMessages(ret);
            return ret;
        }
        catch (LoaderException e) {
            throw new LoadFailedException(e.getMessage(), e.isShown());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogisimFile openLogisimFile(File file, Map<File, File> substitutions) throws LoadFailedException {
        this.substitutions = substitutions;
        try {
            LogisimFile logisimFile = this.openLogisimFile(file);
            return logisimFile;
        }
        finally {
            this.substitutions = Collections.emptyMap();
        }
    }

    public LogisimFile openLogisimFile(InputStream reader) throws IOException {
        LogisimFile ret = null;
        try {
            ret = LogisimFile.load(reader, this);
        }
        catch (LoaderException e) {
            return null;
        }
        this.showMessages(ret);
        return ret;
    }

    public Library[] loadCustomStartupLibraries(String customLibraryDirectoryPath) {
        File directory = new File(customLibraryDirectoryPath);
        if (!directory.exists() || !LOGISIM_DIRECTORY.accept(directory)) {
            return new Library[0];
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return new Library[0];
        }
        ArrayList<Library> loadedLibraries = new ArrayList<Library>();
        for (File file : files) {
            if (!LOGISIM_FILTER.accept(file)) continue;
            try {
                Library library = this.loadLogisimLibrary(file);
                if (library == null || library.getLibraries().isEmpty()) continue;
                loadedLibraries.add(library);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        return loadedLibraries.toArray(new Library[0]);
    }

    public void reload(LoadedLibrary lib) {
        LibraryManager.instance.reload(this, lib);
    }

    public boolean export(LogisimFile file, ZipOutputStream zipFile, String mainFileName) {
        this.zipFile = zipFile;
        file.write(zipFile, this, mainFileName);
        this.zipFile = null;
        return true;
    }

    public boolean export(LogisimFile file, String homeDirectory) {
        try {
            String mainCircFile = LineBuffer.format("{{1}}{{2}}{{3}}{{2}}{{4}}", homeDirectory, File.separator, LOGISIM_CIRCUIT_DIR, this.getMainFile().getName());
            String libraryHome = String.format("%s%s%s", homeDirectory, File.separator, LOGISIM_LIBRARY_DIR);
            FileOutputStream fwrite = new FileOutputStream(mainCircFile);
            file.write(fwrite, this, libraryHome);
        }
        catch (IOException e) {
            System.err.println("Unable to export file");
            return false;
        }
        return true;
    }

    public ZipOutputStream getZipFile() {
        return this.zipFile;
    }

    public void setZipFile(ZipOutputStream file) {
        this.zipFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean save(LogisimFile file, File dest) {
        file.interruptAutosaveThread();
        reference = LibraryManager.instance.findReference(file, dest);
        if (reference != null) {
            OptionPane.showMessageDialog(this.parent, Strings.S.get("fileCircularError", new Object[]{reference.getDisplayName()}), Strings.S.get("fileSaveErrorTitle"), 0);
            return false;
        }
        backup = Loader.determineBackupName(dest);
        backupCreated = backup != null && dest.renameTo(backup) != false;
        fwrite = null;
        oldFile = this.getMainFile();
        try {
            this.setMainFile(dest);
            fwrite = new FileOutputStream(dest);
            file.write((OutputStream)fwrite, (LibraryLoader)this, dest, null);
            file.setName(this.toProjectName(dest));
            LibraryManager.instance.fileSaved(this, dest, oldFile, file);
            ** if (fwrite == null) goto lbl-1000
        }
        catch (IOException e) {
            block26: {
                try {
                    this.setMainFile(oldFile);
                    if (backupCreated) {
                        Loader.recoverBackup(backup, dest);
                    }
                    if (dest.exists() && dest.length() == 0L) {
                        dest.delete();
                    }
                    OptionPane.showMessageDialog(this.parent, Strings.S.get("fileSaveError", new Object[]{e.toString()}), Strings.S.get("fileSaveErrorTitle"), 0);
                    var9_10 = false;
                    if (fwrite == null) break block26;
                }
                catch (Throwable var11_12) {
                    if (fwrite != null) {
                        try {
                            fwrite.close();
                        }
                        catch (IOException e) {
                            if (backupCreated) {
                                Loader.recoverBackup(backup, dest);
                            }
                            if (dest.exists() && dest.length() == 0L) {
                                dest.delete();
                            }
                            OptionPane.showMessageDialog(this.parent, Strings.S.get("fileSaveCloseError", new Object[]{e.toString()}), Strings.S.get("fileSaveErrorTitle"), 0);
                            return false;
                        }
                    }
                    throw var11_12;
                }
                try {
                    fwrite.close();
                }
                catch (IOException e) {
                    if (backupCreated) {
                        Loader.recoverBackup(backup, dest);
                    }
                    if (dest.exists() && dest.length() == 0L) {
                        dest.delete();
                    }
                    OptionPane.showMessageDialog(this.parent, Strings.S.get("fileSaveCloseError", new Object[]{e.toString()}), Strings.S.get("fileSaveErrorTitle"), 0);
                    return false;
                }
            }
            return var9_10;
        }
lbl-1000:
        // 1 sources

        {
            try {
                fwrite.close();
            }
            catch (IOException e) {
                if (backupCreated) {
                    Loader.recoverBackup(backup, dest);
                }
                if (dest.exists() && dest.length() == 0L) {
                    dest.delete();
                }
                OptionPane.showMessageDialog(this.parent, Strings.S.get("fileSaveCloseError", new Object[]{e.toString()}), Strings.S.get("fileSaveErrorTitle"), 0);
                return false;
            }
        }
lbl-1000:
        // 1 sources

        {
        }
        if (!dest.exists() || dest.length() == 0L) {
            if (backupCreated && backup.exists()) {
                Loader.recoverBackup(backup, dest);
            } else {
                dest.delete();
            }
            OptionPane.showMessageDialog(this.parent, Strings.S.get("fileSaveZeroError"), Strings.S.get("fileSaveErrorTitle"), 0);
            return false;
        }
        if (backupCreated && backup.exists()) {
            backup.delete();
        }
        if (this.autosaveFile != null && this.autosaveFile.exists()) {
            this.deleteAutosave();
        }
        return true;
    }

    public boolean autosave(LogisimFile file) {
        File oldAutosave = this.autosaveFile;
        this.autosaveFile = Loader.determineAutosaveName(this.mainFile);
        if (this.autosaveFile == null) {
            return false;
        }
        FileOutputStream fwrite = null;
        try {
            fwrite = new FileOutputStream(this.autosaveFile);
            file.write((OutputStream)fwrite, (LibraryLoader)this, this.autosaveFile, null);
            fwrite.close();
        }
        catch (IOException e) {
            return false;
        }
        if (oldAutosave != null && !oldAutosave.equals(this.autosaveFile)) {
            oldAutosave.delete();
        }
        return true;
    }

    public boolean deleteAutosave() {
        return this.autosaveFile != null ? this.autosaveFile.delete() : false;
    }

    private void setMainFile(File value) {
        this.mainFile = value;
    }

    public void setParent(Component value) {
        this.parent = value;
    }

    @Override
    public void showError(String description) {
        if (!this.filesOpening.empty()) {
            File top = this.filesOpening.peek();
            String init = this.toProjectName(top) + ":";
            String sep = ((String)description).contains("\n") ? "\n" : " ";
            description = init + sep + (String)description;
        }
        if (((String)description).contains("\n") || ((String)description).length() > 60) {
            int lines = 1;
            int pos = ((String)description).indexOf(10);
            while (pos >= 0) {
                ++lines;
                pos = ((String)description).indexOf(10, pos + 1);
            }
            lines = Math.max(4, Math.min(lines, 7));
            JTextArea textArea = new JTextArea(lines, 60);
            textArea.setEditable(false);
            textArea.setText((String)description);
            textArea.setCaretPosition(0);
            JScrollPane scrollPane = new JScrollPane(textArea);
            scrollPane.setPreferredSize(new Dimension(350, 150));
            OptionPane.showMessageDialog(this.parent, scrollPane, Strings.S.get("fileErrorTitle"), 0);
        } else {
            OptionPane.showMessageDialog(this.parent, description, Strings.S.get("fileErrorTitle"), 0);
        }
    }

    private void showMessages(LogisimFile source) {
        if (source == null) {
            return;
        }
        String message = source.getMessage();
        while (message != null) {
            OptionPane.showMessageDialog(this.parent, message, Strings.S.get("fileMessageTitle"), 1);
            message = source.getMessage();
        }
    }

    public int showOptions(String message, String title, String[] options, int initialSelection) {
        return OptionPane.showOptionDialog(this.parent, message, title, -1, 3, null, options, options[initialSelection % options.length]);
    }

    private String toProjectName(File file) {
        String ret = file.getName();
        return ret.endsWith(LOGISIM_EXTENSION) ? ret.substring(0, ret.length() - LOGISIM_EXTENSION.length()) : ret;
    }

    public String vhdlImportChooser(Component window) {
        JFileChooser chooser = this.createChooser();
        chooser.setFileFilter(VHDL_FILTER);
        chooser.setDialogTitle(Strings.S.get("hdlOpenDialog"));
        int returnVal = chooser.showOpenDialog(window);
        if (returnVal != 0) {
            return null;
        }
        File selected = chooser.getSelectedFile();
        if (selected == null) {
            return null;
        }
        try {
            return HdlFile.load(selected);
        }
        catch (IOException e) {
            OptionPane.showMessageDialog(window, e.getMessage(), Strings.S.get("hexOpenErrorTitle"), 0);
            return null;
        }
    }

    public void setAutosavePath(File f) {
        this.autosaveFile = new File(f.getParent(), f.getName());
    }

    private static class LogisimFileFilter
    extends FileFilter {
        private LogisimFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(Loader.LOGISIM_EXTENSION);
        }

        @Override
        public String getDescription() {
            return Strings.S.get("logisimFileFilter");
        }
    }

    private static class LogisimProjectBundleFilter
    extends FileFilter {
        private LogisimProjectBundleFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(Loader.LOGISIM_PROJECT_BUNDLE_EXTENSION);
        }

        @Override
        public String getDescription() {
            return Strings.S.get("logisimProjectBundleFilter");
        }
    }

    private static class LogisimDirectoryFilter
    extends FileFilter {
        private LogisimDirectoryFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }

        @Override
        public String getDescription() {
            return Strings.S.get("logisimDirectoryFilter");
        }
    }

    private static class JarFileFilter
    extends FileFilter {
        private JarFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".jar");
        }

        @Override
        public String getDescription() {
            return Strings.S.get("jarFileFilter");
        }
    }

    private static class TxtFileFilter
    extends FileFilter {
        private TxtFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".txt");
        }

        @Override
        public String getDescription() {
            return Strings.S.get("txtFileFilter");
        }
    }

    private static class TclFileFilter
    extends FileFilter {
        private TclFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".tcl");
        }

        @Override
        public String getDescription() {
            return Strings.S.get("tclFileFilter");
        }
    }

    private static class VhdlFileFilter
    extends FileFilter {
        private VhdlFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(".vhd") || f.getName().endsWith(".vhdl");
        }

        @Override
        public String getDescription() {
            return Strings.S.get("vhdlFileFilter");
        }
    }
}

