/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.data;

import com.cburch.logisim.circuit.CircuitWires;
import com.cburch.logisim.data.BitWidth;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.util.Cache;
import java.awt.Color;
import java.util.Arrays;

public final class Value {
    public static char TRUECHAR = AppPreferences.TRUE_CHAR.get().charAt(0);
    public static char FALSECHAR = AppPreferences.FALSE_CHAR.get().charAt(0);
    public static char UNKNOWNCHAR = AppPreferences.UNKNOWN_CHAR.get().charAt(0);
    public static char ERRORCHAR = AppPreferences.ERROR_CHAR.get().charAt(0);
    public static char DONTCARECHAR = AppPreferences.DONTCARE_CHAR.get().charAt(0);
    public static final Value FALSE = new Value(1, 0L, 0L, 0L);
    public static final Value TRUE = new Value(1, 0L, 0L, 1L);
    public static final Value UNKNOWN = new Value(1, 0L, 1L, 0L);
    public static final Value ERROR = new Value(1, 1L, 0L, 0L);
    public static final Value NIL = new Value(0, 0L, 0L, 0L);
    public static final int MAX_WIDTH = 64;
    public static Color falseColor = new Color(AppPreferences.FALSE_COLOR.get());
    public static Color trueColor = new Color(AppPreferences.TRUE_COLOR.get());
    public static Color unknownColor = new Color(AppPreferences.UNKNOWN_COLOR.get());
    public static Color errorColor = new Color(AppPreferences.ERROR_COLOR.get());
    public static Color nilColor = new Color(AppPreferences.NIL_COLOR.get());
    public static Color strokeColor = new Color(AppPreferences.STROKE_COLOR.get());
    public static Color multiColor = new Color(AppPreferences.BUS_COLOR.get());
    public static Color widthErrorColor = new Color(AppPreferences.WIDTH_ERROR_COLOR.get());
    public static Color widthErrorCaptionColor = new Color(AppPreferences.WIDTH_ERROR_CAPTION_COLOR.get());
    public static Color widthErrorHighlightColor = new Color(AppPreferences.WIDTH_ERROR_HIGHLIGHT_COLOR.get());
    public static Color widthErrorCaptionBgcolor = new Color(AppPreferences.WIDTH_ERROR_BACKGROUND_COLOR.get());
    public static Color clockFrequencyColor = new Color(AppPreferences.CLOCK_FREQUENCY_COLOR.get());
    private static final Cache cache = new Cache();
    private final int width;
    private final long error;
    private final long unknown;
    private final long value;

    private static Value create(int width, long error, long unknown, long value) {
        if (width == 0) {
            return NIL;
        }
        if (width == 1) {
            if ((error & 1L) != 0L) {
                return ERROR;
            }
            if ((unknown & 1L) != 0L) {
                return UNKNOWN;
            }
            if ((value & 1L) != 0L) {
                return TRUE;
            }
            return FALSE;
        }
        long mask = width == 64 ? -1L : -1L << width ^ 0xFFFFFFFFFFFFFFFFL;
        int hashCode = Value.hashcode(width, error, unknown = unknown & mask & ((error &= mask) ^ 0xFFFFFFFFFFFFFFFFL), value = value & mask & (unknown ^ 0xFFFFFFFFFFFFFFFFL) & (error ^ 0xFFFFFFFFFFFFFFFFL));
        Object cached = cache.get(hashCode);
        if (cached != null) {
            Value val = (Value)cached;
            if (val.value == value && val.width == width && val.error == error && val.unknown == unknown) {
                return val;
            }
        }
        Value ret = new Value(width, error, unknown, value);
        cache.put(hashCode, ret);
        return ret;
    }

    public static Value create_unsafe(int width, long error, long unknown, long value) {
        int hashCode = Value.hashcode(width, error, unknown, value);
        Object obj = cache.get(hashCode);
        if (obj != null) {
            Value val = (Value)obj;
            if (val.value == value && val.width == width && val.error == error && val.unknown == unknown) {
                return val;
            }
        }
        Value ret = new Value(width, error, unknown, value);
        cache.put(hashCode, ret);
        return ret;
    }

    public static Value create(Value[] values) {
        if (values.length == 0) {
            return NIL;
        }
        if (values.length == 1) {
            return values[0];
        }
        if (values.length > 64) {
            throw new RuntimeException("Cannot have more than 64 bits in a value");
        }
        int width = values.length;
        long value = 0L;
        long unknown = 0L;
        long error = 0L;
        for (int i = 0; i < values.length; ++i) {
            long mask = 1L << i;
            if (values[i] == TRUE) {
                value |= mask;
                continue;
            }
            if (values[i] == FALSE) continue;
            if (values[i] == UNKNOWN) {
                unknown |= mask;
                continue;
            }
            if (values[i] == ERROR) {
                error |= mask;
                continue;
            }
            throw new RuntimeException("unrecognized value " + String.valueOf(values[i]));
        }
        return Value.create(width, error, unknown, value);
    }

    public static Value createError(BitWidth bits) {
        return Value.create(bits.getWidth(), -1L, 0L, 0L);
    }

    public static Value createUnknown(BitWidth bits) {
        return Value.create(bits.getWidth(), 0L, -1L, 0L);
    }

    public static Value createKnown(BitWidth bits, long value) {
        return Value.create(bits.getWidth(), 0L, 0L, value);
    }

    public static Value createKnown(float value) {
        return Value.create(32, 0L, 0L, Float.floatToIntBits(value));
    }

    public static Value createKnown(double value) {
        return Value.create(64, 0L, 0L, Double.doubleToLongBits(value));
    }

    public static Value createKnown(int bits, long value) {
        return Value.create(bits, 0L, 0L, value);
    }

    public static Value fromLogString(BitWidth width, String t) throws Exception {
        int radix = Value.radixOfLogString(width, t);
        int offset = radix == 16 || radix == 8 ? 2 : (radix == 10 && t.startsWith("-") ? 1 : 0);
        int n = t.length();
        if (n <= offset) {
            throw new Exception("expected digits");
        }
        int w = width.getWidth();
        long value = 0L;
        long unknown = 0L;
        for (int i = offset; i < n; ++i) {
            int d;
            char c = t.charAt(i);
            if (c == 'x' && radix != 10) {
                d = -1;
            } else if ('0' <= c && c <= '9') {
                d = c - 48;
            } else if ('a' <= c && c <= 'f') {
                d = 10 + (c - 97);
            } else if ('A' <= c && c <= 'F') {
                d = 10 + (c - 65);
            } else {
                throw new Exception("Unexpected character '" + t.charAt(i) + "' in \"" + t + "\"");
            }
            if (d >= radix) {
                throw new Exception("Unexpected character '" + t.charAt(i) + "' in \"" + t + "\"");
            }
            value *= (long)radix;
            unknown *= (long)radix;
            if (radix != 10) {
                if (d == -1) {
                    unknown |= (long)(radix - 1);
                    continue;
                }
                value |= (long)d;
                continue;
            }
            if (d == -1) {
                unknown += (long)(radix - 1);
                continue;
            }
            value += (long)d;
        }
        if (radix == 10 && t.charAt(0) == '-') {
            value = -value;
        }
        if (w == 64 ? (value & Long.MAX_VALUE) >> w - 1 != 0L : value >> w != 0L) {
            throw new Exception("Too many bits in \"" + t + "\"");
        }
        return Value.create(w, 0L, unknown &= (1L << w) - 1L, value);
    }

    public static int radixOfLogString(BitWidth width, String t) {
        if (t.startsWith("0x")) {
            return 16;
        }
        if (t.startsWith("0o")) {
            return 8;
        }
        if (t.length() == width.getWidth()) {
            return 2;
        }
        return 10;
    }

    public static Value repeat(Value base, BitWidth width) {
        return Value.repeat(base, width.getWidth());
    }

    public static Value repeat(Value base, int bits) {
        if (base.getWidth() != 1) {
            throw new IllegalArgumentException("first parameter must be one bit");
        }
        if (bits == 1) {
            return base;
        }
        Object[] ret = new Value[bits];
        Arrays.fill(ret, base);
        return Value.create((Value[])ret);
    }

    private static int hashcode(int width, long error, long unknown, long value) {
        int hashCode = width;
        hashCode = 31 * hashCode + (int)(error ^ error >>> 32);
        hashCode = 31 * hashCode + (int)(unknown ^ unknown >>> 32);
        hashCode = 31 * hashCode + (int)(value ^ value >>> 32);
        return hashCode;
    }

    private Value(int width, long error, long unknown, long value) {
        this.width = width;
        this.error = error;
        this.unknown = unknown;
        this.value = value;
    }

    public Value and(Value other) {
        if (other == null) {
            return this;
        }
        if (this.width == 1 && other.width == 1) {
            if (this == FALSE || other == FALSE) {
                return FALSE;
            }
            if (this == TRUE && other == TRUE) {
                return TRUE;
            }
            return ERROR;
        }
        long false0 = (this.value ^ 0xFFFFFFFFFFFFFFFFL) & (this.error ^ 0xFFFFFFFFFFFFFFFFL) & (this.unknown ^ 0xFFFFFFFFFFFFFFFFL);
        long false1 = (other.value ^ 0xFFFFFFFFFFFFFFFFL) & (other.error ^ 0xFFFFFFFFFFFFFFFFL) & (other.unknown ^ 0xFFFFFFFFFFFFFFFFL);
        long falses = false0 | false1;
        return Value.create(Math.max(this.width, other.width), (this.error | other.error | this.unknown | other.unknown) & (falses ^ 0xFFFFFFFFFFFFFFFFL), 0L, this.value & other.value);
    }

    public Value controls(Value other) {
        if (other == null) {
            return null;
        }
        if (this.width == 1) {
            if (this == FALSE) {
                return Value.create(other.width, 0L, -1L, 0L);
            }
            if (this == TRUE || this == UNKNOWN) {
                return other;
            }
            return Value.create(other.width, -1L, 0L, 0L);
        }
        if (this.width != other.width) {
            return Value.create(other.width, -1L, 0L, 0L);
        }
        long enabled = (this.value | this.unknown) & (this.error ^ 0xFFFFFFFFFFFFFFFFL);
        long disabled = (this.value ^ 0xFFFFFFFFFFFFFFFFL) & (this.unknown ^ 0xFFFFFFFFFFFFFFFFL) & (this.error ^ 0xFFFFFFFFFFFFFFFFL);
        return Value.create(other.width, this.error | other.error & (disabled ^ 0xFFFFFFFFFFFFFFFFL), disabled | other.unknown, enabled & other.value);
    }

    public Value combine(Value other) {
        if (other == null) {
            return this;
        }
        if (this == NIL) {
            return other;
        }
        if (other == NIL) {
            return this;
        }
        if (this.width == 1 && other.width == 1) {
            if (this == other) {
                return this;
            }
            if (this == UNKNOWN) {
                return other;
            }
            if (other == UNKNOWN) {
                return this;
            }
            return ERROR;
        }
        if (this.width == other.width) {
            long disagree = (this.value ^ other.value) & ((this.unknown | other.unknown) ^ 0xFFFFFFFFFFFFFFFFL);
            return Value.create(this.width, this.error | other.error | disagree, this.unknown & other.unknown, this.value | other.value);
        }
        long thisKnown = (this.unknown ^ 0xFFFFFFFFFFFFFFFFL) & (long)(this.width == 64 ? -1 : ~(-1 << this.width));
        long otherKnown = (other.unknown ^ 0xFFFFFFFFFFFFFFFFL) & (long)(other.width == 64 ? -1 : ~(-1 << other.width));
        long disagree = (this.value ^ other.value) & thisKnown & otherKnown;
        return Value.create(Math.max(this.width, other.width), this.error | other.error | disagree, (thisKnown ^ 0xFFFFFFFFFFFFFFFFL) & (otherKnown ^ 0xFFFFFFFFFFFFFFFFL), this.value | other.value);
    }

    public static Value combineLikeWidths(int width, CircuitWires.BusConnection[] vals) {
        int n = vals.length;
        for (int i = 0; i < n; ++i) {
            Value v = vals[i].drivenValue;
            if (v == null || v == NIL) continue;
            long error = v.error;
            long unknown = v.unknown;
            long value = v.value;
            for (int j = i + 1; j < n; ++j) {
                v = vals[j].drivenValue;
                if (v == null || v == NIL) continue;
                if (v.width != width) {
                    throw new IllegalArgumentException("INTERNAL ERROR: mismatched widths in Value.combineLikeWidths");
                }
                long disagree = (value ^ v.value) & ((unknown | v.unknown) ^ 0xFFFFFFFFFFFFFFFFL);
                error |= v.error | disagree;
                unknown &= v.unknown;
                value |= v.value;
            }
            return Value.create(width, error, unknown, value);
        }
        return Value.createUnknown(BitWidth.create(width));
    }

    public boolean compatible(Value other) {
        return this.width == other.width && this.error == other.error && this.value == (other.value & (this.unknown ^ 0xFFFFFFFFFFFFFFFFL)) && this.unknown == (other.unknown | this.unknown);
    }

    public boolean equals(Object otherObj) {
        boolean bl;
        if (otherObj instanceof Value) {
            Value other = (Value)otherObj;
            bl = this.width == other.width && this.error == other.error && this.unknown == other.unknown && this.value == other.value;
        } else {
            bl = false;
        }
        return bl;
    }

    public Value extendWidth(int newWidth, Value others) {
        long maskInverse;
        if (this.width == newWidth) {
            return this;
        }
        long l = maskInverse = this.width == 64 ? 0L : -1L << this.width;
        if (others == ERROR) {
            return Value.create(newWidth, this.error | maskInverse, this.unknown, this.value);
        }
        if (others == FALSE) {
            return Value.create(newWidth, this.error, this.unknown, this.value);
        }
        if (others == TRUE) {
            return Value.create(newWidth, this.error, this.unknown, this.value | maskInverse);
        }
        return Value.create(newWidth, this.error, this.unknown | maskInverse, this.value);
    }

    public Value get(int which) {
        if (which < 0 || which >= this.width) {
            return ERROR;
        }
        long mask = 1L << which;
        if ((this.error & mask) != 0L) {
            return ERROR;
        }
        if ((this.unknown & mask) != 0L) {
            return UNKNOWN;
        }
        if ((this.value & mask) != 0L) {
            return TRUE;
        }
        return FALSE;
    }

    public Value[] getAll() {
        Value[] ret = new Value[this.width];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.get(i);
        }
        return ret;
    }

    public BitWidth getBitWidth() {
        return BitWidth.create(this.width);
    }

    public Color getColor() {
        if (this.error != 0L) {
            return errorColor;
        }
        if (this.width == 0) {
            return nilColor;
        }
        if (this.width == 1) {
            if (this == UNKNOWN) {
                return unknownColor;
            }
            if (this == TRUE) {
                return trueColor;
            }
            return falseColor;
        }
        return multiColor;
    }

    public int getWidth() {
        return this.width;
    }

    public int hashCode() {
        return Value.hashcode(this.width, this.error, this.unknown, this.value);
    }

    public boolean isErrorValue() {
        return this.error != 0L;
    }

    public boolean isFullyDefined() {
        return this.width > 0 && this.error == 0L && this.unknown == 0L;
    }

    public boolean isUnknown() {
        if (this.width == 64) {
            return this.error == 0L && this.unknown == -1L;
        }
        return this.error == 0L && this.unknown == (1L << this.width) - 1L;
    }

    public Value not() {
        if (this.width <= 1) {
            if (this == TRUE) {
                return FALSE;
            }
            if (this == FALSE) {
                return TRUE;
            }
            return ERROR;
        }
        return Value.create(this.width, this.error | this.unknown, 0L, this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public Value or(Value other) {
        if (other == null) {
            return this;
        }
        if (this.width == 1 && other.width == 1) {
            if (this == TRUE || other == TRUE) {
                return TRUE;
            }
            if (this == FALSE && other == FALSE) {
                return FALSE;
            }
            return ERROR;
        }
        long true0 = this.value & (this.error ^ 0xFFFFFFFFFFFFFFFFL) & (this.unknown ^ 0xFFFFFFFFFFFFFFFFL);
        long true1 = other.value & (other.error ^ 0xFFFFFFFFFFFFFFFFL) & (other.unknown ^ 0xFFFFFFFFFFFFFFFFL);
        long trues = true0 | true1;
        return Value.create(Math.max(this.width, other.width), (this.error | other.error | this.unknown | other.unknown) & (trues ^ 0xFFFFFFFFFFFFFFFFL), 0L, this.value | other.value);
    }

    public Value set(int which, Value val) {
        if (val.width != 1) {
            throw new RuntimeException("Cannot set multiple values");
        }
        if (which < 0 || which >= this.width) {
            throw new RuntimeException("Attempt to set outside value's width");
        }
        if (this.width == 1) {
            return val;
        }
        long mask = 1L << which ^ 0xFFFFFFFFFFFFFFFFL;
        return Value.create(this.width, this.error & mask | val.error << which, this.unknown & mask | val.unknown << which, this.value & mask | val.value << which);
    }

    public String toBinaryString() {
        switch (this.width) {
            case 0: {
                return Character.toString(DONTCARECHAR);
            }
            case 1: {
                if (this.error != 0L) {
                    return Character.toString(ERRORCHAR);
                }
                if (this.unknown != 0L) {
                    return Character.toString(UNKNOWNCHAR);
                }
                if (this.value != 0L) {
                    return Character.toString(TRUECHAR);
                }
                return Character.toString(FALSECHAR);
            }
        }
        StringBuilder ret = new StringBuilder();
        for (int i = this.width - 1; i >= 0; --i) {
            ret.append(this.get(i).toString());
        }
        return ret.toString();
    }

    public String toDecimalString(boolean signed) {
        if (this.width == 0) {
            return Character.toString(DONTCARECHAR);
        }
        if (this.isErrorValue()) {
            return Character.toString(ERRORCHAR);
        }
        if (!this.isFullyDefined()) {
            return Character.toString(UNKNOWNCHAR);
        }
        long mask = -1L >>> 64 - this.width;
        long val = this.toLongValue() & mask;
        if (signed) {
            boolean isNegative;
            boolean bl = isNegative = val >> this.width - 1 != 0L;
            if (isNegative) {
                val |= mask ^ 0xFFFFFFFFFFFFFFFFL;
            }
            return Long.toString(val);
        }
        return Long.toUnsignedString(val);
    }

    public String toDisplayString() {
        switch (this.width) {
            case 0: {
                return Character.toString(DONTCARECHAR);
            }
            case 1: {
                if (this.error != 0L) {
                    return Character.toString(ERRORCHAR);
                }
                if (this.unknown != 0L) {
                    return Character.toString(UNKNOWNCHAR);
                }
                if (this.value != 0L) {
                    return Character.toString(TRUECHAR);
                }
                return Character.toString(FALSECHAR);
            }
        }
        StringBuilder ret = new StringBuilder();
        for (int i = this.width - 1; i >= 0; --i) {
            ret.append(this.get(i).toString());
            if (i % 4 != 0 || i == 0) continue;
            ret.append(" ");
        }
        return ret.toString();
    }

    public String toDisplayString(int radix) {
        switch (radix) {
            case 2: {
                return this.toDisplayString();
            }
            case 8: {
                return this.toOctalString();
            }
            case 16: {
                return this.toHexString();
            }
        }
        if (this.width == 0) {
            return Character.toString(DONTCARECHAR);
        }
        if (this.isErrorValue()) {
            return Character.toString(ERRORCHAR);
        }
        if (!this.isFullyDefined()) {
            return Character.toString(UNKNOWNCHAR);
        }
        return Long.toString(this.toLongValue(), radix);
    }

    public String toHexString() {
        if (this.width <= 1) {
            return this.toString();
        }
        Value[] vals = this.getAll();
        char[] c = new char[(vals.length + 3) / 4];
        for (int i = 0; i < c.length; ++i) {
            int k = c.length - 1 - i;
            int frst = 4 * k;
            int last = Math.min(vals.length, 4 * (k + 1));
            int v = 0;
            c[i] = 32;
            for (int j = last - 1; j >= frst; --j) {
                if (vals[j] == ERROR) {
                    c[i] = ERRORCHAR;
                    break;
                }
                if (vals[j] == UNKNOWN) {
                    c[i] = UNKNOWNCHAR;
                    break;
                }
                v = 2 * v;
                if (vals[j] != TRUE) continue;
                ++v;
            }
            if (c[i] != ' ') continue;
            c[i] = Character.forDigit(v, 16);
        }
        return new String(c);
    }

    public long toLongValue() {
        if (this.error != 0L) {
            return -1L;
        }
        if (this.unknown != 0L) {
            return -1L;
        }
        return this.value;
    }

    public float toFloatValue() {
        if (this.error != 0L || this.unknown != 0L || this.width != 32) {
            return Float.NaN;
        }
        return Float.intBitsToFloat((int)this.value);
    }

    public double toDoubleValue() {
        if (this.error != 0L || this.unknown != 0L || this.width != 64) {
            return Double.NaN;
        }
        return Double.longBitsToDouble(this.value);
    }

    public float toFloatValueFromFP16() {
        if (this.error != 0L || this.unknown != 0L || this.width != 16) {
            return Float.NaN;
        }
        return Float.float16ToFloat((short)this.value);
    }

    public String toStringFromFloatValue() {
        return switch (this.getWidth()) {
            case 16 -> String.format("%.4g", Float.valueOf(this.toFloatValueFromFP16()));
            case 32 -> Float.toString(this.toFloatValue());
            case 64 -> Double.toString(this.toDoubleValue());
            default -> "NaN";
        };
    }

    public String toOctalString() {
        if (this.width <= 1) {
            return this.toString();
        }
        Value[] vals = this.getAll();
        char[] c = new char[(vals.length + 2) / 3];
        for (int i = 0; i < c.length; ++i) {
            int k = c.length - 1 - i;
            int frst = 3 * k;
            int last = Math.min(vals.length, 3 * (k + 1));
            int v = 0;
            c[i] = 32;
            for (int j = last - 1; j >= frst; --j) {
                if (vals[j] == ERROR) {
                    c[i] = ERRORCHAR;
                    break;
                }
                if (vals[j] == UNKNOWN) {
                    c[i] = UNKNOWNCHAR;
                    break;
                }
                v = 2 * v;
                if (vals[j] != TRUE) continue;
                ++v;
            }
            if (c[i] != ' ') continue;
            c[i] = Character.forDigit(v, 8);
        }
        return new String(c);
    }

    public String toString() {
        switch (this.width) {
            case 0: {
                return Character.toString(DONTCARECHAR);
            }
            case 1: {
                if (this.error != 0L) {
                    return Character.toString(ERRORCHAR);
                }
                if (this.unknown != 0L) {
                    return Character.toString(UNKNOWNCHAR);
                }
                if (this.value != 0L) {
                    return Character.toString(TRUECHAR);
                }
                return Character.toString(FALSECHAR);
            }
        }
        StringBuilder ret = new StringBuilder();
        for (int i = this.width - 1; i >= 0; --i) {
            ret.append(this.get(i).toString());
            if (i % 4 != 0 || i == 0) continue;
            ret.append(" ");
        }
        return ret.toString();
    }

    public Value xor(Value other) {
        if (other == null) {
            return this;
        }
        if (this.width <= 1 && other.width <= 1) {
            if (this == ERROR || other == ERROR) {
                return ERROR;
            }
            if (this == UNKNOWN || other == UNKNOWN) {
                return ERROR;
            }
            if (this == NIL || other == NIL) {
                return ERROR;
            }
            if (this == TRUE == (other == TRUE)) {
                return FALSE;
            }
            return TRUE;
        }
        return Value.create(Math.max(this.width, other.width), this.error | other.error | this.unknown | other.unknown, 0L, this.value ^ other.value);
    }

    public static boolean equal(Value a, Value b) {
        if (!(a != null && a != NIL || b != null && b != NIL)) {
            return true;
        }
        return a != null && b != null && a.equals(b);
    }

    public Value pullTowardsBits(Value other) {
        if (this.width <= 0 || this.unknown == 0L || other.width <= 0) {
            return this;
        }
        long e = this.error | this.unknown & other.error;
        long v = this.value | this.unknown & other.value;
        long u = this.unknown & (other.unknown | (other.width == 64 ? 0L : -1L << other.width));
        return Value.create(this.width, e, u, v);
    }

    public Value pullEachBitTowards(Value bit) {
        if (this.width <= 0 || this.unknown == 0L || bit.width <= 0) {
            return this;
        }
        if (bit == ERROR) {
            return Value.create(this.width, this.error | this.unknown, 0L, this.value);
        }
        if (bit == TRUE) {
            return Value.create(this.width, this.error, 0L, this.value | this.unknown);
        }
        if (bit == FALSE) {
            return Value.create(this.width, this.error, 0L, this.value | 0L);
        }
        if (bit == UNKNOWN) {
            return this;
        }
        throw new IllegalArgumentException("pull value must be 1, 0, X, or E");
    }
}

