/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit.appear;

import com.cburch.draw.model.CanvasObject;
import com.cburch.logisim.circuit.appear.AppearanceAnchor;
import com.cburch.logisim.circuit.appear.AppearancePort;
import com.cburch.logisim.circuit.appear.CircuitAppearance;
import com.cburch.logisim.circuit.appear.DefaultAppearance;
import com.cburch.logisim.circuit.appear.DefaultCustomAppearance;
import com.cburch.logisim.data.Bounds;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class PortManager {
    private final CircuitAppearance appearance;
    private boolean doingUpdate;

    private static Location computeDefaultLocation(CircuitAppearance appear, Instance pin, Map<Instance, AppearancePort> others) {
        int y;
        int x;
        Object pin2;
        HashSet<Location> usedLocs = new HashSet<Location>();
        ArrayList<Instance> sameWay = new ArrayList<Instance>();
        Direction facing = pin.getAttributeValue(StdAttr.FACING);
        for (Map.Entry<Instance, AppearancePort> entry : others.entrySet()) {
            pin2 = entry.getKey();
            Location loc = entry.getValue().getLocation();
            usedLocs.add(loc);
            if (((Instance)pin2).getAttributeValue(StdAttr.FACING) != facing) continue;
            sameWay.add((Instance)pin2);
        }
        if (!sameWay.isEmpty()) {
            int dy;
            int dx;
            Instance p;
            sameWay.add(pin);
            DefaultAppearance.sortPinList(sameWay, facing);
            boolean isFirst = false;
            Instance neighbor = null;
            pin2 = sameWay.iterator();
            while (pin2.hasNext() && (p = (Instance)pin2.next()) != pin) {
                neighbor = p;
            }
            if (neighbor == null) {
                neighbor = sameWay.get(1);
            }
            if (facing == Direction.EAST || facing == Direction.WEST) {
                dx = 0;
                dy = isFirst ? -10 : 10;
            } else {
                dx = isFirst ? -10 : 10;
                dy = 0;
            }
            Location loc = others.get(neighbor).getLocation();
            while (usedLocs.contains(loc = loc.translate(dx, dy))) {
            }
            if (loc.getX() >= 0 && loc.getY() >= 0) {
                return loc;
            }
            while (usedLocs.contains(loc = loc.translate(-dx, -dy))) {
            }
            return loc;
        }
        Bounds bds = appear.getAbsoluteBounds();
        int dX = 0;
        int dY = 0;
        if (facing == Direction.EAST) {
            x = bds.getX() - 7;
            y = bds.getY() + 5;
            dY = 10;
        } else if (facing == Direction.WEST) {
            x = bds.getX() + bds.getWidth() - 3;
            y = bds.getY() + 5;
            dY = 10;
        } else if (facing == Direction.SOUTH) {
            x = bds.getX() + 5;
            y = bds.getY() - 7;
            dX = 10;
        } else {
            x = bds.getX() + 5;
            y = bds.getY() + bds.getHeight() - 3;
            dX = 10;
        }
        x = (x + 9) / 10 * 10;
        y = (y + 9) / 10 * 10;
        Location loc = Location.create(x, y, true);
        while (usedLocs.contains(loc)) {
            loc = loc.translate(dX, dY);
        }
        return loc;
    }

    PortManager(CircuitAppearance appearance) {
        this.appearance = appearance;
        this.doingUpdate = false;
    }

    private void performUpdate(Set<Instance> adds, Set<Instance> removes, Map<Instance, Instance> replaces, Collection<Instance> allPins) {
        HashMap<Instance, AppearancePort> oldObjects = new HashMap<Instance, AppearancePort>();
        Object anchor = null;
        for (CanvasObject obj : this.appearance.getCustomObjectsFromBottom()) {
            if (obj instanceof AppearancePort) {
                AppearancePort appPort = (AppearancePort)obj;
                oldObjects.put(appPort.getPin(), appPort);
                continue;
            }
            if (!(obj instanceof AppearanceAnchor)) continue;
            AppearanceAnchor appAnchor = (AppearanceAnchor)obj;
            anchor = appAnchor;
        }
        if (anchor == null) {
            for (CanvasObject obj : DefaultCustomAppearance.build(allPins)) {
                Object appAnchor;
                if (!(obj instanceof AppearanceAnchor)) continue;
                anchor = appAnchor = (AppearanceAnchor)obj;
            }
            if (anchor == null) {
                anchor = new AppearanceAnchor(Location.create(100, 100, true));
            }
            int dest = this.appearance.getCustomObjectsFromBottom().size();
            this.appearance.addObjects(dest, Collections.singleton(anchor));
        }
        ArrayList<AppearancePort> portRemoves = new ArrayList<AppearancePort>(removes.size());
        ArrayList<AppearancePort> portAdds = new ArrayList<AppearancePort>(adds.size());
        for (Instance pin : removes) {
            AppearancePort port = (AppearancePort)oldObjects.remove(pin);
            if (port == null) continue;
            portRemoves.add(port);
        }
        ArrayList<Instance> addsCopy = new ArrayList<Instance>(adds);
        for (Map.Entry<Instance, Instance> entry : replaces.entrySet()) {
            AppearancePort port = (AppearancePort)oldObjects.remove(entry.getKey());
            if (port != null) {
                port.setPin(entry.getValue());
                oldObjects.put(entry.getValue(), port);
                continue;
            }
            addsCopy.add(entry.getValue());
        }
        DefaultAppearance.sortPinList(addsCopy, Direction.EAST);
        for (Instance pin : addsCopy) {
            if (oldObjects.containsKey(pin)) continue;
            Location loc = PortManager.computeDefaultLocation(this.appearance, pin, oldObjects);
            AppearancePort o = new AppearancePort(loc, pin);
            portAdds.add(o);
            oldObjects.put(pin, o);
        }
        this.appearance.replaceAutomatically(portRemoves, portAdds);
    }

    void updatePorts() {
        this.appearance.recomputePorts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updatePorts(Set<Instance> adds, Set<Instance> removes, Map<Instance, Instance> replaces, Collection<Instance> allPins) {
        if (!this.doingUpdate) {
            try {
                this.doingUpdate = true;
                this.performUpdate(adds, removes, replaces, allPins);
                this.appearance.recomputePorts();
            }
            finally {
                this.doingUpdate = false;
            }
        }
    }
}

