/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.circuit.appear;

import com.cburch.draw.model.CanvasObject;
import com.cburch.draw.shapes.Curve;
import com.cburch.draw.shapes.DrawAttr;
import com.cburch.draw.shapes.Rectangle;
import com.cburch.logisim.circuit.appear.AppearanceAnchor;
import com.cburch.logisim.circuit.appear.AppearancePort;
import com.cburch.logisim.circuit.appear.DefaultAppearance;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.instance.Instance;
import com.cburch.logisim.instance.StdAttr;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultClassicAppearance {
    private static final int OFFS = 50;

    public static List<CanvasObject> build(Collection<Instance> pins) {
        int ay;
        int ax;
        HashMap edge = new HashMap();
        edge.put(Direction.NORTH, new ArrayList());
        edge.put(Direction.SOUTH, new ArrayList());
        edge.put(Direction.EAST, new ArrayList());
        edge.put(Direction.WEST, new ArrayList());
        for (Instance instance : pins) {
            Direction pinFacing = instance.getAttributeValue(StdAttr.FACING);
            Direction pinEdge = pinFacing.reverse();
            List e = (List)edge.get(pinEdge);
            e.add(instance);
        }
        for (Map.Entry entry : edge.entrySet()) {
            DefaultAppearance.sortPinList((List)entry.getValue(), (Direction)entry.getKey());
        }
        int numNorth = ((List)edge.get(Direction.NORTH)).size();
        int n = ((List)edge.get(Direction.SOUTH)).size();
        int numEast = ((List)edge.get(Direction.EAST)).size();
        int numWest = ((List)edge.get(Direction.WEST)).size();
        int maxVert = Math.max(numNorth, n);
        int maxHorz = Math.max(numEast, numWest);
        int offsNorth = DefaultClassicAppearance.computeOffset(numNorth, n, maxHorz);
        int offsSouth = DefaultClassicAppearance.computeOffset(n, numNorth, maxHorz);
        int offsEast = DefaultClassicAppearance.computeOffset(numEast, numWest, maxVert);
        int offsWest = DefaultClassicAppearance.computeOffset(numWest, numEast, maxVert);
        int width = DefaultClassicAppearance.computeDimension(maxVert, maxHorz);
        int height = DefaultClassicAppearance.computeDimension(maxHorz, maxVert);
        if (numEast > 0) {
            ax = width;
            ay = offsEast;
        } else if (numNorth > 0) {
            ax = offsNorth;
            ay = 0;
        } else if (numWest > 0) {
            ax = 0;
            ay = offsWest;
        } else if (n > 0) {
            ax = offsSouth;
            ay = height;
        } else {
            ax = 0;
            ay = 0;
        }
        int rX = Math.round((50 + ax) / 10) * 10;
        int rY = Math.round((50 + ay) / 10) * 10;
        Location e0 = Location.create(rX + (width - 8) / 2, rY + 1, false);
        Location e1 = Location.create(rX + (width + 8) / 2, rY + 1, false);
        Location ct = Location.create(rX + width / 2, rY + 11, false);
        Curve notch = new Curve(e0, e1, ct);
        notch.setValue(DrawAttr.STROKE_WIDTH, 2);
        notch.setValue(DrawAttr.STROKE_COLOR, Color.GRAY);
        Rectangle rect = new Rectangle(rX, rY, width, height);
        rect.setValue(DrawAttr.STROKE_WIDTH, 2);
        ArrayList<CanvasObject> ret = new ArrayList<CanvasObject>();
        ret.add(notch);
        ret.add(rect);
        DefaultClassicAppearance.placePins(ret, (List)edge.get(Direction.WEST), rX, rY + offsWest, 0, 10);
        DefaultClassicAppearance.placePins(ret, (List)edge.get(Direction.EAST), rX + width, rY + offsEast, 0, 10);
        DefaultClassicAppearance.placePins(ret, (List)edge.get(Direction.NORTH), rX + offsNorth, rY, 10, 0);
        DefaultClassicAppearance.placePins(ret, (List)edge.get(Direction.SOUTH), rX + offsSouth, rY + height, 10, 0);
        ret.add(new AppearanceAnchor(Location.create(rX + ax, rY + ay, true)));
        return ret;
    }

    private static int computeDimension(int maxThis, int maxOthers) {
        if (maxThis < 3) {
            return 30;
        }
        if (maxOthers == 0) {
            return 10 * maxThis;
        }
        return 10 * maxThis + 10;
    }

    private static int computeOffset(int numFacing, int numOpposite, int maxOthers) {
        int maxThis = Math.max(numFacing, numOpposite);
        int maxOffs = switch (maxThis) {
            case 0, 1 -> {
                if (maxOthers == 0) {
                    yield 15;
                }
                yield 10;
            }
            case 2 -> 10;
            default -> maxOthers == 0 ? 5 : 10;
        };
        return maxOffs + 10 * ((maxThis - numFacing) / 2);
    }

    private static void placePins(List<CanvasObject> dest, List<Instance> pins, int x, int y, int dx, int dy) {
        for (Instance pin : pins) {
            dest.add(new AppearancePort(Location.create(x, y, true), pin));
            x += dx;
            y += dy;
        }
    }
}

